# cve-ape
CVE Ape is a fairly simple tool free and open source tool which helps to find all registred at the National Vulnerability Database (NVD) list of Common Vulnerabilities and Exposures (CVEs) listed at the package list.

Main usage of this tool is to help with review of linux based IOT devices, but could be also integrated at the CI/CD pipelines to maintain better level of security.

This is not very precise tool because is not checking any backports nor vendors if not supplied specifically.

The tool is downloading and creating a local CVE database at `~/.cache/cve-ape/` folder. It can be used offline, but only after a first update as it has to create a database.
## How to use
You need to generate a pkglist yourself first. Currently only CSV and a list format are supported. 

*Text list format Example:*
```
curl-7.77.0-r0
dbus-1.12.20-r0
dbus-libs-1.12.20-r0
device-mapper-libs-2.02.187-r0
dhcpcd-8.1.9-r0
disk-utils-0.3.0_rc1-r0
dnsmasq-2.85-r0
```
You can run a tool using this command:
`cve-ape -L pkglist.txt`

Full list of **supported** commands: 
```commandline
usage: cve-ape [-h] [-n {api,json}] [-u {now,daily,never,latest}] [--nvd-api-key NVD_API_KEY] [-L PACKAGE_LIST] [-C CSV_FORMAT] [-d CSV_DELIMITER] [-q] [-l {debug,info,warning,error,critical}] [-o OUTPUT_FILE]
               [-f {csv,json,console}] [-c CVSS] [-S {low,medium,high,critical}] [--report] [--affected-versions] [-e EXCLUDE] [--disable-version-check] [--offline]

optional arguments:
  -h, --help            show this help message and exit
  --disable-version-check
                        skips checking for a new version
  --offline             operate in offline mode

CVE Data Download:
  Arguments related to NVD Database and Cache Configuration

  -n {api,json}, --nvd {api,json}
                        choose method for getting CVE lists from NVD
  -u {now,daily,never,latest}, --update {now,daily,never,latest}
                        update schedule for NVD database (default: daily)
  --nvd-api-key NVD_API_KEY
                        specify NVD API key (used to improve NVD rate limit)

Input:
  -L PACKAGE_LIST, --package-list PACKAGE_LIST
                        provide a package list.
  -C CSV_FORMAT, --csv-format CSV_FORMAT
                        comma separated headers if file is a CSV, or comma separated column numbers started from 0 where the first is a package and the second is a version.
  -d CSV_DELIMITER, --csv-delimiter CSV_DELIMITER
                        a delimiter used in the csv file. Default: ";"

Output:
  -q, --quiet           suppress output
  -l {debug,info,warning,error,critical}, --log {debug,info,warning,error,critical}
                        log level (default: info)
```

## Disclamer
Some parts of the code were taken as is from another open source project [cve-bin-tool](https://github.com/intel/cve-bin-tool) from Intel. A lot of respect should be given to those guys.
### License
CVE Ape is licensed under the MIT License - see the LICENSE.rst file for details. 
