# Open_Dev

open_dev is a command-line tool built to assist developers in creating pull requests with ease. The tool interacts with the OpenAI GPT-3 API to generate a summary of changes made to a repository and use it to create a pull request.

## Requirements
[![pypi](https://img.shields.io/pypi/v/open_dev.svg)](https://pypi.org/project/open_dev/)
[![python](https://img.shields.io/pypi/pyversions/open_dev.svg)](https://pypi.org/project/open_dev/)
[![Build Status](https://github.com/8ball030/open_dev/actions/workflows/dev.yml/badge.svg)](https://github.com/8ball030/open_dev/actions/workflows/dev.yml)
[![codecov](https://codecov.io/gh/8ball030/open_dev/branch/main/graphs/badge.svg)](https://codecov.io/github/8ball030/open_dev)

## Installation from Source
To install open_dev, you must have Python 3.6 or later installed on your system.

Clone this repository: `git clone https://github.com/8ball030/open_dev.git.`

Navigate to the project directory: `cd open_dev`.

Install the required dependencies: `pip install -r requirements.txt`.

Set up your `OPENAI_API_KEY` environment variable from OpenAI.

Run `python setup.py install` to install open_dev.

## Install from Pip
You can also install open_dev from pip by running the following command:

```bash
pip install open_dev
```


## Usage
Once open_dev is installed, you can use it by running the open-dev command in your terminal.

```bash
odev repo pull --help

 Usage: odev repo pull [OPTIONS]

 Creates a pull request based on a summary of changes from chatgpt.

╭─ Options ───────────────────────────────────────────────────────────────────╮
│ --target-branch  -tb  TEXT  The target branch to compare against.           │
│ --title          -t   TEXT  The title of the PR. If none will be            │
│                             autogenerated by chatgpt3.                      │
│ --description    -d   TEXT  The description of the PR. If none will be      │
│                             autogenerated by chatgpt3.                      │
│ --dry-run                   Simulate the commit and pr creation.            │
│ --help                      Show this message and exit.                     │
╰─────────────────────────────────────────────────────────────────────────────╯

 ```

```bash
open-dev repo pull
```
You can also specify options when running the pull command. For example, to specify a target branch, you can run:


```bash
open-dev repo pull --target-branch develop
```

## Example  output

![image](https://user-images.githubusercontent.com/35799987/223505087-5992d2db-362a-45e6-8176-d9da91551c9f.png)

License
This project is licensed under the MIT License.
