import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
import { IMesh } from './mesh';
import { Route, RouteBaseProps } from './route';
import { VirtualRouterListener } from './virtual-router-listener';
/**
 * Interface which all VirtualRouter based classes MUST implement.
 *
 * @stability stable
 */
export interface IVirtualRouter extends cdk.IResource {
    /**
     * The name of the VirtualRouter.
     *
     * @stability stable
     * @attribute true
     */
    readonly virtualRouterName: string;
    /**
     * The Amazon Resource Name (ARN) for the VirtualRouter.
     *
     * @stability stable
     * @attribute true
     */
    readonly virtualRouterArn: string;
    /**
     * The Mesh which the VirtualRouter belongs to.
     *
     * @stability stable
     */
    readonly mesh: IMesh;
    /**
     * Add a single route to the router.
     *
     * @stability stable
     */
    addRoute(id: string, props: RouteBaseProps): Route;
}
/**
 * Interface with base properties all routers willl inherit.
 *
 * @stability stable
 */
export interface VirtualRouterBaseProps {
    /**
     * Listener specification for the VirtualRouter.
     *
     * @default - A listener on HTTP port 8080
     * @stability stable
     */
    readonly listeners?: VirtualRouterListener[];
    /**
     * The name of the VirtualRouter.
     *
     * @default - A name is automatically determined
     * @stability stable
     */
    readonly virtualRouterName?: string;
}
declare abstract class VirtualRouterBase extends cdk.Resource implements IVirtualRouter {
    /**
     * The name of the VirtualRouter
     */
    abstract readonly virtualRouterName: string;
    /**
     * The Amazon Resource Name (ARN) for the VirtualRouter
     */
    abstract readonly virtualRouterArn: string;
    /**
     * The Mesh which the VirtualRouter belongs to
     */
    abstract readonly mesh: IMesh;
    /**
     * Add a single route to the router.
     *
     * @stability stable
     */
    addRoute(id: string, props: RouteBaseProps): Route;
}
/**
 * The properties used when creating a new VirtualRouter.
 *
 * @stability stable
 */
export interface VirtualRouterProps extends VirtualRouterBaseProps {
    /**
     * The Mesh which the VirtualRouter belongs to.
     *
     * @stability stable
     */
    readonly mesh: IMesh;
}
/**
 * @stability stable
 */
export declare class VirtualRouter extends VirtualRouterBase {
    /**
     * Import an existing VirtualRouter given an ARN.
     *
     * @stability stable
     */
    static fromVirtualRouterArn(scope: Construct, id: string, virtualRouterArn: string): IVirtualRouter;
    /**
     * Import an existing VirtualRouter given attributes.
     *
     * @stability stable
     */
    static fromVirtualRouterAttributes(scope: Construct, id: string, attrs: VirtualRouterAttributes): IVirtualRouter;
    /**
     * The name of the VirtualRouter.
     *
     * @stability stable
     */
    readonly virtualRouterName: string;
    /**
     * The Amazon Resource Name (ARN) for the VirtualRouter.
     *
     * @stability stable
     */
    readonly virtualRouterArn: string;
    /**
     * The Mesh which the VirtualRouter belongs to.
     *
     * @stability stable
     */
    readonly mesh: IMesh;
    private readonly listeners;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: VirtualRouterProps);
    /**
     * Add port mappings to the router
     */
    private addListener;
}
/**
 * Interface with properties ncecessary to import a reusable VirtualRouter.
 *
 * @stability stable
 */
export interface VirtualRouterAttributes {
    /**
     * The name of the VirtualRouter.
     *
     * @stability stable
     */
    readonly virtualRouterName: string;
    /**
     * The Mesh which the VirtualRouter belongs to.
     *
     * @stability stable
     */
    readonly mesh: IMesh;
}
export {};
