import { CfnVirtualGateway } from './appmesh.generated';
import { HealthCheck } from './health-checks';
import { ListenerTlsOptions } from './listener-tls-options';
import { GrpcConnectionPool, Http2ConnectionPool, HttpConnectionPool } from './shared-interfaces';
import { Construct } from '@aws-cdk/core';
/**
 * Represents the properties needed to define a Listeners for a VirtualGateway
 */
interface VirtualGatewayListenerCommonOptions {
    /**
     * Port to listen for connections on.
     *
     * @default - 8080
     * @stability stable
     */
    readonly port?: number;
    /**
     * The health check information for the listener.
     *
     * @default - no healthcheck
     * @stability stable
     */
    readonly healthCheck?: HealthCheck;
    /**
     * Represents the configuration for enabling TLS on a listener.
     *
     * @default - none
     * @stability stable
     */
    readonly tls?: ListenerTlsOptions;
}
/**
 * Represents the properties needed to define HTTP Listeners for a VirtualGateway.
 *
 * @stability stable
 */
export interface HttpGatewayListenerOptions extends VirtualGatewayListenerCommonOptions {
    /**
     * Connection pool for http listeners.
     *
     * @default - None
     * @stability stable
     */
    readonly connectionPool?: HttpConnectionPool;
}
/**
 * Represents the properties needed to define HTTP2 Listeners for a VirtualGateway.
 *
 * @stability stable
 */
export interface Http2GatewayListenerOptions extends VirtualGatewayListenerCommonOptions {
    /**
     * Connection pool for http listeners.
     *
     * @default - None
     * @stability stable
     */
    readonly connectionPool?: Http2ConnectionPool;
}
/**
 * Represents the properties needed to define GRPC Listeners for a VirtualGateway.
 *
 * @stability stable
 */
export interface GrpcGatewayListenerOptions extends VirtualGatewayListenerCommonOptions {
    /**
     * Connection pool for http listeners.
     *
     * @default - None
     * @stability stable
     */
    readonly connectionPool?: GrpcConnectionPool;
}
/**
 * Properties for a VirtualGateway listener.
 *
 * @stability stable
 */
export interface VirtualGatewayListenerConfig {
    /**
     * Single listener config for a VirtualGateway.
     *
     * @stability stable
     */
    readonly listener: CfnVirtualGateway.VirtualGatewayListenerProperty;
}
/**
 * Represents the properties needed to define listeners for a VirtualGateway.
 *
 * @stability stable
 */
export declare abstract class VirtualGatewayListener {
    /**
     * Returns an HTTP Listener for a VirtualGateway.
     *
     * @stability stable
     */
    static http(options?: HttpGatewayListenerOptions): VirtualGatewayListener;
    /**
     * Returns an HTTP2 Listener for a VirtualGateway.
     *
     * @stability stable
     */
    static http2(options?: Http2GatewayListenerOptions): VirtualGatewayListener;
    /**
     * Returns a GRPC Listener for a VirtualGateway.
     *
     * @stability stable
     */
    static grpc(options?: GrpcGatewayListenerOptions): VirtualGatewayListener;
    /**
     * Called when the GatewayListener type is initialized.
     *
     * Can be used to enforce
     * mutual exclusivity
     *
     * @stability stable
     */
    abstract bind(scope: Construct): VirtualGatewayListenerConfig;
}
export {};
