import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
import { IMesh } from './mesh';
import { RouteSpec } from './route-spec';
import { IVirtualRouter } from './virtual-router';
/**
 * Interface for which all Route based classes MUST implement.
 *
 * @stability stable
 */
export interface IRoute extends cdk.IResource {
    /**
     * The name of the route.
     *
     * @stability stable
     * @attribute true
     */
    readonly routeName: string;
    /**
     * The Amazon Resource Name (ARN) for the route.
     *
     * @stability stable
     * @attribute true
     */
    readonly routeArn: string;
    /**
     * The VirtualRouter the Route belongs to.
     *
     * @stability stable
     */
    readonly virtualRouter: IVirtualRouter;
}
/**
 * Base interface properties for all Routes.
 *
 * @stability stable
 */
export interface RouteBaseProps {
    /**
     * The name of the route.
     *
     * @default - An automatically generated name
     * @stability stable
     */
    readonly routeName?: string;
    /**
     * Protocol specific spec.
     *
     * @stability stable
     */
    readonly routeSpec: RouteSpec;
}
/**
 * Properties to define new Routes.
 *
 * @stability stable
 */
export interface RouteProps extends RouteBaseProps {
    /**
     * The service mesh to define the route in.
     *
     * @stability stable
     */
    readonly mesh: IMesh;
    /**
     * The VirtualRouter the Route belongs to.
     *
     * @stability stable
     */
    readonly virtualRouter: IVirtualRouter;
}
/**
 * Route represents a new or existing route attached to a VirtualRouter and Mesh.
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/routes.html
 * @stability stable
 */
export declare class Route extends cdk.Resource implements IRoute {
    /**
     * Import an existing Route given an ARN.
     *
     * @stability stable
     */
    static fromRouteArn(scope: Construct, id: string, routeArn: string): IRoute;
    /**
     * Import an existing Route given attributes.
     *
     * @stability stable
     */
    static fromRouteAttributes(scope: Construct, id: string, attrs: RouteAttributes): IRoute;
    /**
     * The name of the Route.
     *
     * @stability stable
     */
    readonly routeName: string;
    /**
     * The Amazon Resource Name (ARN) for the route.
     *
     * @stability stable
     */
    readonly routeArn: string;
    /**
     * The VirtualRouter the Route belongs to.
     *
     * @stability stable
     */
    readonly virtualRouter: IVirtualRouter;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: RouteProps);
}
/**
 * Interface with properties ncecessary to import a reusable Route.
 *
 * @stability stable
 */
export interface RouteAttributes {
    /**
     * The name of the Route.
     *
     * @stability stable
     */
    readonly routeName: string;
    /**
     * The VirtualRouter the Route belongs to.
     *
     * @stability stable
     */
    readonly virtualRouter: IVirtualRouter;
}
