"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpGatewayRoutePathMatch = exports.HttpRoutePathMatch = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Defines HTTP route matching based on the URL path of the request.
 *
 * @stability stable
 */
class HttpRoutePathMatch {
    /**
     * The value of the path must match the specified value exactly.
     *
     * The provided `path` must start with the '/' character.
     *
     * @param path the exact path to match on.
     * @stability stable
     */
    static exactly(path) {
        return new HttpRouteWholePathMatch({ exact: path });
    }
    /**
     * The value of the path must match the specified regex.
     *
     * @param regex the regex used to match the path.
     * @stability stable
     */
    static regex(regex) {
        return new HttpRouteWholePathMatch({ regex: regex });
    }
    /**
     * The value of the path must match the specified prefix.
     *
     * @param prefix the value to use to match the beginning of the path part of the URL of the request.
     * @stability stable
     */
    static startsWith(prefix) {
        return new HttpRoutePrefixPathMatch(prefix);
    }
}
exports.HttpRoutePathMatch = HttpRoutePathMatch;
_a = JSII_RTTI_SYMBOL_1;
HttpRoutePathMatch[_a] = { fqn: "@aws-cdk/aws-appmesh.HttpRoutePathMatch", version: "1.121.0" };
class HttpRoutePrefixPathMatch extends HttpRoutePathMatch {
    constructor(prefix) {
        super();
        this.prefix = prefix;
        if (prefix && prefix[0] !== '/') {
            throw new Error(`Prefix Path for the match must start with \'/\', got: ${prefix}`);
        }
    }
    bind(_scope) {
        return {
            prefixPathMatch: this.prefix,
        };
    }
}
class HttpRouteWholePathMatch extends HttpRoutePathMatch {
    constructor(match) {
        super();
        this.match = match;
        if (match.exact && match.exact[0] !== '/') {
            throw new Error(`Exact Path for the match must start with \'/\', got: ${match.exact}`);
        }
    }
    bind(_scope) {
        return {
            wholePathMatch: this.match,
        };
    }
}
/**
 * Defines HTTP gateway route matching based on the URL path of the request.
 *
 * @stability stable
 */
class HttpGatewayRoutePathMatch {
    /**
     * The value of the path must match the specified prefix.
     *
     * @param prefix the value to use to match the beginning of the path part of the URL of the request.
     * @param rewriteTo Specify either disabling automatic rewrite or rewriting to specified prefix path.
     * @stability stable
     */
    static startsWith(prefix, rewriteTo) {
        return new HttpGatewayRoutePrefixPathMatch(prefix, rewriteTo);
    }
    /**
     * The value of the path must match the specified value exactly.
     *
     * The provided `path` must start with the '/' character.
     *
     * @param path the exact path to match on.
     * @param rewriteTo the value to substitute for the matched part of the path of the gateway request URL As a default, retains original request's URL path.
     * @stability stable
     */
    static exactly(path, rewriteTo) {
        return new HttpGatewayRouteWholePathMatch({ exact: path }, rewriteTo);
    }
    /**
     * The value of the path must match the specified regex.
     *
     * @param regex the regex used to match the path.
     * @param rewriteTo the value to substitute for the matched part of the path of the gateway request URL As a default, retains original request's URL path.
     * @stability stable
     */
    static regex(regex, rewriteTo) {
        return new HttpGatewayRouteWholePathMatch({ regex }, rewriteTo);
    }
}
exports.HttpGatewayRoutePathMatch = HttpGatewayRoutePathMatch;
_b = JSII_RTTI_SYMBOL_1;
HttpGatewayRoutePathMatch[_b] = { fqn: "@aws-cdk/aws-appmesh.HttpGatewayRoutePathMatch", version: "1.121.0" };
class HttpGatewayRoutePrefixPathMatch extends HttpGatewayRoutePathMatch {
    constructor(prefixPathMatch, rewriteTo) {
        super();
        this.prefixPathMatch = prefixPathMatch;
        this.rewriteTo = rewriteTo;
        if (prefixPathMatch[0] !== '/') {
            throw new Error('Prefix path for the match must start with \'/\', '
                + `got: ${prefixPathMatch}`);
        }
        if (rewriteTo) {
            if (prefixPathMatch[prefixPathMatch.length - 1] !== '/') {
                throw new Error('When prefix path for the rewrite is specified, prefix path for the match must end with \'/\', '
                    + `got: ${prefixPathMatch}`);
            }
            if (rewriteTo[0] !== '/' || rewriteTo[rewriteTo.length - 1] !== '/') {
                throw new Error('Prefix path for the rewrite must start and end with \'/\', '
                    + `got: ${rewriteTo}`);
            }
        }
    }
    bind(_scope) {
        return {
            prefixPathMatch: this.prefixPathMatch,
            prefixPathRewrite: this.rewriteTo === undefined
                ? undefined
                : {
                    defaultPrefix: this.rewriteTo === '' ? 'DISABLED' : undefined,
                    value: this.rewriteTo === '' ? undefined : this.rewriteTo,
                },
        };
    }
}
class HttpGatewayRouteWholePathMatch extends HttpGatewayRoutePathMatch {
    constructor(wholePathMatch, exactPathRewrite) {
        super();
        this.wholePathMatch = wholePathMatch;
        this.exactPathRewrite = exactPathRewrite;
        if (wholePathMatch.exact && wholePathMatch.exact[0] !== '/') {
            throw new Error(`Exact Path for the match must start with \'/\', got: ${wholePathMatch.exact}`);
        }
        if (exactPathRewrite === '') {
            throw new Error('Exact Path for the rewrite cannot be empty. Unlike startsWith() method, no automatic rewrite on whole path match');
        }
        if (exactPathRewrite && exactPathRewrite[0] !== '/') {
            throw new Error(`Exact Path for the rewrite must start with \'/\', got: ${exactPathRewrite}`);
        }
    }
    bind(_scope) {
        return {
            wholePathMatch: this.wholePathMatch,
            wholePathRewrite: this.exactPathRewrite === undefined ? undefined : { exact: this.exactPathRewrite },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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