# Generated by Django 3.2.4 on 2021-06-08 03:25

import django.utils.timezone
from django.conf import settings
from django.db import migrations, models

import django_qiyu_token.models.bearer


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='BearerTokenModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('token_name', models.CharField(help_text='方便人类记忆的名称', max_length=255, verbose_name='令牌名称')),
                ('token_type',
                 models.CharField(default='default', help_text='访问令牌的类型', max_length=255, verbose_name='令牌类型')),
                ('token_value',
                 models.CharField(default=django_qiyu_token.models.bearer.gen_token, editable=False, max_length=255,
                                  unique=True, verbose_name='访问令牌')),
                ('revoked', models.BooleanField(default=False, help_text='这个访问令牌是否已经撤销', verbose_name='已撤销')),
                ('expire_time', models.DateTimeField(db_index=True, help_text='这个令牌的失效时间', verbose_name='过期时间')),
                ('create_time',
                 models.DateTimeField(default=django.utils.timezone.now, editable=False, help_text='这个令牌的创建时间',
                                      verbose_name='创建时间')),
                ('user',
                 models.ForeignKey(editable=False, help_text='拥有这个令牌的用户', on_delete=django.db.models.deletion.CASCADE,
                                   to=settings.AUTH_USER_MODEL, verbose_name='用户')),
            ],
            options={
                'verbose_name': 'Bearer令牌',
                'verbose_name_plural': 'Bearer令牌',
            },
        ),
    ]
