window.djeymYMaps.modules.define("Heatmap",["option.Manager","Monitor","Layer","heatmap.component.dataConverter","heatmap.component.TileUrlsGenerator"],(function(provide,OptionManager,Monitor,Layer,dataConverter,TileUrlsGenerator){var Heatmap=function(data,options){this._unprocessedPoints=[],data&&this.setData(data),this.options=new OptionManager(options)};Heatmap.prototype.getData=function(){return this._data||null},Heatmap.prototype.setData=function(data){this._data=data;var points=dataConverter.convert(data);return this._tileUrlsGenerator?(this._tileUrlsGenerator.setPoints(points),this._refresh()):this._unprocessedPoints=points,this},Heatmap.prototype.getMap=function(){return this._map},Heatmap.prototype.setMap=function(map){return this._map!==map&&(this._layer&&(this._map.layers.remove(this._layer),this._destroyLayer()),this._map=map,map&&(this._setupLayer(),this._map.layers.add(this._layer))),this},Heatmap.prototype.destroy=function(){this._data=null,this.setMap(null)},Heatmap.prototype._refresh=function(){return this._layer&&this._layer.update(),this},Heatmap.prototype._setupLayer=function(){this._setupTileUrlsGenerator();var getTileUrl=this._tileUrlsGenerator.getTileUrl.bind(this._tileUrlsGenerator);return this._layer=new Layer(getTileUrl,{tileTransparent:!0}),this._setupOptionMonitor(),this._layer},Heatmap.prototype._destroyLayer=function(){this._destroyTileUrlsGenerator(),this._destroyOptionMonitor(),this._layer=null},Heatmap.prototype._setupTileUrlsGenerator=function(){return this._tileUrlsGenerator=new TileUrlsGenerator(this._map.options.get("projection"),this._unprocessedPoints),this._unprocessedPoints=null,this._tileUrlsGenerator.options.setParent(this.options),this._tileUrlsGenerator},Heatmap.prototype._destroyTileUrlsGenerator=function(){this._unprocessedPoints=this._tileUrlsGenerator.getPoints(),this._tileUrlsGenerator.destroy(),this._tileUrlsGenerator=null},Heatmap.prototype._setupOptionMonitor=function(){return this._optionMonitor=new Monitor(this.options),this._optionMonitor.add(["radius","dissipating","opacity","intensityOfMidpoint","gradient"],this._refresh,this)},Heatmap.prototype._destroyOptionMonitor=function(){this._optionMonitor.removeAll(),this._optionMonitor={}},provide(Heatmap)})),window.djeymYMaps.modules.define("heatmap.component.dataConverter",[],(function(provide){var dataConverter={convert:function(data){var points=[];if("string"==typeof object&&(data=JSON.parse(data)),this._isJsonFeatureCollection(data))for(var i=0,l=data.features.length;i<l;i++)points=points.concat(this.convert(data.features[i]));else if(this._isCoordinates(data))points.push(this._convertCoordinatesToPoint(data));else for(var dataArray=[].concat(data),i=0,l=dataArray.length,item;i<l;i++)if(item=dataArray[i],this._isCoordinates(item))points.push(this._convertCoordinatesToPoint(item));else if(this._isJsonGeometry(item)&&"Point"===item.type)points.push(this._convertCoordinatesToPoint(item.coordinates));else if(this._isJsonFeature(item)&&"Point"===item.geometry.type)points.push(this._convertJsonFeatureToPoint(item));else if(this._isGeoObject(item)&&"Point"===item.geometry.getType())points.push(this._convertGeoObjectToPoint(item));else if(this._isCollection(item))for(var iterator=item.getIterator(),geoObject;(geoObject=iterator.getNext())!==iterator.STOP_ITERATION;)points=points.concat(this.convert(geoObject));return points},_isJsonFeature:function(object){return"Feature"===object.type},_convertJsonFeatureToPoint:function(jsonFeature){var weight=1;return jsonFeature.properties&&jsonFeature.properties.weight&&(weight=jsonFeature.properties.weight),{coordinates:jsonFeature.geometry.coordinates,weight:weight}},_isJsonFeatureCollection:function(object){return"FeatureCollection"===object.type},_isCoordinates:function(object){return"[object Array]"===Object.prototype.toString.call(object)&&"number"==typeof object[0]&&"number"==typeof object[1]},_convertCoordinatesToPoint:function(coordinates){return{coordinates:coordinates,weight:1}},_isJsonGeometry:function(object){return Boolean(object.type&&object.coordinates)},_isGeoObject:function(object){return Boolean(object.geometry&&object.getOverlay)},_convertGeoObjectToPoint:function(geoObject){return{coordinates:geoObject.geometry.getCoordinates(),weight:geoObject.properties.get("weight")||1}},_isCollection:function(object){return Boolean(object.getIterator)}};provide(dataConverter)})),window.djeymYMaps.modules.define("heatmap.component.TileUrlsGenerator",["option.Manager","heatmap.component.Canvas"],(function(provide,OptionManager,HeatmapCanvas){var TILE_SIZE=[256,256],TileUrlsGenerator=function(projection,points){this._projection=projection,this._canvas=new HeatmapCanvas(TILE_SIZE),this.options=new OptionManager({}),this._canvas.options.setParent(this.options),this.setPoints(points||[])};function calculateRadiusFactor(zoom){return Math.pow(zoom/10,1.1)}function findMediana(selection){var sortSelection=selection.sort(comparator),center=sortSelection.length/2;return center!==Math.floor(center)?sortSelection[Math.floor(center)]:(sortSelection[center-1]+sortSelection[center])/2}function comparator(a,b){return a-b}TileUrlsGenerator.prototype.setPoints=function(points){this._points=[];for(var weights=[],i=0,length=points.length;i<length;i++)this._points.push({coordinates:this._projection.toGlobalPixels(points[i].coordinates,0),weight:points[i].weight}),weights.push(points[i].weight);return this._canvas.options.set("medianaOfWeights",findMediana(weights)),this},TileUrlsGenerator.prototype.getPoints=function(){for(var points=[],i=0,length=this._points.length;i<length;i++)points.push({coordinates:this._projection.fromGlobalPixels(this._points[i].coordinates,0),weight:this._points[i].weight});return points},TileUrlsGenerator.prototype.getTileUrl=function(tileNumber,zoom){var radiusFactor=this._canvas.options.get("radiusFactor");if(this.options.get("dissipating")){var newRadiusFactor=calculateRadiusFactor(zoom);radiusFactor!==newRadiusFactor&&this._canvas.options.set("radiusFactor",newRadiusFactor)}else radiusFactor&&this._canvas.options.unset("radiusFactor");for(var zoomFactor=Math.pow(2,zoom),tileBounds=[[tileNumber[0]*TILE_SIZE[0]/zoomFactor,tileNumber[1]*TILE_SIZE[1]/zoomFactor],[(tileNumber[0]+1)*TILE_SIZE[0]/zoomFactor,(tileNumber[1]+1)*TILE_SIZE[1]/zoomFactor]],tileMargin=this._canvas.getBrushRadius()/zoomFactor,points=[],i=0,length=this._points.length,point;i<length;i++)point=this._points[i].coordinates,this._contains(tileBounds,point,tileMargin)&&points.push({coordinates:[(point[0]-tileBounds[0][0])*zoomFactor,(point[1]-tileBounds[0][1])*zoomFactor],weight:this._points[i].weight});return this._canvas.generateDataURLHeatmap(points)},TileUrlsGenerator.prototype.destroy=function(){this._canvas.destroy(),this._canvas=null,this._projection=null},TileUrlsGenerator.prototype._contains=function(bounds,point,margin){return point[0]>=bounds[0][0]-margin&&point[0]<=bounds[1][0]+margin&&point[1]>=bounds[0][1]-margin&&point[1]<=bounds[1][1]+margin},provide(TileUrlsGenerator)})),window.djeymYMaps.modules.define("heatmap.component.Canvas",["option.Manager","Monitor"],(function(provide,OptionManager,Monitor){var DEFAULT_OPTIONS_radius=10,DEFAULT_OPTIONS_radiusFactor=1,DEFAULT_OPTIONS_opacity=.8,DEFAULT_OPTIONS_intensityOfMidpoint=.2,DEFAULT_OPTIONS_medianaOfWeights=1,DEFAULT_OPTIONS_gradient={.1:"rgba(128, 255, 0, 0.7)",.2:"rgba(255, 255, 0, 0.8)",.7:"rgba(234, 72, 58, 0.9)",1:"rgba(162, 36, 25, 1)"},EMPTY_PNG="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAQAAAAEACAYAAABccqhmAAABFUlEQVR4nO3BMQEAAADCoPVP7WsIoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAeAMBPAABPO1TCQAAAABJRU5ErkJggg==",Canvas=function(size){this._canvas=document.createElement("canvas"),this._canvas.width=size[0],this._canvas.height=size[1],this._context=this._canvas.getContext("2d"),this.options=new OptionManager({}),this._setupDrawTools(),this._setupOptionMonitor()};Canvas.prototype.getBrushRadius=function(){return this.options.get("radius",DEFAULT_OPTIONS_radius)*this.options.get("radiusFactor",DEFAULT_OPTIONS_radiusFactor)},Canvas.prototype.generateDataURLHeatmap=function(points){return points&&points.length>0?(this._drawHeatmap(points),this._canvas.toDataURL()):EMPTY_PNG},Canvas.prototype.destroy=function(){this._destroyOptionMonitor(),this._destroyDrawTools()},Canvas.prototype._setupOptionMonitor=function(){return this._optionMonitor=new Monitor(this.options),this._optionMonitor.add(["radius","radiusFactor","gradient"],this._setupDrawTools,this)},Canvas.prototype._destroyOptionMonitor=function(){this._optionMonitor.removeAll(),this._optionMonitor={}},Canvas.prototype._setupDrawTools=function(){return this._brush=this._createBrush(),this._gradient=this._createGradient(),this},Canvas.prototype._destroyDrawTools=function(){this._brush=null,this._gradient=null},Canvas.prototype._createBrush=function(){var brush=document.createElement("canvas"),context=brush.getContext("2d"),radius=this.getBrushRadius(),gradient=context.createRadialGradient(radius,radius,0,radius,radius,radius);return brush.width=2*radius,brush.height=2*radius,gradient.addColorStop(0,"rgba(0,0,0,1)"),gradient.addColorStop(1,"rgba(0,0,0,0)"),context.fillStyle=gradient,context.fillRect(0,0,2*radius,2*radius),brush},Canvas.prototype._createGradient=function(){var canvas=document.createElement("canvas"),context=canvas.getContext("2d"),gradient=context.createLinearGradient(0,0,0,256);canvas.width=1,canvas.height=256;var gradientOption=this.options.get("gradient",DEFAULT_OPTIONS_gradient);for(var i in gradientOption)gradientOption.hasOwnProperty(i)&&gradient.addColorStop(i,gradientOption[i]);return context.fillStyle=gradient,context.fillRect(0,0,1,256),context.getImageData(0,0,1,256).data},Canvas.prototype._drawHeatmap=function(points){var context=this._context,radius=this.getBrushRadius(),intensityOfMidpoint,medianaOfWeights,weightFactor=this.options.get("intensityOfMidpoint",DEFAULT_OPTIONS_intensityOfMidpoint)/this.options.get("medianaOfWeights",DEFAULT_OPTIONS_medianaOfWeights);context.clearRect(0,0,this._canvas.width,this._canvas.height);for(var i=0,length=points.length;i<length;i++)context.globalAlpha=Math.min(points[i].weight*weightFactor,1),context.drawImage(this._brush,points[i].coordinates[0]-radius,points[i].coordinates[1]-radius);var heatmapImage=context.getImageData(0,0,this._canvas.width,this._canvas.height);return this._colorize(heatmapImage.data),context.putImageData(heatmapImage,0,0),this},Canvas.prototype._colorize=function(pixels){for(var opacity=this.options.get("opacity",DEFAULT_OPTIONS_opacity),i=3,length=pixels.length,j;i<length;i+=4)pixels[i]&&(j=4*pixels[i],pixels[i-3]=this._gradient[j],pixels[i-2]=this._gradient[j+1],pixels[i-1]=this._gradient[j+2],pixels[i]=opacity*(this._gradient[j+3]||255))},provide(Canvas)}));