import { IResource, Resource } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { IPermissionSet } from './permissionset';
import { PrincipalProperty } from './principal';
export declare enum TargetTypes {
    AWS_ACCOUNT = "AWS_ACCOUNT"
}
/**
 * The resource interface for an AWS SSO assignment.
 *
 * This interface has no attributes because the resulting resource has none.
 */
export interface IAssignment extends IResource {
}
/**
 * The base assignment class
 *
 * Currently this is mostly empty. There isn't any
 * valuable methods to apply here or any resulting
 * attributes to define.
 */
declare abstract class AssignmentBase extends Resource implements IAssignment {
}
/**
 * Attributes for an assignment of which there are none.
 */
export interface AssignmentAttributes {
}
/**
 * The options for creating an assignment.
 */
export interface AssignmentOptions {
    /**
    * The principal to assign the permission set to
    */
    readonly principal: PrincipalProperty;
    /**
    * The target id the permission set will be assigned to
    */
    readonly targetId: string;
    /**
    * The entity type for which the assignment will be created.
    *
    * @default TargetTypes.AWS_ACCOUNT
    */
    readonly targetType?: TargetTypes;
}
/**
 * The properties of a new assignment.
 */
export interface AssignmentProps extends AssignmentOptions {
    /**
     * The permission set to assign to the principal
     */
    readonly permissionSet: IPermissionSet;
}
/**
 * The assignment construct.
 *
 * Has no import method because there is no attributes to import.
 */
export declare class Assignment extends AssignmentBase {
    private static validateAwsAccountTargetId;
    constructor(scope: Construct, id: string, props: AssignmentProps);
}
export {};
