"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
function testFixture() {
    const { stack, app } = testFixtureNoVpc();
    const vpc = new ec2.Vpc(stack, 'VPC');
    return { stack, vpc, app };
}
exports.testFixture = testFixture;
function testFixtureNoVpc() {
    const app = new core_1.App();
    const stack = new core_1.Stack(app, 'Stack', { env: { region: 'us-east-1' } });
    return { stack, app };
}
exports.testFixtureNoVpc = testFixtureNoVpc;
function testFixtureCluster() {
    const { stack, app } = testFixtureNoVpc();
    const cluster = new lib_1.Cluster(stack, 'Cluster');
    return { stack, app, cluster };
}
exports.testFixtureCluster = testFixtureCluster;
// we must specify an explicit environment because we have an AMI map that is
// keyed from the target region.
const env = {
    region: process.env.CDK_INTEG_REGION || process.env.CDK_DEFAULT_REGION,
    account: process.env.CDK_INTEG_ACCOUNT || process.env.CDK_DEFAULT_ACCOUNT,
};
class TestStack extends core_1.Stack {
    constructor(scope, id) {
        super(scope, id, { env });
    }
}
exports.TestStack = TestStack;
//# sourceMappingURL=data:application/json;base64,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