"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const ssm = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'SSM-Parameter');
const role = new iam.Role(stack, 'UserRole', {
    assumedBy: new iam.AccountRootPrincipal(),
});
/// !show
// Create a new SSM Parameter holding a String
const param = new ssm.StringParameter(stack, 'StringParameter', {
    // description: 'Some user-friendly description',
    // name: 'ParameterName',
    stringValue: 'Initial parameter value',
});
// Grant read access to some Role
param.grantRead(role);
// Create a new SSM Parameter holding a StringList
const listParameter = new ssm.StringListParameter(stack, 'StringListParameter', {
    // description: 'Some user-friendly description',
    // name: 'ParameterName',
    stringListValue: ['Initial parameter value A', 'Initial parameter value B'],
});
/// !hide
new cdk.CfnOutput(stack, 'StringListOutput', {
    value: cdk.Fn.join('+', listParameter.stringListValue),
});
new cdk.CfnOutput(stack, 'ParamArn', {
    value: param.parameterArn,
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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