# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class UpdateScheduleUploadSchema(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        UpdateScheduleUploadSchema - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'description': 'str',
            'published': 'bool',
            'short_term_forecast': 'BuShortTermForecastReference',
            'headcount_forecast': 'BuHeadcountForecast',
            'agent_schedules': 'list[BuUpdateAgentScheduleUploadSchema]',
            'metadata': 'WfmVersionedEntityMetadata'
        }

        self.attribute_map = {
            'description': 'description',
            'published': 'published',
            'short_term_forecast': 'shortTermForecast',
            'headcount_forecast': 'headcountForecast',
            'agent_schedules': 'agentSchedules',
            'metadata': 'metadata'
        }

        self._description = None
        self._published = None
        self._short_term_forecast = None
        self._headcount_forecast = None
        self._agent_schedules = None
        self._metadata = None

    @property
    def description(self):
        """
        Gets the description of this UpdateScheduleUploadSchema.
        The description to set for the schedule

        :return: The description of this UpdateScheduleUploadSchema.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateScheduleUploadSchema.
        The description to set for the schedule

        :param description: The description of this UpdateScheduleUploadSchema.
        :type: str
        """
        
        self._description = description

    @property
    def published(self):
        """
        Gets the published of this UpdateScheduleUploadSchema.
        Whether to publish the schedule. Note: a schedule cannot be un-published unless another schedule is published over it

        :return: The published of this UpdateScheduleUploadSchema.
        :rtype: bool
        """
        return self._published

    @published.setter
    def published(self, published):
        """
        Sets the published of this UpdateScheduleUploadSchema.
        Whether to publish the schedule. Note: a schedule cannot be un-published unless another schedule is published over it

        :param published: The published of this UpdateScheduleUploadSchema.
        :type: bool
        """
        
        self._published = published

    @property
    def short_term_forecast(self):
        """
        Gets the short_term_forecast of this UpdateScheduleUploadSchema.
        The short term forecast to associate with the schedule

        :return: The short_term_forecast of this UpdateScheduleUploadSchema.
        :rtype: BuShortTermForecastReference
        """
        return self._short_term_forecast

    @short_term_forecast.setter
    def short_term_forecast(self, short_term_forecast):
        """
        Sets the short_term_forecast of this UpdateScheduleUploadSchema.
        The short term forecast to associate with the schedule

        :param short_term_forecast: The short_term_forecast of this UpdateScheduleUploadSchema.
        :type: BuShortTermForecastReference
        """
        
        self._short_term_forecast = short_term_forecast

    @property
    def headcount_forecast(self):
        """
        Gets the headcount_forecast of this UpdateScheduleUploadSchema.
        The headcount forecast to associate with the schedule

        :return: The headcount_forecast of this UpdateScheduleUploadSchema.
        :rtype: BuHeadcountForecast
        """
        return self._headcount_forecast

    @headcount_forecast.setter
    def headcount_forecast(self, headcount_forecast):
        """
        Sets the headcount_forecast of this UpdateScheduleUploadSchema.
        The headcount forecast to associate with the schedule

        :param headcount_forecast: The headcount_forecast of this UpdateScheduleUploadSchema.
        :type: BuHeadcountForecast
        """
        
        self._headcount_forecast = headcount_forecast

    @property
    def agent_schedules(self):
        """
        Gets the agent_schedules of this UpdateScheduleUploadSchema.
        Individual agent schedules

        :return: The agent_schedules of this UpdateScheduleUploadSchema.
        :rtype: list[BuUpdateAgentScheduleUploadSchema]
        """
        return self._agent_schedules

    @agent_schedules.setter
    def agent_schedules(self, agent_schedules):
        """
        Sets the agent_schedules of this UpdateScheduleUploadSchema.
        Individual agent schedules

        :param agent_schedules: The agent_schedules of this UpdateScheduleUploadSchema.
        :type: list[BuUpdateAgentScheduleUploadSchema]
        """
        
        self._agent_schedules = agent_schedules

    @property
    def metadata(self):
        """
        Gets the metadata of this UpdateScheduleUploadSchema.
        Version metadata for this schedule

        :return: The metadata of this UpdateScheduleUploadSchema.
        :rtype: WfmVersionedEntityMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this UpdateScheduleUploadSchema.
        Version metadata for this schedule

        :param metadata: The metadata of this UpdateScheduleUploadSchema.
        :type: WfmVersionedEntityMetadata
        """
        
        self._metadata = metadata

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

