# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class SupportCenterSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        SupportCenterSettings - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'enabled': 'bool',
            'knowledge_base': 'AddressableEntityRef',
            'custom_messages': 'list[SupportCenterCustomMessage]',
            'router_type': 'str',
            'screens': 'list[SupportCenterScreen]',
            'enabled_categories': 'list[AddressableEntityRef]',
            'style_setting': 'SupportCenterStyleSetting'
        }

        self.attribute_map = {
            'enabled': 'enabled',
            'knowledge_base': 'knowledgeBase',
            'custom_messages': 'customMessages',
            'router_type': 'routerType',
            'screens': 'screens',
            'enabled_categories': 'enabledCategories',
            'style_setting': 'styleSetting'
        }

        self._enabled = None
        self._knowledge_base = None
        self._custom_messages = None
        self._router_type = None
        self._screens = None
        self._enabled_categories = None
        self._style_setting = None

    @property
    def enabled(self):
        """
        Gets the enabled of this SupportCenterSettings.
        Whether or not support center is enabled

        :return: The enabled of this SupportCenterSettings.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this SupportCenterSettings.
        Whether or not support center is enabled

        :param enabled: The enabled of this SupportCenterSettings.
        :type: bool
        """
        
        self._enabled = enabled

    @property
    def knowledge_base(self):
        """
        Gets the knowledge_base of this SupportCenterSettings.
        The knowledge base for support center

        :return: The knowledge_base of this SupportCenterSettings.
        :rtype: AddressableEntityRef
        """
        return self._knowledge_base

    @knowledge_base.setter
    def knowledge_base(self, knowledge_base):
        """
        Sets the knowledge_base of this SupportCenterSettings.
        The knowledge base for support center

        :param knowledge_base: The knowledge_base of this SupportCenterSettings.
        :type: AddressableEntityRef
        """
        
        self._knowledge_base = knowledge_base

    @property
    def custom_messages(self):
        """
        Gets the custom_messages of this SupportCenterSettings.
        Customizable display texts for support center

        :return: The custom_messages of this SupportCenterSettings.
        :rtype: list[SupportCenterCustomMessage]
        """
        return self._custom_messages

    @custom_messages.setter
    def custom_messages(self, custom_messages):
        """
        Sets the custom_messages of this SupportCenterSettings.
        Customizable display texts for support center

        :param custom_messages: The custom_messages of this SupportCenterSettings.
        :type: list[SupportCenterCustomMessage]
        """
        
        self._custom_messages = custom_messages

    @property
    def router_type(self):
        """
        Gets the router_type of this SupportCenterSettings.
        Router type for support center

        :return: The router_type of this SupportCenterSettings.
        :rtype: str
        """
        return self._router_type

    @router_type.setter
    def router_type(self, router_type):
        """
        Sets the router_type of this SupportCenterSettings.
        Router type for support center

        :param router_type: The router_type of this SupportCenterSettings.
        :type: str
        """
        allowed_values = ["Hash", "Browser"]
        if router_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for router_type -> " + router_type)
            self._router_type = "outdated_sdk_version"
        else:
            self._router_type = router_type

    @property
    def screens(self):
        """
        Gets the screens of this SupportCenterSettings.
        Available screens for the support center with its modules

        :return: The screens of this SupportCenterSettings.
        :rtype: list[SupportCenterScreen]
        """
        return self._screens

    @screens.setter
    def screens(self, screens):
        """
        Sets the screens of this SupportCenterSettings.
        Available screens for the support center with its modules

        :param screens: The screens of this SupportCenterSettings.
        :type: list[SupportCenterScreen]
        """
        
        self._screens = screens

    @property
    def enabled_categories(self):
        """
        Gets the enabled_categories of this SupportCenterSettings.
        Enabled article categories for support center

        :return: The enabled_categories of this SupportCenterSettings.
        :rtype: list[AddressableEntityRef]
        """
        return self._enabled_categories

    @enabled_categories.setter
    def enabled_categories(self, enabled_categories):
        """
        Sets the enabled_categories of this SupportCenterSettings.
        Enabled article categories for support center

        :param enabled_categories: The enabled_categories of this SupportCenterSettings.
        :type: list[AddressableEntityRef]
        """
        
        self._enabled_categories = enabled_categories

    @property
    def style_setting(self):
        """
        Gets the style_setting of this SupportCenterSettings.
        Style attributes for support center

        :return: The style_setting of this SupportCenterSettings.
        :rtype: SupportCenterStyleSetting
        """
        return self._style_setting

    @style_setting.setter
    def style_setting(self, style_setting):
        """
        Sets the style_setting of this SupportCenterSettings.
        Style attributes for support center

        :param style_setting: The style_setting of this SupportCenterSettings.
        :type: SupportCenterStyleSetting
        """
        
        self._style_setting = style_setting

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

