# coding: utf-8

"""
LanguageUnderstandingApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class LanguageUnderstandingApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_languageunderstanding_domain(self, domain_id, **kwargs):
        """
        Delete an NLU Domain.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_languageunderstanding_domain(domain_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_id: ID of the NLU domain. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_languageunderstanding_domain" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_id' is set
        if ('domain_id' not in params) or (params['domain_id'] is None):
            raise ValueError("Missing the required parameter `domain_id` when calling `delete_languageunderstanding_domain`")


        resource_path = '/api/v2/languageunderstanding/domains/{domainId}'.replace('{format}', 'json')
        path_params = {}
        if 'domain_id' in params:
            path_params['domainId'] = params['domain_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_languageunderstanding_domain_feedback_feedback_id(self, domain_id, feedback_id, **kwargs):
        """
        Delete the feedback on the NLU Domain Version.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_languageunderstanding_domain_feedback_feedback_id(domain_id, feedback_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_id: ID of the NLU domain. (required)
        :param str feedback_id: ID of the Feedback (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_id', 'feedback_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_languageunderstanding_domain_feedback_feedback_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_id' is set
        if ('domain_id' not in params) or (params['domain_id'] is None):
            raise ValueError("Missing the required parameter `domain_id` when calling `delete_languageunderstanding_domain_feedback_feedback_id`")
        # verify the required parameter 'feedback_id' is set
        if ('feedback_id' not in params) or (params['feedback_id'] is None):
            raise ValueError("Missing the required parameter `feedback_id` when calling `delete_languageunderstanding_domain_feedback_feedback_id`")


        resource_path = '/api/v2/languageunderstanding/domains/{domainId}/feedback/{feedbackId}'.replace('{format}', 'json')
        path_params = {}
        if 'domain_id' in params:
            path_params['domainId'] = params['domain_id']
        if 'feedback_id' in params:
            path_params['feedbackId'] = params['feedback_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_languageunderstanding_domain_version(self, domain_id, domain_version_id, **kwargs):
        """
        Delete an NLU Domain Version
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_languageunderstanding_domain_version(domain_id, domain_version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_id: ID of the NLU domain. (required)
        :param str domain_version_id: ID of the NLU domain version. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_id', 'domain_version_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_languageunderstanding_domain_version" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_id' is set
        if ('domain_id' not in params) or (params['domain_id'] is None):
            raise ValueError("Missing the required parameter `domain_id` when calling `delete_languageunderstanding_domain_version`")
        # verify the required parameter 'domain_version_id' is set
        if ('domain_version_id' not in params) or (params['domain_version_id'] is None):
            raise ValueError("Missing the required parameter `domain_version_id` when calling `delete_languageunderstanding_domain_version`")


        resource_path = '/api/v2/languageunderstanding/domains/{domainId}/versions/{domainVersionId}'.replace('{format}', 'json')
        path_params = {}
        if 'domain_id' in params:
            path_params['domainId'] = params['domain_id']
        if 'domain_version_id' in params:
            path_params['domainVersionId'] = params['domain_version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_languageunderstanding_miner(self, miner_id, **kwargs):
        """
        Delete a miner.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_languageunderstanding_miner(miner_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str miner_id: Miner ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['miner_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_languageunderstanding_miner" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'miner_id' is set
        if ('miner_id' not in params) or (params['miner_id'] is None):
            raise ValueError("Missing the required parameter `miner_id` when calling `delete_languageunderstanding_miner`")


        resource_path = '/api/v2/languageunderstanding/miners/{minerId}'.replace('{format}', 'json')
        path_params = {}
        if 'miner_id' in params:
            path_params['minerId'] = params['miner_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_languageunderstanding_miner_draft(self, miner_id, draft_id, **kwargs):
        """
        Delete a draft
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_languageunderstanding_miner_draft(miner_id, draft_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str miner_id: Miner ID (required)
        :param str draft_id: Draft ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['miner_id', 'draft_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_languageunderstanding_miner_draft" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'miner_id' is set
        if ('miner_id' not in params) or (params['miner_id'] is None):
            raise ValueError("Missing the required parameter `miner_id` when calling `delete_languageunderstanding_miner_draft`")
        # verify the required parameter 'draft_id' is set
        if ('draft_id' not in params) or (params['draft_id'] is None):
            raise ValueError("Missing the required parameter `draft_id` when calling `delete_languageunderstanding_miner_draft`")


        resource_path = '/api/v2/languageunderstanding/miners/{minerId}/drafts/{draftId}'.replace('{format}', 'json')
        path_params = {}
        if 'miner_id' in params:
            path_params['minerId'] = params['miner_id']
        if 'draft_id' in params:
            path_params['draftId'] = params['draft_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_languageunderstanding_domain(self, domain_id, **kwargs):
        """
        Find an NLU Domain.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_languageunderstanding_domain(domain_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_id: ID of the NLU domain. (required)
        :return: NluDomain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_languageunderstanding_domain" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_id' is set
        if ('domain_id' not in params) or (params['domain_id'] is None):
            raise ValueError("Missing the required parameter `domain_id` when calling `get_languageunderstanding_domain`")


        resource_path = '/api/v2/languageunderstanding/domains/{domainId}'.replace('{format}', 'json')
        path_params = {}
        if 'domain_id' in params:
            path_params['domainId'] = params['domain_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='NluDomain',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_languageunderstanding_domain_feedback(self, domain_id, **kwargs):
        """
        Get all feedback in the given NLU Domain Version.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_languageunderstanding_domain_feedback(domain_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_id: ID of the NLU domain. (required)
        :param str intent_name: The top intent name to retrieve feedback for.
        :param str assessment: The top assessment to retrieve feedback for.
        :param date date_start: Begin of time window as ISO-8601 date.
        :param date date_end: End of time window as ISO-8601 date.
        :param bool include_deleted: Whether to include soft-deleted items in the result.
        :param int page_number: Page number
        :param int page_size: Page size
        :param bool enable_cursor_pagination: Enable Cursor Pagination
        :param str after: The cursor that points to the end of the set of entities that has been returned. This is considered only when enableCursorPagination=true
        :param list[str] fields: Fields and properties to get, comma-separated
        :return: NluFeedbackListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_id', 'intent_name', 'assessment', 'date_start', 'date_end', 'include_deleted', 'page_number', 'page_size', 'enable_cursor_pagination', 'after', 'fields']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_languageunderstanding_domain_feedback" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_id' is set
        if ('domain_id' not in params) or (params['domain_id'] is None):
            raise ValueError("Missing the required parameter `domain_id` when calling `get_languageunderstanding_domain_feedback`")


        resource_path = '/api/v2/languageunderstanding/domains/{domainId}/feedback'.replace('{format}', 'json')
        path_params = {}
        if 'domain_id' in params:
            path_params['domainId'] = params['domain_id']

        query_params = {}
        if 'intent_name' in params:
            query_params['intentName'] = params['intent_name']
        if 'assessment' in params:
            query_params['assessment'] = params['assessment']
        if 'date_start' in params:
            query_params['dateStart'] = params['date_start']
        if 'date_end' in params:
            query_params['dateEnd'] = params['date_end']
        if 'include_deleted' in params:
            query_params['includeDeleted'] = params['include_deleted']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'enable_cursor_pagination' in params:
            query_params['enableCursorPagination'] = params['enable_cursor_pagination']
        if 'after' in params:
            query_params['after'] = params['after']
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='NluFeedbackListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_languageunderstanding_domain_feedback_feedback_id(self, domain_id, feedback_id, **kwargs):
        """
        Find a Feedback
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_languageunderstanding_domain_feedback_feedback_id(domain_id, feedback_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_id: ID of the NLU domain. (required)
        :param str feedback_id: ID of the Feedback (required)
        :param list[str] fields: Fields and properties to get, comma-separated
        :return: NluFeedbackResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_id', 'feedback_id', 'fields']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_languageunderstanding_domain_feedback_feedback_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_id' is set
        if ('domain_id' not in params) or (params['domain_id'] is None):
            raise ValueError("Missing the required parameter `domain_id` when calling `get_languageunderstanding_domain_feedback_feedback_id`")
        # verify the required parameter 'feedback_id' is set
        if ('feedback_id' not in params) or (params['feedback_id'] is None):
            raise ValueError("Missing the required parameter `feedback_id` when calling `get_languageunderstanding_domain_feedback_feedback_id`")


        resource_path = '/api/v2/languageunderstanding/domains/{domainId}/feedback/{feedbackId}'.replace('{format}', 'json')
        path_params = {}
        if 'domain_id' in params:
            path_params['domainId'] = params['domain_id']
        if 'feedback_id' in params:
            path_params['feedbackId'] = params['feedback_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='NluFeedbackResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_languageunderstanding_domain_version(self, domain_id, domain_version_id, **kwargs):
        """
        Find an NLU Domain Version.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_languageunderstanding_domain_version(domain_id, domain_version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_id: ID of the NLU domain. (required)
        :param str domain_version_id: ID of the NLU domain version. (required)
        :param bool include_utterances: Whether utterances for intent definition should be included when marshalling response.
        :return: NluDomainVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_id', 'domain_version_id', 'include_utterances']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_languageunderstanding_domain_version" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_id' is set
        if ('domain_id' not in params) or (params['domain_id'] is None):
            raise ValueError("Missing the required parameter `domain_id` when calling `get_languageunderstanding_domain_version`")
        # verify the required parameter 'domain_version_id' is set
        if ('domain_version_id' not in params) or (params['domain_version_id'] is None):
            raise ValueError("Missing the required parameter `domain_version_id` when calling `get_languageunderstanding_domain_version`")


        resource_path = '/api/v2/languageunderstanding/domains/{domainId}/versions/{domainVersionId}'.replace('{format}', 'json')
        path_params = {}
        if 'domain_id' in params:
            path_params['domainId'] = params['domain_id']
        if 'domain_version_id' in params:
            path_params['domainVersionId'] = params['domain_version_id']

        query_params = {}
        if 'include_utterances' in params:
            query_params['includeUtterances'] = params['include_utterances']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='NluDomainVersion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_languageunderstanding_domain_version_report(self, domain_id, domain_version_id, **kwargs):
        """
        Retrieved quality report for the specified NLU Domain Version
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_languageunderstanding_domain_version_report(domain_id, domain_version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_id: ID of the NLU domain. (required)
        :param str domain_version_id: ID of the NLU domain version. (required)
        :return: NluDomainVersionQualityReport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_id', 'domain_version_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_languageunderstanding_domain_version_report" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_id' is set
        if ('domain_id' not in params) or (params['domain_id'] is None):
            raise ValueError("Missing the required parameter `domain_id` when calling `get_languageunderstanding_domain_version_report`")
        # verify the required parameter 'domain_version_id' is set
        if ('domain_version_id' not in params) or (params['domain_version_id'] is None):
            raise ValueError("Missing the required parameter `domain_version_id` when calling `get_languageunderstanding_domain_version_report`")


        resource_path = '/api/v2/languageunderstanding/domains/{domainId}/versions/{domainVersionId}/report'.replace('{format}', 'json')
        path_params = {}
        if 'domain_id' in params:
            path_params['domainId'] = params['domain_id']
        if 'domain_version_id' in params:
            path_params['domainVersionId'] = params['domain_version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='NluDomainVersionQualityReport',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_languageunderstanding_domain_versions(self, domain_id, **kwargs):
        """
        Get all NLU Domain Versions for a given Domain.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_languageunderstanding_domain_versions(domain_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_id: ID of the NLU domain. (required)
        :param bool include_utterances: Whether utterances for intent definition should be included when marshalling response.
        :param int page_number: Page number
        :param int page_size: Page size
        :return: NluDomainVersionListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_id', 'include_utterances', 'page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_languageunderstanding_domain_versions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_id' is set
        if ('domain_id' not in params) or (params['domain_id'] is None):
            raise ValueError("Missing the required parameter `domain_id` when calling `get_languageunderstanding_domain_versions`")


        resource_path = '/api/v2/languageunderstanding/domains/{domainId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'domain_id' in params:
            path_params['domainId'] = params['domain_id']

        query_params = {}
        if 'include_utterances' in params:
            query_params['includeUtterances'] = params['include_utterances']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='NluDomainVersionListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_languageunderstanding_domains(self, **kwargs):
        """
        Get all NLU Domains.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_languageunderstanding_domains(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :return: NluDomainListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_languageunderstanding_domains" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/languageunderstanding/domains'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='NluDomainListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_languageunderstanding_miner(self, miner_id, **kwargs):
        """
        Get information about a miner.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_languageunderstanding_miner(miner_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str miner_id: Miner ID (required)
        :return: Miner
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['miner_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_languageunderstanding_miner" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'miner_id' is set
        if ('miner_id' not in params) or (params['miner_id'] is None):
            raise ValueError("Missing the required parameter `miner_id` when calling `get_languageunderstanding_miner`")


        resource_path = '/api/v2/languageunderstanding/miners/{minerId}'.replace('{format}', 'json')
        path_params = {}
        if 'miner_id' in params:
            path_params['minerId'] = params['miner_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Miner',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_languageunderstanding_miner_draft(self, miner_id, draft_id, **kwargs):
        """
        Get information about a draft.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_languageunderstanding_miner_draft(miner_id, draft_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str miner_id: Miner ID (required)
        :param str draft_id: Draft ID (required)
        :return: Draft
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['miner_id', 'draft_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_languageunderstanding_miner_draft" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'miner_id' is set
        if ('miner_id' not in params) or (params['miner_id'] is None):
            raise ValueError("Missing the required parameter `miner_id` when calling `get_languageunderstanding_miner_draft`")
        # verify the required parameter 'draft_id' is set
        if ('draft_id' not in params) or (params['draft_id'] is None):
            raise ValueError("Missing the required parameter `draft_id` when calling `get_languageunderstanding_miner_draft`")


        resource_path = '/api/v2/languageunderstanding/miners/{minerId}/drafts/{draftId}'.replace('{format}', 'json')
        path_params = {}
        if 'miner_id' in params:
            path_params['minerId'] = params['miner_id']
        if 'draft_id' in params:
            path_params['draftId'] = params['draft_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Draft',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_languageunderstanding_miner_drafts(self, miner_id, **kwargs):
        """
        Retrieve the list of drafts created.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_languageunderstanding_miner_drafts(miner_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str miner_id: Miner ID (required)
        :return: DraftListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['miner_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_languageunderstanding_miner_drafts" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'miner_id' is set
        if ('miner_id' not in params) or (params['miner_id'] is None):
            raise ValueError("Missing the required parameter `miner_id` when calling `get_languageunderstanding_miner_drafts`")


        resource_path = '/api/v2/languageunderstanding/miners/{minerId}/drafts'.replace('{format}', 'json')
        path_params = {}
        if 'miner_id' in params:
            path_params['minerId'] = params['miner_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DraftListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_languageunderstanding_miner_intent(self, miner_id, intent_id, **kwargs):
        """
        Get information about a mined intent
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_languageunderstanding_miner_intent(miner_id, intent_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str miner_id: Miner ID (required)
        :param str intent_id: The ID of the intent to be retrieved. (required)
        :param str expand: Option to fetch utterances
        :return: MinerIntent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['miner_id', 'intent_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_languageunderstanding_miner_intent" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'miner_id' is set
        if ('miner_id' not in params) or (params['miner_id'] is None):
            raise ValueError("Missing the required parameter `miner_id` when calling `get_languageunderstanding_miner_intent`")
        # verify the required parameter 'intent_id' is set
        if ('intent_id' not in params) or (params['intent_id'] is None):
            raise ValueError("Missing the required parameter `intent_id` when calling `get_languageunderstanding_miner_intent`")


        resource_path = '/api/v2/languageunderstanding/miners/{minerId}/intents/{intentId}'.replace('{format}', 'json')
        path_params = {}
        if 'miner_id' in params:
            path_params['minerId'] = params['miner_id']
        if 'intent_id' in params:
            path_params['intentId'] = params['intent_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MinerIntent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_languageunderstanding_miner_intents(self, miner_id, **kwargs):
        """
        Retrieve a list of mined intents.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_languageunderstanding_miner_intents(miner_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str miner_id: Miner ID (required)
        :param str expand: Option to fetch utterances.
        :return: MinedIntentsListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['miner_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_languageunderstanding_miner_intents" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'miner_id' is set
        if ('miner_id' not in params) or (params['miner_id'] is None):
            raise ValueError("Missing the required parameter `miner_id` when calling `get_languageunderstanding_miner_intents`")


        resource_path = '/api/v2/languageunderstanding/miners/{minerId}/intents'.replace('{format}', 'json')
        path_params = {}
        if 'miner_id' in params:
            path_params['minerId'] = params['miner_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MinedIntentsListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_languageunderstanding_miners(self, **kwargs):
        """
        Retrieve the list of miners created.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_languageunderstanding_miners(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: MinerListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_languageunderstanding_miners" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/languageunderstanding/miners'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MinerListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_languageunderstanding_domain(self, domain_id, body, **kwargs):
        """
        Update an NLU Domain.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_languageunderstanding_domain(domain_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_id: ID of the NLU domain. (required)
        :param NluDomain body: The updated NLU Domain. (required)
        :return: NluDomain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_languageunderstanding_domain" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_id' is set
        if ('domain_id' not in params) or (params['domain_id'] is None):
            raise ValueError("Missing the required parameter `domain_id` when calling `patch_languageunderstanding_domain`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_languageunderstanding_domain`")


        resource_path = '/api/v2/languageunderstanding/domains/{domainId}'.replace('{format}', 'json')
        path_params = {}
        if 'domain_id' in params:
            path_params['domainId'] = params['domain_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='NluDomain',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_languageunderstanding_miner_draft(self, miner_id, draft_id, **kwargs):
        """
        Save information for the draft. Either topic draft or intent draft should be sent.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_languageunderstanding_miner_draft(miner_id, draft_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str miner_id: Miner ID (required)
        :param str draft_id: Draft ID (required)
        :param DraftRequest body: 
        :return: Draft
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['miner_id', 'draft_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_languageunderstanding_miner_draft" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'miner_id' is set
        if ('miner_id' not in params) or (params['miner_id'] is None):
            raise ValueError("Missing the required parameter `miner_id` when calling `patch_languageunderstanding_miner_draft`")
        # verify the required parameter 'draft_id' is set
        if ('draft_id' not in params) or (params['draft_id'] is None):
            raise ValueError("Missing the required parameter `draft_id` when calling `patch_languageunderstanding_miner_draft`")


        resource_path = '/api/v2/languageunderstanding/miners/{minerId}/drafts/{draftId}'.replace('{format}', 'json')
        path_params = {}
        if 'miner_id' in params:
            path_params['minerId'] = params['miner_id']
        if 'draft_id' in params:
            path_params['draftId'] = params['draft_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Draft',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_languageunderstanding_domain_feedback(self, domain_id, body, **kwargs):
        """
        Create feedback for the NLU Domain Version.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_languageunderstanding_domain_feedback(domain_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_id: ID of the NLU domain. (required)
        :param NluFeedbackRequest body: The Feedback to create. (required)
        :return: NluFeedbackResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_languageunderstanding_domain_feedback" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_id' is set
        if ('domain_id' not in params) or (params['domain_id'] is None):
            raise ValueError("Missing the required parameter `domain_id` when calling `post_languageunderstanding_domain_feedback`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_languageunderstanding_domain_feedback`")


        resource_path = '/api/v2/languageunderstanding/domains/{domainId}/feedback'.replace('{format}', 'json')
        path_params = {}
        if 'domain_id' in params:
            path_params['domainId'] = params['domain_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='NluFeedbackResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_languageunderstanding_domain_version_detect(self, domain_id, domain_version_id, body, **kwargs):
        """
        Detect intent, entities, etc. in the submitted text using the specified NLU domain version.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_languageunderstanding_domain_version_detect(domain_id, domain_version_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_id: ID of the NLU domain. (required)
        :param str domain_version_id: ID of the NLU domain version. (required)
        :param NluDetectionRequest body: The input data to perform detection on. (required)
        :return: NluDetectionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_id', 'domain_version_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_languageunderstanding_domain_version_detect" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_id' is set
        if ('domain_id' not in params) or (params['domain_id'] is None):
            raise ValueError("Missing the required parameter `domain_id` when calling `post_languageunderstanding_domain_version_detect`")
        # verify the required parameter 'domain_version_id' is set
        if ('domain_version_id' not in params) or (params['domain_version_id'] is None):
            raise ValueError("Missing the required parameter `domain_version_id` when calling `post_languageunderstanding_domain_version_detect`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_languageunderstanding_domain_version_detect`")


        resource_path = '/api/v2/languageunderstanding/domains/{domainId}/versions/{domainVersionId}/detect'.replace('{format}', 'json')
        path_params = {}
        if 'domain_id' in params:
            path_params['domainId'] = params['domain_id']
        if 'domain_version_id' in params:
            path_params['domainVersionId'] = params['domain_version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='NluDetectionResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_languageunderstanding_domain_version_publish(self, domain_id, domain_version_id, **kwargs):
        """
        Publish the draft NLU Domain Version.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_languageunderstanding_domain_version_publish(domain_id, domain_version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_id: ID of the NLU domain. (required)
        :param str domain_version_id: ID of the NLU domain version. (required)
        :return: NluDomainVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_id', 'domain_version_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_languageunderstanding_domain_version_publish" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_id' is set
        if ('domain_id' not in params) or (params['domain_id'] is None):
            raise ValueError("Missing the required parameter `domain_id` when calling `post_languageunderstanding_domain_version_publish`")
        # verify the required parameter 'domain_version_id' is set
        if ('domain_version_id' not in params) or (params['domain_version_id'] is None):
            raise ValueError("Missing the required parameter `domain_version_id` when calling `post_languageunderstanding_domain_version_publish`")


        resource_path = '/api/v2/languageunderstanding/domains/{domainId}/versions/{domainVersionId}/publish'.replace('{format}', 'json')
        path_params = {}
        if 'domain_id' in params:
            path_params['domainId'] = params['domain_id']
        if 'domain_version_id' in params:
            path_params['domainVersionId'] = params['domain_version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='NluDomainVersion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_languageunderstanding_domain_version_train(self, domain_id, domain_version_id, **kwargs):
        """
        Train the draft NLU Domain Version.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_languageunderstanding_domain_version_train(domain_id, domain_version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_id: ID of the NLU domain. (required)
        :param str domain_version_id: ID of the NLU domain version. (required)
        :return: NluDomainVersionTrainingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_id', 'domain_version_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_languageunderstanding_domain_version_train" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_id' is set
        if ('domain_id' not in params) or (params['domain_id'] is None):
            raise ValueError("Missing the required parameter `domain_id` when calling `post_languageunderstanding_domain_version_train`")
        # verify the required parameter 'domain_version_id' is set
        if ('domain_version_id' not in params) or (params['domain_version_id'] is None):
            raise ValueError("Missing the required parameter `domain_version_id` when calling `post_languageunderstanding_domain_version_train`")


        resource_path = '/api/v2/languageunderstanding/domains/{domainId}/versions/{domainVersionId}/train'.replace('{format}', 'json')
        path_params = {}
        if 'domain_id' in params:
            path_params['domainId'] = params['domain_id']
        if 'domain_version_id' in params:
            path_params['domainVersionId'] = params['domain_version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='NluDomainVersionTrainingResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_languageunderstanding_domain_versions(self, domain_id, body, **kwargs):
        """
        Create an NLU Domain Version.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_languageunderstanding_domain_versions(domain_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_id: ID of the NLU domain. (required)
        :param NluDomainVersion body: The NLU Domain Version to create. (required)
        :return: NluDomainVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_languageunderstanding_domain_versions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_id' is set
        if ('domain_id' not in params) or (params['domain_id'] is None):
            raise ValueError("Missing the required parameter `domain_id` when calling `post_languageunderstanding_domain_versions`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_languageunderstanding_domain_versions`")


        resource_path = '/api/v2/languageunderstanding/domains/{domainId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'domain_id' in params:
            path_params['domainId'] = params['domain_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='NluDomainVersion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_languageunderstanding_domains(self, body, **kwargs):
        """
        Create an NLU Domain.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_languageunderstanding_domains(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param NluDomain body: The NLU Domain to create. (required)
        :return: NluDomain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_languageunderstanding_domains" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_languageunderstanding_domains`")


        resource_path = '/api/v2/languageunderstanding/domains'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='NluDomain',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_languageunderstanding_miner_drafts(self, miner_id, body, **kwargs):
        """
        Create a new draft resource.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_languageunderstanding_miner_drafts(miner_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str miner_id: Miner ID (required)
        :param Draft body: Details for creating draft resource (required)
        :return: Draft
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['miner_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_languageunderstanding_miner_drafts" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'miner_id' is set
        if ('miner_id' not in params) or (params['miner_id'] is None):
            raise ValueError("Missing the required parameter `miner_id` when calling `post_languageunderstanding_miner_drafts`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_languageunderstanding_miner_drafts`")


        resource_path = '/api/v2/languageunderstanding/miners/{minerId}/drafts'.replace('{format}', 'json')
        path_params = {}
        if 'miner_id' in params:
            path_params['minerId'] = params['miner_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Draft',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_languageunderstanding_miner_execute(self, miner_id, **kwargs):
        """
        Start the mining process. Specify date range pair with mediaType, queueIds, participantType for mining data from Genesys Cloud. Specify only uploadKey for mining through an external file.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_languageunderstanding_miner_execute(miner_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str miner_id: Miner ID (required)
        :param MinerExecuteRequest body: 
        :return: Miner
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['miner_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_languageunderstanding_miner_execute" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'miner_id' is set
        if ('miner_id' not in params) or (params['miner_id'] is None):
            raise ValueError("Missing the required parameter `miner_id` when calling `post_languageunderstanding_miner_execute`")


        resource_path = '/api/v2/languageunderstanding/miners/{minerId}/execute'.replace('{format}', 'json')
        path_params = {}
        if 'miner_id' in params:
            path_params['minerId'] = params['miner_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Miner',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_languageunderstanding_miners(self, body, **kwargs):
        """
        Create a unique miner.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_languageunderstanding_miners(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Miner body: Details for creating a new miner resource. (required)
        :return: Miner
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_languageunderstanding_miners" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_languageunderstanding_miners`")


        resource_path = '/api/v2/languageunderstanding/miners'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Miner',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_languageunderstanding_domain_version(self, domain_id, domain_version_id, body, **kwargs):
        """
        Update an NLU Domain Version.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_languageunderstanding_domain_version(domain_id, domain_version_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str domain_id: ID of the NLU domain. (required)
        :param str domain_version_id: ID of the NLU domain version. (required)
        :param NluDomainVersion body: The updated NLU Domain Version. (required)
        :return: NluDomainVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain_id', 'domain_version_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_languageunderstanding_domain_version" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'domain_id' is set
        if ('domain_id' not in params) or (params['domain_id'] is None):
            raise ValueError("Missing the required parameter `domain_id` when calling `put_languageunderstanding_domain_version`")
        # verify the required parameter 'domain_version_id' is set
        if ('domain_version_id' not in params) or (params['domain_version_id'] is None):
            raise ValueError("Missing the required parameter `domain_version_id` when calling `put_languageunderstanding_domain_version`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_languageunderstanding_domain_version`")


        resource_path = '/api/v2/languageunderstanding/domains/{domainId}/versions/{domainVersionId}'.replace('{format}', 'json')
        path_params = {}
        if 'domain_id' in params:
            path_params['domainId'] = params['domain_id']
        if 'domain_version_id' in params:
            path_params['domainVersionId'] = params['domain_version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='NluDomainVersion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
