# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class WebMessagingRecipient(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        WebMessagingRecipient - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'first_name': 'str',
            'last_name': 'str',
            'nickname': 'str',
            'additional_ids': 'list[RecipientAdditionalIdentifier]'
        }

        self.attribute_map = {
            'first_name': 'firstName',
            'last_name': 'lastName',
            'nickname': 'nickname',
            'additional_ids': 'additionalIds'
        }

        self._first_name = None
        self._last_name = None
        self._nickname = None
        self._additional_ids = None

    @property
    def first_name(self):
        """
        Gets the first_name of this WebMessagingRecipient.
        First name of the recipient.

        :return: The first_name of this WebMessagingRecipient.
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """
        Sets the first_name of this WebMessagingRecipient.
        First name of the recipient.

        :param first_name: The first_name of this WebMessagingRecipient.
        :type: str
        """
        
        self._first_name = first_name

    @property
    def last_name(self):
        """
        Gets the last_name of this WebMessagingRecipient.
        Last name of the recipient.

        :return: The last_name of this WebMessagingRecipient.
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """
        Sets the last_name of this WebMessagingRecipient.
        Last name of the recipient.

        :param last_name: The last_name of this WebMessagingRecipient.
        :type: str
        """
        
        self._last_name = last_name

    @property
    def nickname(self):
        """
        Gets the nickname of this WebMessagingRecipient.
        Nickname or display name of the recipient.

        :return: The nickname of this WebMessagingRecipient.
        :rtype: str
        """
        return self._nickname

    @nickname.setter
    def nickname(self, nickname):
        """
        Sets the nickname of this WebMessagingRecipient.
        Nickname or display name of the recipient.

        :param nickname: The nickname of this WebMessagingRecipient.
        :type: str
        """
        
        self._nickname = nickname

    @property
    def additional_ids(self):
        """
        Gets the additional_ids of this WebMessagingRecipient.
        List of recipient additional identifiers

        :return: The additional_ids of this WebMessagingRecipient.
        :rtype: list[RecipientAdditionalIdentifier]
        """
        return self._additional_ids

    @additional_ids.setter
    def additional_ids(self, additional_ids):
        """
        Sets the additional_ids of this WebMessagingRecipient.
        List of recipient additional identifiers

        :param additional_ids: The additional_ids of this WebMessagingRecipient.
        :type: list[RecipientAdditionalIdentifier]
        """
        
        self._additional_ids = additional_ids

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

