# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class JourneyWebEventsNotificationDevice(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        JourneyWebEventsNotificationDevice - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'type': 'str',
            'is_mobile': 'bool',
            'screen_height': 'int',
            'screen_width': 'int',
            'fingerprint': 'str',
            'os_family': 'str',
            'os_version': 'str',
            'category': 'str'
        }

        self.attribute_map = {
            'type': 'type',
            'is_mobile': 'isMobile',
            'screen_height': 'screenHeight',
            'screen_width': 'screenWidth',
            'fingerprint': 'fingerprint',
            'os_family': 'osFamily',
            'os_version': 'osVersion',
            'category': 'category'
        }

        self._type = None
        self._is_mobile = None
        self._screen_height = None
        self._screen_width = None
        self._fingerprint = None
        self._os_family = None
        self._os_version = None
        self._category = None

    @property
    def type(self):
        """
        Gets the type of this JourneyWebEventsNotificationDevice.


        :return: The type of this JourneyWebEventsNotificationDevice.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this JourneyWebEventsNotificationDevice.


        :param type: The type of this JourneyWebEventsNotificationDevice.
        :type: str
        """
        
        self._type = type

    @property
    def is_mobile(self):
        """
        Gets the is_mobile of this JourneyWebEventsNotificationDevice.


        :return: The is_mobile of this JourneyWebEventsNotificationDevice.
        :rtype: bool
        """
        return self._is_mobile

    @is_mobile.setter
    def is_mobile(self, is_mobile):
        """
        Sets the is_mobile of this JourneyWebEventsNotificationDevice.


        :param is_mobile: The is_mobile of this JourneyWebEventsNotificationDevice.
        :type: bool
        """
        
        self._is_mobile = is_mobile

    @property
    def screen_height(self):
        """
        Gets the screen_height of this JourneyWebEventsNotificationDevice.


        :return: The screen_height of this JourneyWebEventsNotificationDevice.
        :rtype: int
        """
        return self._screen_height

    @screen_height.setter
    def screen_height(self, screen_height):
        """
        Sets the screen_height of this JourneyWebEventsNotificationDevice.


        :param screen_height: The screen_height of this JourneyWebEventsNotificationDevice.
        :type: int
        """
        
        self._screen_height = screen_height

    @property
    def screen_width(self):
        """
        Gets the screen_width of this JourneyWebEventsNotificationDevice.


        :return: The screen_width of this JourneyWebEventsNotificationDevice.
        :rtype: int
        """
        return self._screen_width

    @screen_width.setter
    def screen_width(self, screen_width):
        """
        Sets the screen_width of this JourneyWebEventsNotificationDevice.


        :param screen_width: The screen_width of this JourneyWebEventsNotificationDevice.
        :type: int
        """
        
        self._screen_width = screen_width

    @property
    def fingerprint(self):
        """
        Gets the fingerprint of this JourneyWebEventsNotificationDevice.


        :return: The fingerprint of this JourneyWebEventsNotificationDevice.
        :rtype: str
        """
        return self._fingerprint

    @fingerprint.setter
    def fingerprint(self, fingerprint):
        """
        Sets the fingerprint of this JourneyWebEventsNotificationDevice.


        :param fingerprint: The fingerprint of this JourneyWebEventsNotificationDevice.
        :type: str
        """
        
        self._fingerprint = fingerprint

    @property
    def os_family(self):
        """
        Gets the os_family of this JourneyWebEventsNotificationDevice.


        :return: The os_family of this JourneyWebEventsNotificationDevice.
        :rtype: str
        """
        return self._os_family

    @os_family.setter
    def os_family(self, os_family):
        """
        Sets the os_family of this JourneyWebEventsNotificationDevice.


        :param os_family: The os_family of this JourneyWebEventsNotificationDevice.
        :type: str
        """
        
        self._os_family = os_family

    @property
    def os_version(self):
        """
        Gets the os_version of this JourneyWebEventsNotificationDevice.


        :return: The os_version of this JourneyWebEventsNotificationDevice.
        :rtype: str
        """
        return self._os_version

    @os_version.setter
    def os_version(self, os_version):
        """
        Sets the os_version of this JourneyWebEventsNotificationDevice.


        :param os_version: The os_version of this JourneyWebEventsNotificationDevice.
        :type: str
        """
        
        self._os_version = os_version

    @property
    def category(self):
        """
        Gets the category of this JourneyWebEventsNotificationDevice.


        :return: The category of this JourneyWebEventsNotificationDevice.
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """
        Sets the category of this JourneyWebEventsNotificationDevice.


        :param category: The category of this JourneyWebEventsNotificationDevice.
        :type: str
        """
        allowed_values = ["desktop", "mobile", "tablet", "other"]
        if category.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for category -> " + category)
            self._category = "outdated_sdk_version"
        else:
            self._category = category

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

