#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# sasoptpy documentation build configuration file, created by
# sphinx-quickstart on Tue Sep 26 17:12:59 2017.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))
import os
import sys
sys.path.insert(0, os.path.abspath('..'))
import matplotlib

# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.doctest',
    'sphinx.ext.intersphinx',
    'sphinx.ext.viewcode',
    'sphinx.ext.githubpages',
    'sphinx.ext.autosummary',
    'IPython.sphinxext.ipython_console_highlighting',
    'IPython.sphinxext.ipython_directive',
    'sphinxcontrib.fulltoc',
    'numpydoc',
    'sphinx.ext.mathjax',
    'sphinx.ext.viewcode'
]

mathjax_path = "https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.5/MathJax.js?config=TeX-MML-AM_CHTML"

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# General information about the project.
import datetime
year = datetime.datetime.now().year
project = 'sasoptpy'
copyright = f'2017-{year}, SAS Institute'
author = 'Sertalp B. Cay (SAS Institute)'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = '1.0.0-alpha.2'
# The full version, including alpha/beta/rc tags.
release = '1.0.0-alpha.2'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']
try:
    if os.environ['ignore'] == 'ex':
        exclude_patterns.append('examples')
    if os.environ['ignore_api'] == 'true':
        exclude_patterns.append('api')
except:
    pass

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = False

# -- Matplotlib options ---------------------------------------------------

plot_include_source = True
plot_formats = [("png", 90)]

# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'nature'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
html_theme_options = {
    "sidebarwidth": "270"
}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# This is required for the alabaster theme
# refs: http://alabaster.readthedocs.io/en/latest/installation.html#sidebars
#html_sidebars = {
#    '**': [
#        'about.html',
#        'navigation.html',
#        'relations.html',  # needs 'show_related': True theme option to display
#        'searchbox.html',
#        'donate.html',
#    ]
#}
html_sidebars = {'**': ['localtoc.html',
                        #'sourcelink.html',
                        'searchbox.html']}

# -- Options for HTMLHelp output ------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'sasoptpydoc'


# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    'preamble': r'''
\definecolor{VerbatimBorderColor}{rgb}{1,1,1}
\definecolor{VerbatimColor}{rgb}{0.9,0.9,0.9}
''',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'sasoptpy.tex', 'sasoptpy Documentation',
     'SAS Institute Inc.', 'manual'),
]


# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'sasoptpy', 'sasoptpy Documentation',
     [author], 1)
]


# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'sasoptpy', 'sasoptpy Documentation',
     author, 'sasoptpy', 'sasoptpy -  SAS Viya Optimization Interface for Python',
     'Miscellaneous'),
]



# -- Options for Epub output ----------------------------------------------

# Bibliographic Dublin Core info.
epub_title = project
epub_author = author
epub_publisher = author
epub_copyright = copyright

# The unique identifier of the text. This can be a ISBN number
# or the project homepage.
#
# epub_identifier = ''

# A unique identification for the text.
#
# epub_uid = ''

# A list of files that should not be packed into the epub file.
epub_exclude_files = ['search.html']



# Example configuration for intersphinx: refer to the Python standard library.
intersphinx_mapping = {'https://docs.python.org/3/': None,
                       'https://pandas.pydata.org/pandas-docs/stable/': None,
                       'https://sassoftware.github.io/python-swat/': None,
                       'saspy': ('https://sassoftware.github.io/saspy/', None)
}


import glob
import re
autosummary_generate = glob.glob("api/*.rst") + glob.glob("*.rst")

# Custom settings

html_last_updated_fmt = '%b %d, %Y (Timestamp: {}-%Y%m%d%H%M%S)'.format(version)

autodoc_default_options = {'show-inheritance': None}

def remove_autosums(app, what, name, obj, options, lines):

    if True or what == 'class':
        lb = None
        for i, line in enumerate(lines):
            if 'Methods' in line:
                lb = i
                break
        if lb is not None:
            lines[:] = lines[:lb]

def setup(app):
    app.connect('autodoc-process-docstring', remove_autosums)
    app.add_stylesheet('css/sasoptpy.css') 
    app.add_javascript('js/url.js')

add_module_names = False

