/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 *
 * Copyright (C) 2020 - Equinor ASA. */

/* eslint no-magic-numbers: 0 */
import React, { Component } from "react";

import HistoryMatch from "../lib/components/HistoryMatch";

const data = {
    confidence_interval_unsorted: {
        low: 0.015790774093431225,
        high: 2.705543454095414,
    },
    iterations: [
        {
            positive: [
                6.8609598246735395, 3.4091665274024567, 0.039012371435171375,
                0.09294270018994359, 0.9468451033534171, 0.5925393318855171,
                0.03132318365723118, 0.2259979441796272, 0.5243918093773674,
                0.9483046419658373, 0.26703380680524136, 0.3149254861735159,
                0.41756428359542985, 0.39046115469423837, 0.5187526720419419,
                0.14143988607597838, 0.27387215337465126, 0.15662655221094074,
                0.18222985576256748, 0.3994398045271035, 0.3213335372702491,
                0.589755965292949, 0.583891083912595, 0.16678951266022415,
                0.1777222494020476, 0.17134870164472912, 0.5073615323989721,
                0.4932744025691578, 0.03982371149591154, 0.07639132353155338,
                0.17771072987771824, 0.21622455229740387, 0.12154967409378409,
                0.0661330198789209, 0.16588785130882538, 0.14382851239465017,
                0.03722356666523854, 0.007698032666542964, 0.09783933957683713,
                0.06707671424815466, 0.0695367710695078, 0.0085555687465107,
                0.017771870527405694, 0.0037398044186040826,
                0.008319819871144689, 0.007203997801287602,
                0.003444319247932931, 0.0016640303505312765,
                0.0008719171378379236, 2.8732592502492946e-5,
            ],
            negative: [
                0.5202596066940235, 1.7557214758087785, 2.5373668231008364,
                1.908711517620275, 0.8943071919762613, 1.0860182515710113,
                1.337830248426704, 1.0344898753419889, 0.7146468886607659,
                0.22121527995363632, 0.8263843530076472, 0.7028007285696988,
                0.5845453951075756, 0.577115486717267, 0.4291905514123349,
                0.7372308501853521, 0.5878537822537938, 0.694923770725252,
                0.6480761079669297, 0.3680604625106751, 0.4258330316081808,
                0.1298816155844159, 0.0002754354132777813, 0.4065698338464614,
                0.3789391553115611, 0.35989490051631834, 0.005554923803263666,
                0.010159698407514626, 0.44819459686970914, 0.1498756445185578,
                0.04675349242278, 0.0066567070831220895, 0.08357834450464562,
                0.13163773606189458, 0.03057439583899737, 0.025687476247549686,
                0.11708871473605843, 0.13689172318374784, 0.04317165385821605,
                0.03082713570922946, 0.00018785838296401077,
                0.020915878922610806, 0.00969608195003309, 0.01954137467474987,
                0.009987160188969545, 0.00855080944403488,
                0.0037895651842623696, 0.003148325945614737,
                0.002753501768658313, 0.00013334285632329908,
            ],
            name: "Iteration 0",
            labels: [
                "Obs. group 21",
                "Obs. group 11",
                "Obs. group 3",
                "Obs. group 10",
                "Obs. group 49",
                "Obs. group 13",
                "Obs. group 37",
                "Obs. group 31",
                "Obs. group 40",
                "Obs. group 19",
                "Obs. group 27",
                "Obs. group 42",
                "Obs. group 39",
                "Obs. group 45",
                "Obs. group 14",
                "Obs. group 24",
                "Obs. group 22",
                "Obs. group 30",
                "Obs. group 9",
                "Obs. group 23",
                "Obs. group 34",
                "Obs. group 6",
                "Obs. group 15",
                "Obs. group 26",
                "Obs. group 7",
                "Obs. group 47",
                "Obs. group 18",
                "Obs. group 44",
                "Obs. group 33",
                "Obs. group 5",
                "Obs. group 0",
                "Obs. group 32",
                "Obs. group 25",
                "Obs. group 36",
                "Obs. group 4",
                "Obs. group 46",
                "Obs. group 29",
                "Obs. group 1",
                "Obs. group 43",
                "Obs. group 20",
                "Obs. group 41",
                "Obs. group 8",
                "Obs. group 38",
                "Obs. group 12",
                "Obs. group 35",
                "Obs. group 16",
                "Obs. group 28",
                "Obs. group 48",
                "Obs. group 2",
                "Obs. group 17",
            ],
        },
        {
            positive: [
                3.759703155713347, 0.5443104117253966, 1.3844719845485194,
                1.2511180058963751, 2.446975234566947, 3.317846415656702,
                2.3210641485560775, 0.9290068803568912, 0.9349378241463365,
                0.5602467259223415, 1.1863644350399398, 0.8501256018798357,
                1.5116053763040063, 0.7846937197126406, 0.8240407734768459,
                0.5161246090558688, 0.3782747720782656, 0.9690221722158205,
                0.8086199761527196, 0.08006027992993996, 0.7526832388332377,
                0.1703591378888829, 0.006554258678790119, 0.0039997231326656555,
                0.6253826522853041, 0.4923394400900549, 0.2712839712171486,
                0.37575000022546035, 0.1461210596758694, 0.12895669440981478,
                0.16259956171663684, 0.06479646425929426, 0.20944457625565202,
                0.11412020196924251, 0.04704319095776973, 0.09742315364389884,
                0.0635863165377215, 0.012296164077228323, 0.04345089209117001,
                0.015789771823595405, 0.10068667395209277,
                0.0032998372877542765, 0.021523333973972023,
                0.011060022280013982, 0.021966826464591128,
                0.006473757294139508, 0.010653104583550559,
                0.004869041384446119, 0.00035259513361265787,
                0.0017463720421646664,
            ],
            negative: [
                1.6555050362361752, 4.667105241497324, 3.055129117126837,
                3.1152628094268033, 1.4334849750939862, 0.5392671196102596,
                1.493383250041796, 2.5225311868386324, 2.1748831973771616,
                2.115174221533715, 1.484274785640071, 1.313907021343766,
                0.3541768711481673, 0.9259750689616978, 0.8702894576525181,
                1.1296243440726554, 1.2527927029204091, 0.44723782695065223,
                0.5679538871495688, 0.8598819841981208, 0.10782082758795236,
                0.6495300823888627, 0.7887882821160956, 0.6978678158483571,
                0.059922767458612254, 0.17618356475947158, 0.2547852860919232,
                0.08552111199094263, 0.27344396425711237, 0.2749806118685689,
                0.10346789200228086, 0.197520188143655, 0.05152710373821126,
                0.11409134081167883, 0.1694081094241463, 0.05133368995360695,
                0.07390029431577448, 0.11912441090658932, 0.08448806176581777,
                0.10753842956381827, 0.008746239173701563, 0.09732828926026212,
                0.07898636602690352, 0.06509167144458593, 0.052956938951286475,
                0.057496041223483056, 0.025488247965499602,
                0.005061248320827761, 0.008218771240681239,
                0.0005969262159999944,
            ],
            name: "Iteration 1",
            labels: [
                "Obs. group 27",
                "Obs. group 33",
                "Obs. group 10",
                "Obs. group 4",
                "Obs. group 17",
                "Obs. group 15",
                "Obs. group 32",
                "Obs. group 26",
                "Obs. group 20",
                "Obs. group 8",
                "Obs. group 13",
                "Obs. group 40",
                "Obs. group 1",
                "Obs. group 37",
                "Obs. group 5",
                "Obs. group 19",
                "Obs. group 22",
                "Obs. group 18",
                "Obs. group 24",
                "Obs. group 30",
                "Obs. group 31",
                "Obs. group 16",
                "Obs. group 39",
                "Obs. group 21",
                "Obs. group 38",
                "Obs. group 42",
                "Obs. group 46",
                "Obs. group 14",
                "Obs. group 44",
                "Obs. group 23",
                "Obs. group 29",
                "Obs. group 7",
                "Obs. group 36",
                "Obs. group 28",
                "Obs. group 0",
                "Obs. group 43",
                "Obs. group 49",
                "Obs. group 12",
                "Obs. group 3",
                "Obs. group 45",
                "Obs. group 6",
                "Obs. group 34",
                "Obs. group 25",
                "Obs. group 35",
                "Obs. group 41",
                "Obs. group 47",
                "Obs. group 2",
                "Obs. group 9",
                "Obs. group 48",
                "Obs. group 11",
            ],
        },
        {
            positive: [
                0.5559499045665462, 1.0747682081341265, 2.008418436488008,
                1.4528945496263108, 1.010721233518335, 1.1449633996862754,
                1.3251722256788363, 0.3531748826138669, 0.7398197018029559,
                1.371720271626504, 0.49027018655175153, 0.039472685094239124,
                0.6473055006857463, 1.1036508627480743, 0.3592040073631278,
                0.5236039367945322, 0.034628722309638406, 0.8973078286103224,
                0.4206367101504768, 0.1465666879639577, 0.2318360225412145,
                0.05743541717600441, 0.046550315000234516, 0.30945393954961553,
                0.46545174507539644, 0.014818228289487307, 0.31049267307033096,
                0.3834416396935858, 0.25429461642194895, 0.3943544892296325,
                0.24999501271706573, 0.3591187814572077, 0.03469499335514457,
                0.14598351220277703, 0.13739602699893733, 0.16078721815114214,
                0.20974797123472258, 0.13905517692607514, 0.11368043698347481,
                0.06782033454460257, 0.03278838172551174, 0.04033864466277784,
                0.051627255025656724, 0.02331195541631735,
                0.0011374246034436513, 0.02793316799909102,
                0.009758751906971093, 0.0024419832646527017,
                0.0010764294756750153, 1.9848199458218872e-7,
            ],
            negative: [
                5.958135562669477, 3.6683243208814247, 0.5196844795746769,
                0.7709865989605603, 1.1976443394560707, 0.9590825792648434,
                0.5529280808132523, 1.3824111777381207, 0.959235291040965,
                0.11234265769706503, 0.9757247844790337, 1.3280826445341347,
                0.678114693669056, 0.19839512102796447, 0.9364423287743484,
                0.6982145202446032, 1.1339470554311246, 0.07442472929559729,
                0.5180310125274955, 0.7381089033067127, 0.6368131912050244,
                0.6978362336592642, 0.5469158841409102, 0.2754316095376226,
                0.05957807210639784, 0.4988625336375895, 0.1670995359539122,
                0.054927779016591606, 0.18050294240334616, 0.027810380841507044,
                0.16315360585947541, 0.0007122840532150469, 0.28020224744461547,
                0.1506510914285642, 0.15116467448084978, 0.12117847543450402,
                0.03780930097040641, 0.09532472468292454, 0.07560604759866578,
                0.08703230578506764, 0.07119463087211246, 0.025724248476638012,
                0.0051136699682995945, 0.021991002903468684,
                0.03394091110021233, 0.0030620499580796094,
                0.00027187672607406854, 0.002623905333097811,
                0.0007228828375160244, 1.2989352291305116e-6,
            ],
            name: "Iteration 2",
            labels: [
                "Obs. group 45",
                "Obs. group 44",
                "Obs. group 46",
                "Obs. group 16",
                "Obs. group 32",
                "Obs. group 25",
                "Obs. group 7",
                "Obs. group 13",
                "Obs. group 19",
                "Obs. group 41",
                "Obs. group 47",
                "Obs. group 6",
                "Obs. group 11",
                "Obs. group 36",
                "Obs. group 39",
                "Obs. group 2",
                "Obs. group 3",
                "Obs. group 24",
                "Obs. group 28",
                "Obs. group 17",
                "Obs. group 8",
                "Obs. group 29",
                "Obs. group 37",
                "Obs. group 31",
                "Obs. group 14",
                "Obs. group 22",
                "Obs. group 1",
                "Obs. group 40",
                "Obs. group 48",
                "Obs. group 42",
                "Obs. group 23",
                "Obs. group 12",
                "Obs. group 35",
                "Obs. group 18",
                "Obs. group 15",
                "Obs. group 27",
                "Obs. group 4",
                "Obs. group 38",
                "Obs. group 26",
                "Obs. group 9",
                "Obs. group 43",
                "Obs. group 49",
                "Obs. group 21",
                "Obs. group 10",
                "Obs. group 33",
                "Obs. group 5",
                "Obs. group 20",
                "Obs. group 34",
                "Obs. group 30",
                "Obs. group 0",
            ],
        },
        {
            positive: [
                2.177310642190094, 0.045562728840134244, 3.26392400991878,
                2.7753133158220127, 2.611125108856533, 1.958060755361022,
                2.381344699765121, 1.9557570559451962, 0.9644762772395603,
                1.6047045038400973, 1.1929870508192528, 1.2323910643528728,
                1.758815755911087, 0.17089508177337315, 0.8721273541048465,
                0.8044662936581308, 0.9655437575589109, 0.6583204773775093,
                0.7800717759093618, 0.5659831605427958, 0.7424210787088622,
                0.6514919541672937, 0.4269154178313937, 0.4988516856213661,
                0.07947298021308749, 0.07466500305482597, 0.2744660071997787,
                0.5776840720474054, 0.14948506593032018, 0.4227365177736946,
                0.4324405441699905, 0.2561519729634228, 0.2677489034770995,
                0.005296609491388061, 0.15455999600464976, 0.05395481926484376,
                0.0549253447091876, 0.1459937147509679, 0.07153702576355453,
                0.08313170631758825, 0.06007538542875637, 0.008476767334557118,
                0.018145786449963903, 0.012869064306039416,
                0.009564241574379928, 0.0014026397720982165,
                0.002019228815962885, 6.027453568965822e-5,
                9.470668891456828e-5, 3.570927576644735e-5,
            ],
            negative: [
                2.4979956606135203, 4.347707905139947, 1.071993891383172,
                0.9375381197428613, 0.9731035081324692, 1.360584037567373,
                0.8176655126472129, 0.9826664207475412, 1.3607028179611875,
                0.6390418602247901, 1.025678906000395, 0.8527006263131632,
                0.32247975230274756, 1.7878769912782733, 0.9700814373041069,
                0.7286328006107798, 0.30500675788374954, 0.5850757437661572,
                0.4399290025196842, 0.5467667148286248, 0.2554200575713027,
                0.27571596524575787, 0.382419977903018, 0.29893938523417946,
                0.7025688982803412, 0.7032132862296495, 0.47974159739855876,
                0.07710108813766949, 0.42973991852381505, 0.13992934795577705,
                0.1245815155212427, 0.2573274387912265, 0.19058234703473415,
                0.40195804321732764, 0.12564856006245717, 0.19582498365166276,
                0.11681954985740027, 0.023721476007450715, 0.043727641320380074,
                0.02949609043199724, 0.02157082781718984, 0.06283787670234584,
                0.03182944672065451, 0.03456750129028129, 0.0030610935208188954,
                0.005944003604828889, 0.0016225594641966648,
                0.0008194260166701671, 0.00010339807843725338,
                5.792811391608389e-6,
            ],
            name: "Iteration 3",
            labels: [
                "Obs. group 15",
                "Obs. group 10",
                "Obs. group 13",
                "Obs. group 42",
                "Obs. group 48",
                "Obs. group 39",
                "Obs. group 29",
                "Obs. group 17",
                "Obs. group 49",
                "Obs. group 25",
                "Obs. group 31",
                "Obs. group 2",
                "Obs. group 26",
                "Obs. group 34",
                "Obs. group 16",
                "Obs. group 40",
                "Obs. group 37",
                "Obs. group 45",
                "Obs. group 22",
                "Obs. group 14",
                "Obs. group 12",
                "Obs. group 46",
                "Obs. group 44",
                "Obs. group 7",
                "Obs. group 6",
                "Obs. group 3",
                "Obs. group 18",
                "Obs. group 32",
                "Obs. group 0",
                "Obs. group 33",
                "Obs. group 11",
                "Obs. group 19",
                "Obs. group 27",
                "Obs. group 35",
                "Obs. group 20",
                "Obs. group 38",
                "Obs. group 41",
                "Obs. group 4",
                "Obs. group 21",
                "Obs. group 9",
                "Obs. group 23",
                "Obs. group 24",
                "Obs. group 1",
                "Obs. group 5",
                "Obs. group 36",
                "Obs. group 8",
                "Obs. group 47",
                "Obs. group 28",
                "Obs. group 43",
                "Obs. group 30",
            ],
        },
    ],
    confidence_interval_sorted: {
        low: [
            9.470554473062732, 6.530864627645606, 5.229108455241102,
            4.428375858462183, 3.859638631223769, 3.4196579131101745,
            3.0694553803445173, 2.7784614006110053, 2.5296833207371967,
            2.3135085838150573, 2.1269041040917123, 1.9556229425407952,
            1.80725394794069, 1.6679380389336462, 1.5448226811359351,
            1.4289279547453773, 1.323348368190213, 1.2237528817741723,
            1.1320854072483997, 1.0488670343017823, 0.9723193417016585,
            0.8985557021252657, 0.8305259163507107, 0.7657004893649921,
            0.7056894097385281, 0.6490129458484174, 0.5966268472554277,
            0.5462862370777164, 0.499399954202344, 0.45550931455206883,
            0.4146732448033542, 0.3756457737552992, 0.3385008886207116,
            0.3041687179664296, 0.2720871312002288, 0.24153927578863724,
            0.2136324631672785, 0.1872536620063405, 0.16183004291628036,
            0.13891464500209194, 0.1180234045053686, 0.09845352062586882,
            0.08085304611276341, 0.06473350323224987, 0.05017916057200406,
            0.03731311969171612, 0.02618259584812311, 0.0166258365968026,
            0.008930471143565495, 0.0031298464470027793,
        ],
        high: [
            4.011545757520679, 3.153513925816763, 2.6545229661384018,
            2.3047342661466934, 2.036757318694754, 1.8165060099582342,
            1.6327867250216013, 1.4781389764951756, 1.3417610081246067,
            1.2199503850453093, 1.113363596779829, 1.018007357923393,
            0.929558718351087, 0.8510696258215337, 0.7801379428434173,
            0.7147458804958402, 0.652318844382841, 0.5972409962397126,
            0.544223707159188, 0.49704100111241145, 0.4521703657983992,
            0.4118265238767667, 0.3735621715614623, 0.33789160061074686,
            0.3053412218494211, 0.2750315555187829, 0.24644682777092547,
            0.22081082729655874, 0.19687824377911278, 0.17433274509453597,
            0.1538247013803272, 0.13470314084355786, 0.11750706756937608,
            0.10152135529991675, 0.08704488185010255, 0.0737696436779409,
            0.061718098889369084, 0.051000879096375074, 0.0416510362298253,
            0.033169978828607, 0.02579893838188652, 0.019582670731810373,
            0.014354189080689694, 0.00991809392170627, 0.006471766884668791,
            0.0038020224502535436, 0.0019406074266654083, 0.0007739796151164998,
            0.00017764379383405267, 6.568995834706299e-6,
        ],
    },
};

class HistoryMatchDemo extends Component {
    render() {
        return (
            <div>
                <HistoryMatch id={"hm"} data={data} />
            </div>
        );
    }
}

export default HistoryMatchDemo;
