# Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
# with the License. A copy of the License is located at http://aws.amazon.com/apache2.0/
# or in the "LICENSE.txt" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
# OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions and
# limitations under the License.

# pylint: disable=R0801


from typing import List

from pcluster.api import util
from pcluster.api.models.base_model_ import Model
from pcluster.api.models.change import Change
from pcluster.api.models.cluster_info_summary import ClusterInfoSummary
from pcluster.api.models.config_validation_message import ConfigValidationMessage


class UpdateClusterResponseContent(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, cluster=None, validation_messages=None, change_set=None):
        """UpdateClusterResponseContent - a model defined in OpenAPI

        :param cluster: The cluster of this UpdateClusterResponseContent.
        :type cluster: ClusterInfoSummary
        :param validation_messages: The validation_messages of this UpdateClusterResponseContent.
        :type validation_messages: List[ConfigValidationMessage]
        :param change_set: The change_set of this UpdateClusterResponseContent.
        :type change_set: List[Change]
        """
        self.openapi_types = {
            "cluster": ClusterInfoSummary,
            "validation_messages": List[ConfigValidationMessage],
            "change_set": List[Change],
        }

        self.attribute_map = {
            "cluster": "cluster",
            "validation_messages": "validationMessages",
            "change_set": "changeSet",
        }

        self._cluster = cluster
        self._validation_messages = validation_messages
        self._change_set = change_set

    @classmethod
    def from_dict(cls, dikt) -> "UpdateClusterResponseContent":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The UpdateClusterResponseContent of this UpdateClusterResponseContent.
        :rtype: UpdateClusterResponseContent
        """
        return util.deserialize_model(dikt, cls)

    @property
    def cluster(self):
        """Gets the cluster of this UpdateClusterResponseContent.


        :return: The cluster of this UpdateClusterResponseContent.
        :rtype: ClusterInfoSummary
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this UpdateClusterResponseContent.


        :param cluster: The cluster of this UpdateClusterResponseContent.
        :type cluster: ClusterInfoSummary
        """
        if cluster is None:
            raise ValueError("Invalid value for `cluster`, must not be `None`")

        self._cluster = cluster

    @property
    def validation_messages(self):
        """Gets the validation_messages of this UpdateClusterResponseContent.

        List of messages collected during cluster config validation whose level is lower than the
        'validationFailureLevel' set by the user.

        :return: The validation_messages of this UpdateClusterResponseContent.
        :rtype: List[ConfigValidationMessage]
        """
        return self._validation_messages

    @validation_messages.setter
    def validation_messages(self, validation_messages):
        """Sets the validation_messages of this UpdateClusterResponseContent.

        List of messages collected during cluster config validation whose level is lower than the
        'validationFailureLevel' set by the user.

        :param validation_messages: The validation_messages of this UpdateClusterResponseContent.
        :type validation_messages: List[ConfigValidationMessage]
        """
        self._validation_messages = validation_messages

    @property
    def change_set(self):
        """Gets the change_set of this UpdateClusterResponseContent.

        List of configuration changes requested by the update operation.

        :return: The change_set of this UpdateClusterResponseContent.
        :rtype: List[Change]
        """
        return self._change_set

    @change_set.setter
    def change_set(self, change_set):
        """Sets the change_set of this UpdateClusterResponseContent.

        List of configuration changes requested by the update operation.

        :param change_set: The change_set of this UpdateClusterResponseContent.
        :type change_set: List[Change]
        """
        if change_set is None:
            raise ValueError("Invalid value for `change_set`, must not be `None`")

        self._change_set = change_set
