# Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
# with the License. A copy of the License is located at http://aws.amazon.com/apache2.0/
# or in the "LICENSE.txt" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
# OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions and
# limitations under the License.

# pylint: disable=R0801


from pcluster.api import util
from pcluster.api.models.base_model_ import Model


class Metadata(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, name=None, version=None):  # noqa: E501
        """Metadata - a model defined in OpenAPI

        :param name: The name of this Metadata.  # noqa: E501
        :type name: str
        :param version: The version of this Metadata.  # noqa: E501
        :type version: str
        """
        self.openapi_types = {"name": str, "version": str}

        self.attribute_map = {"name": "name", "version": "version"}

        self._name = name
        self._version = version

    @classmethod
    def from_dict(cls, dikt) -> "Metadata":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Metadata of this Metadata.  # noqa: E501
        :rtype: Metadata
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self):
        """Gets the name of this Metadata.


        :return: The name of this Metadata.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Metadata.


        :param name: The name of this Metadata.
        :type name: str
        """

        self._name = name

    @property
    def version(self):
        """Gets the version of this Metadata.


        :return: The version of this Metadata.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this Metadata.


        :param version: The version of this Metadata.
        :type version: str
        """

        self._version = version
