# Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
# with the License. A copy of the License is located at http://aws.amazon.com/apache2.0/
# or in the "LICENSE.txt" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
# OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions and
# limitations under the License.

# pylint: disable=R0801


import re

from pcluster.api import util
from pcluster.api.models.base_model_ import Model


class BuildImageRequestContent(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, image_configuration=None, image_id=None):
        """BuildImageRequestContent - a model defined in OpenAPI

        :param image_configuration: The image_configuration of this BuildImageRequestContent.
        :type image_configuration: str
        :param image_id: The image_id of this BuildImageRequestContent.
        :type image_id: str
        """
        self.openapi_types = {"image_configuration": str, "image_id": str}

        self.attribute_map = {"image_configuration": "imageConfiguration", "image_id": "imageId"}

        self._image_configuration = image_configuration
        self._image_id = image_id

    @classmethod
    def from_dict(cls, dikt) -> "BuildImageRequestContent":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The BuildImageRequestContent of this BuildImageRequestContent.
        :rtype: BuildImageRequestContent
        """
        return util.deserialize_model(dikt, cls)

    @property
    def image_configuration(self):
        """Gets the image_configuration of this BuildImageRequestContent.

        Image configuration as a YAML document.

        :return: The image_configuration of this BuildImageRequestContent.
        :rtype: str
        """
        return self._image_configuration

    @image_configuration.setter
    def image_configuration(self, image_configuration):
        """Sets the image_configuration of this BuildImageRequestContent.

        Image configuration as a YAML document.

        :param image_configuration: The image_configuration of this BuildImageRequestContent.
        :type image_configuration: str
        """
        if image_configuration is None:
            raise ValueError("Invalid value for `image_configuration`, must not be `None`")

        self._image_configuration = image_configuration

    @property
    def image_id(self):
        """Gets the image_id of this BuildImageRequestContent.

        Id of the image that will be built.


        :return: The image_id of this BuildImageRequestContent.
        :rtype: str
        """
        return self._image_id

    @image_id.setter
    def image_id(self, image_id):
        """Sets the image_id of this BuildImageRequestContent.

        Id of the image that will be built.

        :param image_id: The image_id of this BuildImageRequestContent.
        :type image_id: str
        """
        if image_id is None:
            raise ValueError("Invalid value for `image_id`, must not be `None`")
        if image_id is not None and not re.search(r"^[a-zA-Z][a-zA-Z0-9-]+$", image_id):
            raise ValueError(
                "Invalid value for `image_id`, must be a follow pattern or equal to `/^[a-zA-Z][a-zA-Z0-9-]+$/`"
            )

        self._image_id = image_id
