# Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
# with the License. A copy of the License is located at http://aws.amazon.com/apache2.0/
# or in the "LICENSE.txt" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
# OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions and
# limitations under the License.

# Generated by OpenAPI Generator (python-flask)

import datetime

import six
from connexion.apps.flask_app import FlaskJSONEncoder

from pcluster.api.models.base_model_ import Model
from pcluster.utils import to_iso_timestr


class JSONEncoder(FlaskJSONEncoder):
    """Make the model objects JSON serializable."""

    include_nulls = False

    def default(self, obj):  # pylint: disable=arguments-renamed
        """Override the base method to add support for model objects serialization."""
        if isinstance(obj, Model):
            dikt = {}
            for attr, _ in six.iteritems(obj.openapi_types):
                value = getattr(obj, attr)
                if value is None and not self.include_nulls:
                    continue
                attr = obj.attribute_map[attr]
                dikt[attr] = value
            return dikt
        elif isinstance(obj, datetime.date):
            return to_iso_timestr(obj)
        return FlaskJSONEncoder.default(self, obj)
