# Domain-driven Design Misc

Пакет предоставляет базовые классы и утилиты для реализации проекта с событийно-ориентированной архитектурой
с использованием набора принципов DDD.

## Классы

**Классы объектов**
- `BaseAggregate` - базовый класс для создания агрегата домена
- `DDDEvent` - базовый класс для реализации событий домена
- `DDDCommand` - базовый класс для реализации команд домена
- `DDDResponse` - класс исключение домена
- `DDDStructure` - базовый класс для создания структур данных при описании команд и событий

Атрибуты классов `DDDEvent`, `DDDCommand` и `DDDSturcture` задаются с использованием `Field`-классов из пакета `dddmisc.fields`

- `get_message_class` - метод получения класса события или команды по его идентификатору из общего регистра
- `get_error_class` - метод получения класса исключения домена из общего регистра

**Класс репозиторий**

Репозиторий уровень абстракции отвечающий за сохранение и воссоздание состояния агрегата.

В пакете репозиторий представлен 2-мя абстрактными классами для синхронной и асинхронной реализации:
- `AbstractSyncRepository` - абстрактный класс для реализации синхронного репозитория
- `AbstractAsyncRepository` - абстрактный класс для реализации асинхронного репозитория

**UnitOfWork**

Unit of work уровень абстракции отвечающий за обеспечения консистентности при сохранении состояния агрегата.
Unit of work является надстройкой над репозиторием.

В пакете UnitOfWork представлен 2-мя абстрактными классами для синхронной и асинхронной реализации:
- `AbstractSyncUnitOfWork` - абстрактный класс для реализации синхронного UnitOfWork
- `AbstractAsyncUnitOfWork` - абстрактный класс для реализации асинхронного UnitOfWork

**InternalMessageBus**

В целях абстрагирования и унификации процесса доставки событий и команд до их обработчиков используется 
внутрення шина сообщений. Дополнительно внутренняя шина сообщений обеспечивает итеративный процесс доставки событий,
порожденных агрегатом в процессе исполнения обработчиков на предыдущей итерации.

В пакете внутрення шина сообщений представлена классами:
- `AsyncMessageBus` - реализации шины сообщений для использования в асинхронном коде
- `SyncMessageBus` - реализации шины сообщений для использования в синхронном коде

**ExternalMessageBus**

В целях предоставления возможности обмена событиями и командами между различными системами или сервисами при использовании
микросервисной архитектуры пакетом предоставляются следующие классы:
- `BaseExternalMessageBus` - Базовый класс предоставляющий функциональность по настройке и управлению подписками на события и команды
- `AbstractAsyncExternalMessageBus` - абстрактный класс определяющий интерфейс для взаимодействия 
с внешней шиной сообщений для инициализации отправки событий и команд в асинхронном коде.
- `AbstractSyncExternalMessageBus` - абстрактный класс определяющий интерфейс для взаимодействия 
с внешней шиной сообщений для инициализации отправки событий и команд в синхронном коде.

Данные классы предназначены для разработки сторонних библиотек расширений 
предоставляющих конкретные реализации протоколов обмена поверх `http`, `amoqp` и т.д.


## Changelog

**0.5.2**

_bugfix:_
- Fix error with nullable and default field attributes



