"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommonCheckWidget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const dotenv = require('dotenv');
const fetch = require('node-fetch');
const FormData = require('form-data');
const crypto = require('crypto');
const fs = require('fs');
const jwt = require('jsonwebtoken');
const uuidv4 = require('uuid/v4');
/*
5000 = error
*/
const CODE_INTERNAL_ERROR = "5000";
dotenv.config();
let env = "prod";
if (process.env.ENVIRONMENT) {
    env = process.env.ENVIRONMENT;
}
let apiKey = process.env.API_KEY;
let commonCheckEndpoint = process.env.COMMONCHECKENDPOINT;
//let privateKey =  process.env.PRIVATE_KEY
let secretPassphrase = process.env.SECRET_PASSPHRASE;
const getHashFromFile = async (file) => {
    try {
        const data = await fs.promises.readFile(file.path, "binary");
        const fileBinary = Buffer.from(data, 'binary');
        const hashSum = crypto.createHash('sha256');
        hashSum.update(fileBinary);
        return hashSum.digest('hex');
    }
    catch (e) {
        console.log(new Date(), "getHashFromFile", e);
        throw e;
    }
};
const generateToken = async (toSign) => {
    let privateKeyFile = 'privateKey.pem';
    if (env === 'dev') {
        privateKeyFile = 'privateKey_dev.pem';
    }
    if (env === 'staging') {
        privateKeyFile = 'privateKey_staging.pem';
    }
    const privateKey = fs.readFileSync(privateKeyFile);
    const objectToSign = toSign;
    const token = jwt.sign(objectToSign, { key: privateKey, passphrase: secretPassphrase }, { algorithm: 'RS512' });
    return token;
};
const callCommonCheckAPI = async (jwt, encryptionFile, requestID) => {
    console.log(new Date(), "Calling CommonCheckAPI", commonCheckEndpoint);
    const formData = new FormData();
    formData.append('file', encryptionFile);
    const options = {
        method: 'POST',
        body: formData,
        headers: {
            'Api-Key': apiKey,
            'Authorization': jwt,
            'Request-ID': requestID
        },
        timeout: 30000,
    };
    console.log("JWT", { requestID, jwt });
    let response;
    try {
        response = await fetch(commonCheckEndpoint + '/verify', options);
        console.log(new Date(), "Completed CommonCheckAPI");
        return response.json();
    }
    catch (error) {
        console.log(new Date(), "Fail CommonCheckAPI");
        throw new Error(response.status);
    }
};
async function backend(encryptionFile, requestID) {
    if (typeof encryptionFile === 'undefined') {
        var error = [];
        error.push({ "type": "Invalid File", "value": "Undefined", "description": "File is required" });
        return ({
            validToEnter: false,
            code: CODE_INTERNAL_ERROR,
            errors: error,
            entryWindow: {},
            metadata: {}
        });
    }
    let hex = "";
    try {
        hex = await getHashFromFile(encryptionFile);
    }
    catch (e) {
        let error = [];
        error.push(e);
        return ({
            validToEnter: false,
            code: CODE_INTERNAL_ERROR,
            errors: [],
            entryWindow: {},
            metadata: {}
        });
    }
    const jwt = await generateToken(hex);
    if (!jwt) {
        return ({
            validToEnter: false,
            code: CODE_INTERNAL_ERROR,
            errors: [],
            entryWindow: {},
            metadata: { jwt: "undefined" }
        });
    }
    try {
        if (!requestID) {
            requestID = uuidv4();
        }
        const responseJson = await callCommonCheckAPI(jwt, encryptionFile, requestID);
        if ((responseJson === null || responseJson === void 0 ? void 0 : responseJson.code) == 'COM-0') {
            return ({
                validToEnter: false,
                code: CODE_INTERNAL_ERROR,
                errors: [],
                entryWindow: {},
                metadata: {}
            });
        }
        if ((responseJson === null || responseJson === void 0 ? void 0 : responseJson.code) == 'COM-3') {
            return ({
                validToEnter: false,
                code: CODE_INTERNAL_ERROR,
                errors: [],
                entryWindow: {},
                metadata: { fields: (responseJson === null || responseJson === void 0 ? void 0 : responseJson.fields) || {} }
            });
        }
        return responseJson;
    }
    catch (e) {
        return ({
            validToEnter: false,
            code: CODE_INTERNAL_ERROR,
            errors: [],
            entryWindow: {},
            metadata: {}
        });
    }
}
class CommonCheckWidget {
    ccwid(encryptionFile, requestID, callback) {
        (async () => {
            const result = await backend(encryptionFile, requestID);
            callback(result);
        })();
    }
    ccw(encryptionFile, callback) {
        (async () => {
            const result = await backend(encryptionFile);
            callback(result);
        })();
    }
    ccwbypathid(path, requestID, callback) {
        let readStream = fs.createReadStream(path)(async () => {
            const result = await backend(readStream, requestID);
            callback(result);
        })();
    }
    ccwbypath(path, callback) {
        let readStream = fs.createReadStream(path)(async () => {
            const result = await backend(readStream);
            callback(result);
        })();
    }
    async ccwidasync(encryptionFile, requestID) {
        const result = await backend(encryptionFile, requestID);
        return result;
    }
    async ccwasync(encryptionFile) {
        const result = await backend(encryptionFile);
        return result;
    }
    async ccwbypathidasync(path, requestID) {
        let readStream = fs.createReadStream(path);
        const result = await backend(readStream, requestID);
        return result;
    }
    async ccwbypathasync(path) {
        let readStream = fs.createReadStream(path);
        const result = await backend(readStream);
        return result;
    }
    ccwerror() {
        let json = {
            validToEnter: false,
            code: CODE_INTERNAL_ERROR,
            errors: [],
            entryWindow: {},
            metadata: {}
        };
        return json;
    }
}
exports.CommonCheckWidget = CommonCheckWidget;
_a = JSII_RTTI_SYMBOL_1;
CommonCheckWidget[_a] = { fqn: "@affinidi/common-check-widget-backend-lib.CommonCheckWidget", version: "1.1.6" };
//# sourceMappingURL=data:application/json;base64,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