<h1 align=center>The Common Check widget Backend Libary</h1>
<p align=center>
  <img src="https://img.shields.io/badge/built-with%20love-pink?style=for-the-badge" />
  <img src="https://img.shields.io/badge/by-affinidi-blue?style=for-the-badge" />
  <img src="https://img.shields.io/badge/for-the%20world-green?style=for-the-badge"/>
</p>

- [Getting started](#getting-started)
- [The Common Check Widget Backend Libary](#the-common-check-widget-backend-libary)
  - [Example in Javascript](#example-in-javascript)
  - [Example in Python](#example-in-python)
  - [Example in dotNET](#example-in-dotnet)
- [The Common Check Widget Documentation](#the-common-check-widget-documentation)



# Getting started

## Private Key File & Environment Variables 

You will need to have privateKey.pem and .env with parameters below.

| Property                | Description                                       |
| ----------------------- | --------------------------------------------------|
| `API_KEY`               | License Key to Commone Check API endpoint         |
| `COMMONCHECK_ENDPOINT`  | Commone Check API endpoint URL                    |
| `SECRET_PASSPHRASE`     | SECRET_PASSPHRASE use to generate private key     |  
| `privateKey.pem`        | Private Key File generated by JWT Web Token       |                                                              

# The Common Check Widget Backend Libary

This package will available on public packages hosts npmjs.org (npm), PyPI (Python), (nuget.org (NuGet), and Maven Central (Maven)) 

| Host                    | URL                                                               |
| ----------------------- | -------------------------------------------------------------------------|
| npmjs.org (npm)         | https://www.npmjs.com/package/@affinidi/common-check-widget-backend-lib/ |
| PyPI (Python)           | https://pypi.org/project/affinidi.common-check-widget-backend-lib/       |
| nuget.org (NuGet)       | https://www.nuget.org/packages/Affinidi.Common.Check.Widget.Backend.Lib/ |   
| Maven Central (Maven)   | Coming Soon                                                              |   


## Example in Javascript
Dependency libaries
```
    "@affinidi/common-check-widget-backend-lib": "^x.x.x",
    "cors": "^2.8.5",
    "express": "^4.17.1",
    "express-form-data": "^2.0.17"
```
Sample Code
```Javascript
const express = require('express');
const cors = require('cors');
const app = express();
const formData = require("express-form-data");
const os = require("os");
const fs = require("fs");
const {CommonCheckWidget} = require('@affinidi/common-check-widget-backend-lib'); 
const ccw = new CommonCheckWidget()
const options = {
  uploadDir: os.tmpdir(),
  autoClean: true
};
app.use(formData.parse(options));
app.use(formData.format());
app.use(formData.stream());
app.use(formData.union());

app.use(cors());

app.get('/', (req, res) => {
  res.send('Common Check Widget API Backend is Alive')
});

app.get('/health', (req, res) => res.send(true))

app.post('/api/v1/verify', async (req, res) => {

    const encryptionFile = req.files.file
    try {
      const responseJson = await ccw.ccwasync(encryptionFile)
      res.send(responseJson)

    } catch (e) {
      console.log("e",e)
      res.send(
        {
          validToEnter: false,
          code: "5000",
          errors: [],
          entryWindow: {},
          metadata: {}
        }
      )
    }

});
let port = process.env.PORT || 3000;

app.listen(port, async () => {
    console.log(`App running on port ${port}`);
});

module.exports = app
```

## Example in Python
Dependency libaries
```
flask==1.1.1
affinidi.common-check-widget-backend-lib==x.x.x
```
Sample Code
```Python
from flask import Flask, request, Response
from flask_cors import CORS
import json
import tempfile
import os
from werkzeug.utils import secure_filename
from affinidi.common_check_widget_backend_lib import *

app = Flask(__name__)
CORS(app)
ccw = CommonCheckWidget()

@app.route("/api/v1/verify", methods=['GET', 'POST'])
def verify():

    if request.method == "POST":
        try:
            if request.files:
                encryptionFile = request.files["file"]

                dir = tempfile.gettempdir()
                filename = secure_filename(encryptionFile.filename)
                encryptionFile.save(os.path.join(dir, filename))
                result = ccw.ccwbypathasync(os.path.join(dir, filename))
                print("RESULT")
                print(result)

                return result
            else:
                print("NO FILE")
                return Response(json.dumps(ccw.ccwerror()), mimetype='application/json')
        except:
            print("ERROR")
            return Response(json.dumps(ccw.ccwerror()), mimetype='application/json')
        

    return Response(json.dumps(ccw.ccwerror()), mimetype='application/json')


if __name__ == '__main__':
    app.run(debug=True, host='0.0.0.0', port=5005)
```

## Example in dotNET
Dependency libaries
```
    <PackageReference Include="Affinidi.Common.Check.Widget.Backend.Lib" Version="1.1.5" />
    <PackageReference Include="Microsoft.AspNet.WebApi" Version="5.2.7" />
    <PackageReference Include="Swashbuckle.AspNetCore" Version="5.6.3" />
```
Sampple Code
```C#
using System;
using Microsoft.AspNetCore.Mvc;
using Affinidi.Common.Check.Widget.Backend.Lib;
using Newtonsoft.Json.Linq;
namespace common_check_widget_demo_backend_dotnet.Controllers
{
    [ApiController]
    [Route("[controller]")]
    public class apiController : ControllerBase
    {
        private const string V = "5000";

        [HttpPost("v1/verify")]
        [HttpPost, DisableRequestSizeLimit]
        public  IActionResult Upload()
        {

            CommonCheckWidget ccw = new CommonCheckWidget();
            try
            {

                var files = HttpContext.Request.Form.Files;
                if (files.Count>0)
                {
                    var file = files[0];
                    var path = System.IO.Path.GetTempPath();
                    var filePath = System.IO.Path.Combine(path, file.FileName);
                
                    using (System.IO.Stream fileStream = new System.IO.FileStream(filePath, System.IO.FileMode.Create)) {
                        file.CopyToAsync(fileStream);
                    }
                    if (file.Length > 0)
                    {
                        
                        var result = ccw.Ccwbypathasync(filePath);

                        return Ok(result);
                        
                    }

                    return Ok(ccw.Ccwerror());
                }
                return Ok(ccw.Ccwerror());
            }
            catch (Exception ex)
            {
                Console.Write(ex.ToString());
                return Ok(ccw.Ccwerror());
            }
        }
    }
}

```

# The Common Check Widget Documentation

Here is our common check widget link: https://doc.common-check-widget.affinity-project.org/#/

