from datetime import datetime
from gsdk.integrations.sportsdataio.ncaab.team.teamlike import Teamlike
from . import controller
from ..... import integrations
from typing import Dict, Any, Optional, Sequence
from . import models
import redis


class Ncaab:

    division : controller.Division = controller.Division()
    key : str = "demo:internal"
    r = redis.Redis(host='localhost', port=6379, db=0)

    @classmethod
    def team(cls, id : int)->controller.Team:
        """Gets a team by id.

        Args:
            id (int): _description_

        Returns:
            controller.Team: _description_
        """
        return controller.Team(id, key=cls.key)

    @classmethod
    def seed_efficiency(cls, seed : Optional[Sequence[Dict[str, Any]]] = None):

        seed_by_name : Dict[str, Teamlike] = {}
        seed_by_school : Dict[str, Teamlike] = {}
        for team in integrations.SportsDataIO.ncaab.teams.get_teams():
            seed_by_name[team.name] = team
            seed_by_school[team.school] = team

        # use the model provided in the class
        model = models.EfficiencyRedisMeta(cls.key, cls.r)
        for team in seed or KENPOMSEED:
            if seed_by_name.get(str(team["Team"])):
                model.commit_efficiency(models.EfficiencyPayload({
                    "team_id" : seed_by_name[str(team["Team"])].team_id,
                    **team
                }), datetime.fromtimestamp(1636449))
            elif seed_by_school.get(str(team["Team"])):
                model.commit_efficiency(models.EfficiencyPayload({
                    "team_id" : seed_by_school[str(team["Team"])].team_id,
                    **team
                }), datetime.fromtimestamp(1636449))
            


KENPOMSEED = [
 {
   "Rk": 1,
   "Team": "Duke",
   "Conf": "ACC",
   "W-L": "31-4",
   "adjem": 34.19,
   "kadjoeff": 121,
   "kadjdeff": 86.8,
   "badjoeff": 121,
   "badjdeff": 86.8,
   "radjoeff": 121,
   "radjdeff": 86.8
 },
 {
   "Rk": 2,
   "Team": "Cincinnati",
   "Conf": "CUSA",
   "W-L": "31-4",
   "adjem": 30.19,
   "kadjoeff": 118.1,
   "kadjdeff": 87.9,
   "badjoeff": 118.1,
   "badjdeff": 87.9,
   "radjoeff": 118.1,
   "radjdeff": 87.9
 },
 {
   "Rk": 3,
   "Team": "Maryland",
   "Conf": "ACC",
   "W-L": "32-4",
   "adjem": 29.25,
   "kadjoeff": 119.2,
   "kadjdeff": 89.9,
   "badjoeff": 119.2,
   "badjdeff": 89.9,
   "radjoeff": 119.2,
   "radjdeff": 89.9
 },
 {
   "Rk": 4,
   "Team": "Kansas",
   "Conf": "B12",
   "W-L": "33-4",
   "adjem": 28.99,
   "kadjoeff": 118.7,
   "kadjdeff": 89.7,
   "badjoeff": 118.7,
   "badjdeff": 89.7,
   "radjoeff": 118.7,
   "radjdeff": 89.7
 },
 {
   "Rk": 5,
   "Team": "Oklahoma",
   "Conf": "B12",
   "W-L": "31-5",
   "adjem": 26.04,
   "kadjoeff": 114.9,
   "kadjdeff": 88.9,
   "badjoeff": 114.9,
   "badjdeff": 88.9,
   "radjoeff": 114.9,
   "radjdeff": 88.9
 },
 {
   "Rk": 6,
   "Team": "Indiana",
   "Conf": "B10",
   "W-L": "25-12",
   "adjem": 24.8,
   "kadjoeff": 114,
   "kadjdeff": 89.2,
   "badjoeff": 114,
   "badjdeff": 89.2,
   "radjoeff": 114,
   "radjdeff": 89.2
 },
 {
   "Rk": 7,
   "Team": "Florida",
   "Conf": "SEC",
   "W-L": "22-9",
   "adjem": 24.72,
   "kadjoeff": 115.1,
   "kadjdeff": 90.4,
   "badjoeff": 115.1,
   "badjdeff": 90.4,
   "radjoeff": 115.1,
   "radjdeff": 90.4
 },
 {
   "Rk": 8,
   "Team": "Illinois",
   "Conf": "B10",
   "W-L": "26-9",
   "adjem": 23.21,
   "kadjoeff": 115.7,
   "kadjdeff": 92.5,
   "badjoeff": 115.7,
   "badjdeff": 92.5,
   "radjoeff": 115.7,
   "radjdeff": 92.5
 },
 {
   "Rk": 9,
   "Team": "Oregon",
   "Conf": "P10",
   "W-L": "26-9",
   "adjem": 22.97,
   "kadjoeff": 119.2,
   "kadjdeff": 96.3,
   "badjoeff": 119.2,
   "badjdeff": 96.3,
   "radjoeff": 119.2,
   "radjdeff": 96.3
 },
 {
   "Rk": 10,
   "Team": "Kentucky",
   "Conf": "SEC",
   "W-L": "22-10",
   "adjem": 22.21,
   "kadjoeff": 113.4,
   "kadjdeff": 91.2,
   "badjoeff": 113.4,
   "badjdeff": 91.2,
   "radjoeff": 113.4,
   "radjdeff": 91.2
 },
 {
   "Rk": 11,
   "Team": "Marquette",
   "Conf": "CUSA",
   "W-L": "26-7",
   "adjem": 21.47,
   "kadjoeff": 113.4,
   "kadjdeff": 91.9,
   "badjoeff": 113.4,
   "badjdeff": 91.9,
   "radjoeff": 113.4,
   "radjdeff": 91.9
 },
 {
   "Rk": 12,
   "Team": "USC",
   "Conf": "P10",
   "W-L": "22-10",
   "adjem": 20.67,
   "kadjoeff": 112.8,
   "kadjdeff": 92.1,
   "badjoeff": 112.8,
   "badjdeff": 92.1,
   "radjoeff": 112.8,
   "radjdeff": 92.1
 },
 {
   "Rk": 13,
   "Team": "Arizona",
   "Conf": "P10",
   "W-L": "24-10",
   "adjem": 20.54,
   "kadjoeff": 119.3,
   "kadjdeff": 98.8,
   "badjoeff": 119.3,
   "badjdeff": 98.8,
   "radjoeff": 119.3,
   "radjdeff": 98.8
 },
 {
   "Rk": 14,
   "Team": "Kent State",
   "Conf": "MAC",
   "W-L": "29-6",
   "adjem": 20.39,
   "kadjoeff": 116.7,
   "kadjdeff": 96.4,
   "badjoeff": 116.7,
   "badjdeff": 96.4,
   "radjoeff": 116.7,
   "radjdeff": 96.4
 },
 {
   "Rk": 15,
   "Team": "Stanford",
   "Conf": "P10",
   "W-L": "20-10",
   "adjem": 20.32,
   "kadjoeff": 116.6,
   "kadjdeff": 96.3,
   "badjoeff": 116.6,
   "badjdeff": 96.3,
   "radjoeff": 116.6,
   "radjdeff": 96.3
 },
 {
   "Rk": 16,
   "Team": "Pittsburgh",
   "Conf": "BE",
   "W-L": "29-6",
   "adjem": 19.94,
   "kadjoeff": 112.1,
   "kadjdeff": 92.2,
   "badjoeff": 112.1,
   "badjdeff": 92.2,
   "radjoeff": 112.1,
   "radjdeff": 92.2
 },
 {
   "Rk": 17,
   "Team": "Ohio State",
   "Conf": "B10",
   "W-L": "24-8",
   "adjem": 19.76,
   "kadjoeff": 116.4,
   "kadjdeff": 96.6,
   "badjoeff": 116.4,
   "badjdeff": 96.6,
   "radjoeff": 116.4,
   "radjdeff": 96.6
 },
 {
   "Rk": 18,
   "Team": "Connecticut",
   "Conf": "BE",
   "W-L": "27-7",
   "adjem": 19.36,
   "kadjoeff": 112.2,
   "kadjdeff": 92.8,
   "badjoeff": 112.2,
   "badjdeff": 92.8,
   "radjoeff": 112.2,
   "radjdeff": 92.8
 },
 {
   "Rk": 19,
   "Team": "Notre Dame",
   "Conf": "BE",
   "W-L": "21-11",
   "adjem": 19.27,
   "kadjoeff": 116.1,
   "kadjdeff": 96.8,
   "badjoeff": 116.1,
   "badjdeff": 96.8,
   "radjoeff": 116.1,
   "radjdeff": 96.8
 },
 {
   "Rk": 20,
   "Team": "South Carolina",
   "Conf": "SEC",
   "W-L": "21-15",
   "adjem": 19.18,
   "kadjoeff": 107,
   "kadjdeff": 87.9,
   "badjoeff": 107,
   "badjdeff": 87.9,
   "radjoeff": 107,
   "radjdeff": 87.9
 },
 {
   "Rk": 21,
   "Team": "N.C. State",
   "Conf": "ACC",
   "W-L": "23-11",
   "adjem": 19.15,
   "kadjoeff": 113.2,
   "kadjdeff": 94,
   "badjoeff": 113.2,
   "badjdeff": 94,
   "radjoeff": 113.2,
   "radjdeff": 94
 },
 {
   "Rk": 22,
   "Team": "Alabama",
   "Conf": "SEC",
   "W-L": "27-8",
   "adjem": 18.73,
   "kadjoeff": 114,
   "kadjdeff": 95.3,
   "badjoeff": 114,
   "badjdeff": 95.3,
   "radjoeff": 114,
   "radjdeff": 95.3
 },
 {
   "Rk": 23,
   "Team": "Xavier",
   "Conf": "A10",
   "W-L": "26-6",
   "adjem": 18.6,
   "kadjoeff": 111.2,
   "kadjdeff": 92.6,
   "badjoeff": 111.2,
   "badjdeff": 92.6,
   "radjoeff": 111.2,
   "radjdeff": 92.6
 },
 {
   "Rk": 24,
   "Team": "Gonzaga",
   "Conf": "WCC",
   "W-L": "28-4",
   "adjem": 18.51,
   "kadjoeff": 115.6,
   "kadjdeff": 97.1,
   "badjoeff": 115.6,
   "badjdeff": 97.1,
   "radjoeff": 115.6,
   "radjdeff": 97.1
 },
 {
   "Rk": 25,
   "Team": "Georgia",
   "Conf": "SEC",
   "W-L": "22-9",
   "adjem": 18.44,
   "kadjoeff": 116.7,
   "kadjdeff": 98.3,
   "badjoeff": 116.7,
   "badjdeff": 98.3,
   "radjoeff": 116.7,
   "radjdeff": 98.3
 },
 {
   "Rk": 26,
   "Team": "Mississippi State",
   "Conf": "SEC",
   "W-L": "27-8",
   "adjem": 18.25,
   "kadjoeff": 111.4,
   "kadjdeff": 93.1,
   "badjoeff": 111.4,
   "badjdeff": 93.1,
   "radjoeff": 111.4,
   "radjdeff": 93.1
 },
 {
   "Rk": 27,
   "Team": "Texas",
   "Conf": "B12",
   "W-L": "22-12",
   "adjem": 17.69,
   "kadjoeff": 116,
   "kadjdeff": 98.3,
   "badjoeff": 116,
   "badjdeff": 98.3,
   "radjoeff": 116,
   "radjdeff": 98.3
 },
 {
   "Rk": 28,
   "Team": "Butler",
   "Conf": "Horz",
   "W-L": "26-6",
   "adjem": 17.63,
   "kadjoeff": 111.9,
   "kadjdeff": 94.3,
   "badjoeff": 111.9,
   "badjdeff": 94.3,
   "radjoeff": 111.9,
   "radjdeff": 94.3
 },
 {
   "Rk": 29,
   "Team": "Missouri",
   "Conf": "B12",
   "W-L": "24-12",
   "adjem": 17.49,
   "kadjoeff": 116.2,
   "kadjdeff": 98.7,
   "badjoeff": 116.2,
   "badjdeff": 98.7,
   "radjoeff": 116.2,
   "radjdeff": 98.7
 },
 {
   "Rk": 30,
   "Team": "Wake Forest",
   "Conf": "ACC",
   "W-L": "21-13",
   "adjem": 17.35,
   "kadjoeff": 118.6,
   "kadjdeff": 101.3,
   "badjoeff": 118.6,
   "badjdeff": 101.3,
   "radjoeff": 118.6,
   "radjdeff": 101.3
 },
 {
   "Rk": 31,
   "Team": "Texas Tech",
   "Conf": "B12",
   "W-L": "23-9",
   "adjem": 17.24,
   "kadjoeff": 114.6,
   "kadjdeff": 97.4,
   "badjoeff": 114.6,
   "badjdeff": 97.4,
   "radjoeff": 114.6,
   "radjdeff": 97.4
 },
 {
   "Rk": 32,
   "Team": "Michigan State",
   "Conf": "B10",
   "W-L": "19-12",
   "adjem": 16.86,
   "kadjoeff": 113,
   "kadjdeff": 96.2,
   "badjoeff": 113,
   "badjdeff": 96.2,
   "radjoeff": 113,
   "radjdeff": 96.2
 },
 {
   "Rk": 33,
   "Team": "Memphis",
   "Conf": "CUSA",
   "W-L": "27-9",
   "adjem": 16.69,
   "kadjoeff": 112.5,
   "kadjdeff": 95.8,
   "badjoeff": 112.5,
   "badjdeff": 95.8,
   "radjoeff": 112.5,
   "radjdeff": 95.8
 },
 {
   "Rk": 34,
   "Team": "Mississippi",
   "Conf": "SEC",
   "W-L": "19-11",
   "adjem": 16.68,
   "kadjoeff": 113.3,
   "kadjdeff": 96.7,
   "badjoeff": 113.3,
   "badjdeff": 96.7,
   "radjoeff": 113.3,
   "radjdeff": 96.7
 },
 {
   "Rk": 35,
   "Team": "UCLA",
   "Conf": "P10",
   "W-L": "21-12",
   "adjem": 16.34,
   "kadjoeff": 113.7,
   "kadjdeff": 97.3,
   "badjoeff": 113.7,
   "badjdeff": 97.3,
   "radjoeff": 113.7,
   "radjdeff": 97.3
 },
 {
   "Rk": 36,
   "Team": "Georgetown",
   "Conf": "BE",
   "W-L": "18-11",
   "adjem": 16.13,
   "kadjoeff": 110.6,
   "kadjdeff": 94.5,
   "badjoeff": 110.6,
   "badjdeff": 94.5,
   "radjoeff": 110.6,
   "radjdeff": 94.5
 },
 {
   "Rk": 37,
   "Team": "California",
   "Conf": "P10",
   "W-L": "23-9",
   "adjem": 16.03,
   "kadjoeff": 109.8,
   "kadjdeff": 93.7,
   "badjoeff": 109.8,
   "badjdeff": 93.7,
   "radjoeff": 109.8,
   "radjdeff": 93.7
 },
 {
   "Rk": 38,
   "Team": "Oklahoma State",
   "Conf": "B12",
   "W-L": "23-9",
   "adjem": 15.8,
   "kadjoeff": 107.9,
   "kadjdeff": 92.1,
   "badjoeff": 107.9,
   "badjdeff": 92.1,
   "radjoeff": 107.9,
   "radjdeff": 92.1
 },
 {
   "Rk": 39,
   "Team": "Miami FL",
   "Conf": "BE",
   "W-L": "24-8",
   "adjem": 15.77,
   "kadjoeff": 110.5,
   "kadjdeff": 94.7,
   "badjoeff": 110.5,
   "badjdeff": 94.7,
   "radjoeff": 110.5,
   "radjdeff": 94.7
 },
 {
   "Rk": 40,
   "Team": "Charlotte",
   "Conf": "CUSA",
   "W-L": "18-12",
   "adjem": 15.73,
   "kadjoeff": 114.2,
   "kadjdeff": 98.5,
   "badjoeff": 114.2,
   "badjdeff": 98.5,
   "radjoeff": 114.2,
   "radjdeff": 98.5
 },
 {
   "Rk": 41,
   "Team": "Tulsa",
   "Conf": "WAC",
   "W-L": "26-7",
   "adjem": 15.59,
   "kadjoeff": 116,
   "kadjdeff": 100.4,
   "badjoeff": 116,
   "badjdeff": 100.4,
   "radjoeff": 116,
   "radjdeff": 100.4
 },
 {
   "Rk": 42,
   "Team": "Dayton",
   "Conf": "A10",
   "W-L": "21-11",
   "adjem": 15.53,
   "kadjoeff": 112.9,
   "kadjdeff": 97.4,
   "badjoeff": 112.9,
   "badjdeff": 97.4,
   "radjoeff": 112.9,
   "radjdeff": 97.4
 },
 {
   "Rk": 43,
   "Team": "Minnesota",
   "Conf": "B10",
   "W-L": "18-13",
   "adjem": 14.54,
   "kadjoeff": 113.5,
   "kadjdeff": 99,
   "badjoeff": 113.5,
   "badjdeff": 99,
   "radjoeff": 113.5,
   "radjdeff": 99
 },
 {
   "Rk": 44,
   "Team": "Western Kentucky",
   "Conf": "SB",
   "W-L": "26-4",
   "adjem": 14.51,
   "kadjoeff": 110.5,
   "kadjdeff": 96,
   "badjoeff": 110.5,
   "badjdeff": 96,
   "radjoeff": 110.5,
   "radjdeff": 96
 },
 {
   "Rk": 45,
   "Team": "Utah",
   "Conf": "MWC",
   "W-L": "19-9",
   "adjem": 14.08,
   "kadjoeff": 111.4,
   "kadjdeff": 97.3,
   "badjoeff": 111.4,
   "badjdeff": 97.3,
   "radjoeff": 111.4,
   "radjdeff": 97.3
 },
 {
   "Rk": 46,
   "Team": "Iowa",
   "Conf": "B10",
   "W-L": "19-16",
   "adjem": 13.66,
   "kadjoeff": 110.4,
   "kadjdeff": 96.8,
   "badjoeff": 110.4,
   "badjdeff": 96.8,
   "radjoeff": 110.4,
   "radjdeff": 96.8
 },
 {
   "Rk": 47,
   "Team": "Valparaiso",
   "Conf": "MCon",
   "W-L": "24-8",
   "adjem": 13.63,
   "kadjoeff": 111.5,
   "kadjdeff": 97.8,
   "badjoeff": 111.5,
   "badjdeff": 97.8,
   "radjoeff": 111.5,
   "radjdeff": 97.8
 },
 {
   "Rk": 48,
   "Team": "Temple",
   "Conf": "A10",
   "W-L": "19-15",
   "adjem": 13.57,
   "kadjoeff": 114,
   "kadjdeff": 100.4,
   "badjoeff": 114,
   "badjdeff": 100.4,
   "radjoeff": 114,
   "radjdeff": 100.4
 },
 {
   "Rk": 49,
   "Team": "Southern Illinois",
   "Conf": "MVC",
   "W-L": "28-8",
   "adjem": 13.45,
   "kadjoeff": 109.2,
   "kadjdeff": 95.7,
   "badjoeff": 109.2,
   "badjdeff": 95.7,
   "radjoeff": 109.2,
   "radjdeff": 95.7
 },
 {
   "Rk": 50,
   "Team": "Wisconsin",
   "Conf": "B10",
   "W-L": "18-13",
   "adjem": 13.22,
   "kadjoeff": 110.7,
   "kadjdeff": 97.5,
   "badjoeff": 110.7,
   "badjdeff": 97.5,
   "radjoeff": 110.7,
   "radjdeff": 97.5
 },
 {
   "Rk": 51,
   "Team": "Hawaii",
   "Conf": "WAC",
   "W-L": "26-6",
   "adjem": 13.15,
   "kadjoeff": 110.3,
   "kadjdeff": 97.2,
   "badjoeff": 110.3,
   "badjdeff": 97.2,
   "radjoeff": 110.3,
   "radjdeff": 97.2
 },
 {
   "Rk": 52,
   "Team": "Villanova",
   "Conf": "BE",
   "W-L": "19-13",
   "adjem": 13.14,
   "kadjoeff": 106.7,
   "kadjdeff": 93.5,
   "badjoeff": 106.7,
   "badjdeff": 93.5,
   "radjoeff": 106.7,
   "radjdeff": 93.5
 },
 {
   "Rk": 53,
   "Team": "Virginia",
   "Conf": "ACC",
   "W-L": "17-12",
   "adjem": 12.92,
   "kadjoeff": 112,
   "kadjdeff": 99.1,
   "badjoeff": 112,
   "badjdeff": 99.1,
   "radjoeff": 112,
   "radjdeff": 99.1
 },
 {
   "Rk": 54,
   "Team": "Tennessee",
   "Conf": "SEC",
   "W-L": "15-16",
   "adjem": 12.67,
   "kadjoeff": 110.9,
   "kadjdeff": 98.2,
   "badjoeff": 110.9,
   "badjdeff": 98.2,
   "radjoeff": 110.9,
   "radjdeff": 98.2
 },
 {
   "Rk": 55,
   "Team": "Ball State",
   "Conf": "MAC",
   "W-L": "23-12",
   "adjem": 12.66,
   "kadjoeff": 113.3,
   "kadjdeff": 100.6,
   "badjoeff": 113.3,
   "badjdeff": 100.6,
   "radjoeff": 113.3,
   "radjdeff": 100.6
 },
 {
   "Rk": 56,
   "Team": "Syracuse",
   "Conf": "BE",
   "W-L": "23-13",
   "adjem": 12.61,
   "kadjoeff": 106.1,
   "kadjdeff": 93.5,
   "badjoeff": 106.1,
   "badjdeff": 93.5,
   "radjoeff": 106.1,
   "radjdeff": 93.5
 },
 {
   "Rk": 57,
   "Team": "Arkansas",
   "Conf": "SEC",
   "W-L": "14-15",
   "adjem": 12.56,
   "kadjoeff": 108.8,
   "kadjdeff": 96.2,
   "badjoeff": 108.8,
   "badjdeff": 96.2,
   "radjoeff": 108.8,
   "radjdeff": 96.2
 },
 {
   "Rk": 58,
   "Team": "Penn",
   "Conf": "Ivy",
   "W-L": "25-7",
   "adjem": 12.23,
   "kadjoeff": 110.2,
   "kadjdeff": 98,
   "badjoeff": 110.2,
   "badjdeff": 98,
   "radjoeff": 110.2,
   "radjdeff": 98
 },
 {
   "Rk": 59,
   "Team": "Creighton",
   "Conf": "MVC",
   "W-L": "23-9",
   "adjem": 11.82,
   "kadjoeff": 111.3,
   "kadjdeff": 99.5,
   "badjoeff": 111.3,
   "badjdeff": 99.5,
   "radjoeff": 111.3,
   "radjdeff": 99.5
 },
 {
   "Rk": 60,
   "Team": "Bowling Green",
   "Conf": "MAC",
   "W-L": "23-9",
   "adjem": 11.76,
   "kadjoeff": 111.3,
   "kadjdeff": 99.6,
   "badjoeff": 111.3,
   "badjdeff": 99.6,
   "radjoeff": 111.3,
   "radjdeff": 99.6
 },
 {
   "Rk": 61,
   "Team": "Louisville",
   "Conf": "CUSA",
   "W-L": "19-13",
   "adjem": 11.74,
   "kadjoeff": 108.1,
   "kadjdeff": 96.4,
   "badjoeff": 108.1,
   "badjdeff": 96.4,
   "radjoeff": 108.1,
   "radjdeff": 96.4
 },
 {
   "Rk": 62,
   "Team": "Pepperdine",
   "Conf": "WCC",
   "W-L": "21-9",
   "adjem": 11.72,
   "kadjoeff": 111.1,
   "kadjdeff": 99.3,
   "badjoeff": 111.1,
   "badjdeff": 99.3,
   "radjoeff": 111.1,
   "radjdeff": 99.3
 },
 {
   "Rk": 63,
   "Team": "BYU",
   "Conf": "MWC",
   "W-L": "17-12",
   "adjem": 11.55,
   "kadjoeff": 109.2,
   "kadjdeff": 97.7,
   "badjoeff": 109.2,
   "badjdeff": 97.7,
   "radjoeff": 109.2,
   "radjdeff": 97.7
 },
 {
   "Rk": 64,
   "Team": "Louisiana Tech",
   "Conf": "WAC",
   "W-L": "20-10",
   "adjem": 11.43,
   "kadjoeff": 110,
   "kadjdeff": 98.6,
   "badjoeff": 110,
   "badjdeff": 98.6,
   "radjoeff": 110,
   "radjdeff": 98.6
 },
 {
   "Rk": 65,
   "Team": "UNC Wilmington",
   "Conf": "CAA",
   "W-L": "23-10",
   "adjem": 11.32,
   "kadjoeff": 107.4,
   "kadjdeff": 96.1,
   "badjoeff": 107.4,
   "badjdeff": 96.1,
   "radjoeff": 107.4,
   "radjdeff": 96.1
 },
 {
   "Rk": 66,
   "Team": "LSU",
   "Conf": "SEC",
   "W-L": "18-15",
   "adjem": 11.1,
   "kadjoeff": 105.4,
   "kadjdeff": 94.3,
   "badjoeff": 105.4,
   "badjdeff": 94.3,
   "radjoeff": 105.4,
   "radjdeff": 94.3
 },
 {
   "Rk": 67,
   "Team": "Wyoming",
   "Conf": "MWC",
   "W-L": "22-9",
   "adjem": 11.01,
   "kadjoeff": 107.8,
   "kadjdeff": 96.7,
   "badjoeff": 107.8,
   "badjdeff": 96.7,
   "radjoeff": 107.8,
   "radjdeff": 96.7
 },
 {
   "Rk": 68,
   "Team": "Saint Joseph's",
   "Conf": "A10",
   "W-L": "19-12",
   "adjem": 10.81,
   "kadjoeff": 114.4,
   "kadjdeff": 103.6,
   "badjoeff": 114.4,
   "badjdeff": 103.6,
   "radjoeff": 114.4,
   "radjdeff": 103.6
 },
 {
   "Rk": 69,
   "Team": "Arizona State",
   "Conf": "P10",
   "W-L": "14-15",
   "adjem": 10.54,
   "kadjoeff": 108.6,
   "kadjdeff": 98.1,
   "badjoeff": 108.6,
   "badjdeff": 98.1,
   "radjoeff": 108.6,
   "radjdeff": 98.1
 },
 {
   "Rk": 70,
   "Team": "Georgia Tech",
   "Conf": "ACC",
   "W-L": "15-16",
   "adjem": 10.5,
   "kadjoeff": 111.1,
   "kadjdeff": 100.6,
   "badjoeff": 111.1,
   "badjdeff": 100.6,
   "radjoeff": 111.1,
   "radjdeff": 100.6
 },
 {
   "Rk": 71,
   "Team": "Boston College",
   "Conf": "BE",
   "W-L": "20-12",
   "adjem": 9.97,
   "kadjoeff": 109.4,
   "kadjdeff": 99.4,
   "badjoeff": 109.4,
   "badjdeff": 99.4,
   "radjoeff": 109.4,
   "radjdeff": 99.4
 },
 {
   "Rk": 72,
   "Team": "Tennessee Tech",
   "Conf": "OVC",
   "W-L": "24-7",
   "adjem": 9.44,
   "kadjoeff": 109.9,
   "kadjdeff": 100.4,
   "badjoeff": 109.9,
   "badjdeff": 100.4,
   "radjoeff": 109.9,
   "radjdeff": 100.4
 },
 {
   "Rk": 73,
   "Team": "South Florida",
   "Conf": "CUSA",
   "W-L": "19-13",
   "adjem": 9.43,
   "kadjoeff": 107.9,
   "kadjdeff": 98.4,
   "badjoeff": 107.9,
   "badjdeff": 98.4,
   "radjoeff": 107.9,
   "radjdeff": 98.4
 },
 {
   "Rk": 74,
   "Team": "San Diego State",
   "Conf": "MWC",
   "W-L": "21-12",
   "adjem": 9.29,
   "kadjoeff": 106.9,
   "kadjdeff": 97.6,
   "badjoeff": 106.9,
   "badjdeff": 97.6,
   "radjoeff": 106.9,
   "radjdeff": 97.6
 },
 {
   "Rk": 75,
   "Team": "Utah State",
   "Conf": "BW",
   "W-L": "22-8",
   "adjem": 9.17,
   "kadjoeff": 106.3,
   "kadjdeff": 97.2,
   "badjoeff": 106.3,
   "badjdeff": 97.2,
   "radjoeff": 106.3,
   "radjdeff": 97.2
 },
 {
   "Rk": 76,
   "Team": "State John's",
   "Conf": "BE",
   "W-L": "20-12",
   "adjem": 9.06,
   "kadjoeff": 102.7,
   "kadjdeff": 93.6,
   "badjoeff": 102.7,
   "badjdeff": 93.6,
   "radjoeff": 102.7,
   "radjdeff": 93.6
 },
 {
   "Rk": 77,
   "Team": "UC Santa Barbara",
   "Conf": "BW",
   "W-L": "19-11",
   "adjem": 8.87,
   "kadjoeff": 108.2,
   "kadjdeff": 99.3,
   "badjoeff": 108.2,
   "badjdeff": 99.3,
   "radjoeff": 108.2,
   "radjdeff": 99.3
 },
 {
   "Rk": 78,
   "Team": "State Bonaventure",
   "Conf": "A10",
   "W-L": "17-13",
   "adjem": 8.59,
   "kadjoeff": 116.1,
   "kadjdeff": 107.5,
   "badjoeff": 116.1,
   "badjdeff": 107.5,
   "radjoeff": 116.1,
   "radjdeff": 107.5
 },
 {
   "Rk": 79,
   "Team": "College of Charleston",
   "Conf": "SC",
   "W-L": "20-8",
   "adjem": 8.41,
   "kadjoeff": 105,
   "kadjdeff": 96.6,
   "badjoeff": 105,
   "badjdeff": 96.6,
   "radjoeff": 105,
   "radjdeff": 96.6
 },
 {
   "Rk": 80,
   "Team": "Richmond",
   "Conf": "A10",
   "W-L": "22-14",
   "adjem": 8.31,
   "kadjoeff": 104.1,
   "kadjdeff": 95.8,
   "badjoeff": 104.1,
   "badjdeff": 95.8,
   "radjoeff": 104.1,
   "radjdeff": 95.8
 },
 {
   "Rk": 81,
   "Team": "UNLV",
   "Conf": "MWC",
   "W-L": "21-11",
   "adjem": 8.26,
   "kadjoeff": 109.7,
   "kadjdeff": 101.5,
   "badjoeff": 109.7,
   "badjdeff": 101.5,
   "radjoeff": 109.7,
   "radjdeff": 101.5
 },
 {
   "Rk": 82,
   "Team": "Fresno State",
   "Conf": "WAC",
   "W-L": "19-15",
   "adjem": 7.82,
   "kadjoeff": 104.4,
   "kadjdeff": 96.5,
   "badjoeff": 104.4,
   "badjdeff": 96.5,
   "radjoeff": 104.4,
   "radjdeff": 96.5
 },
 {
   "Rk": 83,
   "Team": "Purdue",
   "Conf": "B10",
   "W-L": "13-18",
   "adjem": 7.6,
   "kadjoeff": 109.8,
   "kadjdeff": 102.2,
   "badjoeff": 109.8,
   "badjdeff": 102.2,
   "radjoeff": 109.8,
   "radjdeff": 102.2
 },
 {
   "Rk": 84,
   "Team": "Seton Hall",
   "Conf": "BE",
   "W-L": "11-18",
   "adjem": 7.18,
   "kadjoeff": 105,
   "kadjdeff": 97.9,
   "badjoeff": 105,
   "badjdeff": 97.9,
   "radjoeff": 105,
   "radjdeff": 97.9
 },
 {
   "Rk": 85,
   "Team": "Vanderbilt",
   "Conf": "SEC",
   "W-L": "17-15",
   "adjem": 7.14,
   "kadjoeff": 107.6,
   "kadjdeff": 100.5,
   "badjoeff": 107.6,
   "badjdeff": 100.5,
   "radjoeff": 107.6,
   "radjdeff": 100.5
 },
 {
   "Rk": 86,
   "Team": "Saint Louis",
   "Conf": "CUSA",
   "W-L": "15-16",
   "adjem": 6.91,
   "kadjoeff": 98.1,
   "kadjdeff": 91.2,
   "badjoeff": 98.1,
   "badjdeff": 91.2,
   "radjoeff": 98.1,
   "radjdeff": 91.2
 },
 {
   "Rk": 87,
   "Team": "Colorado",
   "Conf": "B12",
   "W-L": "14-14",
   "adjem": 6.78,
   "kadjoeff": 111.3,
   "kadjdeff": 104.6,
   "badjoeff": 111.3,
   "badjdeff": 104.6,
   "radjoeff": 111.3,
   "radjdeff": 104.6
 },
 {
   "Rk": 88,
   "Team": "Auburn",
   "Conf": "SEC",
   "W-L": "12-16",
   "adjem": 6.61,
   "kadjoeff": 98.6,
   "kadjdeff": 92,
   "badjoeff": 98.6,
   "badjdeff": 92,
   "radjoeff": 98.6,
   "radjdeff": 92
 },
 {
   "Rk": 89,
   "Team": "East Tennessee State",
   "Conf": "SC",
   "W-L": "15-10",
   "adjem": 6.6,
   "kadjoeff": 106.2,
   "kadjdeff": 99.6,
   "badjoeff": 106.2,
   "badjdeff": 99.6,
   "radjoeff": 106.2,
   "radjdeff": 99.6
 },
 {
   "Rk": 90,
   "Team": "Northwestern",
   "Conf": "B10",
   "W-L": "16-13",
   "adjem": 6.55,
   "kadjoeff": 99.9,
   "kadjdeff": 93.4,
   "badjoeff": 99.9,
   "badjdeff": 93.4,
   "radjoeff": 99.9,
   "radjdeff": 93.4
 },
 {
   "Rk": 91,
   "Team": "UC Irvine",
   "Conf": "BW",
   "W-L": "20-11",
   "adjem": 6.47,
   "kadjoeff": 108,
   "kadjdeff": 101.5,
   "badjoeff": 108,
   "badjdeff": 101.5,
   "radjoeff": 108,
   "radjdeff": 101.5
 },
 {
   "Rk": 92,
   "Team": "New Mexico",
   "Conf": "MWC",
   "W-L": "16-14",
   "adjem": 6.36,
   "kadjoeff": 110.3,
   "kadjdeff": 103.9,
   "badjoeff": 110.3,
   "badjdeff": 103.9,
   "radjoeff": 110.3,
   "radjdeff": 103.9
 },
 {
   "Rk": 93,
   "Team": "Milwaukee",
   "Conf": "Horz",
   "W-L": "13-13",
   "adjem": 6.28,
   "kadjoeff": 104.8,
   "kadjdeff": 98.5,
   "badjoeff": 104.8,
   "badjdeff": 98.5,
   "radjoeff": 104.8,
   "radjdeff": 98.5
 },
 {
   "Rk": 94,
   "Team": "Providence",
   "Conf": "BE",
   "W-L": "15-16",
   "adjem": 6.19,
   "kadjoeff": 102.9,
   "kadjdeff": 96.7,
   "badjoeff": 102.9,
   "badjdeff": 96.7,
   "radjoeff": 102.9,
   "radjdeff": 96.7
 },
 {
   "Rk": 95,
   "Team": "UAB",
   "Conf": "CUSA",
   "W-L": "13-17",
   "adjem": 6.18,
   "kadjoeff": 102.5,
   "kadjdeff": 96.4,
   "badjoeff": 102.5,
   "badjdeff": 96.4,
   "radjoeff": 102.5,
   "radjdeff": 96.4
 },
 {
   "Rk": 96,
   "Team": "New Mexico State",
   "Conf": "SB",
   "W-L": "18-11",
   "adjem": 5.87,
   "kadjoeff": 109.3,
   "kadjdeff": 103.4,
   "badjoeff": 109.3,
   "badjdeff": 103.4,
   "radjoeff": 109.3,
   "radjdeff": 103.4
 },
 {
   "Rk": 97,
   "Team": "Arkansas Little Rock",
   "Conf": "SB",
   "W-L": "16-11",
   "adjem": 5.75,
   "kadjoeff": 106.8,
   "kadjdeff": 101.1,
   "badjoeff": 106.8,
   "badjdeff": 101.1,
   "radjoeff": 106.8,
   "radjdeff": 101.1
 },
 {
   "Rk": 98,
   "Team": "Pacific",
   "Conf": "BW",
   "W-L": "18-10",
   "adjem": 5.74,
   "kadjoeff": 109.6,
   "kadjdeff": 103.8,
   "badjoeff": 109.6,
   "badjdeff": 103.8,
   "radjoeff": 109.6,
   "radjdeff": 103.8
 },
 {
   "Rk": 99,
   "Team": "Washington",
   "Conf": "P10",
   "W-L": "10-18",
   "adjem": 5.44,
   "kadjoeff": 105.3,
   "kadjdeff": 99.8,
   "badjoeff": 105.3,
   "badjdeff": 99.8,
   "radjoeff": 105.3,
   "radjdeff": 99.8
 },
 {
   "Rk": 100,
   "Team": "McNeese State",
   "Conf": "Slnd",
   "W-L": "20-9",
   "adjem": 5.39,
   "kadjoeff": 103.2,
   "kadjdeff": 97.8,
   "badjoeff": 103.2,
   "badjdeff": 97.8,
   "radjoeff": 103.2,
   "radjdeff": 97.8
 },
 {
   "Rk": 101,
   "Team": "San Diego",
   "Conf": "WCC",
   "W-L": "14-13",
   "adjem": 5.21,
   "kadjoeff": 107.7,
   "kadjdeff": 102.5,
   "badjoeff": 107.7,
   "badjdeff": 102.5,
   "radjoeff": 107.7,
   "radjdeff": 102.5
 },
 {
   "Rk": 102,
   "Team": "Detroit",
   "Conf": "Horz",
   "W-L": "18-13",
   "adjem": 5.01,
   "kadjoeff": 104,
   "kadjdeff": 99,
   "badjoeff": 104,
   "badjdeff": 99,
   "radjoeff": 104,
   "radjdeff": 99
 },
 {
   "Rk": 103,
   "Team": "Nebraska",
   "Conf": "B12",
   "W-L": "13-15",
   "adjem": 5,
   "kadjoeff": 105.8,
   "kadjdeff": 100.8,
   "badjoeff": 105.8,
   "badjdeff": 100.8,
   "radjoeff": 105.8,
   "radjdeff": 100.8
 },
 {
   "Rk": 104,
   "Team": "Houston",
   "Conf": "CUSA",
   "W-L": "17-15",
   "adjem": 4.99,
   "kadjoeff": 108.7,
   "kadjdeff": 103.7,
   "badjoeff": 108.7,
   "badjdeff": 103.7,
   "radjoeff": 108.7,
   "radjdeff": 103.7
 },
 {
   "Rk": 105,
   "Team": "Rutgers",
   "Conf": "BE",
   "W-L": "18-13",
   "adjem": 4.87,
   "kadjoeff": 98,
   "kadjdeff": 93.1,
   "badjoeff": 98,
   "badjdeff": 93.1,
   "radjoeff": 98,
   "radjdeff": 93.1
 },
 {
   "Rk": 106,
   "Team": "Baylor",
   "Conf": "B12",
   "W-L": "12-16",
   "adjem": 4.69,
   "kadjoeff": 108.2,
   "kadjdeff": 103.5,
   "badjoeff": 108.2,
   "badjdeff": 103.5,
   "radjoeff": 108.2,
   "radjdeff": 103.5
 },
 {
   "Rk": 107,
   "Team": "Louisiana Lafayette",
   "Conf": "SB",
   "W-L": "19-11",
   "adjem": 4.63,
   "kadjoeff": 99.7,
   "kadjdeff": 95,
   "badjoeff": 99.7,
   "badjdeff": 95,
   "radjoeff": 99.7,
   "radjdeff": 95
 },
 {
   "Rk": 108,
   "Team": "SMU",
   "Conf": "WAC",
   "W-L": "15-14",
   "adjem": 4.44,
   "kadjoeff": 107.6,
   "kadjdeff": 103.2,
   "badjoeff": 107.6,
   "badjdeff": 103.2,
   "radjoeff": 107.6,
   "radjdeff": 103.2
 },
 {
   "Rk": 109,
   "Team": "Oral Roberts",
   "Conf": "MCon",
   "W-L": "17-13",
   "adjem": 4.33,
   "kadjoeff": 105.4,
   "kadjdeff": 101,
   "badjoeff": 105.4,
   "badjdeff": 101,
   "radjoeff": 105.4,
   "radjdeff": 101
 },
 {
   "Rk": 110,
   "Team": "TCU",
   "Conf": "CUSA",
   "W-L": "14-15",
   "adjem": 4.23,
   "kadjoeff": 110,
   "kadjdeff": 105.8,
   "badjoeff": 110,
   "badjdeff": 105.8,
   "radjoeff": 110,
   "radjdeff": 105.8
 },
 {
   "Rk": 111,
   "Team": "UNC Greensboro",
   "Conf": "SC",
   "W-L": "20-11",
   "adjem": 4.21,
   "kadjoeff": 103.1,
   "kadjdeff": 98.8,
   "badjoeff": 103.1,
   "badjdeff": 98.8,
   "radjoeff": 103.1,
   "radjdeff": 98.8
 },
 {
   "Rk": 112,
   "Team": "Manhattan",
   "Conf": "MAAC",
   "W-L": "20-9",
   "adjem": 4.18,
   "kadjoeff": 104.6,
   "kadjdeff": 100.4,
   "badjoeff": 104.6,
   "badjdeff": 100.4,
   "radjoeff": 104.6,
   "radjdeff": 100.4
 },
 {
   "Rk": 113,
   "Team": "Iowa State",
   "Conf": "B12",
   "W-L": "12-19",
   "adjem": 4.16,
   "kadjoeff": 108.1,
   "kadjdeff": 103.9,
   "badjoeff": 108.1,
   "badjdeff": 103.9,
   "radjoeff": 108.1,
   "radjdeff": 103.9
 },
 {
   "Rk": 114,
   "Team": "Southwest Missouri State",
   "Conf": "MVC",
   "W-L": "17-15",
   "adjem": 4.15,
   "kadjoeff": 107.2,
   "kadjdeff": 103,
   "badjoeff": 107.2,
   "badjdeff": 103,
   "radjoeff": 107.2,
   "radjdeff": 103
 },
 {
   "Rk": 115,
   "Team": "Ohio",
   "Conf": "MAC",
   "W-L": "17-11",
   "adjem": 4.09,
   "kadjoeff": 108.2,
   "kadjdeff": 104.2,
   "badjoeff": 108.2,
   "badjdeff": 104.2,
   "radjoeff": 108.2,
   "radjdeff": 104.2
 },
 {
   "Rk": 116,
   "Team": "Hampton",
   "Conf": "MEAC",
   "W-L": "25-7",
   "adjem": 3.99,
   "kadjoeff": 109.9,
   "kadjdeff": 105.9,
   "badjoeff": 109.9,
   "badjdeff": 105.9,
   "radjoeff": 109.9,
   "radjdeff": 105.9
 },
 {
   "Rk": 117,
   "Team": "Marist",
   "Conf": "MAAC",
   "W-L": "19-9",
   "adjem": 3.98,
   "kadjoeff": 106.7,
   "kadjdeff": 102.8,
   "badjoeff": 106.7,
   "badjdeff": 102.8,
   "radjoeff": 106.7,
   "radjdeff": 102.8
 },
 {
   "Rk": 118,
   "Team": "Illinois Chicago",
   "Conf": "Horz",
   "W-L": "18-14",
   "adjem": 3.85,
   "kadjoeff": 108.9,
   "kadjdeff": 105,
   "badjoeff": 108.9,
   "badjdeff": 105,
   "radjoeff": 108.9,
   "radjdeff": 105
 },
 {
   "Rk": 119,
   "Team": "Davidson",
   "Conf": "SC",
   "W-L": "18-10",
   "adjem": 3.7,
   "kadjoeff": 101.5,
   "kadjdeff": 97.8,
   "badjoeff": 101.5,
   "badjdeff": 97.8,
   "radjoeff": 101.5,
   "radjdeff": 97.8
 },
 {
   "Rk": 120,
   "Team": "Kansas State",
   "Conf": "B12",
   "W-L": "13-16",
   "adjem": 3.67,
   "kadjoeff": 104,
   "kadjdeff": 100.3,
   "badjoeff": 104,
   "badjdeff": 100.3,
   "radjoeff": 104,
   "radjdeff": 100.3
 },
 {
   "Rk": 121,
   "Team": "Florida State",
   "Conf": "ACC",
   "W-L": "12-17",
   "adjem": 3.54,
   "kadjoeff": 105.8,
   "kadjdeff": 102.3,
   "badjoeff": 105.8,
   "badjdeff": 102.3,
   "radjoeff": 105.8,
   "radjdeff": 102.3
 },
 {
   "Rk": 122,
   "Team": "VCU",
   "Conf": "CAA",
   "W-L": "21-11",
   "adjem": 3.53,
   "kadjoeff": 102.9,
   "kadjdeff": 99.3,
   "badjoeff": 102.9,
   "badjdeff": 99.3,
   "radjoeff": 102.9,
   "radjdeff": 99.3
 },
 {
   "Rk": 123,
   "Team": "Nevada",
   "Conf": "WAC",
   "W-L": "16-13",
   "adjem": 3.41,
   "kadjoeff": 103.9,
   "kadjdeff": 100.5,
   "badjoeff": 103.9,
   "badjdeff": 100.5,
   "radjoeff": 103.9,
   "radjdeff": 100.5
 },
 {
   "Rk": 124,
   "Team": "Oregon State",
   "Conf": "P10",
   "W-L": "10-17",
   "adjem": 3.36,
   "kadjoeff": 103.4,
   "kadjdeff": 100,
   "badjoeff": 103.4,
   "badjdeff": 100,
   "radjoeff": 103.4,
   "radjdeff": 100
 },
 {
   "Rk": 125,
   "Team": "Colorado State",
   "Conf": "MWC",
   "W-L": "11-18",
   "adjem": 3.34,
   "kadjoeff": 103.8,
   "kadjdeff": 100.5,
   "badjoeff": 103.8,
   "badjdeff": 100.5,
   "radjoeff": 103.8,
   "radjdeff": 100.5
 },
 {
   "Rk": 126,
   "Team": "Loyola Chicago",
   "Conf": "Horz",
   "W-L": "17-13",
   "adjem": 3.2,
   "kadjoeff": 103.5,
   "kadjdeff": 100.3,
   "badjoeff": 103.5,
   "badjdeff": 100.3,
   "radjoeff": 103.5,
   "radjdeff": 100.3
 },
 {
   "Rk": 127,
   "Team": "Massachusetts",
   "Conf": "A10",
   "W-L": "13-16",
   "adjem": 3.17,
   "kadjoeff": 102,
   "kadjdeff": 98.8,
   "badjoeff": 102,
   "badjdeff": 98.8,
   "radjoeff": 102,
   "radjdeff": 98.8
 },
 {
   "Rk": 128,
   "Team": "Michigan",
   "Conf": "B10",
   "W-L": "11-18",
   "adjem": 3.15,
   "kadjoeff": 105.4,
   "kadjdeff": 102.3,
   "badjoeff": 105.4,
   "badjdeff": 102.3,
   "radjoeff": 105.4,
   "radjdeff": 102.3
 },
 {
   "Rk": 129,
   "Team": "Tulane",
   "Conf": "CUSA",
   "W-L": "13-15",
   "adjem": 3.07,
   "kadjoeff": 104.8,
   "kadjdeff": 101.7,
   "badjoeff": 104.8,
   "badjdeff": 101.7,
   "radjoeff": 104.8,
   "radjdeff": 101.7
 },
 {
   "Rk": 130,
   "Team": "Western Michigan",
   "Conf": "MAC",
   "W-L": "17-13",
   "adjem": 3,
   "kadjoeff": 107.6,
   "kadjdeff": 104.6,
   "badjoeff": 107.6,
   "badjdeff": 104.6,
   "radjoeff": 107.6,
   "radjdeff": 104.6
 },
 {
   "Rk": 131,
   "Team": "Montana State",
   "Conf": "BSky",
   "W-L": "18-10",
   "adjem": 2.97,
   "kadjoeff": 107.4,
   "kadjdeff": 104.4,
   "badjoeff": 107.4,
   "badjdeff": 104.4,
   "radjoeff": 107.4,
   "radjdeff": 104.4
 },
 {
   "Rk": 132,
   "Team": "Clemson",
   "Conf": "ACC",
   "W-L": "13-17",
   "adjem": 2.94,
   "kadjoeff": 107.3,
   "kadjdeff": 104.4,
   "badjoeff": 107.3,
   "badjdeff": 104.4,
   "radjoeff": 107.3,
   "radjdeff": 104.4
 },
 {
   "Rk": 133,
   "Team": "George Mason",
   "Conf": "CAA",
   "W-L": "19-10",
   "adjem": 2.67,
   "kadjoeff": 104.7,
   "kadjdeff": 102.1,
   "badjoeff": 104.7,
   "badjdeff": 102.1,
   "radjoeff": 104.7,
   "radjdeff": 102.1
 },
 {
   "Rk": 134,
   "Team": "Wright State",
   "Conf": "Horz",
   "W-L": "17-11",
   "adjem": 2.67,
   "kadjoeff": 110.9,
   "kadjdeff": 108.3,
   "badjoeff": 110.9,
   "badjdeff": 108.3,
   "radjoeff": 110.9,
   "radjdeff": 108.3
 },
 {
   "Rk": 135,
   "Team": "Georgia State",
   "Conf": "ASun",
   "W-L": "19-11",
   "adjem": 2.6,
   "kadjoeff": 107.8,
   "kadjdeff": 105.2,
   "badjoeff": 107.8,
   "badjdeff": 105.2,
   "radjoeff": 107.8,
   "radjdeff": 105.2
 },
 {
   "Rk": 136,
   "Team": "Georgia Southern",
   "Conf": "SC",
   "W-L": "14-12",
   "adjem": 2.55,
   "kadjoeff": 107,
   "kadjdeff": 104.5,
   "badjoeff": 107,
   "badjdeff": 104.5,
   "radjoeff": 107,
   "radjdeff": 104.5
 },
 {
   "Rk": 137,
   "Team": "North Carolina",
   "Conf": "ACC",
   "W-L": "8-20",
   "adjem": 2.53,
   "kadjoeff": 105.8,
   "kadjdeff": 103.2,
   "badjoeff": 105.8,
   "badjdeff": 103.2,
   "radjoeff": 105.8,
   "radjdeff": 103.2
 },
 {
   "Rk": 138,
   "Team": "Chattanooga",
   "Conf": "SC",
   "W-L": "14-14",
   "adjem": 2.36,
   "kadjoeff": 103.7,
   "kadjdeff": 101.3,
   "badjoeff": 103.7,
   "badjdeff": 101.3,
   "radjoeff": 103.7,
   "radjdeff": 101.3
 },
 {
   "Rk": 139,
   "Team": "Miami OH",
   "Conf": "MAC",
   "W-L": "13-18",
   "adjem": 2.15,
   "kadjoeff": 105.4,
   "kadjdeff": 103.3,
   "badjoeff": 105.4,
   "badjdeff": 103.3,
   "radjoeff": 105.4,
   "radjdeff": 103.3
 },
 {
   "Rk": 140,
   "Team": "Illinois State",
   "Conf": "MVC",
   "W-L": "17-14",
   "adjem": 2.14,
   "kadjoeff": 103.1,
   "kadjdeff": 100.9,
   "badjoeff": 103.1,
   "badjdeff": 100.9,
   "radjoeff": 103.1,
   "radjdeff": 100.9
 },
 {
   "Rk": 141,
   "Team": "Arkansas State",
   "Conf": "SB",
   "W-L": "13-16",
   "adjem": 2.13,
   "kadjoeff": 105.2,
   "kadjdeff": 103.1,
   "badjoeff": 105.2,
   "badjdeff": 103.1,
   "radjoeff": 105.2,
   "radjdeff": 103.1
 },
 {
   "Rk": 142,
   "Team": "Virginia Tech",
   "Conf": "BE",
   "W-L": "10-18",
   "adjem": 2.1,
   "kadjoeff": 104.3,
   "kadjdeff": 102.2,
   "badjoeff": 104.3,
   "badjdeff": 102.2,
   "radjoeff": 104.3,
   "radjdeff": 102.2
 },
 {
   "Rk": 143,
   "Team": "Oakland",
   "Conf": "MCon",
   "W-L": "16-13",
   "adjem": 1.91,
   "kadjoeff": 107.6,
   "kadjdeff": 105.7,
   "badjoeff": 107.6,
   "badjdeff": 105.7,
   "radjoeff": 107.6,
   "radjdeff": 105.7
 },
 {
   "Rk": 144,
   "Team": "Weber State",
   "Conf": "BSky",
   "W-L": "16-11",
   "adjem": 1.76,
   "kadjoeff": 106.1,
   "kadjdeff": 104.4,
   "badjoeff": 106.1,
   "badjdeff": 104.4,
   "radjoeff": 106.1,
   "radjdeff": 104.4
 },
 {
   "Rk": 145,
   "Team": "Princeton",
   "Conf": "Ivy",
   "W-L": "15-12",
   "adjem": 1.47,
   "kadjoeff": 103.7,
   "kadjdeff": 102.2,
   "badjoeff": 103.7,
   "badjdeff": 102.2,
   "radjoeff": 103.7,
   "radjdeff": 102.2
 },
 {
   "Rk": 146,
   "Team": "Murray State",
   "Conf": "OVC",
   "W-L": "17-13",
   "adjem": 1.35,
   "kadjoeff": 106.8,
   "kadjdeff": 105.5,
   "badjoeff": 106.8,
   "badjdeff": 105.5,
   "radjoeff": 106.8,
   "radjdeff": 105.5
 },
 {
   "Rk": 147,
   "Team": "La Salle",
   "Conf": "A10",
   "W-L": "15-17",
   "adjem": 1.32,
   "kadjoeff": 103.9,
   "kadjdeff": 102.6,
   "badjoeff": 103.9,
   "badjdeff": 102.6,
   "radjoeff": 103.9,
   "radjdeff": 102.6
 },
 {
   "Rk": 148,
   "Team": "Yale",
   "Conf": "Ivy",
   "W-L": "21-10",
   "adjem": 1.09,
   "kadjoeff": 102.9,
   "kadjdeff": 101.8,
   "badjoeff": 102.9,
   "badjdeff": 101.8,
   "radjoeff": 102.9,
   "radjdeff": 101.8
 },
 {
   "Rk": 149,
   "Team": "UCF",
   "Conf": "ASun",
   "W-L": "16-12",
   "adjem": 0.98,
   "kadjoeff": 104.4,
   "kadjdeff": 103.4,
   "badjoeff": 104.4,
   "badjdeff": 103.4,
   "radjoeff": 104.4,
   "radjdeff": 103.4
 },
 {
   "Rk": 150,
   "Team": "Central Connecticut 14",
   "Conf": "NEC",
   "W-L": "27-5",
   "adjem": 0.93,
   "kadjoeff": 100.6,
   "kadjdeff": 99.7,
   "badjoeff": 100.6,
   "badjdeff": 99.7,
   "radjoeff": 100.6,
   "radjdeff": 99.7
 },
 {
   "Rk": 151,
   "Team": "The Citadel",
   "Conf": "SC",
   "W-L": "13-12",
   "adjem": 0.66,
   "kadjoeff": 105.3,
   "kadjdeff": 104.6,
   "badjoeff": 105.3,
   "badjdeff": 104.6,
   "radjoeff": 105.3,
   "radjdeff": 104.6
 },
 {
   "Rk": 152,
   "Team": "Wichita State",
   "Conf": "MVC",
   "W-L": "15-15",
   "adjem": 0.61,
   "kadjoeff": 107.8,
   "kadjdeff": 107.2,
   "badjoeff": 107.8,
   "badjdeff": 107.2,
   "radjoeff": 107.8,
   "radjdeff": 107.2
 },
 {
   "Rk": 153,
   "Team": "Toledo",
   "Conf": "MAC",
   "W-L": "16-14",
   "adjem": 0.4,
   "kadjoeff": 99.1,
   "kadjdeff": 98.7,
   "badjoeff": 99.1,
   "badjdeff": 98.7,
   "radjoeff": 99.1,
   "radjdeff": 98.7
 },
 {
   "Rk": 154,
   "Team": "Rider",
   "Conf": "MAAC",
   "W-L": "17-11",
   "adjem": 0.35,
   "kadjoeff": 100.2,
   "kadjdeff": 99.9,
   "badjoeff": 100.2,
   "badjdeff": 99.9,
   "radjoeff": 100.2,
   "radjdeff": 99.9
 },
 {
   "Rk": 155,
   "Team": "Delaware",
   "Conf": "CAA",
   "W-L": "14-16",
   "adjem": 0.32,
   "kadjoeff": 102.7,
   "kadjdeff": 102.4,
   "badjoeff": 102.7,
   "badjdeff": 102.4,
   "radjoeff": 102.7,
   "radjdeff": 102.4
 },
 {
   "Rk": 156,
   "Team": "San Francisco",
   "Conf": "WCC",
   "W-L": "12-15",
   "adjem": 0.21,
   "kadjoeff": 102.9,
   "kadjdeff": 102.7,
   "badjoeff": 102.9,
   "badjdeff": 102.7,
   "radjoeff": 102.9,
   "radjdeff": 102.7
 },
 {
   "Rk": 157,
   "Team": "Troy State",
   "Conf": "ASun",
   "W-L": "18-10",
   "adjem": 0.15,
   "kadjoeff": 104.2,
   "kadjdeff": 104.1,
   "badjoeff": 104.2,
   "badjdeff": 104.1,
   "radjoeff": 104.2,
   "radjdeff": 104.1
 },
 {
   "Rk": 158,
   "Team": "Eastern Washington",
   "Conf": "BSky",
   "W-L": "15-13",
   "adjem": -0.02,
   "kadjoeff": 100.2,
   "kadjdeff": 100.2,
   "badjoeff": 100.2,
   "badjdeff": 100.2,
   "radjoeff": 100.2,
   "radjdeff": 100.2
 },
 {
   "Rk": 159,
   "Team": "Cal Poly",
   "Conf": "BW",
   "W-L": "14-12",
   "adjem": -0.06,
   "kadjoeff": 102.5,
   "kadjdeff": 102.6,
   "badjoeff": 102.5,
   "badjdeff": 102.6,
   "radjoeff": 102.5,
   "radjdeff": 102.6
 },
 {
   "Rk": 160,
   "Team": "UTSA",
   "Conf": "Slnd",
   "W-L": "19-10",
   "adjem": -0.18,
   "kadjoeff": 103,
   "kadjdeff": 103.2,
   "badjoeff": 103,
   "badjdeff": 103.2,
   "radjoeff": 103,
   "radjdeff": 103.2
 },
 {
   "Rk": 161,
   "Team": "North Texas",
   "Conf": "SB",
   "W-L": "13-14",
   "adjem": -0.21,
   "kadjoeff": 108.1,
   "kadjdeff": 108.3,
   "badjoeff": 108.1,
   "badjdeff": 108.3,
   "radjoeff": 108.1,
   "radjdeff": 108.3
 },
 {
   "Rk": 162,
   "Team": "Holy Cross 16",
   "Conf": "Pat",
   "W-L": "18-15",
   "adjem": -0.24,
   "kadjoeff": 98.1,
   "kadjdeff": 98.4,
   "badjoeff": 98.1,
   "badjdeff": 98.4,
   "radjoeff": 98.1,
   "radjdeff": 98.4
 },
 {
   "Rk": 163,
   "Team": "UMKC",
   "Conf": "MCon",
   "W-L": "17-11",
   "adjem": -0.33,
   "kadjoeff": 101.2,
   "kadjdeff": 101.5,
   "badjoeff": 101.2,
   "badjdeff": 101.5,
   "radjoeff": 101.2,
   "radjdeff": 101.5
 },
 {
   "Rk": 164,
   "Team": "Old Dominion",
   "Conf": "CAA",
   "W-L": "13-16",
   "adjem": -0.43,
   "kadjoeff": 102.5,
   "kadjdeff": 102.9,
   "badjoeff": 102.5,
   "badjdeff": 102.9,
   "radjoeff": 102.5,
   "radjdeff": 102.9
 },
 {
   "Rk": 165,
   "Team": "Southern Miss",
   "Conf": "CUSA",
   "W-L": "9-17",
   "adjem": -0.45,
   "kadjoeff": 97.7,
   "kadjdeff": 98.1,
   "badjoeff": 97.7,
   "badjdeff": 98.1,
   "radjoeff": 97.7,
   "radjdeff": 98.1
 },
 {
   "Rk": 166,
   "Team": "Marshall",
   "Conf": "MAC",
   "W-L": "15-15",
   "adjem": -0.55,
   "kadjoeff": 110,
   "kadjdeff": 110.5,
   "badjoeff": 110,
   "badjdeff": 110.5,
   "radjoeff": 110,
   "radjdeff": 110.5
 },
 {
   "Rk": 167,
   "Team": "Texas Pan American",
   "Conf": "ind",
   "W-L": "16-10",
   "adjem": -0.62,
   "kadjoeff": 101.1,
   "kadjdeff": 101.7,
   "badjoeff": 101.1,
   "badjdeff": 101.7,
   "radjoeff": 101.1,
   "radjdeff": 101.7
 },
 {
   "Rk": 168,
   "Team": "Morehead State",
   "Conf": "OVC",
   "W-L": "15-11",
   "adjem": -0.91,
   "kadjoeff": 105.5,
   "kadjdeff": 106.4,
   "badjoeff": 105.5,
   "badjdeff": 106.4,
   "radjoeff": 105.5,
   "radjdeff": 106.4
 },
 {
   "Rk": 169,
   "Team": "IUPUI",
   "Conf": "MCon",
   "W-L": "13-15",
   "adjem": -0.96,
   "kadjoeff": 102.3,
   "kadjdeff": 103.3,
   "badjoeff": 102.3,
   "badjdeff": 103.3,
   "radjoeff": 102.3,
   "radjdeff": 103.3
 },
 {
   "Rk": 170,
   "Team": "DePaul",
   "Conf": "CUSA",
   "W-L": "9-19",
   "adjem": -0.96,
   "kadjoeff": 100.4,
   "kadjdeff": 101.4,
   "badjoeff": 100.4,
   "badjdeff": 101.4,
   "radjoeff": 100.4,
   "radjdeff": 101.4
 },
 {
   "Rk": 171,
   "Team": "Furman",
   "Conf": "SC",
   "W-L": "13-14",
   "adjem": -1.01,
   "kadjoeff": 100.2,
   "kadjdeff": 101.2,
   "badjoeff": 100.2,
   "badjdeff": 101.2,
   "radjoeff": 100.2,
   "radjdeff": 101.2
 },
 {
   "Rk": 172,
   "Team": "New Orleans",
   "Conf": "SB",
   "W-L": "14-14",
   "adjem": -1.15,
   "kadjoeff": 98.4,
   "kadjdeff": 99.5,
   "badjoeff": 98.4,
   "badjdeff": 99.5,
   "radjoeff": 98.4,
   "radjdeff": 99.5
 },
 {
   "Rk": 173,
   "Team": "James Madison",
   "Conf": "CAA",
   "W-L": "14-15",
   "adjem": -1.21,
   "kadjoeff": 106.4,
   "kadjdeff": 107.6,
   "badjoeff": 106.4,
   "badjdeff": 107.6,
   "radjoeff": 106.4,
   "radjdeff": 107.6
 },
 {
   "Rk": 174,
   "Team": "Siena 16",
   "Conf": "MAAC",
   "W-L": "17-19",
   "adjem": -1.21,
   "kadjoeff": 100.8,
   "kadjdeff": 102,
   "badjoeff": 100.8,
   "badjdeff": 102,
   "radjoeff": 100.8,
   "radjdeff": 102
 },
 {
   "Rk": 175,
   "Team": "Drake",
   "Conf": "MVC",
   "W-L": "14-15",
   "adjem": -1.41,
   "kadjoeff": 107.1,
   "kadjdeff": 108.5,
   "badjoeff": 107.1,
   "badjdeff": 108.5,
   "radjoeff": 107.1,
   "radjdeff": 108.5
 },
 {
   "Rk": 176,
   "Team": "Drexel",
   "Conf": "CAA",
   "W-L": "14-14",
   "adjem": -1.45,
   "kadjoeff": 104.4,
   "kadjdeff": 105.9,
   "badjoeff": 104.4,
   "badjdeff": 105.9,
   "radjoeff": 104.4,
   "radjdeff": 105.9
 },
 {
   "Rk": 177,
   "Team": "Long Beach State",
   "Conf": "BW",
   "W-L": "12-17",
   "adjem": -1.48,
   "kadjoeff": 102.9,
   "kadjdeff": 104.4,
   "badjoeff": 102.9,
   "badjdeff": 104.4,
   "radjoeff": 102.9,
   "radjdeff": 104.4
 },
 {
   "Rk": 178,
   "Team": "Northern Iowa",
   "Conf": "MVC",
   "W-L": "14-15",
   "adjem": -1.49,
   "kadjoeff": 108.2,
   "kadjdeff": 109.7,
   "badjoeff": 108.2,
   "badjdeff": 109.7,
   "radjoeff": 108.2,
   "radjdeff": 109.7
 },
 {
   "Rk": 179,
   "Team": "Samford",
   "Conf": "ASun",
   "W-L": "15-14",
   "adjem": -1.49,
   "kadjoeff": 102.5,
   "kadjdeff": 104,
   "badjoeff": 102.5,
   "badjdeff": 104,
   "radjoeff": 102.5,
   "radjdeff": 104
 },
 {
   "Rk": 180,
   "Team": "Niagara",
   "Conf": "MAAC",
   "W-L": "18-14",
   "adjem": -1.64,
   "kadjoeff": 106.6,
   "kadjdeff": 108.2,
   "badjoeff": 106.6,
   "badjdeff": 108.2,
   "radjoeff": 106.6,
   "radjdeff": 108.2
 },
 {
   "Rk": 181,
   "Team": "Air Force",
   "Conf": "MWC",
   "W-L": "9-19",
   "adjem": -1.64,
   "kadjoeff": 103.8,
   "kadjdeff": 105.5,
   "badjoeff": 103.8,
   "badjdeff": 105.5,
   "radjoeff": 103.8,
   "radjdeff": 105.5
 },
 {
   "Rk": 182,
   "Team": "Cal State Northridge",
   "Conf": "BW",
   "W-L": "11-16",
   "adjem": -1.66,
   "kadjoeff": 98.7,
   "kadjdeff": 100.4,
   "badjoeff": 98.7,
   "badjdeff": 100.4,
   "radjoeff": 98.7,
   "radjdeff": 100.4
 },
 {
   "Rk": 183,
   "Team": "East Carolina",
   "Conf": "CUSA",
   "W-L": "10-18",
   "adjem": -1.78,
   "kadjoeff": 102.3,
   "kadjdeff": 104.1,
   "badjoeff": 102.3,
   "badjdeff": 104.1,
   "radjoeff": 102.3,
   "radjdeff": 104.1
 },
 {
   "Rk": 184,
   "Team": "Buffalo",
   "Conf": "MAC",
   "W-L": "12-18",
   "adjem": -1.84,
   "kadjoeff": 99.6,
   "kadjdeff": 101.4,
   "badjoeff": 99.6,
   "badjdeff": 101.4,
   "radjoeff": 99.6,
   "radjdeff": 101.4
 },
 {
   "Rk": 185,
   "Team": "Jacksonville",
   "Conf": "ASun",
   "W-L": "16-12",
   "adjem": -1.98,
   "kadjoeff": 98.7,
   "kadjdeff": 100.7,
   "badjoeff": 98.7,
   "badjdeff": 100.7,
   "radjoeff": 98.7,
   "radjdeff": 100.7
 },
 {
   "Rk": 186,
   "Team": "Northern Illinois",
   "Conf": "MAC",
   "W-L": "12-16",
   "adjem": -2,
   "kadjoeff": 105.6,
   "kadjdeff": 107.6,
   "badjoeff": 105.6,
   "badjdeff": 107.6,
   "radjoeff": 105.6,
   "radjdeff": 107.6
 },
 {
   "Rk": 187,
   "Team": "Louisiana Monroe",
   "Conf": "Slnd",
   "W-L": "19-12",
   "adjem": -2,
   "kadjoeff": 99.9,
   "kadjdeff": 101.9,
   "badjoeff": 99.9,
   "badjdeff": 101.9,
   "radjoeff": 99.9,
   "radjdeff": 101.9
 },
 {
   "Rk": 188,
   "Team": "Boise State",
   "Conf": "WAC",
   "W-L": "12-17",
   "adjem": -2.21,
   "kadjoeff": 98.2,
   "kadjdeff": 100.4,
   "badjoeff": 98.2,
   "badjdeff": 100.4,
   "radjoeff": 98.2,
   "radjdeff": 100.4
 },
 {
   "Rk": 189,
   "Team": "UTEP",
   "Conf": "WAC",
   "W-L": "9-22",
   "adjem": -2.36,
   "kadjoeff": 101.3,
   "kadjdeff": 103.7,
   "badjoeff": 101.3,
   "badjdeff": 103.7,
   "radjoeff": 101.3,
   "radjdeff": 103.7
 },
 {
   "Rk": 190,
   "Team": "Vermont",
   "Conf": "AE",
   "W-L": "21-8",
   "adjem": -2.41,
   "kadjoeff": 105.8,
   "kadjdeff": 108.2,
   "badjoeff": 105.8,
   "badjdeff": 108.2,
   "radjoeff": 105.8,
   "radjdeff": 108.2
 },
 {
   "Rk": 191,
   "Team": "Florida Atlantic",
   "Conf": "ASun",
   "W-L": "18-12",
   "adjem": -2.5,
   "kadjoeff": 99.6,
   "kadjdeff": 102.1,
   "badjoeff": 99.6,
   "badjdeff": 102.1,
   "radjoeff": 99.6,
   "radjdeff": 102.1
 },
 {
   "Rk": 192,
   "Team": "West Virginia",
   "Conf": "BE",
   "W-L": "7-20",
   "adjem": -2.62,
   "kadjoeff": 103.4,
   "kadjdeff": 106.1,
   "badjoeff": 103.4,
   "badjdeff": 106.1,
   "radjoeff": 103.4,
   "radjdeff": 106.1
 },
 {
   "Rk": 193,
   "Team": "Cleveland State",
   "Conf": "Horz",
   "W-L": "12-16",
   "adjem": -2.66,
   "kadjoeff": 97.6,
   "kadjdeff": 100.3,
   "badjoeff": 97.6,
   "badjdeff": 100.3,
   "radjoeff": 97.6,
   "radjdeff": 100.3
 },
 {
   "Rk": 194,
   "Team": "Boston University",
   "Conf": "AE",
   "W-L": "22-10",
   "adjem": -2.74,
   "kadjoeff": 101.3,
   "kadjdeff": 104,
   "badjoeff": 101.3,
   "badjdeff": 104,
   "radjoeff": 101.3,
   "radjdeff": 104
 },
 {
   "Rk": 195,
   "Team": "Gardner Webb",
   "Conf": "ind",
   "W-L": "13-8",
   "adjem": -2.84,
   "kadjoeff": 101.4,
   "kadjdeff": 104.3,
   "badjoeff": 101.4,
   "badjdeff": 104.3,
   "radjoeff": 101.4,
   "radjdeff": 104.3
 },
 {
   "Rk": 196,
   "Team": "Radford",
   "Conf": "BSth",
   "W-L": "14-16",
   "adjem": -2.88,
   "kadjoeff": 98,
   "kadjdeff": 100.9,
   "badjoeff": 98,
   "badjdeff": 100.9,
   "radjoeff": 98,
   "radjdeff": 100.9
 },
 {
   "Rk": 197,
   "Team": "Austin Peay",
   "Conf": "OVC",
   "W-L": "11-18",
   "adjem": -2.98,
   "kadjoeff": 99.4,
   "kadjdeff": 102.4,
   "badjoeff": 99.4,
   "badjdeff": 102.4,
   "radjoeff": 99.4,
   "radjdeff": 102.4
 },
 {
   "Rk": 198,
   "Team": "Penn State",
   "Conf": "B10",
   "W-L": "7-21",
   "adjem": -3.16,
   "kadjoeff": 99.3,
   "kadjdeff": 102.4,
   "badjoeff": 99.3,
   "badjdeff": 102.4,
   "radjoeff": 99.3,
   "radjdeff": 102.4
 },
 {
   "Rk": 199,
   "Team": "Wagner",
   "Conf": "NEC",
   "W-L": "19-10",
   "adjem": -3.17,
   "kadjoeff": 103.1,
   "kadjdeff": 106.2,
   "badjoeff": 103.1,
   "badjdeff": 106.2,
   "radjoeff": 103.1,
   "radjdeff": 106.2
 },
 {
   "Rk": 200,
   "Team": "George Washington",
   "Conf": "A10",
   "W-L": "12-16",
   "adjem": -3.19,
   "kadjoeff": 102.7,
   "kadjdeff": 105.9,
   "badjoeff": 102.7,
   "badjdeff": 105.9,
   "radjoeff": 102.7,
   "radjdeff": 105.9
 },
 {
   "Rk": 201,
   "Team": "Sam Houston State",
   "Conf": "Slnd",
   "W-L": "14-14",
   "adjem": -3.21,
   "kadjoeff": 100.2,
   "kadjdeff": 103.4,
   "badjoeff": 100.2,
   "badjdeff": 103.4,
   "radjoeff": 100.2,
   "radjdeff": 103.4
 },
 {
   "Rk": 202,
   "Team": "Middle Tennessee",
   "Conf": "SB",
   "W-L": "13-15",
   "adjem": -3.38,
   "kadjoeff": 96.8,
   "kadjdeff": 100.2,
   "badjoeff": 96.8,
   "badjdeff": 100.2,
   "radjoeff": 96.8,
   "radjdeff": 100.2
 },
 {
   "Rk": 203,
   "Team": "Rice",
   "Conf": "WAC",
   "W-L": "10-19",
   "adjem": -3.43,
   "kadjoeff": 98,
   "kadjdeff": 101.4,
   "badjoeff": 98,
   "badjdeff": 101.4,
   "radjoeff": 98,
   "radjdeff": 101.4
 },
 {
   "Rk": 204,
   "Team": "Central Michigan",
   "Conf": "MAC",
   "W-L": "8-19",
   "adjem": -3.52,
   "kadjoeff": 101.6,
   "kadjdeff": 105.1,
   "badjoeff": 101.6,
   "badjdeff": 105.1,
   "radjoeff": 101.6,
   "radjdeff": 105.1
 },
 {
   "Rk": 205,
   "Team": "Brown",
   "Conf": "Ivy",
   "W-L": "16-10",
   "adjem": -3.69,
   "kadjoeff": 105.9,
   "kadjdeff": 109.6,
   "badjoeff": 105.9,
   "badjdeff": 109.6,
   "radjoeff": 105.9,
   "radjdeff": 109.6
 },
 {
   "Rk": 206,
   "Team": "American",
   "Conf": "Pat",
   "W-L": "18-12",
   "adjem": -4.01,
   "kadjoeff": 101,
   "kadjdeff": 105.1,
   "badjoeff": 101,
   "badjdeff": 105.1,
   "radjoeff": 101,
   "radjdeff": 105.1
 },
 {
   "Rk": 207,
   "Team": "Green Bay",
   "Conf": "Horz",
   "W-L": "9-21",
   "adjem": -4.25,
   "kadjoeff": 105.3,
   "kadjdeff": 109.6,
   "badjoeff": 105.3,
   "badjdeff": 109.6,
   "radjoeff": 105.3,
   "radjdeff": 109.6
 },
 {
   "Rk": 208,
   "Team": "Fairfield",
   "Conf": "MAAC",
   "W-L": "12-17",
   "adjem": -4.3,
   "kadjoeff": 99.1,
   "kadjdeff": 103.4,
   "badjoeff": 99.1,
   "badjdeff": 103.4,
   "radjoeff": 99.1,
   "radjdeff": 103.4
 },
 {
   "Rk": 209,
   "Team": "Centenary",
   "Conf": "ind",
   "W-L": "10-13",
   "adjem": -4.4,
   "kadjoeff": 101.4,
   "kadjdeff": 105.8,
   "badjoeff": 101.4,
   "badjdeff": 105.8,
   "radjoeff": 101.4,
   "radjdeff": 105.8
 },
 {
   "Rk": 210,
   "Team": "Montana",
   "Conf": "BSky",
   "W-L": "14-15",
   "adjem": -4.51,
   "kadjoeff": 102.4,
   "kadjdeff": 106.9,
   "badjoeff": 102.4,
   "badjdeff": 106.9,
   "radjoeff": 102.4,
   "radjdeff": 106.9
 },
 {
   "Rk": 211,
   "Team": "Santa Clara",
   "Conf": "WCC",
   "W-L": "12-15",
   "adjem": -4.55,
   "kadjoeff": 101.1,
   "kadjdeff": 105.6,
   "badjoeff": 101.1,
   "badjdeff": 105.6,
   "radjoeff": 101.1,
   "radjdeff": 105.6
 },
 {
   "Rk": 212,
   "Team": "Bradley",
   "Conf": "MVC",
   "W-L": "9-20",
   "adjem": -4.59,
   "kadjoeff": 95.3,
   "kadjdeff": 99.9,
   "badjoeff": 95.3,
   "badjdeff": 99.9,
   "radjoeff": 95.3,
   "radjdeff": 99.9
 },
 {
   "Rk": 213,
   "Team": "Texas A&M",
   "Conf": "B12",
   "W-L": "8-22",
   "adjem": -4.73,
   "kadjoeff": 97.4,
   "kadjdeff": 102.2,
   "badjoeff": 97.4,
   "badjdeff": 102.2,
   "radjoeff": 97.4,
   "radjdeff": 102.2
 },
 {
   "Rk": 214,
   "Team": "Fordham",
   "Conf": "A10",
   "W-L": "8-20",
   "adjem": -4.78,
   "kadjoeff": 99.3,
   "kadjdeff": 104.1,
   "badjoeff": 99.3,
   "badjdeff": 104.1,
   "radjoeff": 99.3,
   "radjdeff": 104.1
 },
 {
   "Rk": 215,
   "Team": "Southern Utah",
   "Conf": "MCon",
   "W-L": "9-16",
   "adjem": -4.82,
   "kadjoeff": 100.4,
   "kadjdeff": 105.2,
   "badjoeff": 100.4,
   "badjdeff": 105.2,
   "radjoeff": 100.4,
   "radjdeff": 105.2
 },
 {
   "Rk": 216,
   "Team": "Washington State",
   "Conf": "P10",
   "W-L": "6-21",
   "adjem": -4.94,
   "kadjoeff": 104.3,
   "kadjdeff": 109.3,
   "badjoeff": 104.3,
   "badjdeff": 109.3,
   "radjoeff": 104.3,
   "radjdeff": 109.3
 },
 {
   "Rk": 217,
   "Team": "Belmont",
   "Conf": "ASun",
   "W-L": "11-17",
   "adjem": -5,
   "kadjoeff": 108.8,
   "kadjdeff": 113.8,
   "badjoeff": 108.8,
   "badjdeff": 113.8,
   "radjoeff": 108.8,
   "radjdeff": 113.8
 },
 {
   "Rk": 218,
   "Team": "Iona",
   "Conf": "MAAC",
   "W-L": "13-17",
   "adjem": -5.07,
   "kadjoeff": 98.5,
   "kadjdeff": 103.6,
   "badjoeff": 98.5,
   "badjdeff": 103.6,
   "radjoeff": 98.5,
   "radjdeff": 103.6
 },
 {
   "Rk": 219,
   "Team": "Winthrop",
   "Conf": "BSth",
   "W-L": "17-12",
   "adjem": -5.31,
   "kadjoeff": 97.3,
   "kadjdeff": 102.6,
   "badjoeff": 97.3,
   "badjdeff": 102.6,
   "radjoeff": 97.3,
   "radjdeff": 102.6
 },
 {
   "Rk": 220,
   "Team": "Northern Arizona",
   "Conf": "BSky",
   "W-L": "12-14",
   "adjem": -5.36,
   "kadjoeff": 96.3,
   "kadjdeff": 101.7,
   "badjoeff": 96.3,
   "badjdeff": 101.7,
   "radjoeff": 96.3,
   "radjdeff": 101.7
 },
 {
   "Rk": 221,
   "Team": "Hofstra",
   "Conf": "CAA",
   "W-L": "12-20",
   "adjem": -5.44,
   "kadjoeff": 94.8,
   "kadjdeff": 100.3,
   "badjoeff": 94.8,
   "badjdeff": 100.3,
   "radjoeff": 94.8,
   "radjdeff": 100.3
 },
 {
   "Rk": 222,
   "Team": "William & Mary",
   "Conf": "CAA",
   "W-L": "9-19",
   "adjem": -5.62,
   "kadjoeff": 96.6,
   "kadjdeff": 102.2,
   "badjoeff": 96.6,
   "badjdeff": 102.2,
   "radjoeff": 96.6,
   "radjdeff": 102.2
 },
 {
   "Rk": 223,
   "Team": "Colgate",
   "Conf": "Pat",
   "W-L": "15-11",
   "adjem": -5.62,
   "kadjoeff": 101.8,
   "kadjdeff": 107.4,
   "badjoeff": 101.8,
   "badjdeff": 107.4,
   "radjoeff": 101.8,
   "radjdeff": 107.4
 },
 {
   "Rk": 224,
   "Team": "Howard",
   "Conf": "MEAC",
   "W-L": "18-13",
   "adjem": -5.68,
   "kadjoeff": 101.8,
   "kadjdeff": 107.5,
   "badjoeff": 101.8,
   "badjdeff": 107.5,
   "radjoeff": 101.8,
   "radjdeff": 107.5
 },
 {
   "Rk": 225,
   "Team": "Duquesne",
   "Conf": "A10",
   "W-L": "9-19",
   "adjem": -5.85,
   "kadjoeff": 99.3,
   "kadjdeff": 105.1,
   "badjoeff": 99.3,
   "badjdeff": 105.1,
   "radjoeff": 99.3,
   "radjdeff": 105.1
 },
 {
   "Rk": 226,
   "Team": "Saint Mary's",
   "Conf": "WCC",
   "W-L": "8-20",
   "adjem": -5.85,
   "kadjoeff": 91.3,
   "kadjdeff": 97.1,
   "badjoeff": 91.3,
   "badjdeff": 97.1,
   "radjoeff": 91.3,
   "radjdeff": 97.1
 },
 {
   "Rk": 227,
   "Team": "Akron",
   "Conf": "MAC",
   "W-L": "9-21",
   "adjem": -5.94,
   "kadjoeff": 105.2,
   "kadjdeff": 111.2,
   "badjoeff": 105.2,
   "badjdeff": 111.2,
   "radjoeff": 105.2,
   "radjdeff": 111.2
 },
 {
   "Rk": 228,
   "Team": "Indiana State",
   "Conf": "MVC",
   "W-L": "6-22",
   "adjem": -6.13,
   "kadjoeff": 98.4,
   "kadjdeff": 104.5,
   "badjoeff": 98.4,
   "badjdeff": 104.5,
   "radjoeff": 98.4,
   "radjdeff": 104.5
 },
 {
   "Rk": 229,
   "Team": "Appalachian State",
   "Conf": "SC",
   "W-L": "8-18",
   "adjem": -6.25,
   "kadjoeff": 102.1,
   "kadjdeff": 108.3,
   "badjoeff": 102.1,
   "badjdeff": 108.3,
   "radjoeff": 102.1,
   "radjdeff": 108.3
 },
 {
   "Rk": 230,
   "Team": "Southwest Texas State",
   "Conf": "Slnd",
   "W-L": "11-16",
   "adjem": -6.26,
   "kadjoeff": 100.2,
   "kadjdeff": 106.5,
   "badjoeff": 100.2,
   "badjdeff": 106.5,
   "radjoeff": 100.2,
   "radjdeff": 106.5
 },
 {
   "Rk": 231,
   "Team": "Monmouth",
   "Conf": "NEC",
   "W-L": "18-12",
   "adjem": -6.33,
   "kadjoeff": 96.6,
   "kadjdeff": 103,
   "badjoeff": 96.6,
   "badjdeff": 103,
   "radjoeff": 96.6,
   "radjdeff": 103
 },
 {
   "Rk": 232,
   "Team": "Western Carolina",
   "Conf": "SC",
   "W-L": "8-16",
   "adjem": -6.37,
   "kadjoeff": 100,
   "kadjdeff": 106.4,
   "badjoeff": 100,
   "badjdeff": 106.4,
   "radjoeff": 100,
   "radjdeff": 106.4
 },
 {
   "Rk": 233,
   "Team": "Eastern Illinois",
   "Conf": "OVC",
   "W-L": "12-16",
   "adjem": -6.39,
   "kadjoeff": 102.2,
   "kadjdeff": 108.6,
   "badjoeff": 102.2,
   "badjdeff": 108.6,
   "radjoeff": 102.2,
   "radjdeff": 108.6
 },
 {
   "Rk": 234,
   "Team": "FIU",
   "Conf": "SB",
   "W-L": "9-20",
   "adjem": -6.56,
   "kadjoeff": 96.4,
   "kadjdeff": 103,
   "badjoeff": 96.4,
   "badjdeff": 103,
   "radjoeff": 96.4,
   "radjdeff": 103
 },
 {
   "Rk": 235,
   "Team": "Harvard",
   "Conf": "Ivy",
   "W-L": "14-12",
   "adjem": -6.73,
   "kadjoeff": 94.4,
   "kadjdeff": 101.1,
   "badjoeff": 94.4,
   "badjdeff": 101.1,
   "radjoeff": 94.4,
   "radjdeff": 101.1
 },
 {
   "Rk": 236,
   "Team": "Tennessee State",
   "Conf": "OVC",
   "W-L": "9-17",
   "adjem": -6.77,
   "kadjoeff": 103.2,
   "kadjdeff": 110,
   "badjoeff": 103.2,
   "badjdeff": 110,
   "radjoeff": 103.2,
   "radjdeff": 110
 },
 {
   "Rk": 237,
   "Team": "Rhode Island",
   "Conf": "A10",
   "W-L": "8-20",
   "adjem": -6.8,
   "kadjoeff": 97.6,
   "kadjdeff": 104.4,
   "badjoeff": 97.6,
   "badjdeff": 104.4,
   "radjoeff": 97.6,
   "radjdeff": 104.4
 },
 {
   "Rk": 238,
   "Team": "Lafayette",
   "Conf": "Pat",
   "W-L": "14-14",
   "adjem": -6.83,
   "kadjoeff": 102.7,
   "kadjdeff": 109.6,
   "badjoeff": 102.7,
   "badjdeff": 109.6,
   "radjoeff": 102.7,
   "radjdeff": 109.6
 },
 {
   "Rk": 239,
   "Team": "Columbia",
   "Conf": "Ivy",
   "W-L": "10-16",
   "adjem": -6.93,
   "kadjoeff": 91.2,
   "kadjdeff": 98.1,
   "badjoeff": 91.2,
   "badjdeff": 98.1,
   "radjoeff": 91.2,
   "radjdeff": 98.1
 },
 {
   "Rk": 240,
   "Team": "Northwestern State",
   "Conf": "Slnd",
   "W-L": "12-18",
   "adjem": -7.13,
   "kadjoeff": 100.5,
   "kadjdeff": 107.6,
   "badjoeff": 100.5,
   "badjdeff": 107.6,
   "radjoeff": 100.5,
   "radjdeff": 107.6
 },
 {
   "Rk": 241,
   "Team": "VMI",
   "Conf": "SC",
   "W-L": "7-18",
   "adjem": -7.23,
   "kadjoeff": 99.3,
   "kadjdeff": 106.5,
   "badjoeff": 99.3,
   "badjdeff": 106.5,
   "radjoeff": 99.3,
   "radjdeff": 106.5
 },
 {
   "Rk": 242,
   "Team": "Delaware State",
   "Conf": "MEAC",
   "W-L": "15-13",
   "adjem": -7.34,
   "kadjoeff": 99.6,
   "kadjdeff": 106.9,
   "badjoeff": 99.6,
   "badjdeff": 106.9,
   "radjoeff": 99.6,
   "radjdeff": 106.9
 },
 {
   "Rk": 243,
   "Team": "UMBC",
   "Conf": "NEC",
   "W-L": "20-9",
   "adjem": -7.37,
   "kadjoeff": 96.1,
   "kadjdeff": 103.4,
   "badjoeff": 96.1,
   "badjdeff": 103.4,
   "radjoeff": 96.1,
   "radjdeff": 103.4
 },
 {
   "Rk": 244,
   "Team": "Wofford",
   "Conf": "SC",
   "W-L": "7-18",
   "adjem": -7.7,
   "kadjoeff": 94.1,
   "kadjdeff": 101.8,
   "badjoeff": 94.1,
   "badjdeff": 101.8,
   "radjoeff": 94.1,
   "radjdeff": 101.8
 },
 {
   "Rk": 245,
   "Team": "Jacksonville State",
   "Conf": "ASun",
   "W-L": "13-16",
   "adjem": -7.92,
   "kadjoeff": 101.5,
   "kadjdeff": 109.4,
   "badjoeff": 101.5,
   "badjdeff": 109.4,
   "radjoeff": 101.5,
   "radjdeff": 109.4
 },
 {
   "Rk": 246,
   "Team": "Tennessee Martin",
   "Conf": "OVC",
   "W-L": "11-14",
   "adjem": -7.93,
   "kadjoeff": 99.4,
   "kadjdeff": 107.3,
   "badjoeff": 99.4,
   "badjdeff": 107.3,
   "radjoeff": 99.4,
   "radjdeff": 107.3
 },
 {
   "Rk": 247,
   "Team": "Lamar",
   "Conf": "Slnd",
   "W-L": "15-14",
   "adjem": -8.02,
   "kadjoeff": 98.4,
   "kadjdeff": 106.4,
   "badjoeff": 98.4,
   "badjdeff": 106.4,
   "radjoeff": 98.4,
   "radjdeff": 106.4
 },
 {
   "Rk": 248,
   "Team": "Texas A&M Corpus Chris",
   "Conf": "ind",
   "W-L": "10-15",
   "adjem": -8.08,
   "kadjoeff": 101.3,
   "kadjdeff": 109.3,
   "badjoeff": 101.3,
   "badjdeff": 109.3,
   "radjoeff": 101.3,
   "radjdeff": 109.3
 },
 {
   "Rk": 249,
   "Team": "Portland State",
   "Conf": "BSky",
   "W-L": "11-16",
   "adjem": -8.1,
   "kadjoeff": 104.6,
   "kadjdeff": 112.7,
   "badjoeff": 104.6,
   "badjdeff": 112.7,
   "radjoeff": 104.6,
   "radjdeff": 112.7
 },
 {
   "Rk": 250,
   "Team": "UT Arlington",
   "Conf": "Slnd",
   "W-L": "11-15",
   "adjem": -8.37,
   "kadjoeff": 102.2,
   "kadjdeff": 110.6,
   "badjoeff": 102.2,
   "badjdeff": 110.6,
   "radjoeff": 102.2,
   "radjdeff": 110.6
 },
 {
   "Rk": 251,
   "Team": "San Jose State",
   "Conf": "WAC",
   "W-L": "9-20",
   "adjem": -8.43,
   "kadjoeff": 98.7,
   "kadjdeff": 107.1,
   "badjoeff": 98.7,
   "badjdeff": 107.1,
   "radjoeff": 98.7,
   "radjdeff": 107.1
 },
 {
   "Rk": 252,
   "Team": "Alcorn State",
   "Conf": "SWAC",
   "W-L": "20-10",
   "adjem": -8.71,
   "kadjoeff": 100.1,
   "kadjdeff": 108.8,
   "badjoeff": 100.1,
   "badjdeff": 108.8,
   "radjoeff": 100.1,
   "radjdeff": 108.8
 },
 {
   "Rk": 253,
   "Team": "UC Riverside",
   "Conf": "BW",
   "W-L": "7-18",
   "adjem": -8.86,
   "kadjoeff": 99,
   "kadjdeff": 107.9,
   "badjoeff": 99,
   "badjdeff": 107.9,
   "radjoeff": 99,
   "radjdeff": 107.9
 },
 {
   "Rk": 254,
   "Team": "State Francis NY",
   "Conf": "NEC",
   "W-L": "18-11",
   "adjem": -8.96,
   "kadjoeff": 100.4,
   "kadjdeff": 109.4,
   "badjoeff": 100.4,
   "badjdeff": 109.4,
   "radjoeff": 100.4,
   "radjdeff": 109.4
 },
 {
   "Rk": 255,
   "Team": "South Alabama",
   "Conf": "SB",
   "W-L": "5-21",
   "adjem": -9,
   "kadjoeff": 96,
   "kadjdeff": 105,
   "badjoeff": 96,
   "badjdeff": 105,
   "radjoeff": 96,
   "radjdeff": 105
 },
 {
   "Rk": 256,
   "Team": "Denver",
   "Conf": "SB",
   "W-L": "7-20",
   "adjem": -9.06,
   "kadjoeff": 99,
   "kadjdeff": 108.1,
   "badjoeff": 99,
   "badjdeff": 108.1,
   "radjoeff": 99,
   "radjdeff": 108.1
 },
 {
   "Rk": 257,
   "Team": "Canisius",
   "Conf": "MAAC",
   "W-L": "10-20",
   "adjem": -9.09,
   "kadjoeff": 96.5,
   "kadjdeff": 105.6,
   "badjoeff": 96.5,
   "badjdeff": 105.6,
   "radjoeff": 96.5,
   "radjdeff": 105.6
 },
 {
   "Rk": 258,
   "Team": "Portland",
   "Conf": "WCC",
   "W-L": "6-24",
   "adjem": -9.16,
   "kadjoeff": 97.3,
   "kadjdeff": 106.4,
   "badjoeff": 97.3,
   "badjdeff": 106.4,
   "radjoeff": 97.3,
   "radjdeff": 106.4
 },
 {
   "Rk": 259,
   "Team": "Quinnipiac",
   "Conf": "NEC",
   "W-L": "14-16",
   "adjem": -9.27,
   "kadjoeff": 100.8,
   "kadjdeff": 110.1,
   "badjoeff": 100.8,
   "badjdeff": 110.1,
   "radjoeff": 100.8,
   "radjdeff": 110.1
 },
 {
   "Rk": 260,
   "Team": "Western Illinois",
   "Conf": "MCon",
   "W-L": "10-16",
   "adjem": -9.31,
   "kadjoeff": 102.5,
   "kadjdeff": 111.8,
   "badjoeff": 102.5,
   "badjdeff": 111.8,
   "radjoeff": 102.5,
   "radjdeff": 111.8
 },
 {
   "Rk": 261,
   "Team": "Stephen F. Austin",
   "Conf": "Slnd",
   "W-L": "12-15",
   "adjem": -9.4,
   "kadjoeff": 93.9,
   "kadjdeff": 103.3,
   "badjoeff": 93.9,
   "badjdeff": 103.3,
   "radjoeff": 93.9,
   "radjdeff": 103.3
 },
 {
   "Rk": 262,
   "Team": "Alabama A&M",
   "Conf": "SWAC",
   "W-L": "17-10",
   "adjem": -9.53,
   "kadjoeff": 92.2,
   "kadjdeff": 101.7,
   "badjoeff": 92.2,
   "badjdeff": 101.7,
   "radjoeff": 92.2,
   "radjdeff": 101.7
 },
 {
   "Rk": 263,
   "Team": "UNC Asheville",
   "Conf": "BSth",
   "W-L": "12-14",
   "adjem": -9.7,
   "kadjoeff": 98.9,
   "kadjdeff": 108.6,
   "badjoeff": 98.9,
   "badjdeff": 108.6,
   "radjoeff": 98.9,
   "radjdeff": 108.6
 },
 {
   "Rk": 264,
   "Team": "Loyola Marymount",
   "Conf": "WCC",
   "W-L": "8-20",
   "adjem": -9.86,
   "kadjoeff": 99.1,
   "kadjdeff": 109,
   "badjoeff": 99.1,
   "badjdeff": 109,
   "radjoeff": 99.1,
   "radjdeff": 109
 },
 {
   "Rk": 265,
   "Team": "Evansville",
   "Conf": "MVC",
   "W-L": "7-21",
   "adjem": -9.89,
   "kadjoeff": 98,
   "kadjdeff": 107.9,
   "badjoeff": 98,
   "badjdeff": 107.9,
   "radjoeff": 98,
   "radjdeff": 107.9
 },
 {
   "Rk": 266,
   "Team": "South Carolina State",
   "Conf": "MEAC",
   "W-L": "14-15",
   "adjem": -10.49,
   "kadjoeff": 96.2,
   "kadjdeff": 106.7,
   "badjoeff": 96.2,
   "badjdeff": 106.7,
   "radjoeff": 96.2,
   "radjdeff": 106.7
 },
 {
   "Rk": 267,
   "Team": "Idaho State",
   "Conf": "BSky",
   "W-L": "8-17",
   "adjem": -10.74,
   "kadjoeff": 96.6,
   "kadjdeff": 107.3,
   "badjoeff": 96.6,
   "badjdeff": 107.3,
   "radjoeff": 96.6,
   "radjdeff": 107.3
 },
 {
   "Rk": 268,
   "Team": "Stetson",
   "Conf": "ASun",
   "W-L": "9-16",
   "adjem": -11.01,
   "kadjoeff": 98.1,
   "kadjdeff": 109.1,
   "badjoeff": 98.1,
   "badjdeff": 109.1,
   "radjoeff": 98.1,
   "radjdeff": 109.1
 },
 {
   "Rk": 269,
   "Team": "Bucknell",
   "Conf": "Pat",
   "W-L": "13-16",
   "adjem": -11.27,
   "kadjoeff": 94.5,
   "kadjdeff": 105.8,
   "badjoeff": 94.5,
   "badjdeff": 105.8,
   "radjoeff": 94.5,
   "radjdeff": 105.8
 },
 {
   "Rk": 270,
   "Team": "Navy",
   "Conf": "Pat",
   "W-L": "9-20",
   "adjem": -11.52,
   "kadjoeff": 94.1,
   "kadjdeff": 105.6,
   "badjoeff": 94.1,
   "badjdeff": 105.6,
   "radjoeff": 94.1,
   "radjdeff": 105.6
 },
 {
   "Rk": 271,
   "Team": "North Carolina A&T",
   "Conf": "MEAC",
   "W-L": "10-17",
   "adjem": -11.86,
   "kadjoeff": 92.8,
   "kadjdeff": 104.7,
   "badjoeff": 92.8,
   "badjdeff": 104.7,
   "radjoeff": 92.8,
   "radjdeff": 104.7
 },
 {
   "Rk": 272,
   "Team": "Alabama State",
   "Conf": "SWAC",
   "W-L": "18-12",
   "adjem": -12.62,
   "kadjoeff": 90.1,
   "kadjdeff": 102.7,
   "badjoeff": 90.1,
   "badjdeff": 102.7,
   "radjoeff": 90.1,
   "radjdeff": 102.7
 },
 {
   "Rk": 273,
   "Team": "Southeast Missouri State",
   "Conf": "OVC",
   "W-L": "4-22",
   "adjem": -12.66,
   "kadjoeff": 101.4,
   "kadjdeff": 114,
   "badjoeff": 101.4,
   "badjdeff": 114,
   "radjoeff": 101.4,
   "radjdeff": 114
 },
 {
   "Rk": 274,
   "Team": "Hartford",
   "Conf": "AE",
   "W-L": "14-18",
   "adjem": -12.84,
   "kadjoeff": 91.9,
   "kadjdeff": 104.7,
   "badjoeff": 91.9,
   "badjdeff": 104.7,
   "radjoeff": 91.9,
   "radjdeff": 104.7
 },
 {
   "Rk": 275,
   "Team": "Towson",
   "Conf": "CAA",
   "W-L": "11-18",
   "adjem": -12.9,
   "kadjoeff": 90.4,
   "kadjdeff": 103.3,
   "badjoeff": 90.4,
   "badjdeff": 103.3,
   "radjoeff": 90.4,
   "radjdeff": 103.3
 },
 {
   "Rk": 276,
   "Team": "Sacramento State",
   "Conf": "BSky",
   "W-L": "7-19",
   "adjem": -13.03,
   "kadjoeff": 96.6,
   "kadjdeff": 109.6,
   "badjoeff": 96.6,
   "badjdeff": 109.6,
   "radjoeff": 96.6,
   "radjdeff": 109.6
 },
 {
   "Rk": 277,
   "Team": "Idaho",
   "Conf": "BW",
   "W-L": "8-19",
   "adjem": -13.4,
   "kadjoeff": 92.3,
   "kadjdeff": 105.7,
   "badjoeff": 92.3,
   "badjdeff": 105.7,
   "radjoeff": 92.3,
   "radjdeff": 105.7
 },
 {
   "Rk": 278,
   "Team": "Charleston Southern",
   "Conf": "BSth",
   "W-L": "10-17",
   "adjem": -13.46,
   "kadjoeff": 90.7,
   "kadjdeff": 104.2,
   "badjoeff": 90.7,
   "badjdeff": 104.2,
   "radjoeff": 90.7,
   "radjdeff": 104.2
 },
 {
   "Rk": 279,
   "Team": "Northeastern",
   "Conf": "AE",
   "W-L": "7-21",
   "adjem": -13.5,
   "kadjoeff": 98.1,
   "kadjdeff": 111.6,
   "badjoeff": 98.1,
   "badjdeff": 111.6,
   "radjoeff": 98.1,
   "radjdeff": 111.6
 },
 {
   "Rk": 280,
   "Team": "Florida A&M",
   "Conf": "MEAC",
   "W-L": "9-19",
   "adjem": -13.5,
   "kadjoeff": 93.8,
   "kadjdeff": 107.3,
   "badjoeff": 93.8,
   "badjdeff": 107.3,
   "radjoeff": 93.8,
   "radjdeff": 107.3
 },
 {
   "Rk": 281,
   "Team": "Elon",
   "Conf": "BSth",
   "W-L": "11-16",
   "adjem": -13.55,
   "kadjoeff": 91.1,
   "kadjdeff": 104.7,
   "badjoeff": 91.1,
   "badjdeff": 104.7,
   "radjoeff": 91.1,
   "radjdeff": 104.7
 },
 {
   "Rk": 282,
   "Team": "Mississippi Valley State",
   "Conf": "SWAC",
   "W-L": "11-16",
   "adjem": -13.67,
   "kadjoeff": 101.1,
   "kadjdeff": 114.8,
   "badjoeff": 101.1,
   "badjdeff": 114.8,
   "radjoeff": 101.1,
   "radjdeff": 114.8
 },
 {
   "Rk": 283,
   "Team": "Maine",
   "Conf": "AE",
   "W-L": "12-18",
   "adjem": -13.91,
   "kadjoeff": 94.2,
   "kadjdeff": 108.1,
   "badjoeff": 94.2,
   "badjdeff": 108.1,
   "radjoeff": 94.2,
   "radjdeff": 108.1
 },
 {
   "Rk": 284,
   "Team": "Cal State Fullerton",
   "Conf": "BW",
   "W-L": "4-22",
   "adjem": -14.32,
   "kadjoeff": 94.8,
   "kadjdeff": 109.1,
   "badjoeff": 94.8,
   "badjdeff": 109.1,
   "radjoeff": 94.8,
   "radjdeff": 109.1
 },
 {
   "Rk": 285,
   "Team": "Bethune Cookman",
   "Conf": "MEAC",
   "W-L": "12-17",
   "adjem": -14.58,
   "kadjoeff": 94.8,
   "kadjdeff": 109.4,
   "badjoeff": 94.8,
   "badjdeff": 109.4,
   "radjoeff": 94.8,
   "radjdeff": 109.4
 },
 {
   "Rk": 286,
   "Team": "Youngstown State",
   "Conf": "Horz",
   "W-L": "4-23",
   "adjem": -14.67,
   "kadjoeff": 95.7,
   "kadjdeff": 110.3,
   "badjoeff": 95.7,
   "badjdeff": 110.3,
   "radjoeff": 95.7,
   "radjdeff": 110.3
 },
 {
   "Rk": 287,
   "Team": "New Hampshire",
   "Conf": "AE",
   "W-L": "10-17",
   "adjem": -14.87,
   "kadjoeff": 96.9,
   "kadjdeff": 111.8,
   "badjoeff": 96.9,
   "badjdeff": 111.8,
   "radjoeff": 96.9,
   "radjdeff": 111.8
 },
 {
   "Rk": 288,
   "Team": "Norfolk State",
   "Conf": "MEAC",
   "W-L": "10-19",
   "adjem": -15.02,
   "kadjoeff": 93.7,
   "kadjdeff": 108.7,
   "badjoeff": 93.7,
   "badjdeff": 108.7,
   "radjoeff": 93.7,
   "radjdeff": 108.7
 },
 {
   "Rk": 289,
   "Team": "Army",
   "Conf": "Pat",
   "W-L": "10-16",
   "adjem": -15.11,
   "kadjoeff": 95.4,
   "kadjdeff": 110.5,
   "badjoeff": 95.4,
   "badjdeff": 110.5,
   "radjoeff": 95.4,
   "radjdeff": 110.5
 },
 {
   "Rk": 290,
   "Team": "Robert Morris",
   "Conf": "NEC",
   "W-L": "12-18",
   "adjem": -15.17,
   "kadjoeff": 99.3,
   "kadjdeff": 114.5,
   "badjoeff": 99.3,
   "badjdeff": 114.5,
   "radjoeff": 99.3,
   "radjdeff": 114.5
 },
 {
   "Rk": 291,
   "Team": "IPFW",
   "Conf": "ind",
   "W-L": "3-21",
   "adjem": -15.26,
   "kadjoeff": 97,
   "kadjdeff": 112.3,
   "badjoeff": 97,
   "badjdeff": 112.3,
   "radjoeff": 97,
   "radjdeff": 112.3
 },
 {
   "Rk": 292,
   "Team": "Binghamton",
   "Conf": "AE",
   "W-L": "9-19",
   "adjem": -15.37,
   "kadjoeff": 92.7,
   "kadjdeff": 108.1,
   "badjoeff": 92.7,
   "badjdeff": 108.1,
   "radjoeff": 92.7,
   "radjdeff": 108.1
 },
 {
   "Rk": 293,
   "Team": "Jackson State",
   "Conf": "SWAC",
   "W-L": "9-19",
   "adjem": -15.44,
   "kadjoeff": 96.9,
   "kadjdeff": 112.4,
   "badjoeff": 96.9,
   "badjdeff": 112.4,
   "radjoeff": 96.9,
   "radjdeff": 112.4
 },
 {
   "Rk": 294,
   "Team": "Mercer",
   "Conf": "ASun",
   "W-L": "5-23",
   "adjem": -15.61,
   "kadjoeff": 96.2,
   "kadjdeff": 111.8,
   "badjoeff": 96.2,
   "badjdeff": 111.8,
   "radjoeff": 96.2,
   "radjdeff": 111.8
 },
 {
   "Rk": 295,
   "Team": "Eastern Kentucky",
   "Conf": "OVC",
   "W-L": "4-20",
   "adjem": -15.71,
   "kadjoeff": 93.4,
   "kadjdeff": 109.1,
   "badjoeff": 93.4,
   "badjdeff": 109.1,
   "radjoeff": 93.4,
   "radjdeff": 109.1
 },
 {
   "Rk": 296,
   "Team": "Maryland Eastern Shore",
   "Conf": "MEAC",
   "W-L": "11-18",
   "adjem": -16.02,
   "kadjoeff": 98.8,
   "kadjdeff": 114.9,
   "badjoeff": 98.8,
   "badjdeff": 114.9,
   "radjoeff": 98.8,
   "radjdeff": 114.9
 },
 {
   "Rk": 297,
   "Team": "Birmingham Southern",
   "Conf": "BSth",
   "W-L": "11-14",
   "adjem": -16.2,
   "kadjoeff": 94.4,
   "kadjdeff": 110.6,
   "badjoeff": 94.4,
   "badjdeff": 110.6,
   "radjoeff": 94.4,
   "radjdeff": 110.6
 },
 {
   "Rk": 298,
   "Team": "Lehigh",
   "Conf": "Pat",
   "W-L": "4-23",
   "adjem": -16.21,
   "kadjoeff": 93.1,
   "kadjdeff": 109.3,
   "badjoeff": 93.1,
   "badjdeff": 109.3,
   "radjoeff": 93.1,
   "radjdeff": 109.3
 },
 {
   "Rk": 299,
   "Team": "Sacred Heart",
   "Conf": "NEC",
   "W-L": "8-20",
   "adjem": -16.6,
   "kadjoeff": 96.3,
   "kadjdeff": 112.9,
   "badjoeff": 96.3,
   "badjdeff": 112.9,
   "radjoeff": 96.3,
   "radjdeff": 112.9
 },
 {
   "Rk": 300,
   "Team": "Southeastern Louisiana",
   "Conf": "Slnd",
   "W-L": "6-20",
   "adjem": -16.65,
   "kadjoeff": 89.3,
   "kadjdeff": 105.9,
   "badjoeff": 89.3,
   "badjdeff": 105.9,
   "radjoeff": 89.3,
   "radjdeff": 105.9
 },
 {
   "Rk": 301,
   "Team": "Campbell",
   "Conf": "ASun",
   "W-L": "7-19",
   "adjem": -16.73,
   "kadjoeff": 100.9,
   "kadjdeff": 117.6,
   "badjoeff": 100.9,
   "badjdeff": 117.6,
   "radjoeff": 100.9,
   "radjdeff": 117.6
 },
 {
   "Rk": 302,
   "Team": "High Point",
   "Conf": "BSth",
   "W-L": "9-19",
   "adjem": -17.03,
   "kadjoeff": 96.7,
   "kadjdeff": 113.7,
   "badjoeff": 96.7,
   "badjdeff": 113.7,
   "radjoeff": 96.7,
   "radjdeff": 113.7
 },
 {
   "Rk": 303,
   "Team": "Cornell",
   "Conf": "Ivy",
   "W-L": "4-22",
   "adjem": -17.45,
   "kadjoeff": 89.2,
   "kadjdeff": 106.6,
   "badjoeff": 89.2,
   "badjdeff": 106.6,
   "radjoeff": 89.2,
   "radjdeff": 106.6
 },
 {
   "Rk": 304,
   "Team": "Dartmouth",
   "Conf": "Ivy",
   "W-L": "8-18",
   "adjem": -17.66,
   "kadjoeff": 100.2,
   "kadjdeff": 117.8,
   "badjoeff": 100.2,
   "badjdeff": 117.8,
   "radjoeff": 100.2,
   "radjdeff": 117.8
 },
 {
   "Rk": 305,
   "Team": "State Francis PA",
   "Conf": "NEC",
   "W-L": "6-21",
   "adjem": -17.99,
   "kadjoeff": 89.4,
   "kadjdeff": 107.3,
   "badjoeff": 89.4,
   "badjdeff": 107.3,
   "radjoeff": 89.4,
   "radjdeff": 107.3
 },
 {
   "Rk": 306,
   "Team": "Coastal Carolina",
   "Conf": "BSth",
   "W-L": "8-20",
   "adjem": -18.19,
   "kadjoeff": 95.9,
   "kadjdeff": 114.1,
   "badjoeff": 95.9,
   "badjdeff": 114.1,
   "radjoeff": 95.9,
   "radjdeff": 114.1
 },
 {
   "Rk": 307,
   "Team": "Eastern Michigan",
   "Conf": "MAC",
   "W-L": "5-24",
   "adjem": -18.22,
   "kadjoeff": 97.1,
   "kadjdeff": 115.3,
   "badjoeff": 97.1,
   "badjdeff": 115.3,
   "radjoeff": 97.1,
   "radjdeff": 115.3
 },
 {
   "Rk": 308,
   "Team": "Saint Peter's",
   "Conf": "MAAC",
   "W-L": "4-24",
   "adjem": -18.57,
   "kadjoeff": 93,
   "kadjdeff": 111.6,
   "badjoeff": 93,
   "badjdeff": 111.6,
   "radjoeff": 93,
   "radjdeff": 111.6
 },
 {
   "Rk": 309,
   "Team": "Grambling State",
   "Conf": "SWAC",
   "W-L": "8-19",
   "adjem": -18.91,
   "kadjoeff": 97.3,
   "kadjdeff": 116.2,
   "badjoeff": 97.3,
   "badjdeff": 116.2,
   "radjoeff": 97.3,
   "radjdeff": 116.2
 },
 {
   "Rk": 310,
   "Team": "Lipscomb",
   "Conf": "ind",
   "W-L": "4-21",
   "adjem": -19.34,
   "kadjoeff": 93.6,
   "kadjdeff": 112.9,
   "badjoeff": 93.6,
   "badjdeff": 112.9,
   "radjoeff": 93.6,
   "radjdeff": 112.9
 },
 {
   "Rk": 311,
   "Team": "Texas Southern",
   "Conf": "SWAC",
   "W-L": "11-17",
   "adjem": -19.56,
   "kadjoeff": 94.6,
   "kadjdeff": 114.1,
   "badjoeff": 94.6,
   "badjdeff": 114.1,
   "radjoeff": 94.6,
   "radjdeff": 114.1
 },
 {
   "Rk": 312,
   "Team": "Stony Brook",
   "Conf": "AE",
   "W-L": "6-22",
   "adjem": -20.04,
   "kadjoeff": 91.5,
   "kadjdeff": 111.5,
   "badjoeff": 91.5,
   "badjdeff": 111.5,
   "radjoeff": 91.5,
   "radjdeff": 111.5
 },
 {
   "Rk": 313,
   "Team": "Loyola MD",
   "Conf": "MAAC",
   "W-L": "5-23",
   "adjem": -20.27,
   "kadjoeff": 86.7,
   "kadjdeff": 106.9,
   "badjoeff": 86.7,
   "badjdeff": 106.9,
   "radjoeff": 86.7,
   "radjdeff": 106.9
 },
 {
   "Rk": 314,
   "Team": "Albany",
   "Conf": "AE",
   "W-L": "8-20",
   "adjem": -20.29,
   "kadjoeff": 87,
   "kadjdeff": 107.3,
   "badjoeff": 87,
   "badjdeff": 107.3,
   "radjoeff": 87,
   "radjdeff": 107.3
 },
 {
   "Rk": 315,
   "Team": "Coppin State",
   "Conf": "MEAC",
   "W-L": "5-24",
   "adjem": -21.03,
   "kadjoeff": 88,
   "kadjdeff": 109,
   "badjoeff": 88,
   "badjdeff": 109,
   "radjoeff": 88,
   "radjdeff": 109
 },
 {
   "Rk": 316,
   "Team": "Morgan State",
   "Conf": "MEAC",
   "W-L": "3-25",
   "adjem": -21.23,
   "kadjoeff": 90,
   "kadjdeff": 111.3,
   "badjoeff": 90,
   "badjdeff": 111.3,
   "radjoeff": 90,
   "radjdeff": 111.3
 },
 {
   "Rk": 317,
   "Team": "Southern",
   "Conf": "SWAC",
   "W-L": "7-19",
   "adjem": -21.56,
   "kadjoeff": 93.9,
   "kadjdeff": 115.5,
   "badjoeff": 93.9,
   "badjdeff": 115.5,
   "radjoeff": 93.9,
   "radjdeff": 115.5
 },
 {
   "Rk": 318,
   "Team": "Fairleigh Dickinson",
   "Conf": "NEC",
   "W-L": "4-25",
   "adjem": -22.73,
   "kadjoeff": 93.5,
   "kadjdeff": 116.3,
   "badjoeff": 93.5,
   "badjdeff": 116.3,
   "radjoeff": 93.5,
   "radjdeff": 116.3
 },
 {
   "Rk": 319,
   "Team": "Prairie View A&M",
   "Conf": "SWAC",
   "W-L": "9-19",
   "adjem": -23.35,
   "kadjoeff": 89.6,
   "kadjdeff": 112.9,
   "badjoeff": 89.6,
   "badjdeff": 112.9,
   "radjoeff": 89.6,
   "radjdeff": 112.9
 },
 {
   "Rk": 320,
   "Team": "Chicago State",
   "Conf": "MCon",
   "W-L": "1-26",
   "adjem": -24.56,
   "kadjoeff": 89.5,
   "kadjdeff": 114.1,
   "badjoeff": 89.5,
   "badjdeff": 114.1,
   "radjoeff": 89.5,
   "radjdeff": 114.1
 },
 {
   "Rk": 321,
   "Team": "LIU Brooklyn",
   "Conf": "NEC",
   "W-L": "5-22",
   "adjem": -24.88,
   "kadjoeff": 97.5,
   "kadjdeff": 122.3,
   "badjoeff": 97.5,
   "badjdeff": 122.3,
   "radjoeff": 97.5,
   "radjdeff": 122.3
 },
 {
   "Rk": 322,
   "Team": "Liberty",
   "Conf": "BSth",
   "W-L": "3-24",
   "adjem": -25.14,
   "kadjoeff": 85.6,
   "kadjdeff": 110.7,
   "badjoeff": 85.6,
   "badjdeff": 110.7,
   "radjoeff": 85.6,
   "radjdeff": 110.7
 },
 {
   "Rk": 323,
   "Team": "Nicholls State",
   "Conf": "Slnd",
   "W-L": "1-25",
   "adjem": -26.22,
   "kadjoeff": 87.1,
   "kadjdeff": 113.3,
   "badjoeff": 87.1,
   "badjdeff": 113.3,
   "radjoeff": 87.1,
   "radjdeff": 113.3
 },
 {
   "Rk": 324,
   "Team": "Arkansas Pine Bluff",
   "Conf": "SWAC",
   "W-L": "2-26",
   "adjem": -28.85,
   "kadjoeff": 82.2,
   "kadjdeff": 111.1,
   "badjoeff": 82.2,
   "badjdeff": 111.1,
   "radjoeff": 82.2,
   "radjdeff": 111.1
 },
 {
   "Rk": 325,
   "Team": "Mount State Mary's",
   "Conf": "NEC",
   "W-L": "3-24",
   "adjem": -29.36,
   "kadjoeff": 85.1,
   "kadjdeff": 114.5,
   "badjoeff": 85.1,
   "badjdeff": 114.5,
   "radjoeff": 85.1,
   "radjdeff": 114.5
 },
 {
   "Rk": 326,
   "Team": "Morris Brown",
   "Conf": "ind",
   "W-L": "4-23",
   "adjem": -29.95,
   "kadjoeff": 85.1,
   "kadjdeff": 115.1,
   "badjoeff": 85.1,
   "badjdeff": 115.1,
   "radjoeff": 85.1,
   "radjdeff": 115.1
 },
 {
   "Rk": 327,
   "Team": "Savannah State",
   "Conf": "ind",
   "W-L": "2-24",
   "adjem": -31.15,
   "kadjoeff": 78.1,
   "kadjdeff": 109.2,
   "badjoeff": 78.1,
   "badjdeff": 109.2,
   "radjoeff": 78.1,
   "radjdeff": 109.2
 }
]
