# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['django-stubs', 'psycopg2-stubs']

package_data = \
{'': ['*'],
 'django-stubs': ['apps/*',
                  'conf/*',
                  'conf/locale/*',
                  'conf/urls/*',
                  'contrib/*',
                  'contrib/admin/*',
                  'contrib/admin/migrations/*',
                  'contrib/admin/templatetags/*',
                  'contrib/admin/views/*',
                  'contrib/admindocs/*',
                  'contrib/auth/*',
                  'contrib/auth/handlers/*',
                  'contrib/auth/management/*',
                  'contrib/auth/management/commands/*',
                  'contrib/auth/migrations/*',
                  'contrib/contenttypes/*',
                  'contrib/contenttypes/management/*',
                  'contrib/contenttypes/management/commands/*',
                  'contrib/contenttypes/migrations/*',
                  'contrib/flatpages/*',
                  'contrib/flatpages/migrations/*',
                  'contrib/flatpages/templatetags/*',
                  'contrib/gis/*',
                  'contrib/gis/admin/*',
                  'contrib/gis/db/*',
                  'contrib/gis/db/backends/*',
                  'contrib/gis/db/backends/base/*',
                  'contrib/gis/db/backends/mysql/*',
                  'contrib/gis/db/backends/oracle/*',
                  'contrib/gis/db/backends/postgis/*',
                  'contrib/gis/db/backends/spatialite/*',
                  'contrib/gis/db/models/*',
                  'contrib/gis/db/models/sql/*',
                  'contrib/gis/forms/*',
                  'contrib/gis/gdal/*',
                  'contrib/gis/gdal/prototypes/*',
                  'contrib/gis/gdal/raster/*',
                  'contrib/gis/geoip2/*',
                  'contrib/gis/geos/*',
                  'contrib/gis/geos/prototypes/*',
                  'contrib/gis/serializers/*',
                  'contrib/gis/sitemaps/*',
                  'contrib/gis/utils/*',
                  'contrib/humanize/*',
                  'contrib/humanize/templatetags/*',
                  'contrib/messages/*',
                  'contrib/messages/storage/*',
                  'contrib/postgres/*',
                  'contrib/postgres/aggregates/*',
                  'contrib/postgres/fields/*',
                  'contrib/redirects/*',
                  'contrib/redirects/migrations/*',
                  'contrib/sessions/*',
                  'contrib/sessions/backends/*',
                  'contrib/sessions/management/*',
                  'contrib/sessions/management/commands/*',
                  'contrib/sessions/migrations/*',
                  'contrib/sitemaps/*',
                  'contrib/sitemaps/management/*',
                  'contrib/sitemaps/management/commands/*',
                  'contrib/sites/*',
                  'contrib/sites/migrations/*',
                  'contrib/staticfiles/*',
                  'contrib/staticfiles/management/*',
                  'contrib/staticfiles/management/commands/*',
                  'contrib/staticfiles/templatetags/*',
                  'contrib/syndication/*',
                  'core/*',
                  'core/cache/*',
                  'core/cache/backends/*',
                  'core/checks/*',
                  'core/checks/compatibility/*',
                  'core/checks/security/*',
                  'core/files/*',
                  'core/handlers/*',
                  'core/mail/*',
                  'core/mail/backends/*',
                  'core/management/*',
                  'core/management/commands/*',
                  'core/serializers/*',
                  'core/servers/*',
                  'db/*',
                  'db/backends/*',
                  'db/backends/base/*',
                  'db/backends/dummy/*',
                  'db/backends/mysql/*',
                  'db/backends/oracle/*',
                  'db/backends/postgresql/*',
                  'db/backends/sqlite3/*',
                  'db/migrations/*',
                  'db/migrations/operations/*',
                  'db/models/*',
                  'db/models/fields/*',
                  'db/models/functions/*',
                  'db/models/sql/*',
                  'dispatch/*',
                  'forms/*',
                  'http/*',
                  'middleware/*',
                  'template/*',
                  'template/backends/*',
                  'template/loaders/*',
                  'templatetags/*',
                  'test/*',
                  'urls/*',
                  'utils/*',
                  'utils/translation/*',
                  'views/*',
                  'views/decorators/*',
                  'views/generic/*']}

setup_kwargs = {
    'name': 'django-types',
    'version': '0.11.0',
    'description': 'Type stubs for Django',
    'long_description': '# django-types [![PyPI](https://img.shields.io/pypi/v/django-types.svg)](https://pypi.org/project/django-types/)\n\nType stubs for [Django](https://www.djangoproject.com).\n\n> Note: this project was forked from\n> <https://github.com/typeddjango/django-stubs> with the goal of removing the\n> [`mypy`](https://github.com/python/mypy) plugin dependency so that `mypy`\n> can\'t [crash due to Django\n> config](https://github.com/typeddjango/django-stubs/issues/318), and that\n> non-`mypy` type checkers like\n> [`pyright`](https://github.com/microsoft/pyright) will work better with\n> Django.\n\n## install\n\n```bash\npip install django-types\n```\n\nYou\'ll need to monkey patch Django\'s `QuerySet`, `Manager` (not needed for Django 3.1+) and\n`ForeignKey` classes so we can index into them with a generic argument. Add this to your\nsettings.py:\n\n```python\n# in settings.py\nfrom django.db.models import ForeignKey\nfrom django.db.models.manager import BaseManager\nfrom django.db.models.query import QuerySet\n\n# NOTE: there are probably other items you\'ll need to monkey patch depending on\n# your version.\nfor cls in [QuerySet, BaseManager, ForeignKey]:\n    cls.__class_getitem__ = classmethod(lambda cls, *args, **kwargs: cls)  # type: ignore [attr-defined]\n```\n\n## usage\n\n### ForeignKey ids and related names as properties in ORM models\n\nWhen defining a Django ORM model with a foreign key, like so:\n\n```python\nclass User(models.Model):\n    team = models.ForeignKey(\n        "Team",\n        null=True,\n        on_delete=models.SET_NULL,\n    )\n    role = models.ForeignKey(\n        "Role",\n        null=True,\n        on_delete=models.SET_NULL,\n        related_name="users",\n    )\n```\n\ntwo properties are created, `team` as expected, and `team_id`. Also, a related\nmanager called `user_set` is created on `Team` for the reverse access.\n\nIn order to properly add typing to the foreing key itself and also for the created ids you can do\nsomething like this:\n\n```python\nfrom typing import TYPE_CHECKING\n\nfrom someapp.models import Team\nif TYPE_CHECKING:\n    # In this example Role cannot be imported due to circular import issues,\n    # but doing so inside TYPE_CHECKING will make sure that the typing bellow\n    # knows what "Role" means\n    from anotherapp.models import Role\n\n\nclass User(models.Model):\n    team_id: Optional[int]\n    team = models.ForeignKey(\n        Team,\n        null=True,\n        on_delete=models.SET_NULL,\n    )\n    role_id: int\n    role = models.ForeignKey["Role"](\n        "Role",\n        null=False,\n        on_delete=models.SET_NULL,\n        related_name="users",\n    )\n\n\nreveal_type(User().team)\n# note: Revealed type is \'Optional[Team]\'\nreveal_type(User().role)\n# note: Revealed type is \'Role\'\n```\n\nThis will make sure that `team_id` and `role_id` can be accessed. Also, `team` and `role`\nwill be typed to their right objects.\n\nTo be able to access the related manager `Team` and `Role` you could do:\n\n```python\nfrom typing import TYPE_CHECKING\n\nif TYPE_CHECKING:\n    # This doesn\'t really exists on django so it always need to be imported this way\n    from django.db.models.manager import RelatedManager\n    from user.models import User\n\n\nclass Team(models.Model):\n    if TYPE_CHECKING:\n        user_set = RelatedManager["User"]()\n\n\nclass Role(models.Model):\n    if TYPE_CHECKING:\n        users = RelatedManager["User"]()\n\nreveal_type(Team().user_set)\n# note: Revealed type is \'RelatedManager[User]\'\nreveal_type(Role().users)\n# note: Revealed type is \'RelatedManager[User]\'\n```\n\n\n### `id Field`\n\nBy default Django will create an `AutoField` for you if one doesn\'t exist.\n\nFor type checkers to know about the `id` field you\'ll need to declare the\nfield explicitly.\n\n```python\n# before\nclass Post(models.Model):\n    ...\n\n# after\nclass Post(models.Model):\n    id = models.AutoField(primary_key=True)\n    # OR\n    id: int\n```\n\n### `HttpRequest`\'s `user` property\n\nThe `HttpRequest`\'s `user` property has a type of `Union[AbstractBaseUser, AnonymousUser]`,\nbut for most of your views you\'ll probably want either an authed user or an\n`AnonymousUser`.\n\nSo we can define a subclass for each case:\n\n```python\nclass AuthedHttpRequest(HttpRequest):\n    user: User  # type: ignore [assignment]\n```\n\nAnd then you can use it in your views:\n\n```python\n@auth.login_required\ndef activity(request: AuthedHttpRequest, team_id: str) -> HttpResponse:\n    ...\n```\n\nYou can also get more strict with your `login_required` decorator so that the\nfirst argument of the fuction it is decorating is `AuthedHttpRequest`:\n\n```python\nfrom typing import Any, Union, TypeVar, cast\nfrom django.http import HttpRequest, HttpResponse\nfrom typing_extensions import Protocol\nfrom functools import wraps\n\nclass RequestHandler1(Protocol):\n    def __call__(self, request: AuthedHttpRequest) -> HttpResponse:\n        ...\n\n\nclass RequestHandler2(Protocol):\n    def __call__(self, request: AuthedHttpRequest, __arg1: Any) -> HttpResponse:\n        ...\n\n\nRequestHandler = Union[RequestHandler1, RequestHandler2]\n\n\n# Verbose bound arg due to limitations of Python typing.\n# see: https://github.com/python/mypy/issues/5876\n_F = TypeVar("_F", bound=RequestHandler)\n\n\ndef login_required(view_func: _F) -> _F:\n    @wraps(view_func)\n    def wrapped_view(\n        request: AuthedHttpRequest, *args: object, **kwargs: object\n    ) -> HttpResponse:\n        if request.user.is_authenticated:\n            return view_func(request, *args, **kwargs)  # type: ignore [call-arg]\n        raise AuthenticationRequired\n\n    return cast(_F, wrapped_view)\n```\n\nThen the following will type error:\n\n```python\n@auth.login_required\ndef activity(request: HttpRequest, team_id: str) -> HttpResponse:\n    ...\n```\n\n## related\n\n- <https://github.com/sbdchd/djangorestframework-types>\n- <https://github.com/sbdchd/celery-types>\n- <https://github.com/sbdchd/mongo-types>\n- <https://github.com/sbdchd/msgpack-types>\n',
    'author': 'Steve Dignam',
    'author_email': 'steve@dignam.xyz',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/sbdchd/django-types',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.6.2,<4.0.0',
}


setup(**setup_kwargs)
