import pathlib
from setuptools import setup, find_packages

HERE = pathlib.Path(__file__).parent

VERSION = '0.2.4'
PACKAGE_NAME = 'checkpointe'
AUTHOR = 'Eddie Kirkland'
AUTHOR_EMAIL = 'eddie@kdsolutions.co'
URL = 'https://github.com/e-kirkland/checkpointe'

LICENSE = 'Apache License 2.0'
DESCRIPTION = 'A simple process timer for python scripts.'
LONG_DESCRIPTION = (HERE / "README.md").read_text()
LONG_DESC_TYPE = "text/markdown"

INSTALL_REQUIRES = [
      'datetime'
]

setup(name=PACKAGE_NAME,
      version=VERSION,
      description=DESCRIPTION,
      long_description=LONG_DESCRIPTION,
      long_description_content_type=LONG_DESC_TYPE,
      author=AUTHOR,
      license=LICENSE,
      author_email=AUTHOR_EMAIL,
      url=URL,
      install_requires=INSTALL_REQUIRES,
      packages=find_packages()
      )