# ![pyTrendyol](https://cdn.dsmcdn.com/web/production/favicon.ico) pyTrendyol

![Repo Boyutu](https://img.shields.io/github/repo-size/keyiflerolsun/pyTrendyol?logo=git&logoColor=white)
![Görüntülenme](https://hits.seeyoufarm.com/api/count/incr/badge.svg?url=https://github.com/keyiflerolsun/pyTrendyol&title=Görüntülenme)
<a href="https://KekikAkademi.org/Kahve" target="_blank"><img src="https://img.shields.io/badge/☕️-Kahve Ismarla-ffdd00" title="☕️ Kahve Ismarla" style="padding-left:5px;"></a>

![Python Version](https://img.shields.io/pypi/pyversions/pyTrendyol?logo=python&logoColor=white)
![License](https://img.shields.io/pypi/l/pyTrendyol?logo=gnu&logoColor=white)
![Status](https://img.shields.io/pypi/status/pyTrendyol?logo=windowsterminal&logoColor=white)

![PyPI](https://img.shields.io/pypi/v/pyTrendyol?logo=pypi&logoColor=white)
![PyPI - Downloads](https://img.shields.io/pypi/dm/pyTrendyol?logo=pypi&logoColor=white)
![PyPI - Wheel](https://img.shields.io/pypi/wheel/pyTrendyol?logo=pypi&logoColor=white)

*Trendyol'dan veri almayı kolaylaştırmak için tasarlanan kütüphane.*

[![ForTheBadge made-with-python](http://ForTheBadge.com/images/badges/made-with-python.svg)](https://www.python.org/)
[![ForTheBadge built-with-love](http://ForTheBadge.com/images/badges/built-with-love.svg)](https://GitHub.com/keyiflerolsun/)

## 🚀 Kurulum

```bash
# Yüklemek
pip install pyTrendyol

# Güncellemek
pip install -U pyTrendyol
```

## 📝 Kullanım

```python
from pyTrendyol import Kategori, Urun

trend_kategori = Kategori()
trend_urun     = Urun()

telefon_aksesuarlari = trend_kategori.urunleri_ver(
    kategori_adi = "telefon aksesuarları",
    sayfa_tara   = 3
)
print(telefon_aksesuarlari)
    # » [{'link': 'https://www.trendyol.com/mimtec/iphone-14-pro-uyumlu-ve-iphone-14-pro-max-uyumlu-kamera-koruyucu-lens-koruyucu-p-377711098', 'marka': 'mimtec', 'yildiz': 4, 'baslik': 'Iphone 14 Pro Uyumlu Ve Iphone 14 Pro Max Uyumlu Kamera Koruyucu Lens Koruyucu', 'indirim': None, 'indirimsiz': None, 'fiyat': '40 TL'}, {'link': 'https://www.trendyol.com/tria/apple-iphone-11-kamera-lens-koruyucu-temperli-seffaf-full-cam-p-147638470', 'marka': 'Tria', 'yildiz': 4, 'baslik': 'Apple Iphone 11 Kamera Lens Koruyucu Temperli Şeffaf Full Cam', 'indirim': None, 'indirimsiz': None, 'fiyat': '39,90 TL'}, {'link': 'https://www.trendyol.com/powerfox/iphone-7-plus-8-plus-uyumlu-surgulu-kamera-korumali-silikon-kilif-p-281022758', 'marka': 'Powerfox', 'yildiz': 4, 'baslik': 'Iphone 7 Plus 8 Plus Uyumlu Sürgülü Kamera Korumalı Silikon Kılıf', 'indirim': None, 'indirimsiz': None, 'fiyat': '26,99 TL'}, {'link': 'https://www.trendyol.com/kensa/type-c-ve-usb-girisli-arac-metal-cakmaklik-sarj-aleti-cift-girisli-araba-sarj-p-300432204', 'marka': 'Kensa', 'yildiz': 4, 'baslik': 'Type-c Ve Usb Girişli Araç Metal Çakmaklık Şarj Aleti Çift Girişli Araba Şarj', 'indirim': None, 'indirimsiz': None, 'fiyat': '99,99 TL'}, {'link': 'https://www.trendyol.com/powerfox/iphone-13-13-mini-uyumlu-kamera-lens-koruyucu-2-li-set-koknar-yesili-p-443877806', 'marka': 'Powerfox', 'yildiz': 4, 'baslik': "Iphone 13/13 Mini Uyumlu Kamera Lens Koruyucu(2'li Set) Köknar Yeşili", 'indirim': None, 'indirimsiz': None, 'fiyat': 'Son 30 Günün En Düşük Fiyatı!24,93 TL'}, {'link': 'https://www.trendyol.com/case/aynali-telefon-kilifi-iphone-13-uyumlu-p-434671917', 'marka': 'Case', 'yildiz': 4, 'baslik': 'Aynalı Telefon Kılıfı Iphone 13 Uyumlu', 'indirim': None, 'indirimsiz': None, 'fiyat': '99,99 TL'}, {'link': 'https://www.trendyol.com/go-aksesuar/iphone-14-plus-ayicik-tasarimli-kilif-p-462753413', 'marka': 'Go Aksesuar', 'yildiz': 3, 'baslik': 'Iphone 14 Plus Ayıcık Tasarımlı Kılıf', 'indirim': None, 'indirimsiz': None, 'fiyat': '150 TL'}, {'link': 'https://www.trendyol.com/bilisimgo-technology/iphone-xs-max-elektroliz-logo-detayli-kenarlari-renkli-kamera-lens-korumali-kilif-p-370572266', 'marka': 'BilişimGo Technology', 'yildiz': 4, 'baslik': 'Iphone Xs Max Elektroliz Logo Detaylı Kenarları Renkli Kamera Lens Korumalı Kılıf', 'indirim': None, 'indirimsiz': None, 'fiyat': '59,99 TL'}, {'link': 'https://www.trendyol.com/baseus/halo-2-4-a-usb-a-iphone-hizli-sarj-lightning-sarj-1-metre-data-aktarim-kablosu-siyah-p-456236311', 'marka': 'Baseus', 'yildiz': 4, 'baslik': 'Halo 2.4 A Usb-a Iphone Hızlı Şarj Lightning Şarj 1 Metre Data Aktarım Kablosu Siyah', 'indirim': None, 'indirimsiz': None, 'fiyat': '134,90 TL'}, {'link': 'https://www.trendyol.com/my-murdum/iphone-samsung-huawei-kablo-koruyucu-sarj-aleti-kulaklik-icin-3-lu-set-p-61607383', 'marka': 'MY MÜRDÜM', 'yildiz': 4, 'baslik': "Iphone Samsung Huawei Kablo Koruyucu - Şarj Aleti Kulaklık Için 3'lü Set", 'indirim': None, 'indirimsiz': None, 'fiyat': '59 TL'}, {'link': 'https://www.trendyol.com/hytech/samsung-galaxy-j2-j3-j4-j5-j6-j7-j8-orjinal-hizli-micro-sarj-aleti-ve-data-kablosu-p-434835242', 'marka': 'Hytech', 'yildiz': 5, 'baslik': 'Samsung Galaxy J2/j3/j4/j5/j6/j7/j8 Orjinal Hızlı Micro Şarj Aleti Ve Data Kablosu', 'indirim': None, 'indirimsiz': None, 'fiyat': '33 TL'}, {'link': 'https://www.trendyol.com/m-tk-moveteck/apple-iphone-7-8-plus-uyumlu-kilif-parlak-gold-serit-astronot-standli-sik-kaplama-sik-p-346709912', 'marka': 'm.tk moveteck', 'yildiz': 4, 'baslik': 'Apple Iphone 7 / 8 Plus Uyumlu Kılıf Parlak Gold Şerit Astronot Standlı Şık Kaplama Şık', 'indirim': None, 'indirimsiz': None, 'fiyat': '123,22 TL'}, {'link': 'https://www.trendyol.com/ucuzmi-bulvar-telefon/cevirmeli-sonsuz-kinetik-enerji-ve-usb-led-usb-sarj-aleti-acil-led-fenerli-pratik-kamp-lambasi-p-148313729', 'marka': 'ucuzmi bulvar telefon', 'yildiz': 2, 'baslik': 'Çevirmeli Sonsuz Kinetik Enerji Ve Usb Led Usb Şarj Aleti Acil Led Fenerli Pratik Kamp Lambası', 'indirim': None, 'indirimsiz': None, 'fiyat': '119 TL'}, {'link': 'https://www.trendyol.com/casetify/aynali-telefon-kilifi-iphone-7-8-plus-case-p-360962507', 'marka': 'Casetify', 'yildiz': 5, 'baslik': 'Aynalı - Telefon Kılıfı - Iphone 7/8 Plus Case', 'indirim': None, 'indirimsiz': None, 'fiyat': '106,90 TL'}, {'link': 'https://www.trendyol.com/aktarmobile/macbook-air-13-m1-2021-ekran-koruyucu-13-3-a2337-uyumlu-2-adet-ultra-ince-kirilmaz-tam-uyum-p-248381527', 'marka': 'AktarMobile', 'yildiz': 3, 'baslik': 'Macbook Air 13 M1 2021 Ekran Koruyucu 13.3" A2337 Uyumlu - 2 Adet - Ultra Ince & Kırılmaz & Tam Uyum', 'indirim': None, 'indirimsiz': None, 'fiyat': '133,50 TL'}, {'link': 'https://www.trendyol.com/huawei/orijinal-hizli-micro-uyumlu-usb-sarj-aleti-beyaz-p-31655244', 'marka': 'Huawei', 'yildiz': 3, 'baslik': 'Orijinal Hızlı Micro Uyumlu Usb Sarj Aleti Beyaz', 'indirim': None, 'indirimsiz': None, 'fiyat': '229 TL'}, {'link': 'https://www.trendyol.com/kvk-privacy/iphone-7-plus-uyumlu-lansman-the-heart-desenli-telefon-kilifi-p-99083194', 'marka': 'KVK PRİVACY', 'yildiz': 4, 'baslik': 'Iphone 7 Plus Uyumlu Lansman The Heart Desenli Telefon Kılıfı', 'indirim': None, 'indirimsiz': None, 'fiyat': '59,90 TL'}, {'link': 'https://www.trendyol.com/shinytech/apple-watch-akilli-saat-44mm-ekran-koruyucu-9d-tam-koruma-p-370573205', 'marka': 'ShinyTECH', 'yildiz': 4, 'baslik': 'Apple Watch & Akıllı Saat 44mm Ekran Koruyucu (9d Tam Koruma)', 'indirim': None, 'indirimsiz': None, 'fiyat': '48,80 TL'}, {'link': 'https://www.trendyol.com/powerfox/iphone-11-uyumlu-kaplan-yarim-yuz-seffaf-telefon-kilifi-p-641713044', 'marka': 'Powerfox', 'yildiz': 4, 'baslik': 'Iphone 11 Uyumlu Kaplan Yarım Yüz Şeffaf Telefon Kılıfı', 'indirim': None, 'indirimsiz': None, 'fiyat': '29,99 TL'}, {'link': 'https://www.trendyol.com/fibaks/xiaomi-redmi-note-8-kilif-simli-renkli-parlak-kamera-lens-korumali-transparan-kapak-p-366744982', 'marka': 'Fibaks', 'yildiz': 5, 'baslik': 'Xiaomi Redmi Note 8 Kılıf Simli Renkli Parlak Kamera Lens Korumalı Transparan Kapak', 'indirim': None, 'indirimsiz': None, 'fiyat': '84,99 TL'}, {'link': 'https://www.trendyol.com/bilisimgo-technology/samsung-galaxy-a50-a30s-renkli-zincirli-telefon-kilifi-p-235253985', 'marka': 'BilişimGo Technology', 'yildiz': 5, 'baslik': 'Samsung Galaxy A50 / A30s Renkli Zincirli Telefon Kılıfı', 'indirim': None, 'indirimsiz': None, 'fiyat': '59,99 TL'}, {'link': 'https://www.trendyol.com/gaga-elektronik/samsung-galaxy-a23-uyumlu-askili-anti-shock-kilif-baslikla-uyumlu-model-p-445145137', 'marka': 'gaga elektronik', 'yildiz': 5, 'baslik': 'Samsung Galaxy A23 Uyumlu Askılı Anti Shock Kılıf (başlıkla Uyumlu Model)', 'indirim': None, 'indirimsiz': None, 'fiyat': '59,90 TL'}, {'link': 'https://www.trendyol.com/okmore/iphone-7-8-plus-x-11-uyumlu-soket-cogaltici-kulaklik-adaptoru-p-38582242', 'marka': 'OKMORE', 'yildiz': 3, 'baslik': 'Iphone 7 8 Plus X 11 Uyumlu Soket Çoğaltıcı Kulaklık Adaptörü', 'indirim': None, 'indirimsiz': None, 'fiyat': '22,90 TL'}, {'link': 'https://www.trendyol.com/kilifland/apple-iphone-6-6s-plus-kilif-kisiye-ozel-silikon-kilif-uzerine-yazi-p-37560615', 'marka': 'Kılıfland', 'yildiz': 3, 'baslik': 'Apple Iphone 6 6s Plus Kılıf Kişiye Özel Silikon Kılıf Üzerine Yazı', 'indirim': None, 'indirimsiz': None, 'fiyat': '50,89 TL'}, {'link': 'https://www.trendyol.com/telehome/xiaomi-redmi-note-8-pro-kirilmaz-cam-tam-kaplayan-p-88945521', 'marka': 'Telehome', 'yildiz': 3, 'baslik': 'Xiaomi Redmi Note 8 Pro Kırılmaz Cam Tam Kaplayan', 'indirim': None, 'indirimsiz': None, 'fiyat': 'Son 30 Günün En Düşük Fiyatı!29 TL26,50 TL'}, {'link': 'https://www.trendyol.com/omix/x400-kilif-silikon-moderna-desenli-mix-sticker-p-337019080', 'marka': 'omix', 'yildiz': 4, 'baslik': 'X400 Kılıf Silikon Moderna Desenli Mix Sticker', 'indirim': None, 'indirimsiz': None, 'fiyat': '59,90 TL'}, {'link': 'https://www.trendyol.com/reeder/p13-blue-max-pro-lite-2022-kilif-mat-renk-yumusak-silikon-kapak-p-316755916', 'marka': 'Reeder', 'yildiz': 4, 'baslik': 'P13 Blue Max Pro Lite 2022 Kılıf Mat Renk Yumuşak Silikon Kapak', 'indirim': None, 'indirimsiz': None, 'fiyat': '97,50 TL'}, {'link': 'https://www.trendyol.com/la-case/iphone-13-logolu-lansman-kilif-p-392615029', 'marka': 'La Case', 'yildiz': 5, 'baslik': 'Iphone 13 Logolu Lansman Kılıf', 'indirim': None, 'indirimsiz': None, 'fiyat': '59,90 TL'}, {'link': 'https://www.trendyol.com/trendteknomarket/a15-hello-kity-kalp-desenli-baskili-seffaf-telefon-kilif-uyumlu-p-474631514', 'marka': 'TRENDTEKNOMARKET', 'yildiz': 0, 'baslik': 'A15 Hello Kity Kalp Desenli Baskılı Şeffaf Telefon Kılıf Uyumlu', 'indirim': None, 'indirimsiz': None, 'fiyat': '49,99 TL'}, {'link': 'https://www.trendyol.com/do-ng/apple-iphone-7-8-se-2020-uyumlu-kenarlari-renkli-kose-korumali-baskili-silikon-seffaf-telefon-kilifi-p-375550550', 'marka': 'do ng', 'yildiz': 3, 'baslik': 'Apple Iphone 7 8 Se 2020 Uyumlu Kenarları Renkli Köşe Korumalı Baskılı Silikon Şeffaf Telefon Kılıfı', 'indirim': None, 'indirimsiz': None, 'fiyat': '46,80 TL'}, {'link': 'https://www.trendyol.com/gaga-elektronik/samsung-galaxy-a52-uyumlu-seffaf-el-gecmeli-kilif-baslikla-uyumlu-model-p-360876456', 'marka': 'gaga elektronik', 'yildiz': 4, 'baslik': 'Samsung Galaxy A52 Uyumlu Şeffaf El Geçmeli Kılıf (başlıkla Uyumlu Model)', 'indirim': None, 'indirimsiz': None, 'fiyat': '44,93 TL'}, {'link': 'https://www.trendyol.com/m-tk-moveteck/samsung-galaxy-a04-kilif-kamera-korumali-arkasi-mat-buzlu-renkli-tuslu-silikon-p-467368570', 'marka': 'm.tk moveteck', 'yildiz': 4, 'baslik': 'Samsung Galaxy A04 Kılıf Kamera Korumalı Arkası Mat Buzlu Renkli Tuşlu Silikon', 'indirim': None, 'indirimsiz': None, 'fiyat': '149 TL'}, {'link': 'https://www.trendyol.com/aksesuarda-moda/iphone-7-8-se-2020-uyumlu-tasli-kalpli-lazer-silikon-kilif-p-315351743', 'marka': 'Aksesuarda Moda', 'yildiz': 5, 'baslik': 'Iphone 7-8-se 2020 Uyumlu Taşlı Kalpli Lazer Silikon Kılıf', 'indirim': None, 'indirimsiz': None, 'fiyat': '123 TL'}, {'link': 'https://www.trendyol.com/hypercep/xiaomi-redmi-note-8-pro-koyu-yesil-kamera-korumali-surgulu-cicek-baskili-silikon-kilif-p-301071730', 'marka': 'HyperCep', 'yildiz': 4, 'baslik': 'Xiaomi Redmi Note 8 Pro Koyu Yeşil Kamera Korumalı Sürgülü Çiçek Baskılı Silikon Kılıf', 'indirim': None, 'indirimsiz': None, 'fiyat': '84,90 TL'}, {'link': 'https://www.trendyol.com/fibaks/samsung-galaxy-a23-kilif-surgulu-kamera-korumali-ultra-ince-arkasi-mat-seffaf-zar-kapak-p-357039930', 'marka': 'Fibaks', 'yildiz': 3, 'baslik': 'Samsung Galaxy A23 Kılıf Sürgülü Kamera Korumalı Ultra Ince Arkası Mat Şeffaf Zar Kapak', 'indirim': None, 'indirimsiz': None, 'fiyat': '59,99 TL'}, {'link': 'https://www.trendyol.com/shoptocase/xiaomi-redmi-note-10-pro-uyumlu-dusunceli-kurukafa-tasarimli-lansman-telefon-kilifi-p-335945384', 'marka': 'shoptocase', 'yildiz': 4, 'baslik': 'Xiaomi Redmi Note 10 Pro Uyumlu Düşünceli Kurukafa Tasarımlı Lansman Telefon Kılıfı', 'indirim': None, 'indirimsiz': None, 'fiyat': '59,90 TL'}, {'link': 'https://www.trendyol.com/gradis-shop/samsung-galaxy-a32-renkli-kalpli-desen-baskili-lansman-telefon-kilifi-baskili-beyaz-lansman-kilif-p-308847143', 'marka': 'Gradis Shop', 'yildiz': 5, 'baslik': 'Samsung Galaxy A32 Renkli Kalpli Desen Baskılı Lansman Telefon Kılıfı Baskılı Beyaz Lansman Kılıf', 'indirim': None, 'indirimsiz': None, 'fiyat': '58,90 TL'}, {'link': 'https://www.trendyol.com/suppo/iphone-12-mini-logolu-lansman-ici-kadife-silikon-kilif-icerir-p-90164119', 'marka': 'SUPPO', 'yildiz': 4, 'baslik': 'Iphone 12 Mini Logolu Lansman Içi Kadife Silikon Kılıf Içerir.', 'indirim': None, 'indirimsiz': None, 'fiyat': '49,99 TL'}, {'link': 'https://www.trendyol.com/gaga-elektronik/samsung-galaxy-a12-sefaf-kartlikli-antishock-kamera-korumali-kilif-baslikla-uyumlu-model-p-360423538', 'marka': 'gaga elektronik', 'yildiz': 5, 'baslik': 'Samsung Galaxy A12 Şefaf Kartlıklı Antishock Kamera Korumalı Kılıf (başlıkla Uyumlu Model)', 'indirim': None, 'indirimsiz': None, 'fiyat': '59,90 TL'}, {'link': 'https://www.trendyol.com/kvk-privacy/iphone-12-pro-max-6-7-kilif-hologramli-love-desenli-seffaf-kilif-p-362589703', 'marka': 'KVK PRİVACY', 'yildiz': 4, 'baslik': 'Iphone 12 Pro Max (6.7) Kılıf Hologramlı Love Desenli Şeffaf Kılıf', 'indirim': None, 'indirimsiz': None, 'fiyat': '59,90 TL'}, {'link': 'https://www.trendyol.com/bilisim-aksesuar/samsung-galaxy-a33-5g-kilif-lansman-ici-kadife-silikon-kilif-kapak-p-293942400', 'marka': 'Bilişim Aksesuar', 'yildiz': 4, 'baslik': 'Samsung Galaxy A33 5g Kılıf Lansman Içi Kadife Silikon Kılıf Kapak', 'indirim': None, 'indirimsiz': None, 'fiyat': '42,90 TL'}, {'link': 'https://www.trendyol.com/m-tk-moveteck/xiaomi-redmi-9c-uyumlu-kilif-kamera-korumali-parlak-gold-kenarli-yumusak-renkli-silikon-kapak-p-316889833', 'marka': 'm.tk moveteck', 'yildiz': 4, 'baslik': 'Xiaomi Redmi 9c Uyumlu Kılıf Kamera Korumalı Parlak Gold Kenarlı Yumuşak Renkli Silikon Kapak', 'indirim': None, 'indirimsiz': None, 'fiyat': '80,69 TL'}, {'link': 'https://www.trendyol.com/trendcell/iphone-11-12mini-12-6-1-uyumlu-mercek-lens-kamera-korumasi-siyah-renk-p-319983880', 'marka': 'TrendCell', 'yildiz': 4, 'baslik': 'Iphone 11-12mini-12 6.1 Uyumlu Mercek Lens Kamera Koruması Siyah Renk', 'indirim': None, 'indirimsiz': None, 'fiyat': 'Son 30 Günün En Düşük Fiyatı!54,90 TL46,06 TL'}, {'link': 'https://www.trendyol.com/suppo/iphone-xr-logolu-lansman-kilif-p-95813251', 'marka': 'SUPPO', 'yildiz': 4, 'baslik': 'Iphone Xr Logolu, Lansman Kılıf', 'indirim': None, 'indirimsiz': None, 'fiyat': '45,66 TL'}, {'link': 'https://www.trendyol.com/teknoparkta/xiaomi-redmi-9t-mat-hayalet-ekran-privacy-tam-kaplayan-kirilmaz-cam-seramik-ekran-koruyucu-p-219032315', 'marka': 'TEKNOPARKTA', 'yildiz': 3, 'baslik': 'Xiaomi Redmi 9t Mat Hayalet Ekran Privacy Tam Kaplayan Kırılmaz Cam Seramik Ekran Koruyucu', 'indirim': None, 'indirimsiz': None, 'fiyat': '55 TL'}, {'link': 'https://www.trendyol.com/dijimedia/huawei-p40-lite-tam-kapatan-hayalet-ekran-temperli-ekran-koruyucu-p-43122713', 'marka': 'Dijimedia', 'yildiz': 3, 'baslik': 'Huawei P40 Lite Tam Kapatan Hayalet Ekran Temperli Ekran Koruyucu', 'indirim': None, 'indirimsiz': None, 'fiyat': '48,58 TL'}, {'link': 'https://www.trendyol.com/ucuzmi/samsung-galaxy-s4-micro-usb-sarj-ve-data-kablosu-3-0a-2-4a-5a-mikro-cihazlarina-tam-uyumlu-beyaz-p-137302860', 'marka': 'ucuzmi', 'yildiz': 4, 'baslik': 'Samsung Galaxy S4 Micro Usb Şarj Ve Data Kablosu 3.0a - 2.4a - 5a Mikro Cihazlarına Tam Uyumlu Beyaz', 'indirim': None, 'indirimsiz': None, 'fiyat': '16,90 TL'}, {'link': 'https://www.trendyol.com/apple/watch-se-40mm-3-adet-on-lensun-esnek-nano-parmak-izi-birakmayan-mat-saat-ekran-koruyucu-p-383671291', 'marka': 'Apple', 'yildiz': 3, 'baslik': 'Watch Se-40mm (3 Adet Ön) Lensun Esnek Nano Parmak Izi Bırakmayan ( Mat ) Saat Ekran Koruyucu', 'indirim': None, 'indirimsiz': None, 'fiyat': '100 TL'}, {'link': 'https://www.trendyol.com/ekoodukkan/apple-watch-seri-7-45mm-watch-gard-ekran-koruyucu-360-koruma-p-199018153', 'marka': 'Ekoodukkan', 'yildiz': 4, 'baslik': 'Apple Watch Seri 7 45mm Watch Gard Ekran Koruyucu 360 Koruma', 'indirim': None, 'indirimsiz': None, 'fiyat': '49,99 TL'}, {'link': 'https://www.trendyol.com/tria/samsung-galaxy-a32-4g-uyumlu-ici-kadife-silikon-baskili-pembe-kalpli-telefon-kilifi-p-339253749', 'marka': 'Tria', 'yildiz': 4, 'baslik': 'Samsung Galaxy A32 4g Uyumlu Içi Kadife Silikon Baskılı Pembe Kalpli Telefon Kılıfı', 'indirim': None, 'indirimsiz': None, 'fiyat': '59,90 TL'}, {'link': 'https://www.trendyol.com/mooodcase/tasarim-odullu-iphone-11-uyumlu-luks-lens-korumali-seffaf-arka-kapak-p-156545267', 'marka': 'mooodcase', 'yildiz': 4, 'baslik': 'Tasarım Ödüllü Iphone 11 Uyumlu Lüks Lens Korumalı Şeffaf Arka Kapak', 'indirim': None, 'indirimsiz': None, 'fiyat': '59,90 TL'}, {'link': 'https://www.trendyol.com/tria/xiaomi-redmi-note-9s-9-pro-uyumlu-kamera-korumali-kirmizi-ipli-boyun-askili-telefon-kilifi-p-372056368', 'marka': 'Tria', 'yildiz': 5, 'baslik': 'Xiaomi Redmi Note 9s / 9 Pro Uyumlu Kamera Korumalı Kırmızı Ipli Boyun Askılı Telefon Kılıfı', 'indirim': None, 'indirimsiz': None, 'fiyat': '38,86 TL'}, {'link': 'https://www.trendyol.com/deji/gunes-enerjili-powerbank-turuncu-dj-ol02-p-43306565', 'marka': 'Deji', 'yildiz': 4, 'baslik': 'Güneş Enerjili Powerbank -turuncu - Dj-ol02', 'indirim': None, 'indirimsiz': None, 'fiyat': 'Son 30 Günün En Düşük Fiyatı!427,31 TL'}, {'link': 'https://www.trendyol.com/butikcase/iphone-13-desenli-tom-and-jerry-seffaf-telefon-kilifi-p-450354619', 'marka': 'butikcase', 'yildiz': 3, 'baslik': 'Iphone 13 Desenli Tom And Jerry Şeffaf Telefon Kılıfı', 'indirim': None, 'indirimsiz': None, 'fiyat': '31,55 TL'}, {'link': 'https://www.trendyol.com/rotaks/samsung-galaxy-a13-4g-uyumlu-kilif-surgulu-slayt-kamera-korumali-baskili-p-361422012', 'marka': 'Rotaks', 'yildiz': 4, 'baslik': 'Samsung Galaxy A13 4g Uyumlu Kılıf Sürgülü Slayt Kamera Korumalı Baskılı', 'indirim': None, 'indirimsiz': None, 'fiyat': '58,30 TL'}, {'link': 'https://www.trendyol.com/kilifoloji/iphone-14-kirilmaz-cam-komple-seffaf-p-444095851', 'marka': 'Kılıfoloji', 'yildiz': 4, 'baslik': 'Iphone 14 Kırılmaz Cam Komple Şeffaf', 'indirim': None, 'indirimsiz': None, 'fiyat': 'Son 30 Günün En Düşük Fiyatı!23,02 TL19,99 TL'}, {'link': 'https://www.trendyol.com/ovada/iphone-11-uyumlu-kamera-koruma-cikintili-desenli-hologramli-renk-degistiren-luks-kilif-p-391572611', 'marka': 'OVADA', 'yildiz': 5, 'baslik': 'Iphone 11 Uyumlu Kamera Koruma Çıkıntılı Desenli Hologramlı Renk Değiştiren Lüks Kılıf', 'indirim': None, 'indirimsiz': None, 'fiyat': '89,24 TL'}, {'link': 'https://www.trendyol.com/butikcase/uyumlu-iphone-11-mutlu-smile-kamera-korumali-telefon-kilifi-p-324663932', 'marka': 'butikcase', 'yildiz': 4, 'baslik': 'Uyumlu Iphone 11 Mutlu Smile Kamera Korumalı Telefon Kılıfı', 'indirim': None, 'indirimsiz': None, 'fiyat': '31,98 TL'}, {'link': 'https://www.trendyol.com/ecr-mobile/apple-watch-7-8-45mm-ile-uyumlu-akilli-saat-ekran-koruyucu-2-adet-p-193172414', 'marka': 'Ecr Mobile', 'yildiz': 3, 'baslik': 'Apple Watch 7/8 45mm Ile Uyumlu Akıllı Saat Ekran Koruyucu(2 Adet)', 'indirim': None, 'indirimsiz': None, 'fiyat': '39,99 TL'}, {'link': 'https://www.trendyol.com/artin/2-adet-cep-telefonu-hoparloru-icin-toz-onleyici-sticker-telefon-hoparlor-koruyucu-1-6-cm-2-2-cm-p-411414173', 'marka': 'artin', 'yildiz': 3, 'baslik': '2 Adet Cep Telefonu Hoparlörü Için Toz Önleyici Sticker-telefon Hoparlör Koruyucu 1.6 Cm-2.2 Cm', 'indirim': None, 'indirimsiz': None, 'fiyat': '19 TL'}, {'link': 'https://www.trendyol.com/baseus/halo-usb-type-c-40w-flash-sarj-2-metre-usb-sarj-kablosu-p-32868000', 'marka': 'Baseus', 'yildiz': 4, 'baslik': 'Halo Usb Type-c 40w Flash Şarj 2 Metre Usb Şarj Kablosu', 'indirim': None, 'indirimsiz': None, 'fiyat': 'Son 14 Günün En Düşük Fiyatı!123,80 TL'}, {'link': 'https://www.trendyol.com/emybox/apple-iphone-7-8-se-2020-uyumlu-logo-detayli-lens-korumali-renkli-seffaf-silikon-telefon-kilifi-p-647406318', 'marka': 'emybox', 'yildiz': 0, 'baslik': 'Apple Iphone 7/8 Se 2020 Uyumlu Logo Detaylı Lens Korumalı Renkli Şeffaf Silikon Telefon Kılıfı', 'indirim': None, 'indirimsiz': None, 'fiyat': '59,95 TL'}, {'link': 'https://www.trendyol.com/go-aksesuar/iphone-11-kilif-luxury-koseli-12-gorunumlu-yumusak-silikon-kamera-korumali-kilif-uyumlu-p-388179419', 'marka': 'Go Aksesuar', 'yildiz': 4, 'baslik': 'Iphone 11 Kılıf Luxury (köşeli 12 Görünümlü) Yumuşak Silikon Kamera Korumalı Kılıf Uyumlu', 'indirim': None, 'indirimsiz': None, 'fiyat': '48,99 TL'}, {'link': 'https://www.trendyol.com/trendteknomarket/samsung-galaxy-a13-a23-kamera-korumali-jerry-dolar-baskili-desenli-kilif-p-466585279', 'marka': 'TRENDTEKNOMARKET', 'yildiz': 4, 'baslik': 'Samsung Galaxy A13 / A23 Kamera Korumalı Jerry Dolar Baskılı Desenli Kılıf', 'indirim': None, 'indirimsiz': None, 'fiyat': '59,99 TL'}, {'link': 'https://www.trendyol.com/apple/iphone-20w-12-12-pro-max-hizli-sarj-aleti-seti-20w-adaptor-usb-c-kablo-p-94952822', 'marka': 'Apple', 'yildiz': 3, 'baslik': 'Iphone 20w 12/12 Pro Max Hızlı Şarj Aleti Seti 20w Adaptör + Usb-c Kablo', 'indirim': None, 'indirimsiz': None, 'fiyat': '699 TL'}, {'link': 'https://www.trendyol.com/vivo/y16-kilif-kamera-korumali-yumusak-seffaf-ince-super-p-648450386', 'marka': 'vivo', 'yildiz': 5, 'baslik': 'Y16 Kılıf Kamera Korumalı Yumuşak Şeffaf Ince (süper)', 'indirim': None, 'indirimsiz': None, 'fiyat': '49,99 TL'}, {'link': 'https://www.trendyol.com/powerfox/iphone-7-plus-8-plus-uyumlu-surgulu-kamera-korumali-silikon-kilif-p-281022758', 'marka': 'Powerfox', 'yildiz': 4, 'baslik': 'Iphone 7 Plus 8 Plus Uyumlu Sürgülü Kamera Korumalı Silikon Kılıf', 'indirim': None, 'indirimsiz': None, 'fiyat': '26,99 TL'}, {'link': 'https://www.trendyol.com/go-aksesuar/iphone-13-uyumlu-extra-kamera-korumali-kamerasi-cam-lensli-lazer-kilif-p-387587977', 'marka': 'Go Aksesuar', 'yildiz': 4, 'baslik': 'Iphone 13 Uyumlu Extra Kamera Korumalı (kamerası Cam Lensli) Lazer Kılıf', 'indirim': None, 'indirimsiz': None, 'fiyat': '54,99 TL'}, {'link': 'https://www.trendyol.com/spelt/sarj-aleti-kablosu-kablo-kordon-koruyucu-spiral-sarma-kilif-koruma-silver-shine-p-220308894', 'marka': 'Spelt', 'yildiz': 4, 'baslik': 'Şarj Aleti Kablosu Kablo Kordon Koruyucu Spiral Sarma Kılıf Koruma Silver Shine', 'indirim': None, 'indirimsiz': None, 'fiyat': '49,90 TL'}, {'link': 'https://www.trendyol.com/co/samsung-galaxy-a32-4g-mat-hayalet-ekran-kirilmaz-cam-seramik-ekran-koruyucu-film-p-462773922', 'marka': 'Co', 'yildiz': 4, 'baslik': 'Samsung Galaxy A32 4g Mat Hayalet Ekran Kırılmaz Cam Seramik Ekran Koruyucu Film', 'indirim': None, 'indirimsiz': None, 'fiyat': '58,98 TL'}, {'link': 'https://www.trendyol.com/go-aksesuar/iphone-8-plus-uyumlu-seramik-nano-beyaz-esnek-tam-full-kaplayan-kirilmaz-cam-ekran-koruyucu-p-131330404', 'marka': 'Go Aksesuar', 'yildiz': 4, 'baslik': 'Iphone 8 Plus Uyumlu Seramik Nano Beyaz Esnek Tam Full Kaplayan Kırılmaz Cam Ekran Koruyucu', 'indirim': None, 'indirimsiz': None, 'fiyat': '29,99 TL'}, {'link': 'https://www.trendyol.com/kvk-privacy/iphone-12-uyumlu-seffaf-kilif-airbag-antishock-koseli-darbe-emici-seffaf-kilif-p-218115114', 'marka': 'KVK PRİVACY', 'yildiz': 4, 'baslik': 'Iphone 12 Uyumlu Şeffaf Kılıf Airbag Antishock Köşeli Darbe Emici Şeffaf Kılıf', 'indirim': None, 'indirimsiz': None, 'fiyat': '39,90 TL'}]

urun_detay = trend_urun.detay_ver(
    urun_link = "https://www.trendyol.com/glassy/iphone-6s-plus-tam-kaplayan-kirilmaz-cam-9d-siyah-p-63170604"
)
print(urun_detay)
    # » {'link': 'https://trendyol.com/glassy/iphone-6s-plus-tam-kaplayan-kirilmaz-cam-9d-siyah-p-63170604', 'marka': 'GLASSY', 'baslik': 'Iphone 6s Plus Tam Kaplayan Kırılmaz Cam 9d Siyah sbdcwey8rfh', 'resim': 'https://cdn.dsmcdn.com/mnresize/1200/1800/ty26/product/media/images/20201123/23/30612094/110618929/0/0_org_zoom.jpg', 'gercek': None, 'indirimli': None, 'kampanya': None, 'son_fiyat': '21,90 TL', 'yorumlar': [{'kullanici': 'Z** S**', 'elit': True, 'tarih': '11 Nisan 2022', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'Çok çok güzel paketlenmişti hasarsız geldi teşekkür ederim beş yıldızı fazlasıyla hakediyo'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '23 Şubat 2022', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'Ürüne fazla özen göstermişler kırılmaması için sağlam geldi teşekkürler'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '27 Mart 2022', 'satici': 'iphonoloji', 'yildiz': 1, 'yorum': 'aşırı kalitesiz ürün'}, {'kullanici': 'A** G**', 'elit': False, 'tarih': '17 Ocak 2023', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'Sorunsuz geldi teşekkürler'}, {'kullanici': 'H** B**', 'elit': False, 'tarih': '15 Ocak 2023', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': '6S Plus telefonuma tam oturdu'}, {'kullanici': 'g** d**', 'elit': False, 'tarih': '30 Ocak 2022', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'Çok şık ve özel korumalı olarak gönderilmiş sapasağlam ulaştı elime çok teşekkür ederim ☺️'}, {'kullanici': 'O** M** M**', 'elit': False, 'tarih': '28 Ocak 2023', 'satici': 'Telehome', 'yildiz': 5, 'yorum': 'İkitane gonderildi iiiii'}, {'kullanici': 'Sare Y.', 'elit': False, 'tarih': '12 Ağustos 2021', 'satici': 'JoyPlus', 'yildiz': 5, 'yorum': 'Ürün cok güzel .Kesinlikle tavsiye edilir.Mükemmel bir fiyatı vardı ayrıca indirm kullandım.Harika fiyata harika bir ürün aldım.Tavsiye edilir.Paketini ve ürünün resmini  paylasıyorum.Firmaya teşekkürler...'}, {'kullanici': 'A** f** d**', 'elit': False, 'tarih': '6 Aralık 2022', 'satici': 'iphonoloji', 'yildiz': 1, 'yorum': 'kırık geldi'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '18 Mart 2022', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'Ürün kaliteli tavsiye ediyorum'}, {'kullanici': 'B** D**', 'elit': True, 'tarih': '8 Aralık 2022', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'korunaklı bir şekilde kırılmamış halde elime ulasti..mendiller de yanindaydi'}, {'kullanici': 'Erdal A.', 'elit': False, 'tarih': '11 Ocak 2022', 'satici': 'Telehome', 'yildiz': 5, 'yorum': 'Kaliteli urun'}, {'kullanici': 'B** T**', 'elit': False, 'tarih': '14 Şubat 2022', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'Kaliteli güzel beğendim'}, {'kullanici': 'Sermin C.', 'elit': False, 'tarih': '23 Nisan 2022', 'satici': 'Adaman', 'yildiz': 5, 'yorum': 'Kalitesi iyi'}, {'kullanici': 'B** S**', 'elit': False, 'tarih': '17 Nisan 2022', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'Güzel beğendim'}, {'kullanici': 'Özgür Ç.', 'elit': False, 'tarih': '13 Şubat 2023', 'satici': 'iphonoloji', 'yildiz': 1, 'yorum': 'Kırılmaz sert cam denilmiş fakat kağıt gibi kırılmaz cam göndermişler. Sakın almayın.'}, {'kullanici': 'F** K**', 'elit': False, 'tarih': '25 Haziran 2022', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'Çok güzel oldu teşekkürler'}, {'kullanici': 'F** K**', 'elit': False, 'tarih': '7 Ocak 2023', 'satici': 'iphonoloji', 'yildiz': 1, 'yorum': 'Yapışkanı yok. Hiçbir işe yaramaz para boşa gitti'}, {'kullanici': 'S** S**', 'elit': False, 'tarih': '18 Mayıs 2022', 'satici': 'iphonoloji', 'yildiz': 4, 'yorum': 'güzel bir ürün'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '2 Şubat 2023', 'satici': 'Telehome', 'yildiz': 5, 'yorum': 'Gayet güzeldi'}, {'kullanici': 'Ceren K.', 'elit': False, 'tarih': '16 Haziran 2021', 'satici': 'Adaman', 'yildiz': 5, 'yorum': 'Çok güzel iPhone 6 Plus a da oluyor kaliteli fiyatı gayet uygun kırık gelmedi teşekkürler 😊'}, {'kullanici': 'S** D**', 'elit': False, 'tarih': '7 Nisan 2022', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'Çok güzel sağlam geldi'}, {'kullanici': 'Nazan A.', 'elit': False, 'tarih': '22 Mayıs 2022', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'Çok kaliteli sağlam geldi'}, {'kullanici': 'M** Ş**', 'elit': False, 'tarih': '15 Mart 2021', 'satici': 'Baysam', 'yildiz': 5, 'yorum': 'ekranı tam kaplayan muhteşem ürün memnun kaldık tavsiye ederiz'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '26 Aralık 2020', 'satici': 'Telehome', 'yildiz': 3, 'yorum': 'Kutulama iyiydi, normal sert koruma fiyati karsiligi guzel'}, {'kullanici': 'N** T**', 'elit': False, 'tarih': '19 Ocak 2022', 'satici': 'JoyPlus', 'yildiz': 5, 'yorum': 'teşekkür ederim'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '13 Ağustos 2021', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'Gayet sağlam ve hızlı geldi sipariş verdim ertesi gün sabah elime ulaştı taktım çok güzel oldu'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '8 Aralık 2020', 'satici': 'Telehome', 'yildiz': 5, 'yorum': 'Sağlam geldi boyutları tam'}, {'kullanici': 'E** A** E**', 'elit': False, 'tarih': '7 Kasım 2022', 'satici': 'iphonoloji', 'yildiz': 2, 'yorum': 'Kırık geldi'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '14 Haziran 2022', 'satici': 'Telehome', 'yildiz': 1, 'yorum': 'Kırık geldi'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '14 Şubat 2023', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'Ürün gerçekten çok güzel kaliteli ve mükemmel durdu tavsiye ederim'}, {'kullanici': 'D** E**', 'elit': False, 'tarih': '21 Ocak 2022', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'Gayet sağlam geldi paketleme iyiydi…'}, {'kullanici': 'A** A**', 'elit': False, 'tarih': '22 Eylül 2022', 'satici': 'iphonoloji', 'yildiz': 1, 'yorum': 'Ürünü kesinlikle beğenmedim, telefonda boşluklar oluştu, yanında kılıf almıştım kılıf kırıl geldi. Yenisini talep ettim gönderilmedi.'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '16 Aralık 2021', 'satici': 'Telehome', 'yildiz': 1, 'yorum': 'Basit güzel değil'}, {'kullanici': 'Mehmet A. K.', 'elit': False, 'tarih': '9 Haziran 2021', 'satici': 'GO AKSESUAR', 'yildiz': 5, 'yorum': 'Fiyat olarak muhtemelen bundan uygununu bulamazsınız ve çok harika duruyor ürün.'}, {'kullanici': 'Y** Y**', 'elit': False, 'tarih': '15 Ekim 2022', 'satici': 'iphonoloji', 'yildiz': 1, 'yorum': 'Ürünün kalites çok kötü Tm kaplıyor demişler yalan Tm kaplamıyor köşe ve kenarlar açık kaldı iyade edeceğim'}, {'kullanici': 'M** K** Ş**', 'elit': True, 'tarih': '14 Şubat 2022', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'Beklediğim gibi başka camda almıştım gayet memnunum tavsiye ediyorum'}, {'kullanici': 'ö** g**', 'elit': False, 'tarih': '10 Kasım 2022', 'satici': 'iphonoloji', 'yildiz': 4, 'yorum': 'Kaliteli alırken düşünmenize gerek yok'}, {'kullanici': 'H** H** Ç**', 'elit': True, 'tarih': '18 Eylül 2022', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'Hızlı kargo teşekkürler.'}, {'kullanici': 'K** B**', 'elit': False, 'tarih': '11 Ekim 2021', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'iyiydi beğendik'}, {'kullanici': 'Özkan D.', 'elit': False, 'tarih': '11 Temmuz 2021', 'satici': 'GO AKSESUAR', 'yildiz': 5, 'yorum': 'Harika kalite. Kesinlikle burdan alın'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '8 Temmuz 2022', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'Ürün İnanılmaz Başarılı... Şiddetle tavsiye edilir'}, {'kullanici': 'Yunus K.', 'elit': False, 'tarih': '9 Haziran 2021', 'satici': 'Adaman', 'yildiz': 5, 'yorum': 'Ürün 10 numara 5 yıldız kesinlikle şu zamana kadar telefonuma taktığım en iyi ekran koruyucu 10/10 puan veriyorum'}, {'kullanici': 'A** K**', 'elit': False, 'tarih': '30 Ağustos 2021', 'satici': 'JoyPlus', 'yildiz': 5, 'yorum': 'Mükemmelll'}, {'kullanici': 'A** M**', 'elit': False, 'tarih': '29 Ağustos 2021', 'satici': 'GO AKSESUAR', 'yildiz': 1, 'yorum': 'Ürün çok dandik sakın almayın ….'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '21 Aralık 2022', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'Güzel'}, {'kullanici': 'M** Z**', 'elit': False, 'tarih': '16 Ekim 2022', 'satici': 'Telehome', 'yildiz': 5, 'yorum': 'Güzel bir ürün'}, {'kullanici': 'M** K** A**', 'elit': False, 'tarih': '7 Ekim 2022', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'Çok başarılı çok kaliteli'}, {'kullanici': 'N** O**', 'elit': False, 'tarih': '1 Ekim 2022', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'Beğendim çok güzel'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '12 Eylül 2022', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'piyasadakilerden iyi, kaç aydır kullanıyorum gayet başarılı'}, {'kullanici': 'B** K**', 'elit': True, 'tarih': '17 Ağustos 2022', 'satici': 'Telehome', 'yildiz': 5, 'yorum': 'Güzel kaliteli bir ürün'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '2 Ekim 2021', 'satici': 'JoyPlus', 'yildiz': 5, 'yorum': 'Harika bir ürün fiyatını kesinlikle hakediyor'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '12 Mayıs 2021', 'satici': 'iphonoloji', 'yildiz': 1, 'yorum': 'Ekranı tam kaplamıyor. Kenarları açık kalıyor.'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '22 Ekim 2022', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'Merhabalar. Ürünün fiyatı ucuz diye endişeyle aldım fakat ürün geldiğinde pahalı olanlar kadar kaliteli olmasına çok sevindim. Bu ürünü gönül rahatlığıyla alabilirsiniz. Gerçekten kalitesi üst seviye. Teşekkürler GLASSY'}, {'kullanici': 'G** G**', 'elit': True, 'tarih': '1 Kasım 2022', 'satici': 'iphonoloji', 'yildiz': 1, 'yorum': 'Paramparça bir halde geldi'}, {'kullanici': 't** d**', 'elit': False, 'tarih': '16 Kasım 2021', 'satici': 'JoyPlus', 'yildiz': 5, 'yorum': 'Fiyatına göre kaliteli tamamem kapsıyor ekranı alacak arkadaşar kacırmayın derim ayrıca ekranın üst kısmı kırık olanlar alıp kullanabilirler ben öyle yaptım'}, {'kullanici': 'I** C**', 'elit': False, 'tarih': '10 Eylül 2022', 'satici': 'iphonoloji', 'yildiz': 4, 'yorum': 'Ütün güzel'}, {'kullanici': 'Muhammed E.', 'elit': False, 'tarih': '7 Nisan 2022', 'satici': 'iphonoloji', 'yildiz': 4, 'yorum': 'güzel ürün hızlı kargo'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '13 Kasım 2022', 'satici': 'Telehome', 'yildiz': 1, 'yorum': 'Kesinlikle almayın ikinci kez gönderdiler kırık çıkıyor'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '27 Ekim 2021', 'satici': 'JoyPlus', 'yildiz': 5, 'yorum': 'Urun cok ince kirilmaz cam degil de ince bir jelatin gibi ekrani sadece cizikten korur baska modeller bakmanizi tavsiye ederim'}, {'kullanici': 't** s**', 'elit': False, 'tarih': '23 Haziran 2021', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'Kırılmaz Cam koruyucu alacaksanız . Bunu tercih etmelisiniz . Gördüklerimin en iyisi . 10 numara özel kabı bile diğerlerinde farklı . Teşekkür ederim'}, {'kullanici': 'İ** K**', 'elit': False, 'tarih': '15 Mart 2022', 'satici': 'JoyPlus', 'yildiz': 5, 'yorum': 'Güzel ve kullanışlı gayet kalın'}, {'kullanici': 'K** T**', 'elit': True, 'tarih': '14 Temmuz 2022', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'Ürünü 2 defadır yanlış gönderiyosunuz 6s için istedim ekrana takınca ön kamera kapanıyor.'}, {'kullanici': 'N** P**', 'elit': True, 'tarih': '19 Mart 2022', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'güzel fiyatına göre'}, {'kullanici': 'G** I**', 'elit': False, 'tarih': '8 Eylül 2021', 'satici': 'JoyPlus', 'yildiz': 4, 'yorum': 'Dört yıldız vermemin nedeni siyah çerçeveli olması. Onun dışında çok çok güzel bir ürün. Tüm ekranı kapladı, kullanımı orjinal ekran gibi, Paketleme harika ve beklentimi karşıladı'}, {'kullanici': 'AHMET C. A.', 'elit': False, 'tarih': '22 Nisan 2021', 'satici': 'JoyPlus', 'yildiz': 5, 'yorum': 'Gayet başarılı ürün hızlı kargo teşekkürler'}, {'kullanici': 'A** E**', 'elit': False, 'tarih': '16 Mart 2022', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'Telefona tam oturdu kenarlarda boşluk kalmadı 👏🏻👏🏻'}, {'kullanici': 'A** K**', 'elit': False, 'tarih': '2 Temmuz 2022', 'satici': 'iphonoloji', 'yildiz': 1, 'yorum': 'Sakın almayın beş para etmez. Daha ilk günden yere düşmediği halde köşeden çatladı ikinci gün orta tuşun kenarı çatladı. Demek ki birde yere düşse ne olacak acaba sözde ekran koruyucu.'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '9 Nisan 2022', 'satici': 'iphonoloji', 'yildiz': 4, 'yorum': 'Ekranı tam kaplıyor ve çok ince değil. İnce olmaması güzel ancak çok sert olmayan darbelerde bile çatlıyor maalesef. Görüntü olarak iyi duruyor.'}, {'kullanici': 'İ** D**', 'elit': False, 'tarih': '15 Mayıs 2022', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'arkadaşıma almıştım ürün güzel geldi fiyatıda oldukça uygun kendimede aldım ben çok beğendim alın aldırın'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '21 Haziran 2021', 'satici': 'JoyPlus', 'yildiz': 2, 'yorum': 'Ürün şekil olarak güzel . Video izleyip güzelce taktım. 1 hafta oldu , kırılmaz camın kenarları çatlamaya başlamış. (Düşme vs olmadı) İyice çatlayacak,çöp olana kadar da öyle kullanacaksınız. Ucuz etin yahnisi hesabı. Ucuz zaten diyen alsın, yoksa tavsiye etmem'}, {'kullanici': 'feyza o.', 'elit': False, 'tarih': '21 Haziran 2021', 'satici': 'JoyPlus', 'yildiz': 5, 'yorum': 'çok kolay taktım 10 tl ye alınabilecek en güzel cam'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '15 Aralık 2021', 'satici': 'iphonoloji', 'yildiz': 3, 'yorum': 'Çok ince ve plastik gibi. Fakat iş görüyor diyebilirim.'}, {'kullanici': 'M** E** Ö**', 'elit': False, 'tarih': '26 Kasım 2022', 'satici': 'Adaman', 'yildiz': 5, 'yorum': 'tesekkurler tam bir fp urunu'}, {'kullanici': 'B** Y**', 'elit': False, 'tarih': '1 Kasım 2021', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'güzel'}, {'kullanici': 'Ahmet G.', 'elit': False, 'tarih': '23 Şubat 2022', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': '6s yerine 6s plus siparişi vermişim hediye ettik memnun kaldılar'}, {'kullanici': 'F** K** D**', 'elit': False, 'tarih': '23 Mart 2022', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'Hem fiyatı iyi hem görünüşü iyi kalın sağlam'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '19 Haziran 2021', 'satici': 'JoyPlus', 'yildiz': 4, 'yorum': 'Telefon camı tam olarak kaplamıyor. Ama bu fiyata gayet normal'}, {'kullanici': 'Emre T. U.', 'elit': False, 'tarih': '11 Temmuz 2021', 'satici': 'Adaman', 'yildiz': 5, 'yorum': 'Fiyatına göre iyi'}, {'kullanici': 'F** Ö**', 'elit': False, 'tarih': '13 Eylül 2022', 'satici': 'Telehome', 'yildiz': 5, 'yorum': 'Siparişim eksik ve yanlış geldi. Soru bölümünden ulaşamadım. Yanlış gelen ürünü gönderirken diğerini de göndermem gerekir mi? Satıcıdan dönüş bekliyorum.'}, {'kullanici': 'Yağız G.', 'elit': False, 'tarih': '1 Ağustos 2022', 'satici': 'iphonoloji', 'yildiz': 1, 'yorum': 'Kamera tarafı kırık geldi'}, {'kullanici': 'N** k**', 'elit': False, 'tarih': '30 Eylül 2022', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'Ürünün hem fiyatı uygun hem de göründüğü gibi kaliteli bir ürün.'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '26 Nisan 2021', 'satici': 'Adaman', 'yildiz': 1, 'yorum': 'İphone 6s plus cam sipariş verdim ama çok küçük geldi ve kargo hizli gelmedi Çok geçti'}, {'kullanici': 'F** Z**', 'elit': False, 'tarih': '21 Mart 2022', 'satici': 'GO AKSESUAR', 'yildiz': 5, 'yorum': 'Ürün anlatıldığı gibi.tavsiye ederim.'}, {'kullanici': 'Merve A.', 'elit': True, 'tarih': '9 Şubat 2023', 'satici': 'iphonoloji', 'yildiz': 3, 'yorum': 'Kendimiz rahatlıkla uyguladık ama ufak bir darbede bile hemen çatlıyor'}, {'kullanici': 'Seda K.', 'elit': False, 'tarih': '9 Mart 2021', 'satici': 'Telehome', 'yildiz': 5, 'yorum': 'Tam istediğim gibi'}, {'kullanici': 'emine y.', 'elit': True, 'tarih': '27 Mayıs 2021', 'satici': 'enuygun01', 'yildiz': 5, 'yorum': 'Ürün güzel kalın cam 6s plus a uygun. Ekranı tam kapatıyor sondaki kavisli küçük kısmı kapatmıyor düz bir ürün. Bu fiyata alınabilecek güzel bir ürün tavsiye ederim.kendiniz yapacaksanız hiçbir toz kalmayacak şekilde temizledikten sonra uygulayın çok kolay uygulaması'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '7 Temmuz 2022', 'satici': 'iphonoloji', 'yildiz': 5, 'yorum': 'ürün güzel ama beyaz telefona siyah almayın yama gibi duruyo'}, {'kullanici': 'N** K**', 'elit': False, 'tarih': '13 Eylül 2022', 'satici': 'iphonoloji', 'yildiz': 2, 'yorum': 'Çok kalın tabaka gibi daha takarken kenarı attı.'}, {'kullanici': 'i** ç**', 'elit': False, 'tarih': '17 Aralık 2022', 'satici': 'iphonoloji', 'yildiz': 1, 'yorum': 'Defolu ürün yollanmışsınız yapışkansız sadece ekran var jelatini vardır diye acmaya calıstım ama ekran kırıldı zaten'}, {'kullanici': 'M** H**', 'elit': False, 'tarih': '19 Ocak 2022', 'satici': 'iphonoloji', 'yildiz': 1, 'yorum': 'Kırılmaz cam değil incecik bi şey tavsiye etmiyorum'}, {'kullanici': 'B** T**', 'elit': False, 'tarih': '5 Eylül 2022', 'satici': 'Telehome', 'yildiz': 1, 'yorum': 'Benim istediğim aslında gelen fotoğrafa bakabilirsiniz bide eksik geldi'}, {'kullanici': 'Mahsun C.', 'elit': False, 'tarih': '20 Mayıs 2021', 'satici': 'iphonoloji', 'yildiz': 1, 'yorum': 'Ürün kırık geldi, iade için kod vermiyorsunuz şikayetçiyim'}, {'kullanici': 'S** A**', 'elit': False, 'tarih': '8 Haziran 2021', 'satici': 'Adaman', 'yildiz': 5, 'yorum': 'ürünün hem figsti uygun hem görüldüğü gibi kaliteli bir ürün'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '16 Haziran 2021', 'satici': 'iphonoloji', 'yildiz': 4, 'yorum': 'İlk defa internetten kırılmaz cam aldım ve gayet kaliteli çıktı.'}, {'kullanici': 'F** Y**', 'elit': False, 'tarih': '28 Aralık 2022', 'satici': 'iphonoloji', 'yildiz': 1, 'yorum': 'hemen kirildi yani cok cabuk kirilio'}, {'kullanici': 'D** U**', 'elit': False, 'tarih': '16 Ocak 2021', 'satici': 'Telehome', 'yildiz': 1, 'yorum': '2?gunde catladııı'}, {'kullanici': 'G** E**', 'elit': False, 'tarih': '28 Ağustos 2021', 'satici': 'JoyPlus', 'yildiz': 5, 'yorum': 'urun güzel de ben takamadim'}, {'kullanici': 'Hümeyra D.', 'elit': False, 'tarih': '3 Temmuz 2021', 'satici': 'JoyPlus', 'yildiz': 5, 'yorum': 'Çok güzel bayıldım çiziklerimi kapattı ve fiyatına görede kalın sağlam çok güzel✌🏻👍'}, {'kullanici': 'Ş** G**', 'elit': True, 'tarih': '28 Temmuz 2021', 'satici': 'Adaman', 'yildiz': 1, 'yorum': '1 gün kullanmadan cebimde kenarları kırıldı.'}, {'kullanici': 'B** S**', 'elit': True, 'tarih': '17 Eylül 2021', 'satici': 'iphonoloji', 'yildiz': 1, 'yorum': 'Ürün 7 günde gelmedi ve iadeye düştü bir de kargo parasını kilitlemeye çalıştılar'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '29 Aralık 2020', 'satici': 'Telehome', 'yildiz': 1, 'yorum': 'Ürün üm kargoda kırıldı bu ne rezillik'}, {'kullanici': 'R** A**', 'elit': False, 'tarih': '23 Ekim 2021', 'satici': 'JoyPlus', 'yildiz': 5, 'yorum': 'Gerçekten kaliteli ben kendim takıyorum üstelik kusursuz çok iyi'}, {'kullanici': 'E** D**', 'elit': False, 'tarih': '1 Ekim 2021', 'satici': 'Telehome', 'yildiz': 1, 'yorum': 'İlk düşüşte çatladı kalitesiz 🤦🏽\u200d♀️🤦🏽\u200d♀️'}, {'kullanici': 'A** D**', 'elit': False, 'tarih': '15 Ekim 2021', 'satici': 'iphonoloji', 'yildiz': 1, 'yorum': 'Kırılmaz cam diye aldik. Jelatinimsi bir sey geldi. 8 liralik ürünün iadesiyle ugrasmak istemiyorum ama isinize özen gosterin lütfen..'}, {'kullanici': 'Ozge D.', 'elit': True, 'tarih': '22 Haziran 2021', 'satici': 'JoyPlus', 'yildiz': 5, 'yorum': 'Mükemmel paketleme ve kaliteli ürün iyi ki almışım  indirimde aldım fakat fiyatıda pahalı olsa satıcı son kuruşuna kadar hakediyor teşekkür ederim.'}, {'kullanici': 'N** A**', 'elit': False, 'tarih': '14 Eylül 2021', 'satici': 'JoyPlus', 'yildiz': 5, 'yorum': 'aşırı güzel geldi paketlenmesi kalitesi vs vs çok iyi çok memnun kaldım'}, {'kullanici': 'N** H**', 'elit': True, 'tarih': '22 Eylül 2021', 'satici': 'JoyPlus', 'yildiz': 5, 'yorum': 'Cok guzel hakiketen cok begendim takdir ederim elinize saglik kargolama urun paketlenmesi korunmasi superdi almanizi tavsiye ederim👍🏻'}, {'kullanici': 'nevroz a.', 'elit': True, 'tarih': '12 Mayıs 2021', 'satici': 'JoyPlus', 'yildiz': 5, 'yorum': 'İkinci siparişim 🤌🏻 Paketleme süper takmak çok rahattı teşekkürler 🙏🏻'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '27 Ağustos 2021', 'satici': 'JoyPlus', 'yildiz': 5, 'yorum': 'Kargom çok hızlı elime ulaştı Ürün göründüğü gibi çok beğendim çok kaliteli paketlemede çok iyiydi satıcıya çok teşekkür ederim'}, {'kullanici': 'Duygu E.', 'elit': False, 'tarih': '23 Ağustos 2021', 'satici': 'JoyPlus', 'yildiz': 5, 'yorum': 'Ürünün paketlemesine bayıldım çok kaliteli bir cam geldi çok teşekkür ederim.💜'}, {'kullanici': 'B** Y**', 'elit': False, 'tarih': '1 Aralık 2021', 'satici': 'JoyPlus', 'yildiz': 5, 'yorum': 'Ürün çok ama çok kaliteli. Ekranı tam kapatıyor. Siyah çerçeveli. Ambalajı süper. Ancak Eylül’de 8,5tl iken Kasım’da 17tl’ye olmuş!!! JoyPlus mağazasından aldım. Başka satıcıda yine eski fiyattan vardı; ama riske etmemek için yine aynı satıcıdan aldım, Ama insaf yani, 2 katı olmuş 2 ayda!!!'}, {'kullanici': 'Beyza A.', 'elit': True, 'tarih': '18 Haziran 2021', 'satici': 'JoyPlus', 'yildiz': 5, 'yorum': 'Teşekkür ederim çok güzel paketlenmiş ve kalitesi baya güzel böyle işini yapan insanları çok seviyorum işin rast gitsin'}, {'kullanici': 's** O**', 'elit': False, 'tarih': '18 Ocak 2022', 'satici': 'JoyPlus', 'yildiz': 5, 'yorum': 'Hızlı teslimat özenli paketlenmişti teşekkürler'}, {'kullanici': 'S** Ş**', 'elit': True, 'tarih': '23 Eylül 2021', 'satici': 'JoyPlus', 'yildiz': 4, 'yorum': 'Sırf yorum gözüksün diye 5 yıldız verdim, iPhone 6 cam almıştım ama gelen 7 plus uğraşıp geri iade edicem parası sorun değil ama yapılan ayıp. Paketlemesi sağlam gönderimi hızlı o konuda firmaya teşekkür ederim.'}, {'kullanici': 'E** N** K**', 'elit': False, 'tarih': '29 Ekim 2021', 'satici': 'JoyPlus', 'yildiz': 3, 'yorum': 'Ürün gayet güzel,kaliteli. Paketlenmesi de özenli ve güzel bir şekilde geldi.'}, {'kullanici': 'Ş** S**', 'elit': True, 'tarih': '5 Temmuz 2021', 'satici': 'JoyPlus', 'yildiz': 5, 'yorum': 'güzel paketleme'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '6 Temmuz 2021', 'satici': 'JoyPlus', 'yildiz': 5, 'yorum': 'ben ürünü yanlış almışım fakat ürün baya kaliteli duruyor sadece paketi on lira eder :)'}, {'kullanici': 'B** B**', 'elit': True, 'tarih': '13 Mart 2021', 'satici': 'Baysam', 'yildiz': 5, 'yorum': 'Kötü yorumlara rağmen 2 adet sipariş ettim satıcıyla da güzel paketlemesi için iletişime geçtim. Ürün gayet güzel uygun fiyatlı kırılmadan elime ulaştı👍🏻'}, {'kullanici': 'Muhammet Ç.', 'elit': False, 'tarih': '8 Mart 2021', 'satici': 'Baysam', 'yildiz': 1, 'yorum': '2 tanesi kırık geldi paketide bıçak ile sanki 3 4 yerden kesmişler. bence indirimli diye kırık gönderildi'}, {'kullanici': 'H** C**', 'elit': False, 'tarih': '3 Ağustos 2021', 'satici': 'JoyPlus', 'yildiz': 5, 'yorum': 'Çok iyi iş görür bir ürün tek bir çizik dahi yoktu'}, {'kullanici': 'S** K**', 'elit': False, 'tarih': '13 Haziran 2021', 'satici': 'JoyPlus', 'yildiz': 3, 'yorum': 'Cam güzel tam oldu ama paramparça geldi ya neden güzel paketleme yok bunun sonucu ne olucak şimdi yorumumu da yayınlatmıyorsunuz'}, {'kullanici': 'h** ç**', 'elit': True, 'tarih': '21 Ocak 2022', 'satici': '6parmak', 'yildiz': 5, 'yorum': 'Ürün çok güzelpaketlenmişti ama ben yanlış almışım bu yüzden iade ettim.'}, {'kullanici': 'D** A**', 'elit': False, 'tarih': '29 Kasım 2021', 'satici': 'Adaman', 'yildiz': 4, 'yorum': '6 plus yazıldıgı halde 6s ıle uyumlu urun gondermısler 🤦🏻\u200d♀️kafayı yememek elde degıl bjde ben bu urune kargo parası odedım'}, {'kullanici': 'B** Y**', 'elit': False, 'tarih': '2 Haziran 2021', 'satici': 'JoyPlus', 'yildiz': 5, 'yorum': '6 adet aldım hepsi sorunsuz ulaştı ürünlerde bitane bile çizik yok,teşekkürler'}, {'kullanici': 'E** E**', 'elit': False, 'tarih': '19 Aralık 2022', 'satici': 'JoyPlus', 'yildiz': 1, 'yorum': '1 hafta ürünü göndermedi. mesajıma cevap vermedi. gördüğüm en kötü satıcı. siparişi sonunda iptal ettim.'}, {'kullanici': 'i** k**', 'elit': False, 'tarih': '25 Ağustos 2021', 'satici': 'Adaman', 'yildiz': 2, 'yorum': 'ben 6s plus camı istemiştim fakat 6s camı geldi ama mat olması güzel doğru gönderselerdi iyiydi'}, {'kullanici': 'N** V**', 'elit': False, 'tarih': '2 Aralık 2021', 'satici': 'Adaman', 'yildiz': 1, 'yorum': 'ıphone 6 s plus cam siparişi verdim fakat ıphone 6 s camı geldi. ve yurtdışına çıktım. kıbrıstayım. ürünü nasıl değiştirebiliriz?'}, {'kullanici': '**** ****', 'elit': False, 'tarih': '22 Mart 2021', 'satici': 'Baysam', 'yildiz': 1, 'yorum': 'Ben sizden iphone 6 s plus kırılmaz camını istedim siz başka telefonunkini göndermissiniz ön kamerayı kapatıyor'}]}
```

## 💸 Bağış Yap

**[☕️ Kahve Ismarla](https://KekikAkademi.org/Kahve)**

## 🌐 Telif Hakkı ve Lisans

* *Copyright (C) 2022 by* [keyiflerolsun](https://github.com/keyiflerolsun) ❤️️
* [GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007](https://github.com/keyiflerolsun/pyTrendyol/blob/master/LICENSE) *Koşullarına göre lisanslanmıştır..*

## ♻️ İletişim

*Benimle iletişime geçmek isterseniz, **Telegram**'dan mesaj göndermekten çekinmeyin;* [@keyiflerolsun](https://t.me/KekikKahve)

##

> **[@KekikAkademi](https://t.me/KekikAkademi)** *için yazılmıştır..*