"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const ec2 = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-ec2-vpc');
const vpc = new ec2.Vpc(stack, 'MyVpc');
// Test Security Group Rules
const sg = new ec2.SecurityGroup(stack, 'SG', { vpc });
const rules = [
    ec2.Port.icmpPing(),
    ec2.Port.icmpType(128),
    ec2.Port.allIcmp(),
    ec2.Port.allUdp(),
    ec2.Port.udp(123),
    ec2.Port.udpRange(800, 801),
];
for (const rule of rules) {
    sg.addIngressRule(ec2.Peer.anyIpv4(), rule);
}
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcudnBjLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcudnBjLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEscUNBQXFDO0FBQ3JDLDhCQUE4QjtBQUU5QixNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztBQUMxQixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsR0FBRyxFQUFFLGlCQUFpQixDQUFDLENBQUM7QUFFcEQsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxDQUFDLEtBQUssRUFBRSxPQUFPLENBQUMsQ0FBQztBQUV4Qyw0QkFBNEI7QUFDNUIsTUFBTSxFQUFFLEdBQUcsSUFBSSxHQUFHLENBQUMsYUFBYSxDQUFDLEtBQUssRUFBRSxJQUFJLEVBQUUsRUFBRSxHQUFHLEVBQUUsQ0FBQyxDQUFDO0FBRXZELE1BQU0sS0FBSyxHQUFHO0lBQ1osR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLEVBQUU7SUFDbkIsR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDO0lBQ3RCLEdBQUcsQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFO0lBQ2xCLEdBQUcsQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFO0lBQ2pCLEdBQUcsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLEdBQUcsQ0FBQztJQUNqQixHQUFHLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxDQUFDO0NBQzVCLENBQUM7QUFFRixLQUFLLE1BQU0sSUFBSSxJQUFJLEtBQUssRUFBRTtJQUN4QixFQUFFLENBQUMsY0FBYyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLEVBQUUsSUFBSSxDQUFDLENBQUM7Q0FDN0M7QUFFRCxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgKiBhcyBlYzIgZnJvbSAnLi4vbGliJztcblxuY29uc3QgYXBwID0gbmV3IGNkay5BcHAoKTtcbmNvbnN0IHN0YWNrID0gbmV3IGNkay5TdGFjayhhcHAsICdhd3MtY2RrLWVjMi12cGMnKTtcblxuY29uc3QgdnBjID0gbmV3IGVjMi5WcGMoc3RhY2ssICdNeVZwYycpO1xuXG4vLyBUZXN0IFNlY3VyaXR5IEdyb3VwIFJ1bGVzXG5jb25zdCBzZyA9IG5ldyBlYzIuU2VjdXJpdHlHcm91cChzdGFjaywgJ1NHJywgeyB2cGMgfSk7XG5cbmNvbnN0IHJ1bGVzID0gW1xuICBlYzIuUG9ydC5pY21wUGluZygpLFxuICBlYzIuUG9ydC5pY21wVHlwZSgxMjgpLFxuICBlYzIuUG9ydC5hbGxJY21wKCksXG4gIGVjMi5Qb3J0LmFsbFVkcCgpLFxuICBlYzIuUG9ydC51ZHAoMTIzKSxcbiAgZWMyLlBvcnQudWRwUmFuZ2UoODAwLCA4MDEpLFxuXTtcblxuZm9yIChjb25zdCBydWxlIG9mIHJ1bGVzKSB7XG4gIHNnLmFkZEluZ3Jlc3NSdWxlKGVjMi5QZWVyLmFueUlwdjQoKSwgcnVsZSk7XG59XG5cbmFwcC5zeW50aCgpO1xuIl19