"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const ec2_generated_1 = require("./ec2.generated");
/**
 * A VPC endpoint service
 * @resource AWS::EC2::VPCEndpointService
 * @experimental
 */
class VpcEndpointService extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        if (props.vpcEndpointServiceLoadBalancers === undefined || props.vpcEndpointServiceLoadBalancers.length === 0) {
            throw new Error("VPC Endpoint Service must have at least one load balancer specified.");
        }
        this.vpcEndpointServiceLoadBalancers = props.vpcEndpointServiceLoadBalancers;
        this.acceptanceRequired = props.acceptanceRequired !== undefined ? props.acceptanceRequired : true;
        this.whitelistedPrincipals = props.whitelistedPrincipals !== undefined ? props.whitelistedPrincipals : [];
        this.endpointService = new ec2_generated_1.CfnVPCEndpointService(this, id, {
            networkLoadBalancerArns: this.vpcEndpointServiceLoadBalancers.map(lb => lb.loadBalancerArn),
            acceptanceRequired: this.acceptanceRequired
        });
        if (this.whitelistedPrincipals.length > 0) {
            new ec2_generated_1.CfnVPCEndpointServicePermissions(this, "Permissions", {
                serviceId: this.endpointService.ref,
                allowedPrincipals: this.whitelistedPrincipals.map(x => x.arn)
            });
        }
    }
}
exports.VpcEndpointService = VpcEndpointService;
//# sourceMappingURL=data:application/json;base64,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