"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _SimilarityMethod:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType
class _SimilarityMethodEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_SimilarityMethod.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SIMILARITY_METHOD_UNSPECIFIED: _SimilarityMethod.ValueType  # 0
    """If not given, the implementation defaults to cosine similarity."""

    SIMILARITY_METHOD_COSINE: _SimilarityMethod.ValueType  # 1
    """Cosine similarity. [Wikipedia](https://en.wikipedia.org/wiki/Cosine_similarity)."""

    SIMILARITY_METHOD_DYNAMAX_JACCARD: _SimilarityMethod.ValueType  # 2
    """DynaMax Jaccard. [Paper](https://arxiv.org/abs/1904.13264), [Code](https://github.com/babylonhealth/fuzzymax/blob/master/similarity/fuzzy.py)."""

    SIMILARITY_METHOD_MAXPOOL_JACCARD: _SimilarityMethod.ValueType  # 3
    """MaxPool Jaccard. [Paper](https://arxiv.org/abs/1904.13264), [Code](https://github.com/babylonhealth/fuzzymax/blob/master/similarity/fuzzy.py)."""

    SIMILARITY_METHOD_DYNAMAX_DICE: _SimilarityMethod.ValueType  # 4
    """DynaMax Dice. [Paper](https://arxiv.org/abs/1904.13264), [Code](https://github.com/babylonhealth/fuzzymax/blob/master/similarity/fuzzy.py)."""

    SIMILARITY_METHOD_DYNAMAX_OTSUKA: _SimilarityMethod.ValueType  # 5
    """DynaMax Otsuka. [Paper](https://arxiv.org/abs/1904.13264), [Code](https://github.com/babylonhealth/fuzzymax/blob/master/similarity/fuzzy.py)."""

    SIMILARITY_METHOD_WMD: _SimilarityMethod.ValueType  # 6
    """Word Mover's Distance [Gensim Tutorial](https://radimrehurek.com/gensim/auto_examples/tutorials/run_wmd.html)."""

    SIMILARITY_METHOD_EDIT: _SimilarityMethod.ValueType  # 7
    """Levenshtein distance. [Wikipedia](https://en.wikipedia.org/wiki/Levenshtein_distance)."""

    SIMILARITY_METHOD_JACCARD: _SimilarityMethod.ValueType  # 8
    """Jaccard similarity. [Wikipedia](https://en.wikipedia.org/wiki/Jaccard_index)."""

    SIMILARITY_METHOD_ANGULAR: _SimilarityMethod.ValueType  # 9
    """Angular distance. [Wikipedia](https://en.wikipedia.org/wiki/Angular_distance)."""

class SimilarityMethod(_SimilarityMethod, metaclass=_SimilarityMethodEnumTypeWrapper):
    """Possible methods to compute the similarity between two vectors."""
    pass

SIMILARITY_METHOD_UNSPECIFIED: SimilarityMethod.ValueType  # 0
"""If not given, the implementation defaults to cosine similarity."""

SIMILARITY_METHOD_COSINE: SimilarityMethod.ValueType  # 1
"""Cosine similarity. [Wikipedia](https://en.wikipedia.org/wiki/Cosine_similarity)."""

SIMILARITY_METHOD_DYNAMAX_JACCARD: SimilarityMethod.ValueType  # 2
"""DynaMax Jaccard. [Paper](https://arxiv.org/abs/1904.13264), [Code](https://github.com/babylonhealth/fuzzymax/blob/master/similarity/fuzzy.py)."""

SIMILARITY_METHOD_MAXPOOL_JACCARD: SimilarityMethod.ValueType  # 3
"""MaxPool Jaccard. [Paper](https://arxiv.org/abs/1904.13264), [Code](https://github.com/babylonhealth/fuzzymax/blob/master/similarity/fuzzy.py)."""

SIMILARITY_METHOD_DYNAMAX_DICE: SimilarityMethod.ValueType  # 4
"""DynaMax Dice. [Paper](https://arxiv.org/abs/1904.13264), [Code](https://github.com/babylonhealth/fuzzymax/blob/master/similarity/fuzzy.py)."""

SIMILARITY_METHOD_DYNAMAX_OTSUKA: SimilarityMethod.ValueType  # 5
"""DynaMax Otsuka. [Paper](https://arxiv.org/abs/1904.13264), [Code](https://github.com/babylonhealth/fuzzymax/blob/master/similarity/fuzzy.py)."""

SIMILARITY_METHOD_WMD: SimilarityMethod.ValueType  # 6
"""Word Mover's Distance [Gensim Tutorial](https://radimrehurek.com/gensim/auto_examples/tutorials/run_wmd.html)."""

SIMILARITY_METHOD_EDIT: SimilarityMethod.ValueType  # 7
"""Levenshtein distance. [Wikipedia](https://en.wikipedia.org/wiki/Levenshtein_distance)."""

SIMILARITY_METHOD_JACCARD: SimilarityMethod.ValueType  # 8
"""Jaccard similarity. [Wikipedia](https://en.wikipedia.org/wiki/Jaccard_index)."""

SIMILARITY_METHOD_ANGULAR: SimilarityMethod.ValueType  # 9
"""Angular distance. [Wikipedia](https://en.wikipedia.org/wiki/Angular_distance)."""

global___SimilarityMethod = SimilarityMethod


class _EmbeddingLevel:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType
class _EmbeddingLevelEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_EmbeddingLevel.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    EMBEDDING_LEVEL_UNSPECIFIED: _EmbeddingLevel.ValueType  # 0
    """In the default case, no vector is computed."""

    EMBEDDING_LEVEL_DOCUMENT: _EmbeddingLevel.ValueType  # 1
    """Compute one vector for the whole string."""

    EMBEDDING_LEVEL_TOKENS: _EmbeddingLevel.ValueType  # 2
    """Compute vectors for all tokens in the string."""

    EMBEDDING_LEVEL_SENTENCES: _EmbeddingLevel.ValueType  # 3
    """Compute vectors for all sentences found in the string."""

class EmbeddingLevel(_EmbeddingLevel, metaclass=_EmbeddingLevelEnumTypeWrapper):
    pass

EMBEDDING_LEVEL_UNSPECIFIED: EmbeddingLevel.ValueType  # 0
"""In the default case, no vector is computed."""

EMBEDDING_LEVEL_DOCUMENT: EmbeddingLevel.ValueType  # 1
"""Compute one vector for the whole string."""

EMBEDDING_LEVEL_TOKENS: EmbeddingLevel.ValueType  # 2
"""Compute vectors for all tokens in the string."""

EMBEDDING_LEVEL_SENTENCES: EmbeddingLevel.ValueType  # 3
"""Compute vectors for all sentences found in the string."""

global___EmbeddingLevel = EmbeddingLevel


class _Pooling:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType
class _PoolingEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Pooling.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    POOLING_UNSPECIFIED: _Pooling.ValueType  # 0
    """IN the default case, the arithmetic mean should be used."""

    POOLING_MEAN: _Pooling.ValueType  # 1
    """Arithmetic mean of all elements. [Wikipedia](https://en.wikipedia.org/wiki/Arithmetic_mean)."""

    POOLING_MAX: _Pooling.ValueType  # 2
    """Maximum element of vector. [Wikipedia](https://en.wikipedia.org/wiki/Maximum)."""

    POOLING_MIN: _Pooling.ValueType  # 3
    """Minimum element of vector. [Wikipedia](https://en.wikipedia.org/wiki/Minimum)."""

    POOLING_SUM: _Pooling.ValueType  # 4
    """Sum of all elements."""

    POOLING_FIRST: _Pooling.ValueType  # 5
    """First element of vector."""

    POOLING_LAST: _Pooling.ValueType  # 6
    """Last element of vector."""

    POOLING_MEDIAN: _Pooling.ValueType  # 7
    """Median element of vector. [Wikipedia](https://en.wikipedia.org/wiki/Median)."""

    POOLING_GMEAN: _Pooling.ValueType  # 8
    """Geometirc mean of all elements. [Wikipedia](https://en.wikipedia.org/wiki/Geometric_mean)."""

    POOLING_HMEAN: _Pooling.ValueType  # 9
    """Harmonic mean of all elements. [Wikipedia](https://en.wikipedia.org/wiki/Harmonic_mean)."""

class Pooling(_Pooling, metaclass=_PoolingEnumTypeWrapper):
    pass

POOLING_UNSPECIFIED: Pooling.ValueType  # 0
"""IN the default case, the arithmetic mean should be used."""

POOLING_MEAN: Pooling.ValueType  # 1
"""Arithmetic mean of all elements. [Wikipedia](https://en.wikipedia.org/wiki/Arithmetic_mean)."""

POOLING_MAX: Pooling.ValueType  # 2
"""Maximum element of vector. [Wikipedia](https://en.wikipedia.org/wiki/Maximum)."""

POOLING_MIN: Pooling.ValueType  # 3
"""Minimum element of vector. [Wikipedia](https://en.wikipedia.org/wiki/Minimum)."""

POOLING_SUM: Pooling.ValueType  # 4
"""Sum of all elements."""

POOLING_FIRST: Pooling.ValueType  # 5
"""First element of vector."""

POOLING_LAST: Pooling.ValueType  # 6
"""Last element of vector."""

POOLING_MEDIAN: Pooling.ValueType  # 7
"""Median element of vector. [Wikipedia](https://en.wikipedia.org/wiki/Median)."""

POOLING_GMEAN: Pooling.ValueType  # 8
"""Geometirc mean of all elements. [Wikipedia](https://en.wikipedia.org/wiki/Geometric_mean)."""

POOLING_HMEAN: Pooling.ValueType  # 9
"""Harmonic mean of all elements. [Wikipedia](https://en.wikipedia.org/wiki/Harmonic_mean)."""

global___Pooling = Pooling


class _EmbeddingType:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType
class _EmbeddingTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_EmbeddingType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    EMBEDDING_TYPE_UNSPECIFIED: _EmbeddingType.ValueType  # 0
    """In the default case, no embedding is computed."""

    EMBEDDING_TYPE_SPACY: _EmbeddingType.ValueType  # 1
    """[Spacy](https://spacy.io/models)."""

    EMBEDDING_TYPE_TRANSFORMERS: _EmbeddingType.ValueType  # 2
    """[HuggingFace Transformers](https://huggingface.co/models)."""

    EMBEDDING_TYPE_SENTENCE_TRANSFORMERS: _EmbeddingType.ValueType  # 3
    """[UKPLab Sentence Transformers](https://www.sbert.net/docs/pretrained_models.html)"""

    EMBEDDING_TYPE_TENSORFLOW_HUB: _EmbeddingType.ValueType  # 4
    """Tensorflow Hub. Example: [Universal Sentence Encoder](https://tfhub.dev/google/universal-sentence-encoder/4)."""

class EmbeddingType(_EmbeddingType, metaclass=_EmbeddingTypeEnumTypeWrapper):
    pass

EMBEDDING_TYPE_UNSPECIFIED: EmbeddingType.ValueType  # 0
"""In the default case, no embedding is computed."""

EMBEDDING_TYPE_SPACY: EmbeddingType.ValueType  # 1
"""[Spacy](https://spacy.io/models)."""

EMBEDDING_TYPE_TRANSFORMERS: EmbeddingType.ValueType  # 2
"""[HuggingFace Transformers](https://huggingface.co/models)."""

EMBEDDING_TYPE_SENTENCE_TRANSFORMERS: EmbeddingType.ValueType  # 3
"""[UKPLab Sentence Transformers](https://www.sbert.net/docs/pretrained_models.html)"""

EMBEDDING_TYPE_TENSORFLOW_HUB: EmbeddingType.ValueType  # 4
"""Tensorflow Hub. Example: [Universal Sentence Encoder](https://tfhub.dev/google/universal-sentence-encoder/4)."""

global___EmbeddingType = EmbeddingType


class NlpConfig(google.protobuf.message.Message):
    """Common message for configuring spacy."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    LANGUAGE_FIELD_NUMBER: builtins.int
    SPACY_MODEL_FIELD_NUMBER: builtins.int
    EMBEDDING_MODELS_FIELD_NUMBER: builtins.int
    SIMILARITY_METHOD_FIELD_NUMBER: builtins.int
    language: typing.Text
    """Any language supported by spacy (e.g., `en`).
    [Reference](https://spacy.io/usage/models#languages).
    """

    spacy_model: typing.Text
    """Name of the trained spacy pipeline (e.g., `en_core_web_lg`).
    If empty, a blank spacy model will be used (e.g., if you only need embeddings and provide custom `embedding_models`.
    [Example: English models](https://spacy.io/models/en).
    """

    @property
    def embedding_models(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___EmbeddingModel]:
        """List of embeddings to use for computing word/sentence vectors.
        If given, these embeddings will **override** the embeddings of the specified `spacy_model`.
        Multiple models are concatenated to each other, increasing the length of the resulting vector.
        """
        pass
    similarity_method: global___SimilarityMethod.ValueType
    """Mathematical function to determine a similarity score given two strings."""

    def __init__(self,
        *,
        language: typing.Text = ...,
        spacy_model: typing.Text = ...,
        embedding_models: typing.Optional[typing.Iterable[global___EmbeddingModel]] = ...,
        similarity_method: global___SimilarityMethod.ValueType = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["embedding_models",b"embedding_models","language",b"language","similarity_method",b"similarity_method","spacy_model",b"spacy_model"]) -> None: ...
global___NlpConfig = NlpConfig

class SimilaritiesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CONFIG_FIELD_NUMBER: builtins.int
    TEXT_TUPLES_FIELD_NUMBER: builtins.int
    EXTRAS_FIELD_NUMBER: builtins.int
    @property
    def config(self) -> global___NlpConfig:
        """Spacy config."""
        pass
    @property
    def text_tuples(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TextTuple]:
        """List of string pairs to compare."""
        pass
    @property
    def extras(self) -> google.protobuf.struct_pb2.Struct:
        """Implementation-specific information can be encoded here"""
        pass
    def __init__(self,
        *,
        config: typing.Optional[global___NlpConfig] = ...,
        text_tuples: typing.Optional[typing.Iterable[global___TextTuple]] = ...,
        extras: typing.Optional[google.protobuf.struct_pb2.Struct] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["config",b"config","extras",b"extras"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["config",b"config","extras",b"extras","text_tuples",b"text_tuples"]) -> None: ...
global___SimilaritiesRequest = SimilaritiesRequest

class SimilaritiesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SIMILARITIES_FIELD_NUMBER: builtins.int
    EXTRAS_FIELD_NUMBER: builtins.int
    @property
    def similarities(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """List of similarities ordered just like the original `text_tuples`."""
        pass
    @property
    def extras(self) -> google.protobuf.struct_pb2.Struct:
        """Implementation-specific information can be encoded here"""
        pass
    def __init__(self,
        *,
        similarities: typing.Optional[typing.Iterable[builtins.float]] = ...,
        extras: typing.Optional[google.protobuf.struct_pb2.Struct] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["extras",b"extras"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["extras",b"extras","similarities",b"similarities"]) -> None: ...
global___SimilaritiesResponse = SimilaritiesResponse

class TextTuple(google.protobuf.message.Message):
    """Store a pair of strings."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TEXT1_FIELD_NUMBER: builtins.int
    TEXT2_FIELD_NUMBER: builtins.int
    text1: typing.Text
    text2: typing.Text
    def __init__(self,
        *,
        text1: typing.Text = ...,
        text2: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["text1",b"text1","text2",b"text2"]) -> None: ...
global___TextTuple = TextTuple

class Strings(google.protobuf.message.Message):
    """Wrapper message to encode a list of strings that can also be `null`."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    VALUES_FIELD_NUMBER: builtins.int
    @property
    def values(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]: ...
    def __init__(self,
        *,
        values: typing.Optional[typing.Iterable[typing.Text]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["values",b"values"]) -> None: ...
global___Strings = Strings

class DocBinRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CONFIG_FIELD_NUMBER: builtins.int
    TEXTS_FIELD_NUMBER: builtins.int
    ATTRIBUTES_FIELD_NUMBER: builtins.int
    ENABLED_PIPES_FIELD_NUMBER: builtins.int
    DISABLED_PIPES_FIELD_NUMBER: builtins.int
    EMBEDDING_LEVELS_FIELD_NUMBER: builtins.int
    EXTRAS_FIELD_NUMBER: builtins.int
    @property
    def config(self) -> global___NlpConfig:
        """Spacy config."""
        pass
    @property
    def texts(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """List of strings to be processed."""
        pass
    @property
    def attributes(self) -> global___Strings:
        """Attributes that shall be included in the DocBin object.
        Defaults to `("ORTH", "TAG", "HEAD", "DEP", "ENT_IOB", "ENT_TYPE", "ENT_KB_ID", "LEMMA", "MORPH", "POS")`.
        Possible values: `("IS_ALPHA", "IS_ASCII", "IS_DIGIT", "IS_LOWER", "IS_PUNCT", "IS_SPACE", "IS_TITLE", "IS_UPPER", "LIKE_URL", "LIKE_NUM", "LIKE_EMAIL", "IS_STOP", "IS_OOV_DEPRECATED", "IS_BRACKET", "IS_QUOTE", "IS_LEFT_PUNCT", "IS_RIGHT_PUNCT", "IS_CURRENCY", "ID", "ORTH", "LOWER", "NORM", "SHAPE", "PREFIX", "SUFFIX", "LENGTH", "CLUSTER", "LEMMA", "POS", "TAG", "DEP", "ENT_IOB", "ENT_TYPE", "ENT_ID", "ENT_KB_ID", "HEAD", "SENT_START", "SENT_END", "SPACY", "PROB", "LANG", "MORPH", "IDX")`.
        [Documentation](https://spacy.io/api/token#attributes).
        """
        pass
    @property
    def enabled_pipes(self) -> global___Strings: ...
    @property
    def disabled_pipes(self) -> global___Strings: ...
    @property
    def embedding_levels(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___EmbeddingLevel.ValueType]:
        """List of vectors that shall be saved in the `DocBin` object.
        The computation is time-consuming, so you should only specify the embeddings you actually use!
        """
        pass
    @property
    def extras(self) -> google.protobuf.struct_pb2.Struct:
        """Implementation-specific information can be encoded here"""
        pass
    def __init__(self,
        *,
        config: typing.Optional[global___NlpConfig] = ...,
        texts: typing.Optional[typing.Iterable[typing.Text]] = ...,
        attributes: typing.Optional[global___Strings] = ...,
        enabled_pipes: typing.Optional[global___Strings] = ...,
        disabled_pipes: typing.Optional[global___Strings] = ...,
        embedding_levels: typing.Optional[typing.Iterable[global___EmbeddingLevel.ValueType]] = ...,
        extras: typing.Optional[google.protobuf.struct_pb2.Struct] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_attributes",b"_attributes","attributes",b"attributes","config",b"config","disabled_pipes",b"disabled_pipes","enabled_pipes",b"enabled_pipes","extras",b"extras","pipes",b"pipes"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_attributes",b"_attributes","attributes",b"attributes","config",b"config","disabled_pipes",b"disabled_pipes","embedding_levels",b"embedding_levels","enabled_pipes",b"enabled_pipes","extras",b"extras","pipes",b"pipes","texts",b"texts"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_attributes",b"_attributes"]) -> typing.Optional[typing_extensions.Literal["attributes"]]: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["pipes",b"pipes"]) -> typing.Optional[typing_extensions.Literal["enabled_pipes","disabled_pipes"]]: ...
global___DocBinRequest = DocBinRequest

class DocBinResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    DOCBIN_FIELD_NUMBER: builtins.int
    EXTRAS_FIELD_NUMBER: builtins.int
    docbin: builtins.bytes
    """Serialized [`DocBin`](https://spacy.io/api/docbin) object"""

    @property
    def extras(self) -> google.protobuf.struct_pb2.Struct:
        """Implementation-specific information can be encoded here"""
        pass
    def __init__(self,
        *,
        docbin: builtins.bytes = ...,
        extras: typing.Optional[google.protobuf.struct_pb2.Struct] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["extras",b"extras"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["docbin",b"docbin","extras",b"extras"]) -> None: ...
global___DocBinResponse = DocBinResponse

class VectorsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CONFIG_FIELD_NUMBER: builtins.int
    TEXTS_FIELD_NUMBER: builtins.int
    EMBEDDING_LEVELS_FIELD_NUMBER: builtins.int
    EXTRAS_FIELD_NUMBER: builtins.int
    @property
    def config(self) -> global___NlpConfig:
        """Spacy config."""
        pass
    @property
    def texts(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """List of strings that shall be embedded (i.e., converted to vectors)."""
        pass
    @property
    def embedding_levels(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___EmbeddingLevel.ValueType]:
        """List of vectors that shall be returned.
        The computation is time-consuming, so you should only specify the embeddings you actually use!
        """
        pass
    @property
    def extras(self) -> google.protobuf.struct_pb2.Struct:
        """Implementation-specific information can be encoded here"""
        pass
    def __init__(self,
        *,
        config: typing.Optional[global___NlpConfig] = ...,
        texts: typing.Optional[typing.Iterable[typing.Text]] = ...,
        embedding_levels: typing.Optional[typing.Iterable[global___EmbeddingLevel.ValueType]] = ...,
        extras: typing.Optional[google.protobuf.struct_pb2.Struct] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["config",b"config","extras",b"extras"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["config",b"config","embedding_levels",b"embedding_levels","extras",b"extras","texts",b"texts"]) -> None: ...
global___VectorsRequest = VectorsRequest

class VectorsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    VECTORS_FIELD_NUMBER: builtins.int
    EXTRAS_FIELD_NUMBER: builtins.int
    @property
    def vectors(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___VectorResponse]:
        """List of vectors whose order corresponds to the one of `texts`."""
        pass
    @property
    def extras(self) -> google.protobuf.struct_pb2.Struct:
        """Implementation-specific information can be encoded here"""
        pass
    def __init__(self,
        *,
        vectors: typing.Optional[typing.Iterable[global___VectorResponse]] = ...,
        extras: typing.Optional[google.protobuf.struct_pb2.Struct] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["extras",b"extras"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["extras",b"extras","vectors",b"vectors"]) -> None: ...
global___VectorsResponse = VectorsResponse

class VectorResponse(google.protobuf.message.Message):
    """Container object that includes vectors for all levels specified in `embedding_levels`."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    DOCUMENT_FIELD_NUMBER: builtins.int
    TOKENS_FIELD_NUMBER: builtins.int
    SENTENCES_FIELD_NUMBER: builtins.int
    EXTRAS_FIELD_NUMBER: builtins.int
    @property
    def document(self) -> global___Vector:
        """One vector for the whole string."""
        pass
    @property
    def tokens(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Vector]:
        """Vectors for all tokens in the string."""
        pass
    @property
    def sentences(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Vector]:
        """Vectors for all sentences found in the string."""
        pass
    @property
    def extras(self) -> google.protobuf.struct_pb2.Struct:
        """Implementation-specific information can be encoded here"""
        pass
    def __init__(self,
        *,
        document: typing.Optional[global___Vector] = ...,
        tokens: typing.Optional[typing.Iterable[global___Vector]] = ...,
        sentences: typing.Optional[typing.Iterable[global___Vector]] = ...,
        extras: typing.Optional[google.protobuf.struct_pb2.Struct] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["document",b"document","extras",b"extras"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["document",b"document","extras",b"extras","sentences",b"sentences","tokens",b"tokens"]) -> None: ...
global___VectorResponse = VectorResponse

class Vector(google.protobuf.message.Message):
    """Container for storing a vector as a list of floats."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    VECTOR_FIELD_NUMBER: builtins.int
    @property
    def vector(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    def __init__(self,
        *,
        vector: typing.Optional[typing.Iterable[builtins.float]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["vector",b"vector"]) -> None: ...
global___Vector = Vector

class EmbeddingModel(google.protobuf.message.Message):
    """Specification of one model that is used to generate embeddings for strings."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    MODEL_TYPE_FIELD_NUMBER: builtins.int
    MODEL_NAME_FIELD_NUMBER: builtins.int
    POOLING_TYPE_FIELD_NUMBER: builtins.int
    PMEAN_FIELD_NUMBER: builtins.int
    model_type: global___EmbeddingType.ValueType
    """Each embedding has to be implemented, thus this enum is used to select the correct one."""

    model_name: typing.Text
    """You have to specify the name of the model that should be used by the selected impelemtation (i.e., `model_type`).
    We provide links to exemplary models for each implementation in the documentation of `EmbeddingType`.
    """

    pooling_type: global___Pooling.ValueType
    """Standard pooling functions like mean, min, max."""

    pmean: builtins.float
    """Power mean (or generalized mean).
    This method allows you to alter the computation of the mean representation.
    Special cases include arithmetic mean (p = 1), geometric mean (p = 0), harmonic mean (p = -1), minimum (p = -∞), maximum (p = ∞).
    [Wikipedia](https://en.wikipedia.org/wiki/Generalized_mean).
    [Paper](https://arxiv.org/abs/1803.01400).
    """

    def __init__(self,
        *,
        model_type: global___EmbeddingType.ValueType = ...,
        model_name: typing.Text = ...,
        pooling_type: global___Pooling.ValueType = ...,
        pmean: builtins.float = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pmean",b"pmean","pooling",b"pooling","pooling_type",b"pooling_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_name",b"model_name","model_type",b"model_type","pmean",b"pmean","pooling",b"pooling","pooling_type",b"pooling_type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["pooling",b"pooling"]) -> typing.Optional[typing_extensions.Literal["pooling_type","pmean"]]: ...
global___EmbeddingModel = EmbeddingModel
