# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['neptune',
 'neptune.attributes',
 'neptune.attributes.atoms',
 'neptune.attributes.series',
 'neptune.attributes.sets',
 'neptune.cli',
 'neptune.common',
 'neptune.common.backends',
 'neptune.common.hardware',
 'neptune.common.hardware.cgroup',
 'neptune.common.hardware.gauges',
 'neptune.common.hardware.gpu',
 'neptune.common.hardware.metrics',
 'neptune.common.hardware.metrics.reports',
 'neptune.common.hardware.metrics.service',
 'neptune.common.hardware.resources',
 'neptune.common.hardware.system',
 'neptune.common.patches',
 'neptune.common.storage',
 'neptune.common.websockets',
 'neptune.integrations',
 'neptune.integrations.aws',
 'neptune.integrations.detectron2',
 'neptune.integrations.fastai',
 'neptune.integrations.kedro',
 'neptune.integrations.lightgbm',
 'neptune.integrations.optuna',
 'neptune.integrations.prophet',
 'neptune.integrations.pytorch_lightning',
 'neptune.integrations.sacred',
 'neptune.integrations.sklearn',
 'neptune.integrations.tensorflow_keras',
 'neptune.integrations.transformers',
 'neptune.integrations.xgboost',
 'neptune.internal',
 'neptune.internal.artifacts',
 'neptune.internal.artifacts.drivers',
 'neptune.internal.backends',
 'neptune.internal.hardware',
 'neptune.internal.hardware.gpu',
 'neptune.internal.init',
 'neptune.internal.notebooks',
 'neptune.internal.operation_processors',
 'neptune.internal.streams',
 'neptune.internal.threading',
 'neptune.internal.types',
 'neptune.internal.utils',
 'neptune.internal.websockets',
 'neptune.legacy',
 'neptune.legacy.internal',
 'neptune.legacy.internal.api_clients',
 'neptune.legacy.internal.api_clients.hosted_api_clients',
 'neptune.legacy.internal.backends',
 'neptune.legacy.internal.channels',
 'neptune.legacy.internal.execution',
 'neptune.legacy.internal.experiments',
 'neptune.legacy.internal.notebooks',
 'neptune.legacy.internal.streams',
 'neptune.legacy.internal.threads',
 'neptune.legacy.internal.utils',
 'neptune.legacy.internal.websockets',
 'neptune.logging',
 'neptune.management',
 'neptune.management.internal',
 'neptune.metadata_containers',
 'neptune.new',
 'neptune.types',
 'neptune.types.atoms',
 'neptune.types.series',
 'neptune.types.sets',
 'neptune.vendor']

package_data = \
{'': ['*']}

install_requires = \
['GitPython>=2.0.8',
 'Pillow>=1.1.6',
 'PyJWT',
 'boto3>=1.16.0',
 'bravado>=11.0.0,<12.0.0',
 'click>=7.0',
 'future>=0.17.1',
 'oauthlib>=2.1.0',
 'packaging',
 'pandas',
 'psutil',
 'requests-oauthlib>=1.0.0',
 'requests>=2.20.0',
 'six>=1.12.0',
 'swagger-spec-validator>=2.7.4',
 'urllib3',
 'websocket-client>=0.35.0,!=1.0.0']

extras_require = \
{':python_version < "3.7"': ['dataclasses>=0.6'],
 ':python_version < "3.8"': ['importlib-metadata'],
 'aws': ['neptune-aws'],
 'detectron2:python_version >= "3.7"': ['neptune-detectron2'],
 'dev': ['altair',
         'bokeh',
         'coverage[toml]',
         'freezegun',
         'matplotlib',
         'mock',
         'moto[s3]',
         'munch',
         'plotly',
         'pre-commit',
         'pytest',
         'pytest-mock',
         'pytest-timeout',
         'pytest-xdist',
         'tensorflow',
         'torch',
         'vega_datasets',
         'Faker'],
 'e2e': ['optuna',
         'scikit-learn',
         'torchvision',
         'pytorch-lightning',
         'transformers'],
 'e2e:python_version < "3.9"': ['zenml'],
 'fastai': ['neptune-fastai'],
 'kedro:python_version < "3.11"': ['kedro-neptune'],
 'lightgbm': ['neptune-lightgbm'],
 'optuna': ['neptune-optuna'],
 'prophet': ['neptune-prophet'],
 'pytorch-lightning': ['pytorch-lightning'],
 'sacred': ['neptune-sacred'],
 'sklearn': ['neptune-sklearn'],
 'tensorflow-keras': ['neptune-tensorflow-keras'],
 'transformers': ['transformers'],
 'xgboost': ['neptune-xgboost'],
 'zenml:python_version < "3.9"': ['zenml']}

entry_points = \
{'console_scripts': ['neptune = neptune.cli.__main__:main']}

setup_kwargs = {
    'name': 'neptune',
    'version': '1.0.0',
    'description': 'Neptune Client',
    'long_description': '<div align="center">\n    <img src="https://raw.githubusercontent.com/neptune-ai/neptune-client/assets/readme/github-banner.jpeg" width="1500" />\n    &nbsp;\n <h1>neptune.ai</h1>\n</div>\n\n<div align="center">\n  <a href="https://docs.neptune.ai/usage/quickstart/">Quickstart</a>\n  <span>&nbsp;&nbsp;•&nbsp;&nbsp;</span>\n  <a href="https://neptune.ai/">Website</a>\n  <span>&nbsp;&nbsp;•&nbsp;&nbsp;</span>\n  <a href="https://docs.neptune.ai/">Docs</a>\n  <span>&nbsp;&nbsp;•&nbsp;&nbsp;</span>\n  <a href="https://github.com/neptune-ai/examples">Examples</a>\n  <span>&nbsp;&nbsp;•&nbsp;&nbsp;</span>\n  <a href="https://neptune.ai/resources">Resource center</a>\n  <span>&nbsp;&nbsp;•&nbsp;&nbsp;</span>\n  <a href="https://neptune.ai/blog">Blog</a>\n  <span>&nbsp;&nbsp;•&nbsp;&nbsp;</span>\n  <a href="https://neptune.ai/events">Podcast</a>\n&nbsp;\n  <hr />\n</div>\n\n## What is neptune.ai?\n\nneptune.ai makes it easy to log, store, organize, compare, register, and share <b>all your ML model metadata in a single place</b>.\n\n* Automate and standardize as your modeling team grows.\n* Collaborate on models and results with your team and across the org.\n* Use hosted, deploy on-premises, or in a private cloud. Integrate with any MLOps stack.\n&nbsp;\n\n&nbsp;\n<div align="center">\n    <a href="https://youtu.be/mv9jxexmbBk">\n      <img border="0" alt="neptune.ai explainer video" src="https://raw.githubusercontent.com/neptune-ai/neptune-client/assets/readme/github-explainer-video.png" width="600">\n    </a>\n</div>\n&nbsp;\n\n&nbsp;\n<a href="https://app.neptune.ai/showcase/example-project-tensorflow-keras/experiments?split=tbl&dash=charts&viewId=eccd5adf-42b3-497e-9cc2-9fa2655429b3"><b>Play with a live neptune.ai app →</b></a>\n&nbsp;\n\n&nbsp;\n## Getting started\n\n**Step 1:** Create a **[free account](https://neptune.ai/register)**\n\n**Step 2:** Install Neptune client library\n\n```bash\npip install neptune\n```\n\n**Step 3:** Add experiment tracking snippet to your code\n\n```python\nimport neptune\n\nrun = neptune.init_run(project="Me/MyProject")\nrun["parameters"] = {"lr": 0.1, "dropout": 0.4}\nrun["test_accuracy"] = 0.84\n\n```\n\n[![Open in Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/neptune-ai/examples/blob/master/how-to-guides/hello-neptune/notebooks/hello_neptune.ipynb)\n&nbsp;\n\n&nbsp;\n## Core features\n\n**Log and display**\n\nAdd a snippet to any step of your ML pipeline once. Decide what and how you want to log. Run a million times.\n\n* <a href="https://docs.neptune.ai/integrations/"><b>Any framework:</b></a> any code, PyTorch, PyTorch Lightning, TensorFlow/Keras, scikit-learn, LightGBM, XGBoost, Optuna, Kedro.\n\n* <a href="https://docs.neptune.ai/logging/what_you_can_log/"><b>Any metadata type:</b></a> metrics, parameters, dataset and model versions, images, interactive plots, videos, hardware (GPU, CPU, memory), code state.\n\n* <a href="https://docs.neptune.ai/usage/pipelines/"><b>From anywhere in your ML pipeline:</b></a> multinode pipelines, distributed computing, log during or after execution, log offline, and sync when you are back online.\n&nbsp;\n\n&nbsp;\n<div align="center">\n      <img border="0" alt="all metadata metrics" src="https://raw.githubusercontent.com/neptune-ai/neptune-client/assets/readme/all-metadata-metrics.gif" width="600">\n    </a>\n</div>\n&nbsp;\n\n&nbsp;\n\n**Organize experiments**\n\nOrganize logs in a fully customizable nested structure. Display model metadata in user-defined dashboard templates.\n\n* <a href="https://app.neptune.ai/o/showcase/org/example-project-tensorflow-keras/experiments?split=tbl&dash=charts&viewId=4a21e7e9-abab-4f9f-8723-41f5ae4f71e8&product_tour_id=314370"><b>Nested metadata structure:</b></a> flexible API lets you customize the metadata logging structure however you want. Talk to a dictionary at the code level. See the folder structure in the app. Organize nested parameter configs or the results on k-fold validation splits the way they should be.\n\n* <a href="https://app.neptune.ai/o/showcase/org/example-project-tensorflow-keras/experiments?split=tbl&dash=charts&viewId=4a21e7e9-abab-4f9f-8723-41f5ae4f71e8&product_tour_id=314370"><b>Custom dashboards:</b></a> combine different metadata types in one view. Define it for one run. Use anywhere. Look at GPU, memory consumption, and load times to debug training speed. See learning curves, image predictions, and confusion matrix to debug model quality.\n\n* <a href="https://app.neptune.ai/o/showcase/org/example-project-tensorflow-keras/experiments?split=tbl&dash=charts&viewId=4a21e7e9-abab-4f9f-8723-41f5ae4f71e8&product_tour_id=314370"><b>Table views:</b></a> create different views of the runs table and save them for later. You can have separate table views for debugging, comparing parameter sets, or best experiments.\n&nbsp;\n\n&nbsp;\n<div align="center">\n      <img border="0" alt="organize dashboards" src="https://raw.githubusercontent.com/neptune-ai/neptune-client/assets/readme/organize-dashboards.gif" width="600">\n    </a>\n</div>\n&nbsp;\n\n&nbsp;\n\n**Compare results**\n\nVisualize training live in the neptune.ai web app. See how different parameters and configs affect the results. Optimize models quicker.\n\n* <a href="https://app.neptune.ai/o/showcase/org/example-project-tensorflow-keras/experiments?split=tbl&dash=charts&viewId=4a21e7e9-abab-4f9f-8723-41f5ae4f71e8&product_tour_id=314370"><b>Compare:</b></a> learning curves, parameters, images, datasets.\n\n* <a href="https://app.neptune.ai/o/showcase/org/example-project-tensorflow-keras/experiments?split=tbl&dash=charts&viewId=4a21e7e9-abab-4f9f-8723-41f5ae4f71e8&product_tour_id=314370"><b>Search, sort, and filter:</b></a> experiments by any field you logged. Use our query language to filter runs based on parameter values, metrics, execution times, or anything else.\n\n* <a href="https://app.neptune.ai/o/showcase/org/example-project-tensorflow-keras/experiments?split=tbl&dash=charts&viewId=4a21e7e9-abab-4f9f-8723-41f5ae4f71e8&product_tour_id=314370"><b>Visualize and display:</b></a> runs table, interactive display, folder structure, dashboards.\n\n* <a href="https://app.neptune.ai/o/showcase/org/example-project-tensorflow-keras/experiments?split=tbl&dash=charts&viewId=4a21e7e9-abab-4f9f-8723-41f5ae4f71e8&product_tour_id=314370"><b>Monitor live:</b></a> hardware consumption metrics, GPU, CPU, memory.\n\n* <a href="https://app.neptune.ai/o/showcase/org/example-project-tensorflow-keras/experiments?split=tbl&dash=charts&viewId=4a21e7e9-abab-4f9f-8723-41f5ae4f71e8&product_tour_id=314370"><b>Group by:</b></a> dataset versions, parameters.\n&nbsp;\n\n&nbsp;\n<div align="center">\n      <img border="0" alt="compare, search, filter" src="https://raw.githubusercontent.com/neptune-ai/neptune-client/assets/readme/compare-search-filter.gif" width="600">\n    </a>\n</div>\n&nbsp;\n\n&nbsp;\n\n**Register models**\n\nVersion, review, and access production-ready models and metadata associated with them in a single place.\n\n* <a href="https://docs.neptune.ai/model_registry/registering_model/"><b>Version models:</b></a> register models, create model versions, version external model artifacts.\n\n* <a href="https://docs.neptune.ai/model_registry/managing_stage/"><b>Review and change stages:</b></a> look at the validation, test metrics and other model metadata. You can move models between None/Staging/Production/Archived.\n\n* <a href="https://docs.neptune.ai/model_registry/overview/"><b>Access and share models:</b></a> every model and model version is accessible via the neptune.ai web app or through the API.\n&nbsp;\n\n&nbsp;\n<div align="center">\n      <img border="0" alt="register stages" src="https://raw.githubusercontent.com/neptune-ai/neptune-client/assets/readme/register-stages.gif" width="600">\n    </a>\n</div>\n&nbsp;\n\n&nbsp;\n\n**Share results**\n\nHave a single place where your team can see the results and access all models and experiments.\n\n* <a href="https://docs.neptune.ai/about/collaboration/"><b>Send a link:</b></a> share every chart, dashboard, table view, or anything else you see in the neptune.ai app by copying and sending persistent URLs.\n\n* <a href="https://docs.neptune.ai/usage/querying_metadata/"><b>Query API:</b></a> access all model metadata via neptune.ai API. Whatever you logged, you can query in a similar way.\n\n* <a href="https://neptune.ai/pricing"><b>Manage users and projects:</b></a> create different projects, add users to them, and grant different permissions levels.\n\n* <a href="https://neptune.ai/pricing"><b>Add your entire org:</b></a> get unlimited users on every paid plan. So you can invite your entire organization, including product managers and subject matter experts at no extra cost.\n&nbsp;\n\n&nbsp;\n<div align="center">\n      <img border="0" alt="share persistent link" src="https://raw.githubusercontent.com/neptune-ai/neptune-client/assets/readme/share-persistent-link.gif" width="600">\n    </a>\n</div>\n&nbsp;\n\n&nbsp;\n## Integrate with any MLOps stack\nneptune.ai integrates with <a href="https://docs.neptune.ai/integrations/"><b>25+ frameworks:</b></a> PyTorch, PyTorch Lightning, TensorFlow/Keras, LightGBM, scikit-learn, XGBoost, Optuna, Kedro, 🤗 Transformers, fastai, Prophet, and more.\n\n#### <img src="https://raw.githubusercontent.com/neptune-ai/neptune-client/assets/readme/Pytorch-lightning-logo.png" width="60" /> <br> <br> PyTorch Lightning\n\nExample:\n\n```python\nfrom pytorch_lightning import Trainer\nfrom pytorch_lightning.loggers import NeptuneLogger\n\n# Create NeptuneLogger instance\nfrom neptune.new import ANONYMOUS_API_TOKEN\nneptune_logger = NeptuneLogger(\n    api_key=ANONYMOUS_API_TOKEN,\n    project="common/pytorch-lightning-integration",\n    tags=["training", "resnet"],  # optional\n)\n\n# Pass the logger to the Trainer\ntrainer = Trainer(max_epochs=10, logger=neptune_logger)\n\n# Run the Trainer\ntrainer.fit(my_model, my_dataloader)\n```\n\n[![neptune-pl](https://img.shields.io/badge/PytorchLightning-experiment-success?logo=data:image/png;base64,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)](https://app.neptune.ai/common/pytorch-lightning-integration/experiments?split=tbl&dash=charts&viewId=faa75e77-5bd6-42b9-9379-863fe7a33227)\n&nbsp;\n\n[![github-code](https://img.shields.io/badge/GitHub-code-informational?logo=github)](https://github.com/neptune-ai/examples/tree/main/integrations-and-supported-tools/pytorch-lightning/scripts)\n[![jupyter-code](https://img.shields.io/badge/Jupyter-code-informational?logo=jupyter)](https://github.com/neptune-ai/examples/blob/main/integrations-and-supported-tools/pytorch-lightning/notebooks/Neptune_PyTorch_Lightning.ipynb)\n[![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/neptune-ai/examples/blob/main/integrations-and-supported-tools/pytorch-lightning/notebooks/Neptune_PyTorch_Lightning.ipynb)\n[<img src="https://img.shields.io/badge/docs-PyTorch%20Lightning-yellow">](https://docs.neptune.ai/integrations/lightning/)\n&nbsp;\n\n&nbsp;\n## neptune.ai is trusted by great companies\n&nbsp;\n\n<div align="center">\n    <img src="https://raw.githubusercontent.com/neptune-ai/neptune-client/assets/readme/github-customers.png" width="1500" />\n</div>\n&nbsp;\n\nRead how various customers use Neptune to <a href="https://neptune.ai/customers">improve their workflow</a>.\n&nbsp;\n\n&nbsp;\n## Support\n\nIf you get stuck or simply want to talk to us about something, here are your options:\n* Check our <a href="https://docs.neptune.ai/getting_help/#frequently-asked-questions">FAQ page</a>.\n* Take a look at our <a href="https://neptune.ai/resources">resource center</a>.\n* Chat! In the app, click the <a href="https://docs.neptune.ai/getting_help/#chat">blue message icon</a> in the bottom-right corner and send a message. A real person will talk to you ASAP (typically very ASAP).\n* You can just shoot us an email at [support@neptune.ai](mailto:support@neptune.ai).\n&nbsp;\n\n&nbsp;\n## People behind\n\nCreated with :heart: by the [neptune.ai team](https://neptune.ai/about-us):\n\nPiotr, Valentina, Paulina, Chaz, Prince, Parth, Kshitij, Siddhant, Jakub, Patrycja, Dominika, Karolina, Stephen, Artur, Aleksiej, Martyna, Małgorzata, Magdalena, Karolina, Marcin, Michał, Tymoteusz, Rafał, Aleksandra, Sabine, Tomek, Piotr, Adam, Jakub, Rafał, Piotr, Hubert, Marcin, Jakub, Paweł, Jakub, Franciszek, Bartosz, Aleksander, Dawid, Pavel, Patryk, and [you?](https://neptune.ai/jobs)\n',
    'author': 'neptune.ai',
    'author_email': 'contact@neptune.ai',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://neptune.ai/',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
