"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const version_1 = require("./version");
describe('Schema', () => {
    describe('Version', () => {
        test('missing version', () => {
            expect(() => version_1.getValidVersion('3.0.x')).toThrowError('Invalid OpenApi version "undefined"');
        });
        test('incorrect version', () => {
            expect(() => version_1.getValidVersion('3.0.x', 'a.b.c')).toThrowError('Invalid OpenApi version "a.b.c"');
        });
        test('incorrect version (with prefix)', () => {
            expect(() => version_1.getValidVersion('3.0.x', 'v3.0.3')).toThrowError('Do not prefix the version value');
        });
        test('unsupported version (3.1.0)', () => {
            expect(() => version_1.getValidVersion('3.0.x', '3.1.0')).toThrowError('Unsupported OpenApi version "3.1.0": Must be 3.0.x');
        });
        test('unsupported future version (5.0.0)', () => {
            expect(() => version_1.getValidVersion('>= 3.0.0 | < 5', '5.0.0')).toThrowError('Unsupported OpenApi version "5.0.0": Must be >= 3.0.0 | < 5');
        });
        test('supported major.minor.patch version (3.0.3)', () => {
            expect(version_1.getValidVersion('3.0.x', '3.0.3')).toBe('3.0.3');
        });
        test('supported major.minor version (3.0)', () => {
            expect(version_1.getValidVersion('3.0.x', '3.0')).toBe('3.0.0');
        });
        test('supported major version (3)', () => {
            expect(version_1.getValidVersion('3.0.x', '3.0')).toBe('3.0.0');
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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