"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Integration = exports.InternalIntegrationType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
var InternalIntegrationType;
(function (InternalIntegrationType) {
    InternalIntegrationType["AWS"] = "AWS";
    InternalIntegrationType["CORS"] = "CORS";
    InternalIntegrationType["HTTP"] = "HTTP";
    InternalIntegrationType["LAMBDA"] = "LAMBDA";
    InternalIntegrationType["MOCK"] = "MOCK";
})(InternalIntegrationType = exports.InternalIntegrationType || (exports.InternalIntegrationType = {}));
/**
 * Essentially responsible for converting CDK `IntegrationProps` into
 * API Gateway OpenApi integration extension ()`XAmazonApigatewayIntegration`).
 * Also defines few basic methods (`getIntegration` & `getValidatorId`) used
 * by derivative classes.
 */
class Integration {
    /** Construc a new integration. */
    constructor(props, config) {
        this.xAmazonApigatewayIntegration = this.mapPropsToIntegration(props);
        this.validator = config.validator;
        this.type = config.type;
    }
    /**
     * Convert CDK integration into API Gateway OpenApi integration extension.
     */
    mapPropsToIntegration(props) {
        return {
            cacheKeyParameters: props.options?.cacheKeyParameters,
            cacheNamespace: props.options?.cacheNamespace,
            connectionType: props.options?.connectionType,
            connectionId: props.options?.vpcLink?.vpcLinkId,
            credentials: props.options?.credentialsRole?.roleArn,
            contentHandling: props.options?.contentHandling,
            httpMethod: props.integrationHttpMethod || 'POST',
            passthroughBehavior: props.options?.passthroughBehavior,
            requestParameters: props.options?.requestParameters,
            requestTemplates: props.options?.requestTemplates,
            responses: this.resolveResponses(props),
            timeoutInMillis: this.resolveTimeout(props),
            type: props.type,
            //tlsConfig: props.options?.
            uri: props.uri,
        };
    }
    resolveTimeout(props) {
        if (typeof props.options?.timeout !== 'undefined') {
            return props.options.timeout.toMilliseconds();
        }
        return undefined;
    }
    resolveResponses(props) {
        const responses = {};
        props.options?.integrationResponses?.forEach(resp => {
            const selectionPattern = this.resolveSelectionPattern(props.options.integrationResponses, resp);
            if (typeof selectionPattern === 'undefined') {
                throw new Error('You must provide a selectionPattern when multiple integration responses defined');
            }
            responses[selectionPattern] = {
                statusCode: resp.statusCode,
                responseParameters: resp.responseParameters,
                responseTemplates: resp.responseTemplates,
                contentHandling: resp.contentHandling,
            };
        });
        return responses;
    }
    /**
     * Decide selection pattern.
     *
     * @see https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_apigateway.IntegrationResponse.html#selectionpattern
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration-responses.html
     *
     * @default
     * resp.statusCode
     */
    resolveSelectionPattern(responses, resp) {
        if (typeof resp?.selectionPattern === 'string') {
            return resp.selectionPattern;
        }
        if (responses.length === 1) {
            return 'default';
        }
        return undefined;
    }
}
exports.Integration = Integration;
_a = JSII_RTTI_SYMBOL_1;
Integration[_a] = { fqn: "@alma-cdk/openapix.Integration", version: "0.0.49" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmFzZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9pbnRlZ3JhdGlvbi9iYXNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBYUEsSUFBWSx1QkFNWDtBQU5ELFdBQVksdUJBQXVCO0lBQ2pDLHNDQUFTLENBQUE7SUFDVCx3Q0FBVyxDQUFBO0lBQ1gsd0NBQVcsQ0FBQTtJQUNYLDRDQUFlLENBQUE7SUFDZix3Q0FBVyxDQUFBO0FBQ2IsQ0FBQyxFQU5XLHVCQUF1QixHQUF2QiwrQkFBdUIsS0FBdkIsK0JBQXVCLFFBTWxDO0FBa0JEOzs7OztHQUtHO0FBQ0gsTUFBc0IsV0FBVztJQU0vQixrQ0FBa0M7SUFDbEMsWUFBWSxLQUF1QixFQUFFLE1BQXlCO1FBQzVELElBQUksQ0FBQyw0QkFBNEIsR0FBRyxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDdEUsSUFBSSxDQUFDLFNBQVMsR0FBRyxNQUFNLENBQUMsU0FBUyxDQUFDO1FBQ2xDLElBQUksQ0FBQyxJQUFJLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQztJQUMxQixDQUFDO0lBRUQ7O09BRUc7SUFDSyxxQkFBcUIsQ0FBQyxLQUF1QjtRQUNuRCxPQUFPO1lBQ0wsa0JBQWtCLEVBQUUsS0FBSyxDQUFDLE9BQU8sRUFBRSxrQkFBa0I7WUFDckQsY0FBYyxFQUFFLEtBQUssQ0FBQyxPQUFPLEVBQUUsY0FBYztZQUM3QyxjQUFjLEVBQUUsS0FBSyxDQUFDLE9BQU8sRUFBRSxjQUFjO1lBQzdDLFlBQVksRUFBRSxLQUFLLENBQUMsT0FBTyxFQUFFLE9BQU8sRUFBRSxTQUFTO1lBQy9DLFdBQVcsRUFBRSxLQUFLLENBQUMsT0FBTyxFQUFFLGVBQWUsRUFBRSxPQUFPO1lBQ3BELGVBQWUsRUFBRSxLQUFLLENBQUMsT0FBTyxFQUFFLGVBQWU7WUFDL0MsVUFBVSxFQUFFLEtBQUssQ0FBQyxxQkFBcUIsSUFBSSxNQUFNO1lBQ2pELG1CQUFtQixFQUFFLEtBQUssQ0FBQyxPQUFPLEVBQUUsbUJBQW1CO1lBQ3ZELGlCQUFpQixFQUFFLEtBQUssQ0FBQyxPQUFPLEVBQUUsaUJBQWlCO1lBQ25ELGdCQUFnQixFQUFFLEtBQUssQ0FBQyxPQUFPLEVBQUUsZ0JBQWdCO1lBQ2pELFNBQVMsRUFBRSxJQUFJLENBQUMsZ0JBQWdCLENBQUMsS0FBSyxDQUFDO1lBQ3ZDLGVBQWUsRUFBRSxJQUFJLENBQUMsY0FBYyxDQUFDLEtBQUssQ0FBQztZQUMzQyxJQUFJLEVBQUUsS0FBSyxDQUFDLElBQUk7WUFDaEIsNEJBQTRCO1lBQzVCLEdBQUcsRUFBRSxLQUFLLENBQUMsR0FBRztTQUNmLENBQUM7SUFDSixDQUFDO0lBRU8sY0FBYyxDQUFDLEtBQXVCO1FBQzVDLElBQUksT0FBTyxLQUFLLENBQUMsT0FBTyxFQUFFLE9BQU8sS0FBSyxXQUFXLEVBQUU7WUFDakQsT0FBTyxLQUFLLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxjQUFjLEVBQUUsQ0FBQztTQUMvQztRQUNELE9BQU8sU0FBUyxDQUFDO0lBQ25CLENBQUM7SUFFTyxnQkFBZ0IsQ0FBQyxLQUF1QjtRQUM5QyxNQUFNLFNBQVMsR0FBMEMsRUFBRSxDQUFDO1FBQzVELEtBQUssQ0FBQyxPQUFPLEVBQUUsb0JBQW9CLEVBQUUsT0FBTyxDQUFDLElBQUksQ0FBQyxFQUFFO1lBRWxELE1BQU0sZ0JBQWdCLEdBQUcsSUFBSSxDQUFDLHVCQUF1QixDQUFDLEtBQUssQ0FBQyxPQUFRLENBQUMsb0JBQXFCLEVBQUUsSUFBSSxDQUFDLENBQUM7WUFFbEcsSUFBSSxPQUFPLGdCQUFnQixLQUFLLFdBQVcsRUFBRTtnQkFDM0MsTUFBTSxJQUFJLEtBQUssQ0FBQyxpRkFBaUYsQ0FBQyxDQUFDO2FBQ3BHO1lBRUQsU0FBUyxDQUFDLGdCQUFnQixDQUFDLEdBQUc7Z0JBQzVCLFVBQVUsRUFBRSxJQUFJLENBQUMsVUFBVTtnQkFDM0Isa0JBQWtCLEVBQUUsSUFBSSxDQUFDLGtCQUFrQjtnQkFDM0MsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLGlCQUFpQjtnQkFDekMsZUFBZSxFQUFFLElBQUksQ0FBQyxlQUFlO2FBRXRDLENBQUM7UUFDSixDQUFDLENBQUMsQ0FBQztRQUNILE9BQU8sU0FBUyxDQUFDO0lBQ25CLENBQUM7SUFFRDs7Ozs7Ozs7T0FRRztJQUNLLHVCQUF1QixDQUFDLFNBQWdDLEVBQUUsSUFBeUI7UUFFekYsSUFBSSxPQUFPLElBQUksRUFBRSxnQkFBZ0IsS0FBSyxRQUFRLEVBQUU7WUFDOUMsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7U0FDOUI7UUFFRCxJQUFJLFNBQVMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFO1lBQzFCLE9BQU8sU0FBUyxDQUFDO1NBQ2xCO1FBRUQsT0FBTyxTQUFTLENBQUM7SUFDbkIsQ0FBQzs7QUFwRkgsa0NBc0ZDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSW50ZWdyYXRpb25Qcm9wcywgSW50ZWdyYXRpb25SZXNwb25zZSB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1hcGlnYXRld2F5JztcbmltcG9ydCB7IFhBbWF6b25BcGlnYXRld2F5SW50ZWdyYXRpb24sIFhBbWF6b25BcGlnYXRld2F5SW50ZWdyYXRpb25SZXNwb25zZXMgfSBmcm9tICcuLi94LWFtYXpvbi1hcGlnYXRld2F5JztcblxuLyoqIEludGVyZmFjZSBpbXBsZW1lbnRlZCBieSBhbGwgaW50ZWdyYXRpb25zLiAqL1xuZXhwb3J0IGludGVyZmFjZSBJQmFzZUludGVncmF0aW9uIHtcblxuICAvKiogSWRlbnRpZmllciB0byBlbmFibGUgaW50ZXJuYWwgdHlwZSBjaGVja3MuICovXG4gIHJlYWRvbmx5IHR5cGU6IEludGVybmFsSW50ZWdyYXRpb25UeXBlO1xuXG4gIHJlYWRvbmx5IHhBbWF6b25BcGlnYXRld2F5SW50ZWdyYXRpb246IFhBbWF6b25BcGlnYXRld2F5SW50ZWdyYXRpb247XG4gIHJlYWRvbmx5IHZhbGlkYXRvcj86IHN0cmluZztcbn1cblxuZXhwb3J0IGVudW0gSW50ZXJuYWxJbnRlZ3JhdGlvblR5cGUge1xuICBBV1M9J0FXUycsXG4gIENPUlM9J0NPUlMnLFxuICBIVFRQPSdIVFRQJyxcbiAgTEFNQkRBPSdMQU1CREEnLFxuICBNT0NLPSdNT0NLJyxcbn1cblxuLyoqIE1ldGhvZCBpbnRlZ3JhdGlvbiB2YWxpZGF0b3IgY29uZmlndXJhdGlvbi4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgVmFsaWRhdG9yQ29uZmlnIHtcbiAgLyoqXG4gICAqIFZhbGlkYXRvciBpZGVudGlmaWVyIGZvciBtZXRob2QgaW50ZWdyYXRpb24uIFRoaXMgd2lsbCBvdmVycmlkZSB0aGUgZGVmYXVsdFxuICAgKiB2YWxpZGF0b3IgaWYgb25lIGNvbmZpZ3VyZWQuXG4gICAqXG4gICAqIFNob3VsZCBtYXRjaCBhIGtleSBmcm9tIE9wZW5BcGkgc2NoZW1hIGBjb21wb25lbnRzLnNlY3VyaXR5U2NoZW1hc2AuXG4gICAqL1xuICByZWFkb25seSB2YWxpZGF0b3I/OiBzdHJpbmc7XG59XG5cbi8qKiBCYXNlIGludGVncmF0aW9uIGNvbmZpZy4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSW50ZWdyYXRpb25Db25maWcgZXh0ZW5kcyBWYWxpZGF0b3JDb25maWcge1xuICByZWFkb25seSB0eXBlOiBJbnRlcm5hbEludGVncmF0aW9uVHlwZTtcbn1cblxuLyoqXG4gKiBFc3NlbnRpYWxseSByZXNwb25zaWJsZSBmb3IgY29udmVydGluZyBDREsgYEludGVncmF0aW9uUHJvcHNgIGludG9cbiAqIEFQSSBHYXRld2F5IE9wZW5BcGkgaW50ZWdyYXRpb24gZXh0ZW5zaW9uICgpYFhBbWF6b25BcGlnYXRld2F5SW50ZWdyYXRpb25gKS5cbiAqIEFsc28gZGVmaW5lcyBmZXcgYmFzaWMgbWV0aG9kcyAoYGdldEludGVncmF0aW9uYCAmIGBnZXRWYWxpZGF0b3JJZGApIHVzZWRcbiAqIGJ5IGRlcml2YXRpdmUgY2xhc3Nlcy5cbiAqL1xuZXhwb3J0IGFic3RyYWN0IGNsYXNzIEludGVncmF0aW9uIGltcGxlbWVudHMgSUJhc2VJbnRlZ3JhdGlvbiB7XG4gIHB1YmxpYyByZWFkb25seSB4QW1hem9uQXBpZ2F0ZXdheUludGVncmF0aW9uOiBYQW1hem9uQXBpZ2F0ZXdheUludGVncmF0aW9uO1xuICBwdWJsaWMgcmVhZG9ubHkgdmFsaWRhdG9yPzogc3RyaW5nO1xuXG4gIHB1YmxpYyByZWFkb25seSB0eXBlOiBJbnRlcm5hbEludGVncmF0aW9uVHlwZTtcblxuICAvKiogQ29uc3RydWMgYSBuZXcgaW50ZWdyYXRpb24uICovXG4gIGNvbnN0cnVjdG9yKHByb3BzOiBJbnRlZ3JhdGlvblByb3BzLCBjb25maWc6IEludGVncmF0aW9uQ29uZmlnKSB7XG4gICAgdGhpcy54QW1hem9uQXBpZ2F0ZXdheUludGVncmF0aW9uID0gdGhpcy5tYXBQcm9wc1RvSW50ZWdyYXRpb24ocHJvcHMpO1xuICAgIHRoaXMudmFsaWRhdG9yID0gY29uZmlnLnZhbGlkYXRvcjtcbiAgICB0aGlzLnR5cGUgPSBjb25maWcudHlwZTtcbiAgfVxuXG4gIC8qKlxuICAgKiBDb252ZXJ0IENESyBpbnRlZ3JhdGlvbiBpbnRvIEFQSSBHYXRld2F5IE9wZW5BcGkgaW50ZWdyYXRpb24gZXh0ZW5zaW9uLlxuICAgKi9cbiAgcHJpdmF0ZSBtYXBQcm9wc1RvSW50ZWdyYXRpb24ocHJvcHM6IEludGVncmF0aW9uUHJvcHMpOiBYQW1hem9uQXBpZ2F0ZXdheUludGVncmF0aW9uIHtcbiAgICByZXR1cm4ge1xuICAgICAgY2FjaGVLZXlQYXJhbWV0ZXJzOiBwcm9wcy5vcHRpb25zPy5jYWNoZUtleVBhcmFtZXRlcnMsXG4gICAgICBjYWNoZU5hbWVzcGFjZTogcHJvcHMub3B0aW9ucz8uY2FjaGVOYW1lc3BhY2UsXG4gICAgICBjb25uZWN0aW9uVHlwZTogcHJvcHMub3B0aW9ucz8uY29ubmVjdGlvblR5cGUsXG4gICAgICBjb25uZWN0aW9uSWQ6IHByb3BzLm9wdGlvbnM/LnZwY0xpbms/LnZwY0xpbmtJZCxcbiAgICAgIGNyZWRlbnRpYWxzOiBwcm9wcy5vcHRpb25zPy5jcmVkZW50aWFsc1JvbGU/LnJvbGVBcm4sXG4gICAgICBjb250ZW50SGFuZGxpbmc6IHByb3BzLm9wdGlvbnM/LmNvbnRlbnRIYW5kbGluZyxcbiAgICAgIGh0dHBNZXRob2Q6IHByb3BzLmludGVncmF0aW9uSHR0cE1ldGhvZCB8fCAnUE9TVCcsXG4gICAgICBwYXNzdGhyb3VnaEJlaGF2aW9yOiBwcm9wcy5vcHRpb25zPy5wYXNzdGhyb3VnaEJlaGF2aW9yLFxuICAgICAgcmVxdWVzdFBhcmFtZXRlcnM6IHByb3BzLm9wdGlvbnM/LnJlcXVlc3RQYXJhbWV0ZXJzLFxuICAgICAgcmVxdWVzdFRlbXBsYXRlczogcHJvcHMub3B0aW9ucz8ucmVxdWVzdFRlbXBsYXRlcyxcbiAgICAgIHJlc3BvbnNlczogdGhpcy5yZXNvbHZlUmVzcG9uc2VzKHByb3BzKSxcbiAgICAgIHRpbWVvdXRJbk1pbGxpczogdGhpcy5yZXNvbHZlVGltZW91dChwcm9wcyksXG4gICAgICB0eXBlOiBwcm9wcy50eXBlLFxuICAgICAgLy90bHNDb25maWc6IHByb3BzLm9wdGlvbnM/LlxuICAgICAgdXJpOiBwcm9wcy51cmksXG4gICAgfTtcbiAgfVxuXG4gIHByaXZhdGUgcmVzb2x2ZVRpbWVvdXQocHJvcHM6IEludGVncmF0aW9uUHJvcHMpOiBudW1iZXIgfCB1bmRlZmluZWQge1xuICAgIGlmICh0eXBlb2YgcHJvcHMub3B0aW9ucz8udGltZW91dCAhPT0gJ3VuZGVmaW5lZCcpIHtcbiAgICAgIHJldHVybiBwcm9wcy5vcHRpb25zLnRpbWVvdXQudG9NaWxsaXNlY29uZHMoKTtcbiAgICB9XG4gICAgcmV0dXJuIHVuZGVmaW5lZDtcbiAgfVxuXG4gIHByaXZhdGUgcmVzb2x2ZVJlc3BvbnNlcyhwcm9wczogSW50ZWdyYXRpb25Qcm9wcyk6IFhBbWF6b25BcGlnYXRld2F5SW50ZWdyYXRpb25SZXNwb25zZXMgfCB1bmRlZmluZWQge1xuICAgIGNvbnN0IHJlc3BvbnNlczogWEFtYXpvbkFwaWdhdGV3YXlJbnRlZ3JhdGlvblJlc3BvbnNlcyA9IHt9O1xuICAgIHByb3BzLm9wdGlvbnM/LmludGVncmF0aW9uUmVzcG9uc2VzPy5mb3JFYWNoKHJlc3AgPT4ge1xuXG4gICAgICBjb25zdCBzZWxlY3Rpb25QYXR0ZXJuID0gdGhpcy5yZXNvbHZlU2VsZWN0aW9uUGF0dGVybihwcm9wcy5vcHRpb25zIS5pbnRlZ3JhdGlvblJlc3BvbnNlcyEsIHJlc3ApO1xuXG4gICAgICBpZiAodHlwZW9mIHNlbGVjdGlvblBhdHRlcm4gPT09ICd1bmRlZmluZWQnKSB7XG4gICAgICAgIHRocm93IG5ldyBFcnJvcignWW91IG11c3QgcHJvdmlkZSBhIHNlbGVjdGlvblBhdHRlcm4gd2hlbiBtdWx0aXBsZSBpbnRlZ3JhdGlvbiByZXNwb25zZXMgZGVmaW5lZCcpO1xuICAgICAgfVxuXG4gICAgICByZXNwb25zZXNbc2VsZWN0aW9uUGF0dGVybl0gPSB7XG4gICAgICAgIHN0YXR1c0NvZGU6IHJlc3Auc3RhdHVzQ29kZSxcbiAgICAgICAgcmVzcG9uc2VQYXJhbWV0ZXJzOiByZXNwLnJlc3BvbnNlUGFyYW1ldGVycyxcbiAgICAgICAgcmVzcG9uc2VUZW1wbGF0ZXM6IHJlc3AucmVzcG9uc2VUZW1wbGF0ZXMsXG4gICAgICAgIGNvbnRlbnRIYW5kbGluZzogcmVzcC5jb250ZW50SGFuZGxpbmcsXG5cbiAgICAgIH07XG4gICAgfSk7XG4gICAgcmV0dXJuIHJlc3BvbnNlcztcbiAgfVxuXG4gIC8qKlxuICAgKiBEZWNpZGUgc2VsZWN0aW9uIHBhdHRlcm4uXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Nkay9hcGkvdjIvZG9jcy9hd3MtY2RrLWxpYi5hd3NfYXBpZ2F0ZXdheS5JbnRlZ3JhdGlvblJlc3BvbnNlLmh0bWwjc2VsZWN0aW9ucGF0dGVyblxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hcGlnYXRld2F5L2xhdGVzdC9kZXZlbG9wZXJndWlkZS9hcGktZ2F0ZXdheS1zd2FnZ2VyLWV4dGVuc2lvbnMtaW50ZWdyYXRpb24tcmVzcG9uc2VzLmh0bWxcbiAgICpcbiAgICogQGRlZmF1bHRcbiAgICogcmVzcC5zdGF0dXNDb2RlXG4gICAqL1xuICBwcml2YXRlIHJlc29sdmVTZWxlY3Rpb25QYXR0ZXJuKHJlc3BvbnNlczogSW50ZWdyYXRpb25SZXNwb25zZVtdLCByZXNwOiBJbnRlZ3JhdGlvblJlc3BvbnNlKTogc3RyaW5nIHwgdW5kZWZpbmVkIHtcblxuICAgIGlmICh0eXBlb2YgcmVzcD8uc2VsZWN0aW9uUGF0dGVybiA9PT0gJ3N0cmluZycpIHtcbiAgICAgIHJldHVybiByZXNwLnNlbGVjdGlvblBhdHRlcm47XG4gICAgfVxuXG4gICAgaWYgKHJlc3BvbnNlcy5sZW5ndGggPT09IDEpIHtcbiAgICAgIHJldHVybiAnZGVmYXVsdCc7XG4gICAgfVxuXG4gICAgcmV0dXJuIHVuZGVmaW5lZDtcbiAgfVxuXG59XG5cbiJdfQ==