import { AwsIntegrationProps as CdkAwsIntegrationProps } from 'aws-cdk-lib/aws-apigateway';
import { Construct } from 'constructs';
import { Integration, ValidatorConfig } from './base';
export interface AwsIntegrationProps extends CdkAwsIntegrationProps, ValidatorConfig {
}
/** Defines direct AWS service integration. */
export declare class AwsIntegration extends Integration {
    /** Resolves the AWS service integration URI. */
    private static resolveUri;
    /**
     * Defines direct AWS service integration.
     *
     * @example
     * '/item': {
     *   'GET': new openapix.AwsIntegration(this, {
     *     service: 'dynamodb',
     *     action: 'GetItem',
     *     options: {
     *       credentialsRole: role,
     *       requestTemplates: {
     *         'application/json': JSON.stringify({
     *           "TableName": table.tableName,
     *           "Key": {
     *             'PK': {
     *               "S": "$input.params('item')"
     *             }
     *           }
     *         }),
     *       },
     *     },
     *   }),
     * },
     */
    constructor(scope: Construct, props: AwsIntegrationProps);
}
