"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CognitoUserPoolsAuthorizer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
// implements AuthorizerConfig ... JSII doesn't like
class CognitoUserPoolsAuthorizer extends constructs_1.Construct {
    constructor(scope, id, props) {
        const { cognitoUserPools, resultsCacheTtl } = props;
        super(scope, id);
        this.id = id;
        this.xAmazonApigatewayAuthtype = 'cognito_user_pools';
        this.xAmazonApigatewayAuthorizer = {
            type: 'cognito_user_pools',
            providerARNs: cognitoUserPools.map(p => p.userPoolArn),
            authorizerResultTtlInSeconds: (function () {
                if (typeof resultsCacheTtl !== 'undefined') {
                    return resultsCacheTtl.toSeconds();
                }
                return undefined;
            }()),
        };
    }
}
exports.CognitoUserPoolsAuthorizer = CognitoUserPoolsAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
CognitoUserPoolsAuthorizer[_a] = { fqn: "@alma-cdk/openapix.CognitoUserPoolsAuthorizer", version: "0.0.49" };
//# sourceMappingURL=data:application/json;base64,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