# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CoreNetworkArgs', 'CoreNetwork']

@pulumi.input_type
class CoreNetworkArgs:
    def __init__(__self__, *,
                 global_network_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 policy_document: Optional[Any] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['CoreNetworkTagArgs']]]] = None):
        """
        The set of arguments for constructing a CoreNetwork resource.
        :param pulumi.Input[str] global_network_id: The ID of the global network that your core network is a part of.
        :param pulumi.Input[str] description: The description of core network
        :param Any policy_document: Live policy document for the core network, you must provide PolicyDocument in Json Format
        :param pulumi.Input[Sequence[pulumi.Input['CoreNetworkTagArgs']]] tags: The tags for the global network.
        """
        pulumi.set(__self__, "global_network_id", global_network_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if policy_document is not None:
            pulumi.set(__self__, "policy_document", policy_document)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="globalNetworkId")
    def global_network_id(self) -> pulumi.Input[str]:
        """
        The ID of the global network that your core network is a part of.
        """
        return pulumi.get(self, "global_network_id")

    @global_network_id.setter
    def global_network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "global_network_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of core network
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Optional[Any]:
        """
        Live policy document for the core network, you must provide PolicyDocument in Json Format
        """
        return pulumi.get(self, "policy_document")

    @policy_document.setter
    def policy_document(self, value: Optional[Any]):
        pulumi.set(self, "policy_document", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CoreNetworkTagArgs']]]]:
        """
        The tags for the global network.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CoreNetworkTagArgs']]]]):
        pulumi.set(self, "tags", value)


warnings.warn("""CoreNetwork is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)


class CoreNetwork(pulumi.CustomResource):
    warnings.warn("""CoreNetwork is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 global_network_id: Optional[pulumi.Input[str]] = None,
                 policy_document: Optional[Any] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CoreNetworkTagArgs']]]]] = None,
                 __props__=None):
        """
        AWS::NetworkManager::CoreNetwork Resource Type Definition.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of core network
        :param pulumi.Input[str] global_network_id: The ID of the global network that your core network is a part of.
        :param Any policy_document: Live policy document for the core network, you must provide PolicyDocument in Json Format
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CoreNetworkTagArgs']]]] tags: The tags for the global network.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CoreNetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        AWS::NetworkManager::CoreNetwork Resource Type Definition.

        :param str resource_name: The name of the resource.
        :param CoreNetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CoreNetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 global_network_id: Optional[pulumi.Input[str]] = None,
                 policy_document: Optional[Any] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CoreNetworkTagArgs']]]]] = None,
                 __props__=None):
        pulumi.log.warn("""CoreNetwork is deprecated: CoreNetwork is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CoreNetworkArgs.__new__(CoreNetworkArgs)

            __props__.__dict__["description"] = description
            if global_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'global_network_id'")
            __props__.__dict__["global_network_id"] = global_network_id
            __props__.__dict__["policy_document"] = policy_document
            __props__.__dict__["tags"] = tags
            __props__.__dict__["core_network_arn"] = None
            __props__.__dict__["core_network_id"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["edges"] = None
            __props__.__dict__["owner_account"] = None
            __props__.__dict__["segments"] = None
            __props__.__dict__["state"] = None
        super(CoreNetwork, __self__).__init__(
            'aws-native:networkmanager:CoreNetwork',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'CoreNetwork':
        """
        Get an existing CoreNetwork resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = CoreNetworkArgs.__new__(CoreNetworkArgs)

        __props__.__dict__["core_network_arn"] = None
        __props__.__dict__["core_network_id"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["edges"] = None
        __props__.__dict__["global_network_id"] = None
        __props__.__dict__["owner_account"] = None
        __props__.__dict__["policy_document"] = None
        __props__.__dict__["segments"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["tags"] = None
        return CoreNetwork(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="coreNetworkArn")
    def core_network_arn(self) -> pulumi.Output[str]:
        """
        The ARN (Amazon resource name) of core network
        """
        return pulumi.get(self, "core_network_arn")

    @property
    @pulumi.getter(name="coreNetworkId")
    def core_network_id(self) -> pulumi.Output[str]:
        """
        The Id of core network
        """
        return pulumi.get(self, "core_network_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The creation time of core network
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of core network
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def edges(self) -> pulumi.Output[Sequence['outputs.CoreNetworkEdge']]:
        """
        The edges within a core network.
        """
        return pulumi.get(self, "edges")

    @property
    @pulumi.getter(name="globalNetworkId")
    def global_network_id(self) -> pulumi.Output[str]:
        """
        The ID of the global network that your core network is a part of.
        """
        return pulumi.get(self, "global_network_id")

    @property
    @pulumi.getter(name="ownerAccount")
    def owner_account(self) -> pulumi.Output[str]:
        """
        Owner of the core network
        """
        return pulumi.get(self, "owner_account")

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> pulumi.Output[Optional[Any]]:
        """
        Live policy document for the core network, you must provide PolicyDocument in Json Format
        """
        return pulumi.get(self, "policy_document")

    @property
    @pulumi.getter
    def segments(self) -> pulumi.Output[Sequence['outputs.CoreNetworkSegment']]:
        """
        The segments within a core network.
        """
        return pulumi.get(self, "segments")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of core network
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.CoreNetworkTag']]]:
        """
        The tags for the global network.
        """
        return pulumi.get(self, "tags")

