# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'BrokerConfigurationId',
    'BrokerEncryptionOptions',
    'BrokerLdapServerMetadata',
    'BrokerLogList',
    'BrokerMaintenanceWindow',
    'BrokerTagsEntry',
    'BrokerUser',
    'ConfigurationAssociationConfigurationId',
    'ConfigurationTagsEntry',
]

@pulumi.output_type
class BrokerConfigurationId(dict):
    def __init__(__self__, *,
                 id: str,
                 revision: int):
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "revision", revision)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def revision(self) -> int:
        return pulumi.get(self, "revision")


@pulumi.output_type
class BrokerEncryptionOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "useAwsOwnedKey":
            suggest = "use_aws_owned_key"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BrokerEncryptionOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BrokerEncryptionOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BrokerEncryptionOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 use_aws_owned_key: bool,
                 kms_key_id: Optional[str] = None):
        pulumi.set(__self__, "use_aws_owned_key", use_aws_owned_key)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="useAwsOwnedKey")
    def use_aws_owned_key(self) -> bool:
        return pulumi.get(self, "use_aws_owned_key")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class BrokerLdapServerMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleBase":
            suggest = "role_base"
        elif key == "roleSearchMatching":
            suggest = "role_search_matching"
        elif key == "serviceAccountPassword":
            suggest = "service_account_password"
        elif key == "serviceAccountUsername":
            suggest = "service_account_username"
        elif key == "userBase":
            suggest = "user_base"
        elif key == "userSearchMatching":
            suggest = "user_search_matching"
        elif key == "roleName":
            suggest = "role_name"
        elif key == "roleSearchSubtree":
            suggest = "role_search_subtree"
        elif key == "userRoleName":
            suggest = "user_role_name"
        elif key == "userSearchSubtree":
            suggest = "user_search_subtree"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BrokerLdapServerMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BrokerLdapServerMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BrokerLdapServerMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hosts: Sequence[str],
                 role_base: str,
                 role_search_matching: str,
                 service_account_password: str,
                 service_account_username: str,
                 user_base: str,
                 user_search_matching: str,
                 role_name: Optional[str] = None,
                 role_search_subtree: Optional[bool] = None,
                 user_role_name: Optional[str] = None,
                 user_search_subtree: Optional[bool] = None):
        pulumi.set(__self__, "hosts", hosts)
        pulumi.set(__self__, "role_base", role_base)
        pulumi.set(__self__, "role_search_matching", role_search_matching)
        pulumi.set(__self__, "service_account_password", service_account_password)
        pulumi.set(__self__, "service_account_username", service_account_username)
        pulumi.set(__self__, "user_base", user_base)
        pulumi.set(__self__, "user_search_matching", user_search_matching)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if role_search_subtree is not None:
            pulumi.set(__self__, "role_search_subtree", role_search_subtree)
        if user_role_name is not None:
            pulumi.set(__self__, "user_role_name", user_role_name)
        if user_search_subtree is not None:
            pulumi.set(__self__, "user_search_subtree", user_search_subtree)

    @property
    @pulumi.getter
    def hosts(self) -> Sequence[str]:
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter(name="roleBase")
    def role_base(self) -> str:
        return pulumi.get(self, "role_base")

    @property
    @pulumi.getter(name="roleSearchMatching")
    def role_search_matching(self) -> str:
        return pulumi.get(self, "role_search_matching")

    @property
    @pulumi.getter(name="serviceAccountPassword")
    def service_account_password(self) -> str:
        return pulumi.get(self, "service_account_password")

    @property
    @pulumi.getter(name="serviceAccountUsername")
    def service_account_username(self) -> str:
        return pulumi.get(self, "service_account_username")

    @property
    @pulumi.getter(name="userBase")
    def user_base(self) -> str:
        return pulumi.get(self, "user_base")

    @property
    @pulumi.getter(name="userSearchMatching")
    def user_search_matching(self) -> str:
        return pulumi.get(self, "user_search_matching")

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[str]:
        return pulumi.get(self, "role_name")

    @property
    @pulumi.getter(name="roleSearchSubtree")
    def role_search_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "role_search_subtree")

    @property
    @pulumi.getter(name="userRoleName")
    def user_role_name(self) -> Optional[str]:
        return pulumi.get(self, "user_role_name")

    @property
    @pulumi.getter(name="userSearchSubtree")
    def user_search_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "user_search_subtree")


@pulumi.output_type
class BrokerLogList(dict):
    def __init__(__self__, *,
                 audit: Optional[bool] = None,
                 general: Optional[bool] = None):
        if audit is not None:
            pulumi.set(__self__, "audit", audit)
        if general is not None:
            pulumi.set(__self__, "general", general)

    @property
    @pulumi.getter
    def audit(self) -> Optional[bool]:
        return pulumi.get(self, "audit")

    @property
    @pulumi.getter
    def general(self) -> Optional[bool]:
        return pulumi.get(self, "general")


@pulumi.output_type
class BrokerMaintenanceWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "timeOfDay":
            suggest = "time_of_day"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BrokerMaintenanceWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BrokerMaintenanceWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BrokerMaintenanceWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: str,
                 time_of_day: str,
                 time_zone: str):
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "time_of_day", time_of_day)
        pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> str:
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="timeOfDay")
    def time_of_day(self) -> str:
        return pulumi.get(self, "time_of_day")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> str:
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class BrokerTagsEntry(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class BrokerUser(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consoleAccess":
            suggest = "console_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BrokerUser. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BrokerUser.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BrokerUser.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: str,
                 username: str,
                 console_access: Optional[bool] = None,
                 groups: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if console_access is not None:
            pulumi.set(__self__, "console_access", console_access)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="consoleAccess")
    def console_access(self) -> Optional[bool]:
        return pulumi.get(self, "console_access")

    @property
    @pulumi.getter
    def groups(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "groups")


@pulumi.output_type
class ConfigurationAssociationConfigurationId(dict):
    def __init__(__self__, *,
                 id: str,
                 revision: int):
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "revision", revision)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def revision(self) -> int:
        return pulumi.get(self, "revision")


@pulumi.output_type
class ConfigurationTagsEntry(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


