/*
 * SPDX-FileCopyrightText: 2006-2021 Istituto Italiano di Tecnologia (IIT)
 * SPDX-License-Identifier: BSD-3-Clause
 */

// Autogenerated by Thrift Compiler (0.14.1-yarped)
//
// This is an automatically generated file.
// It could get re-generated if the ALLOW_IDL_GENERATION flag is on.

#include <yarpdataplayer_console_IDL.h>

#include <yarp/os/idl/WireTypes.h>

class yarpdataplayer_console_IDL_step_helper :
        public yarp::os::Portable
{
public:
    explicit yarpdataplayer_console_IDL_step_helper();
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    thread_local static bool s_return_helper;
};

thread_local bool yarpdataplayer_console_IDL_step_helper::s_return_helper = {};

yarpdataplayer_console_IDL_step_helper::yarpdataplayer_console_IDL_step_helper()
{
    s_return_helper = {};
}

bool yarpdataplayer_console_IDL_step_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(1)) {
        return false;
    }
    if (!writer.writeTag("step", 1, 1)) {
        return false;
    }
    return true;
}

bool yarpdataplayer_console_IDL_step_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.readBool(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

class yarpdataplayer_console_IDL_setFrame_helper :
        public yarp::os::Portable
{
public:
    explicit yarpdataplayer_console_IDL_setFrame_helper(const std::int32_t frameNum);
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    std::int32_t m_frameNum;

    thread_local static bool s_return_helper;
};

thread_local bool yarpdataplayer_console_IDL_setFrame_helper::s_return_helper = {};

yarpdataplayer_console_IDL_setFrame_helper::yarpdataplayer_console_IDL_setFrame_helper(const std::int32_t frameNum) :
        m_frameNum{frameNum}
{
    s_return_helper = {};
}

bool yarpdataplayer_console_IDL_setFrame_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(2)) {
        return false;
    }
    if (!writer.writeTag("setFrame", 1, 1)) {
        return false;
    }
    if (!writer.writeI32(m_frameNum)) {
        return false;
    }
    return true;
}

bool yarpdataplayer_console_IDL_setFrame_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.readBool(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

class yarpdataplayer_console_IDL_getFrame_helper :
        public yarp::os::Portable
{
public:
    explicit yarpdataplayer_console_IDL_getFrame_helper(const std::string& name);
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    std::string m_name;

    thread_local static std::int32_t s_return_helper;
};

thread_local std::int32_t yarpdataplayer_console_IDL_getFrame_helper::s_return_helper = {};

yarpdataplayer_console_IDL_getFrame_helper::yarpdataplayer_console_IDL_getFrame_helper(const std::string& name) :
        m_name{name}
{
    s_return_helper = {};
}

bool yarpdataplayer_console_IDL_getFrame_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(2)) {
        return false;
    }
    if (!writer.writeTag("getFrame", 1, 1)) {
        return false;
    }
    if (!writer.writeString(m_name)) {
        return false;
    }
    return true;
}

bool yarpdataplayer_console_IDL_getFrame_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.readI32(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

class yarpdataplayer_console_IDL_load_helper :
        public yarp::os::Portable
{
public:
    explicit yarpdataplayer_console_IDL_load_helper(const std::string& path);
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    std::string m_path;

    thread_local static bool s_return_helper;
};

thread_local bool yarpdataplayer_console_IDL_load_helper::s_return_helper = {};

yarpdataplayer_console_IDL_load_helper::yarpdataplayer_console_IDL_load_helper(const std::string& path) :
        m_path{path}
{
    s_return_helper = {};
}

bool yarpdataplayer_console_IDL_load_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(2)) {
        return false;
    }
    if (!writer.writeTag("load", 1, 1)) {
        return false;
    }
    if (!writer.writeString(m_path)) {
        return false;
    }
    return true;
}

bool yarpdataplayer_console_IDL_load_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.readBool(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

class yarpdataplayer_console_IDL_play_helper :
        public yarp::os::Portable
{
public:
    explicit yarpdataplayer_console_IDL_play_helper();
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    thread_local static bool s_return_helper;
};

thread_local bool yarpdataplayer_console_IDL_play_helper::s_return_helper = {};

yarpdataplayer_console_IDL_play_helper::yarpdataplayer_console_IDL_play_helper()
{
    s_return_helper = {};
}

bool yarpdataplayer_console_IDL_play_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(1)) {
        return false;
    }
    if (!writer.writeTag("play", 1, 1)) {
        return false;
    }
    return true;
}

bool yarpdataplayer_console_IDL_play_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.readBool(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

class yarpdataplayer_console_IDL_pause_helper :
        public yarp::os::Portable
{
public:
    explicit yarpdataplayer_console_IDL_pause_helper();
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    thread_local static bool s_return_helper;
};

thread_local bool yarpdataplayer_console_IDL_pause_helper::s_return_helper = {};

yarpdataplayer_console_IDL_pause_helper::yarpdataplayer_console_IDL_pause_helper()
{
    s_return_helper = {};
}

bool yarpdataplayer_console_IDL_pause_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(1)) {
        return false;
    }
    if (!writer.writeTag("pause", 1, 1)) {
        return false;
    }
    return true;
}

bool yarpdataplayer_console_IDL_pause_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.readBool(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

class yarpdataplayer_console_IDL_stop_helper :
        public yarp::os::Portable
{
public:
    explicit yarpdataplayer_console_IDL_stop_helper();
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    thread_local static bool s_return_helper;
};

thread_local bool yarpdataplayer_console_IDL_stop_helper::s_return_helper = {};

yarpdataplayer_console_IDL_stop_helper::yarpdataplayer_console_IDL_stop_helper()
{
    s_return_helper = {};
}

bool yarpdataplayer_console_IDL_stop_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(1)) {
        return false;
    }
    if (!writer.writeTag("stop", 1, 1)) {
        return false;
    }
    return true;
}

bool yarpdataplayer_console_IDL_stop_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.readBool(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

class yarpdataplayer_console_IDL_enable_helper :
        public yarp::os::Portable
{
public:
    explicit yarpdataplayer_console_IDL_enable_helper(const std::string& part);
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    std::string m_part;

    thread_local static bool s_return_helper;
};

thread_local bool yarpdataplayer_console_IDL_enable_helper::s_return_helper = {};

yarpdataplayer_console_IDL_enable_helper::yarpdataplayer_console_IDL_enable_helper(const std::string& part) :
        m_part{part}
{
    s_return_helper = {};
}

bool yarpdataplayer_console_IDL_enable_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(2)) {
        return false;
    }
    if (!writer.writeTag("enable", 1, 1)) {
        return false;
    }
    if (!writer.writeString(m_part)) {
        return false;
    }
    return true;
}

bool yarpdataplayer_console_IDL_enable_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.readBool(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

class yarpdataplayer_console_IDL_disable_helper :
        public yarp::os::Portable
{
public:
    explicit yarpdataplayer_console_IDL_disable_helper(const std::string& part);
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    std::string m_part;

    thread_local static bool s_return_helper;
};

thread_local bool yarpdataplayer_console_IDL_disable_helper::s_return_helper = {};

yarpdataplayer_console_IDL_disable_helper::yarpdataplayer_console_IDL_disable_helper(const std::string& part) :
        m_part{part}
{
    s_return_helper = {};
}

bool yarpdataplayer_console_IDL_disable_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(2)) {
        return false;
    }
    if (!writer.writeTag("disable", 1, 1)) {
        return false;
    }
    if (!writer.writeString(m_part)) {
        return false;
    }
    return true;
}

bool yarpdataplayer_console_IDL_disable_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.readBool(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

class yarpdataplayer_console_IDL_getAllParts_helper :
        public yarp::os::Portable
{
public:
    explicit yarpdataplayer_console_IDL_getAllParts_helper();
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    thread_local static std::vector<std::string> s_return_helper;
};

thread_local std::vector<std::string> yarpdataplayer_console_IDL_getAllParts_helper::s_return_helper = {};

yarpdataplayer_console_IDL_getAllParts_helper::yarpdataplayer_console_IDL_getAllParts_helper()
{
}

bool yarpdataplayer_console_IDL_getAllParts_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(1)) {
        return false;
    }
    if (!writer.writeTag("getAllParts", 1, 1)) {
        return false;
    }
    return true;
}

bool yarpdataplayer_console_IDL_getAllParts_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    s_return_helper.clear();
    uint32_t _size0;
    yarp::os::idl::WireState _etype3;
    reader.readListBegin(_etype3, _size0);
    s_return_helper.resize(_size0);
    for (size_t _i4 = 0; _i4 < _size0; ++_i4) {
        if (!reader.readString(s_return_helper[_i4])) {
            reader.fail();
            return false;
        }
    }
    reader.readListEnd();
    return true;
}

class yarpdataplayer_console_IDL_getPortName_helper :
        public yarp::os::Portable
{
public:
    explicit yarpdataplayer_console_IDL_getPortName_helper(const std::string& part);
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    std::string m_part;

    thread_local static std::string s_return_helper;
};

thread_local std::string yarpdataplayer_console_IDL_getPortName_helper::s_return_helper = {};

yarpdataplayer_console_IDL_getPortName_helper::yarpdataplayer_console_IDL_getPortName_helper(const std::string& part) :
        m_part{part}
{
    s_return_helper = {};
}

bool yarpdataplayer_console_IDL_getPortName_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(2)) {
        return false;
    }
    if (!writer.writeTag("getPortName", 1, 1)) {
        return false;
    }
    if (!writer.writeString(m_part)) {
        return false;
    }
    return true;
}

bool yarpdataplayer_console_IDL_getPortName_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.readString(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

class yarpdataplayer_console_IDL_setPortName_helper :
        public yarp::os::Portable
{
public:
    explicit yarpdataplayer_console_IDL_setPortName_helper(const std::string& part, const std::string& new_name);
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    std::string m_part;
    std::string m_new_name;

    thread_local static bool s_return_helper;
};

thread_local bool yarpdataplayer_console_IDL_setPortName_helper::s_return_helper = {};

yarpdataplayer_console_IDL_setPortName_helper::yarpdataplayer_console_IDL_setPortName_helper(const std::string& part, const std::string& new_name) :
        m_part{part},
        m_new_name{new_name}
{
    s_return_helper = {};
}

bool yarpdataplayer_console_IDL_setPortName_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(3)) {
        return false;
    }
    if (!writer.writeTag("setPortName", 1, 1)) {
        return false;
    }
    if (!writer.writeString(m_part)) {
        return false;
    }
    if (!writer.writeString(m_new_name)) {
        return false;
    }
    return true;
}

bool yarpdataplayer_console_IDL_setPortName_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.readBool(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

class yarpdataplayer_console_IDL_setSpeed_helper :
        public yarp::os::Portable
{
public:
    explicit yarpdataplayer_console_IDL_setSpeed_helper(const double speed);
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    double m_speed;

    thread_local static bool s_return_helper;
};

thread_local bool yarpdataplayer_console_IDL_setSpeed_helper::s_return_helper = {};

yarpdataplayer_console_IDL_setSpeed_helper::yarpdataplayer_console_IDL_setSpeed_helper(const double speed) :
        m_speed{speed}
{
    s_return_helper = {};
}

bool yarpdataplayer_console_IDL_setSpeed_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(2)) {
        return false;
    }
    if (!writer.writeTag("setSpeed", 1, 1)) {
        return false;
    }
    if (!writer.writeFloat64(m_speed)) {
        return false;
    }
    return true;
}

bool yarpdataplayer_console_IDL_setSpeed_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.readBool(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

class yarpdataplayer_console_IDL_getSpeed_helper :
        public yarp::os::Portable
{
public:
    explicit yarpdataplayer_console_IDL_getSpeed_helper();
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    thread_local static double s_return_helper;
};

thread_local double yarpdataplayer_console_IDL_getSpeed_helper::s_return_helper = {};

yarpdataplayer_console_IDL_getSpeed_helper::yarpdataplayer_console_IDL_getSpeed_helper()
{
    s_return_helper = {};
}

bool yarpdataplayer_console_IDL_getSpeed_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(1)) {
        return false;
    }
    if (!writer.writeTag("getSpeed", 1, 1)) {
        return false;
    }
    return true;
}

bool yarpdataplayer_console_IDL_getSpeed_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.readFloat64(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

class yarpdataplayer_console_IDL_repeat_helper :
        public yarp::os::Portable
{
public:
    explicit yarpdataplayer_console_IDL_repeat_helper(const bool val);
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    bool m_val;

    thread_local static bool s_return_helper;
};

thread_local bool yarpdataplayer_console_IDL_repeat_helper::s_return_helper = {};

yarpdataplayer_console_IDL_repeat_helper::yarpdataplayer_console_IDL_repeat_helper(const bool val) :
        m_val{val}
{
    s_return_helper = {};
}

bool yarpdataplayer_console_IDL_repeat_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(2)) {
        return false;
    }
    if (!writer.writeTag("repeat", 1, 1)) {
        return false;
    }
    if (!writer.writeBool(m_val)) {
        return false;
    }
    return true;
}

bool yarpdataplayer_console_IDL_repeat_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.readBool(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

class yarpdataplayer_console_IDL_setStrict_helper :
        public yarp::os::Portable
{
public:
    explicit yarpdataplayer_console_IDL_setStrict_helper(const bool val);
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    bool m_val;

    thread_local static bool s_return_helper;
};

thread_local bool yarpdataplayer_console_IDL_setStrict_helper::s_return_helper = {};

yarpdataplayer_console_IDL_setStrict_helper::yarpdataplayer_console_IDL_setStrict_helper(const bool val) :
        m_val{val}
{
    s_return_helper = {};
}

bool yarpdataplayer_console_IDL_setStrict_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(2)) {
        return false;
    }
    if (!writer.writeTag("setStrict", 1, 1)) {
        return false;
    }
    if (!writer.writeBool(m_val)) {
        return false;
    }
    return true;
}

bool yarpdataplayer_console_IDL_setStrict_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.readBool(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

class yarpdataplayer_console_IDL_forward_helper :
        public yarp::os::Portable
{
public:
    explicit yarpdataplayer_console_IDL_forward_helper(const std::int32_t steps);
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    std::int32_t m_steps;

    thread_local static bool s_return_helper;
};

thread_local bool yarpdataplayer_console_IDL_forward_helper::s_return_helper = {};

yarpdataplayer_console_IDL_forward_helper::yarpdataplayer_console_IDL_forward_helper(const std::int32_t steps) :
        m_steps{steps}
{
    s_return_helper = {};
}

bool yarpdataplayer_console_IDL_forward_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(2)) {
        return false;
    }
    if (!writer.writeTag("forward", 1, 1)) {
        return false;
    }
    if (!writer.writeI32(m_steps)) {
        return false;
    }
    return true;
}

bool yarpdataplayer_console_IDL_forward_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.readBool(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

class yarpdataplayer_console_IDL_backward_helper :
        public yarp::os::Portable
{
public:
    explicit yarpdataplayer_console_IDL_backward_helper(const std::int32_t steps);
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    std::int32_t m_steps;

    thread_local static bool s_return_helper;
};

thread_local bool yarpdataplayer_console_IDL_backward_helper::s_return_helper = {};

yarpdataplayer_console_IDL_backward_helper::yarpdataplayer_console_IDL_backward_helper(const std::int32_t steps) :
        m_steps{steps}
{
    s_return_helper = {};
}

bool yarpdataplayer_console_IDL_backward_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(2)) {
        return false;
    }
    if (!writer.writeTag("backward", 1, 1)) {
        return false;
    }
    if (!writer.writeI32(m_steps)) {
        return false;
    }
    return true;
}

bool yarpdataplayer_console_IDL_backward_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.readBool(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

class yarpdataplayer_console_IDL_getProgress_helper :
        public yarp::os::Portable
{
public:
    explicit yarpdataplayer_console_IDL_getProgress_helper();
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    thread_local static double s_return_helper;
};

thread_local double yarpdataplayer_console_IDL_getProgress_helper::s_return_helper = {};

yarpdataplayer_console_IDL_getProgress_helper::yarpdataplayer_console_IDL_getProgress_helper()
{
    s_return_helper = {};
}

bool yarpdataplayer_console_IDL_getProgress_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(1)) {
        return false;
    }
    if (!writer.writeTag("getProgress", 1, 1)) {
        return false;
    }
    return true;
}

bool yarpdataplayer_console_IDL_getProgress_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.readFloat64(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

class yarpdataplayer_console_IDL_getStatus_helper :
        public yarp::os::Portable
{
public:
    explicit yarpdataplayer_console_IDL_getStatus_helper();
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    thread_local static std::string s_return_helper;
};

thread_local std::string yarpdataplayer_console_IDL_getStatus_helper::s_return_helper = {};

yarpdataplayer_console_IDL_getStatus_helper::yarpdataplayer_console_IDL_getStatus_helper()
{
    s_return_helper = {};
}

bool yarpdataplayer_console_IDL_getStatus_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(1)) {
        return false;
    }
    if (!writer.writeTag("getStatus", 1, 1)) {
        return false;
    }
    return true;
}

bool yarpdataplayer_console_IDL_getStatus_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.readString(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

class yarpdataplayer_console_IDL_resume_helper :
        public yarp::os::Portable
{
public:
    explicit yarpdataplayer_console_IDL_resume_helper();
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    thread_local static bool s_return_helper;
};

thread_local bool yarpdataplayer_console_IDL_resume_helper::s_return_helper = {};

yarpdataplayer_console_IDL_resume_helper::yarpdataplayer_console_IDL_resume_helper()
{
    s_return_helper = {};
}

bool yarpdataplayer_console_IDL_resume_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(1)) {
        return false;
    }
    if (!writer.writeTag("resume", 1, 1)) {
        return false;
    }
    return true;
}

bool yarpdataplayer_console_IDL_resume_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.readBool(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

class yarpdataplayer_console_IDL_quit_helper :
        public yarp::os::Portable
{
public:
    explicit yarpdataplayer_console_IDL_quit_helper();
    bool write(yarp::os::ConnectionWriter& connection) const override;
    bool read(yarp::os::ConnectionReader& connection) override;

    thread_local static bool s_return_helper;
};

thread_local bool yarpdataplayer_console_IDL_quit_helper::s_return_helper = {};

yarpdataplayer_console_IDL_quit_helper::yarpdataplayer_console_IDL_quit_helper()
{
    s_return_helper = {};
}

bool yarpdataplayer_console_IDL_quit_helper::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(1)) {
        return false;
    }
    if (!writer.writeTag("quit", 1, 1)) {
        return false;
    }
    return true;
}

bool yarpdataplayer_console_IDL_quit_helper::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListReturn()) {
        return false;
    }
    if (!reader.readBool(s_return_helper)) {
        reader.fail();
        return false;
    }
    return true;
}

// Constructor
yarpdataplayer_console_IDL::yarpdataplayer_console_IDL()
{
    yarp().setOwner(*this);
}

bool yarpdataplayer_console_IDL::step()
{
    yarpdataplayer_console_IDL_step_helper helper{};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "bool yarpdataplayer_console_IDL::step()");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? yarpdataplayer_console_IDL_step_helper::s_return_helper : bool{};
}

bool yarpdataplayer_console_IDL::setFrame(const std::int32_t frameNum)
{
    yarpdataplayer_console_IDL_setFrame_helper helper{frameNum};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "bool yarpdataplayer_console_IDL::setFrame(const std::int32_t frameNum)");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? yarpdataplayer_console_IDL_setFrame_helper::s_return_helper : bool{};
}

std::int32_t yarpdataplayer_console_IDL::getFrame(const std::string& name)
{
    yarpdataplayer_console_IDL_getFrame_helper helper{name};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "std::int32_t yarpdataplayer_console_IDL::getFrame(const std::string& name)");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? yarpdataplayer_console_IDL_getFrame_helper::s_return_helper : std::int32_t{};
}

bool yarpdataplayer_console_IDL::load(const std::string& path)
{
    yarpdataplayer_console_IDL_load_helper helper{path};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "bool yarpdataplayer_console_IDL::load(const std::string& path)");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? yarpdataplayer_console_IDL_load_helper::s_return_helper : bool{};
}

bool yarpdataplayer_console_IDL::play()
{
    yarpdataplayer_console_IDL_play_helper helper{};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "bool yarpdataplayer_console_IDL::play()");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? yarpdataplayer_console_IDL_play_helper::s_return_helper : bool{};
}

bool yarpdataplayer_console_IDL::pause()
{
    yarpdataplayer_console_IDL_pause_helper helper{};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "bool yarpdataplayer_console_IDL::pause()");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? yarpdataplayer_console_IDL_pause_helper::s_return_helper : bool{};
}

bool yarpdataplayer_console_IDL::stop()
{
    yarpdataplayer_console_IDL_stop_helper helper{};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "bool yarpdataplayer_console_IDL::stop()");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? yarpdataplayer_console_IDL_stop_helper::s_return_helper : bool{};
}

bool yarpdataplayer_console_IDL::enable(const std::string& part)
{
    yarpdataplayer_console_IDL_enable_helper helper{part};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "bool yarpdataplayer_console_IDL::enable(const std::string& part)");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? yarpdataplayer_console_IDL_enable_helper::s_return_helper : bool{};
}

bool yarpdataplayer_console_IDL::disable(const std::string& part)
{
    yarpdataplayer_console_IDL_disable_helper helper{part};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "bool yarpdataplayer_console_IDL::disable(const std::string& part)");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? yarpdataplayer_console_IDL_disable_helper::s_return_helper : bool{};
}

std::vector<std::string> yarpdataplayer_console_IDL::getAllParts()
{
    yarpdataplayer_console_IDL_getAllParts_helper helper{};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "std::vector<std::string> yarpdataplayer_console_IDL::getAllParts()");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? yarpdataplayer_console_IDL_getAllParts_helper::s_return_helper : std::vector<std::string>{};
}

std::string yarpdataplayer_console_IDL::getPortName(const std::string& part)
{
    yarpdataplayer_console_IDL_getPortName_helper helper{part};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "std::string yarpdataplayer_console_IDL::getPortName(const std::string& part)");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? yarpdataplayer_console_IDL_getPortName_helper::s_return_helper : std::string{};
}

bool yarpdataplayer_console_IDL::setPortName(const std::string& part, const std::string& new_name)
{
    yarpdataplayer_console_IDL_setPortName_helper helper{part, new_name};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "bool yarpdataplayer_console_IDL::setPortName(const std::string& part, const std::string& new_name)");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? yarpdataplayer_console_IDL_setPortName_helper::s_return_helper : bool{};
}

bool yarpdataplayer_console_IDL::setSpeed(const double speed)
{
    yarpdataplayer_console_IDL_setSpeed_helper helper{speed};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "bool yarpdataplayer_console_IDL::setSpeed(const double speed)");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? yarpdataplayer_console_IDL_setSpeed_helper::s_return_helper : bool{};
}

double yarpdataplayer_console_IDL::getSpeed()
{
    yarpdataplayer_console_IDL_getSpeed_helper helper{};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "double yarpdataplayer_console_IDL::getSpeed()");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? yarpdataplayer_console_IDL_getSpeed_helper::s_return_helper : double{};
}

bool yarpdataplayer_console_IDL::repeat(const bool val)
{
    yarpdataplayer_console_IDL_repeat_helper helper{val};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "bool yarpdataplayer_console_IDL::repeat(const bool val)");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? yarpdataplayer_console_IDL_repeat_helper::s_return_helper : bool{};
}

bool yarpdataplayer_console_IDL::setStrict(const bool val)
{
    yarpdataplayer_console_IDL_setStrict_helper helper{val};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "bool yarpdataplayer_console_IDL::setStrict(const bool val)");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? yarpdataplayer_console_IDL_setStrict_helper::s_return_helper : bool{};
}

bool yarpdataplayer_console_IDL::forward(const std::int32_t steps)
{
    yarpdataplayer_console_IDL_forward_helper helper{steps};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "bool yarpdataplayer_console_IDL::forward(const std::int32_t steps)");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? yarpdataplayer_console_IDL_forward_helper::s_return_helper : bool{};
}

bool yarpdataplayer_console_IDL::backward(const std::int32_t steps)
{
    yarpdataplayer_console_IDL_backward_helper helper{steps};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "bool yarpdataplayer_console_IDL::backward(const std::int32_t steps)");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? yarpdataplayer_console_IDL_backward_helper::s_return_helper : bool{};
}

double yarpdataplayer_console_IDL::getProgress()
{
    yarpdataplayer_console_IDL_getProgress_helper helper{};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "double yarpdataplayer_console_IDL::getProgress()");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? yarpdataplayer_console_IDL_getProgress_helper::s_return_helper : double{};
}

std::string yarpdataplayer_console_IDL::getStatus()
{
    yarpdataplayer_console_IDL_getStatus_helper helper{};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "std::string yarpdataplayer_console_IDL::getStatus()");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? yarpdataplayer_console_IDL_getStatus_helper::s_return_helper : std::string{};
}

bool yarpdataplayer_console_IDL::resume()
{
    yarpdataplayer_console_IDL_resume_helper helper{};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "bool yarpdataplayer_console_IDL::resume()");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? yarpdataplayer_console_IDL_resume_helper::s_return_helper : bool{};
}

bool yarpdataplayer_console_IDL::quit()
{
    yarpdataplayer_console_IDL_quit_helper helper{};
    if (!yarp().canWrite()) {
        yError("Missing server method '%s'?", "bool yarpdataplayer_console_IDL::quit()");
    }
    bool ok = yarp().write(helper, helper);
    return ok ? yarpdataplayer_console_IDL_quit_helper::s_return_helper : bool{};
}

// help method
std::vector<std::string> yarpdataplayer_console_IDL::help(const std::string& functionName)
{
    bool showAll = (functionName == "--all");
    std::vector<std::string> helpString;
    if (showAll) {
        helpString.emplace_back("*** Available commands:");
        helpString.emplace_back("step");
        helpString.emplace_back("setFrame");
        helpString.emplace_back("getFrame");
        helpString.emplace_back("load");
        helpString.emplace_back("play");
        helpString.emplace_back("pause");
        helpString.emplace_back("stop");
        helpString.emplace_back("enable");
        helpString.emplace_back("disable");
        helpString.emplace_back("getAllParts");
        helpString.emplace_back("getPortName");
        helpString.emplace_back("setPortName");
        helpString.emplace_back("setSpeed");
        helpString.emplace_back("getSpeed");
        helpString.emplace_back("repeat");
        helpString.emplace_back("setStrict");
        helpString.emplace_back("forward");
        helpString.emplace_back("backward");
        helpString.emplace_back("getProgress");
        helpString.emplace_back("getStatus");
        helpString.emplace_back("resume");
        helpString.emplace_back("quit");
        helpString.emplace_back("help");
    } else {
        if (functionName == "step") {
            helpString.emplace_back("bool step() ");
            helpString.emplace_back("Steps the player once. The player will be stepped ");
            helpString.emplace_back("until all parts have sent data ");
            helpString.emplace_back("@return true/false on success/failure ");
        }
        if (functionName == "setFrame") {
            helpString.emplace_back("bool setFrame(const std::int32_t frameNum) ");
            helpString.emplace_back("Sets the frame number to the user desired frame. ");
            helpString.emplace_back("@param frameNum specifies the frame number the user ");
            helpString.emplace_back(" would like to skip to ");
            helpString.emplace_back("@return true/false on success/failure ");
        }
        if (functionName == "getFrame") {
            helpString.emplace_back("std::int32_t getFrame(const std::string& name) ");
            helpString.emplace_back("Gets the frame number the user is requesting ");
            helpString.emplace_back("@param name specifies the name of the data to modify ");
            helpString.emplace_back(" would like to skip to ");
            helpString.emplace_back("@return i32 returns the current frame index ");
        }
        if (functionName == "load") {
            helpString.emplace_back("bool load(const std::string& path) ");
            helpString.emplace_back("Loads a dataset from a path ");
            helpString.emplace_back("@return true/false on success/failure ");
        }
        if (functionName == "play") {
            helpString.emplace_back("bool play() ");
            helpString.emplace_back("Plays the dataSets ");
            helpString.emplace_back("@return true/false on success/failure ");
        }
        if (functionName == "pause") {
            helpString.emplace_back("bool pause() ");
            helpString.emplace_back("Pauses the dataSets ");
            helpString.emplace_back("@return true/false on success/failure ");
        }
        if (functionName == "stop") {
            helpString.emplace_back("bool stop() ");
            helpString.emplace_back("Stops the dataSets ");
            helpString.emplace_back("@return true/false on success/failure ");
        }
        if (functionName == "enable") {
            helpString.emplace_back("bool enable(const std::string& part) ");
            helpString.emplace_back("Enables the specified part. ");
            helpString.emplace_back("@param name specifies the name of the loaded data ");
            helpString.emplace_back("@return true/false on success/failure ");
        }
        if (functionName == "disable") {
            helpString.emplace_back("bool disable(const std::string& part) ");
            helpString.emplace_back("Disable the specified part. ");
            helpString.emplace_back("@param name specifies the name of the loaded data ");
            helpString.emplace_back("@return true/false on success/failure ");
        }
        if (functionName == "getAllParts") {
            helpString.emplace_back("std::vector<std::string> getAllParts() ");
            helpString.emplace_back("Gets the names of all parts loaded. ");
            helpString.emplace_back("@return list of names of the loaded parts. ");
        }
        if (functionName == "getPortName") {
            helpString.emplace_back("std::string getPortName(const std::string& part) ");
            helpString.emplace_back("Gets the name of the port associated to the specified part ");
            helpString.emplace_back("@param name specifies the name of the data to modify ");
            helpString.emplace_back("@return port name ");
        }
        if (functionName == "setPortName") {
            helpString.emplace_back("bool setPortName(const std::string& part, const std::string& new_name) ");
            helpString.emplace_back("Sets the name of the port associated to the specified part ");
            helpString.emplace_back("@param part specifies the name of the data to modify ");
            helpString.emplace_back("@param new_name specifies the new name to assign to the port ");
            helpString.emplace_back("@return true/false on success/failure ");
        }
        if (functionName == "setSpeed") {
            helpString.emplace_back("bool setSpeed(const double speed) ");
            helpString.emplace_back("Sets the player speed ");
            helpString.emplace_back("@param speed specifies ");
            helpString.emplace_back("@return true/false on success/failure ");
        }
        if (functionName == "getSpeed") {
            helpString.emplace_back("double getSpeed() ");
            helpString.emplace_back("Gets the player speed ");
            helpString.emplace_back("@return value of the player speed ");
        }
        if (functionName == "repeat") {
            helpString.emplace_back("bool repeat(const bool val = 0) ");
            helpString.emplace_back("Sets repeat mode ");
            helpString.emplace_back("@param val if true repeat mode is active. ");
            helpString.emplace_back("@return true/false on success/failure ");
        }
        if (functionName == "setStrict") {
            helpString.emplace_back("bool setStrict(const bool val = 0) ");
            helpString.emplace_back("Sets strict mode ");
            helpString.emplace_back("@param val if true strict mode is active. ");
            helpString.emplace_back("@return true/false on success/failure ");
        }
        if (functionName == "forward") {
            helpString.emplace_back("bool forward(const std::int32_t steps = 5) ");
            helpString.emplace_back("Steps forward ");
            helpString.emplace_back("@param steps number of steps to go forward (default=5). ");
            helpString.emplace_back("@return true/false on success/failure ");
        }
        if (functionName == "backward") {
            helpString.emplace_back("bool backward(const std::int32_t steps = 5) ");
            helpString.emplace_back("Steps backward ");
            helpString.emplace_back("@param steps number of steps to go backward (default=5). ");
            helpString.emplace_back("@return true/false on success/failure ");
        }
        if (functionName == "getProgress") {
            helpString.emplace_back("double getProgress() ");
            helpString.emplace_back("Get the progress of the parts ");
            helpString.emplace_back("@return the progress of the parts ");
        }
        if (functionName == "getStatus") {
            helpString.emplace_back("std::string getStatus() ");
            helpString.emplace_back("Get the status of playing ");
            helpString.emplace_back("@return the status (playing, paused, stopped) ");
        }
        if (functionName == "resume") {
            helpString.emplace_back("bool resume() ");
            helpString.emplace_back("Resume dataset from where it was paused ");
            helpString.emplace_back("@return true/false on success/failure ");
        }
        if (functionName == "quit") {
            helpString.emplace_back("bool quit() ");
            helpString.emplace_back("Quit the module. ");
            helpString.emplace_back("@return true/false on success/failure ");
        }
        if (functionName == "help") {
            helpString.emplace_back("std::vector<std::string> help(const std::string& functionName = \"--all\")");
            helpString.emplace_back("Return list of available commands, or help message for a specific function");
            helpString.emplace_back("@param functionName name of command for which to get a detailed description. If none or '--all' is provided, print list of available commands");
            helpString.emplace_back("@return list of strings (one string per line)");
        }
    }
    if (helpString.empty()) {
        helpString.emplace_back("Command not found");
    }
    return helpString;
}

// read from ConnectionReader
bool yarpdataplayer_console_IDL::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    reader.expectAccept();
    if (!reader.readListHeader()) {
        reader.fail();
        return false;
    }

    std::string tag = reader.readTag();
    bool direct = (tag == "__direct__");
    if (direct) {
        tag = reader.readTag();
    }
    while (!reader.isError()) {
        if (tag == "step") {
            yarpdataplayer_console_IDL_step_helper::s_return_helper = step();
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeBool(yarpdataplayer_console_IDL_step_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "setFrame") {
            std::int32_t frameNum;
            if (!reader.readI32(frameNum)) {
                reader.fail();
                return false;
            }
            yarpdataplayer_console_IDL_setFrame_helper::s_return_helper = setFrame(frameNum);
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeBool(yarpdataplayer_console_IDL_setFrame_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "getFrame") {
            std::string name;
            if (!reader.readString(name)) {
                reader.fail();
                return false;
            }
            yarpdataplayer_console_IDL_getFrame_helper::s_return_helper = getFrame(name);
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeI32(yarpdataplayer_console_IDL_getFrame_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "load") {
            std::string path;
            if (!reader.readString(path)) {
                reader.fail();
                return false;
            }
            yarpdataplayer_console_IDL_load_helper::s_return_helper = load(path);
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeBool(yarpdataplayer_console_IDL_load_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "play") {
            yarpdataplayer_console_IDL_play_helper::s_return_helper = play();
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeBool(yarpdataplayer_console_IDL_play_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "pause") {
            yarpdataplayer_console_IDL_pause_helper::s_return_helper = pause();
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeBool(yarpdataplayer_console_IDL_pause_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "stop") {
            yarpdataplayer_console_IDL_stop_helper::s_return_helper = stop();
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeBool(yarpdataplayer_console_IDL_stop_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "enable") {
            std::string part;
            if (!reader.readString(part)) {
                reader.fail();
                return false;
            }
            yarpdataplayer_console_IDL_enable_helper::s_return_helper = enable(part);
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeBool(yarpdataplayer_console_IDL_enable_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "disable") {
            std::string part;
            if (!reader.readString(part)) {
                reader.fail();
                return false;
            }
            yarpdataplayer_console_IDL_disable_helper::s_return_helper = disable(part);
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeBool(yarpdataplayer_console_IDL_disable_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "getAllParts") {
            yarpdataplayer_console_IDL_getAllParts_helper::s_return_helper = getAllParts();
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeListBegin(BOTTLE_TAG_STRING, static_cast<uint32_t>(yarpdataplayer_console_IDL_getAllParts_helper::s_return_helper.size()))) {
                    return false;
                }
                for (const auto& _item5 : yarpdataplayer_console_IDL_getAllParts_helper::s_return_helper) {
                    if (!writer.writeString(_item5)) {
                        return false;
                    }
                }
                if (!writer.writeListEnd()) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "getPortName") {
            std::string part;
            if (!reader.readString(part)) {
                reader.fail();
                return false;
            }
            yarpdataplayer_console_IDL_getPortName_helper::s_return_helper = getPortName(part);
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeString(yarpdataplayer_console_IDL_getPortName_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "setPortName") {
            std::string part;
            std::string new_name;
            if (!reader.readString(part)) {
                reader.fail();
                return false;
            }
            if (!reader.readString(new_name)) {
                reader.fail();
                return false;
            }
            yarpdataplayer_console_IDL_setPortName_helper::s_return_helper = setPortName(part, new_name);
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeBool(yarpdataplayer_console_IDL_setPortName_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "setSpeed") {
            double speed;
            if (!reader.readFloat64(speed)) {
                reader.fail();
                return false;
            }
            yarpdataplayer_console_IDL_setSpeed_helper::s_return_helper = setSpeed(speed);
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeBool(yarpdataplayer_console_IDL_setSpeed_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "getSpeed") {
            yarpdataplayer_console_IDL_getSpeed_helper::s_return_helper = getSpeed();
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeFloat64(yarpdataplayer_console_IDL_getSpeed_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "repeat") {
            bool val;
            if (!reader.readBool(val)) {
                val = 0;
            }
            yarpdataplayer_console_IDL_repeat_helper::s_return_helper = repeat(val);
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeBool(yarpdataplayer_console_IDL_repeat_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "setStrict") {
            bool val;
            if (!reader.readBool(val)) {
                val = 0;
            }
            yarpdataplayer_console_IDL_setStrict_helper::s_return_helper = setStrict(val);
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeBool(yarpdataplayer_console_IDL_setStrict_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "forward") {
            std::int32_t steps;
            if (!reader.readI32(steps)) {
                steps = 5;
            }
            yarpdataplayer_console_IDL_forward_helper::s_return_helper = forward(steps);
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeBool(yarpdataplayer_console_IDL_forward_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "backward") {
            std::int32_t steps;
            if (!reader.readI32(steps)) {
                steps = 5;
            }
            yarpdataplayer_console_IDL_backward_helper::s_return_helper = backward(steps);
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeBool(yarpdataplayer_console_IDL_backward_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "getProgress") {
            yarpdataplayer_console_IDL_getProgress_helper::s_return_helper = getProgress();
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeFloat64(yarpdataplayer_console_IDL_getProgress_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "getStatus") {
            yarpdataplayer_console_IDL_getStatus_helper::s_return_helper = getStatus();
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeString(yarpdataplayer_console_IDL_getStatus_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "resume") {
            yarpdataplayer_console_IDL_resume_helper::s_return_helper = resume();
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeBool(yarpdataplayer_console_IDL_resume_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "quit") {
            yarpdataplayer_console_IDL_quit_helper::s_return_helper = quit();
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(1)) {
                    return false;
                }
                if (!writer.writeBool(yarpdataplayer_console_IDL_quit_helper::s_return_helper)) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (tag == "help") {
            std::string functionName;
            if (!reader.readString(functionName)) {
                functionName = "--all";
            }
            auto help_strings = help(functionName);
            yarp::os::idl::WireWriter writer(reader);
            if (!writer.isNull()) {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeTag("many", 1, 0)) {
                    return false;
                }
                if (!writer.writeListBegin(BOTTLE_TAG_INT32, static_cast<uint32_t>(help_strings.size()))) {
                    return false;
                }
                for (const auto& help_string : help_strings) {
                    if (!writer.writeString(help_string)) {
                        return false;
                    }
                }
                if (!writer.writeListEnd()) {
                    return false;
                }
            }
            reader.accept();
            return true;
        }
        if (reader.noMore()) {
            reader.fail();
            return false;
        }
        std::string next_tag = reader.readTag();
        if (next_tag == "") {
            break;
        }
        tag.append("_").append(next_tag);
    }
    return false;
}
