# coding=utf-8
from __future__ import print_function, absolute_import, unicode_literals

import getopt
import sys

# 基本api
from bw import __version__
# from bw.csdk.cpp_sdk import py_bwi_set_version
from bw.model.storage import Context
from bw.enum import *
from .basic import (
    set_token,set_srv_cache, get_version, subscribe, unsubscribe,
    current, get_strerror, schedule, run,  log, set_serv_addr, stop,set_cache)
# 数据查询api
from .query import (
    history_n, history, get_fundamentals,
    # get_dividend, 
    get_fundmental_set,
    # get_continuous_contracts,
     get_next_trading_date,
    get_previous_trading_date, get_trading_dates, get_concept, get_industry, get_constituents,
    #get_history_constituents,get_history_instruments, get_instrumentinfos, get_instruments,
get_plates
#, get_fundamentals_n
)
# 交易api
from .trade import (
   order_target_volume,
    order_volume, 
    order_percent, 
    order_value,
    order_target_value,
    order_target_percent,
    #  order_batch,
    order_cancel_all,
    order_cancel, order_close_all,
    get_orders,get_positions, get_unfinished_orders, get_execution_reports)

__all__ = [
    'order_target_volume', 
    'order_target_value',
     'order_target_percent',
    'order_volume', 
    'order_percent', 
    'order_value', 
    # 'order_batch',

    'order_cancel_all', 'order_cancel', 'order_close_all',
    'get_orders', 'get_positions','get_unfinished_orders','get_execution_reports',

    'set_token','set_srv_cache', 'get_version', 'subscribe', 'unsubscribe',
    'current', 'get_strerror', 'schedule', 'run','set_cache',
    'log', 'stop',

    'history_n', 'history',
     'get_fundamentals', 
     'get_fundmental_set',
    # 'get_dividend',
    # 'get_continuous_contracts', 
    'get_next_trading_date',
    'get_previous_trading_date', 'get_trading_dates', 
    'get_plates', 
    'get_concept',
    'get_industry',
    'get_constituents', 
    # 'get_history_constituents',
    # 'get_history_instruments', 'get_instrumentinfos', 'get_fundamentals_n',
    # 'get_instruments', 
    'set_serv_addr',

    'Context',

    'ExecType_Unknown',
    'ExecType_New',
    'ExecType_DoneForDay',
    'ExecType_Canceled',
    'ExecType_PendingCancel',
    'ExecType_Stopped',
    'ExecType_Rejected',
    'ExecType_Suspended',
    'ExecType_PendingNew',
    'ExecType_Calculated',
    'ExecType_Expired',
    'ExecType_Restated',
    'ExecType_PendingReplace',
    'ExecType_Trade',
    'ExecType_TradeCorrect',
    'ExecType_TradeCancel',
    'ExecType_OrderStatus',
    'ExecType_CancelRejected',
    'OrderStatus_Unknown',
    'OrderStatus_New',
    'OrderStatus_PartiallyFilled',
    'OrderStatus_Filled',
    'OrderStatus_DoneForDay',
    'OrderStatus_Canceled',
    'OrderStatus_PendingCancel',
    'OrderStatus_Stopped',
    'OrderStatus_Rejected',
    'OrderStatus_Suspended',
    'OrderStatus_PendingNew',
    'OrderStatus_Calculated',
    'OrderStatus_Expired',
    'OrderStatus_AcceptedForBidding',
    'OrderStatus_PendingReplace',
    'OrderRejectReason_Unknown',
    'OrderRejectReason_RiskRuleCheckFailed',
    'OrderRejectReason_NoEnoughCash',
    'OrderRejectReason_NoEnoughPosition',
    'OrderRejectReason_IllegalAccountId',
    'OrderRejectReason_IllegalStrategyId',
    'OrderRejectReason_IllegalSymbol',
    'OrderRejectReason_IllegalVolume',
    'OrderRejectReason_IllegalPrice',
    'OrderRejectReason_AccountDisabled',
    'OrderRejectReason_AccountDisconnected',
    'OrderRejectReason_AccountLoggedout',
    'OrderRejectReason_NotInTradingSession',
    'OrderRejectReason_OrderTypeNotSupported',
    'OrderRejectReason_Throttle',
    'CancelOrderRejectReason_OrderFinalized',
    'CancelOrderRejectReason_UnknownOrder',
    'CancelOrderRejectReason_BrokerOption',
    'CancelOrderRejectReason_AlreadyInPendingCancel',
    'OrderSide_Unknown',
    'OrderSide_Buy',
    'OrderSide_Sell',
    'OrderType_Unknown',
    'OrderType_Limit',
    'OrderType_Market',
    'OrderType_Stop',
    'OrderDuration_Unknown',
    'OrderDuration_FAK',
    'OrderDuration_FOK',
    'OrderDuration_GFD',
    'OrderDuration_GFS',
    'OrderDuration_GTD',
    'OrderDuration_GTC',
    'OrderDuration_GFA',
    'OrderQualifier_Unknown',
    'OrderQualifier_BOC',
    'OrderQualifier_BOP',
    'OrderQualifier_B5TC',
    'OrderQualifier_B5TL',
    'OrderStyle_Unknown',
    'OrderStyle_Volume',
    'OrderStyle_Value',
    'OrderStyle_Percent',
    'OrderStyle_TargetVolume',
    'OrderStyle_TargetValue',
    'OrderStyle_TargetPercent',
    'PositionSide_Unknown',
    'PositionSide_Long',
    'PositionSide_Short',
    'PositionEffect_Unknown',
    'PositionEffect_Open',
    'PositionEffect_Close',
    'PositionEffect_CloseToday',
    'PositionEffect_CloseYesterday',
    'CashPositionChangeReason_Unknown',
    'CashPositionChangeReason_Trade',
    'CashPositionChangeReason_Inout',
    'MODE_LIVE',
    'MODE_BACKTEST',
    'ADJUST_NONE',
    'ADJUST_PREV',
    'ADJUST_POST',
    
    'SEC_TYPE_STOCK',
    'SEC_TYPE_BOND',
    'SEC_TYPE_FUND',
    'SEC_TYPE_WARRANT',
    'SEC_TYPE_INDEX',
    'SEC_TYPE_FUTURES',
    'SEC_TYPE_STOCK_KC',
    'SEC_TYPE_PLATE',
    'SEC_TYPE_CONCEPT',
]

try:
    if sys.version_info.major < 3:
        __all__ = [str(item) for item in __all__]
    ver_info = sys.version_info
    sdk_lang = "python{}.{}".format(ver_info.major, ver_info.minor)
    sdk_version = __version__.__version__

    # py_bwi_set_version(sdk_version, sdk_lang)

    command_argv = sys.argv[1:]
    options, args = getopt.getopt(command_argv, None,
                                  ['strategy_id=', 'filename=',
                                   'mode=','usr=','pwd=' ,'token=', 'apitoken=',
                                   'backtest_start_time=',
                                   'backtest_end_time=',
                                   'backtest_initial_cash=',
                                   'backtest_transaction_ratio=',
                                   'backtest_commission_ratio=',
                                   'backtest_slippage_ratio=',
                                   'backtest_adjust=',
                                   'backtest_check_cache=',
                                   'serv_addr=',
                                   'port=',  # 用于pycharm的python console时会额外传入port参数
                                   ])

    for option, value in options:
        if option == '--serv_addr' and value:
            set_serv_addr(value)
            break
except BaseException as e:
    pass
