[EN_INTRO](./README_EN.md)
# 介绍
spparser 的目标是为文本数据的读写、处理提供一种简洁的、高效的方式。同时支持同步、异步读写文件，并支持正则、xpath、css选择器提取数据。未来将会实现对数据库的读写支持, 以及引入NLP以提供更灵活的处理方式。其架构图如下：  

![jiagoutu](data:image/jpg;base64,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)
  

其中异步读写部分受到 @zpoint的[idataapi_transform](https://github.com/zpoint/idataapi-transform)启发，在此表示感谢



# 安装
```shell
pip3 install spparser
```

# 快速开始

```python
from spparser import Reader, Writer, Extractor

def main():
    data = Reader.read_csv(file_path="./example.csv", each_line_type="dict", max_read_lines=10)
    '''
    example.csv:
    field1,field2
    1,2
    3,4
    5,6
    '''
    '''
    read_csv result: data = [{'a': '122github', 'b': '2'}, {'a': '-8spparser999', 'b': '4'}]
    '''
    alist = []
    for item in data:
        res = Extractor.regex(r"[a-zA-Z]+", item["a"], flags=0, trim_mode=True, return_all=False)
        alist.append(res)
    '''
    alist = ["github","spparser"]
    '''
    Writer.write(alist, "result.json")

if __name__ == "__main__":
    main()
```
  
使用Extractor.xpath() 提取html文本  
```python
from spparser import Reader, Writer, Extractor

def main():
    '''
    demo.html
    <html lang="en">
    <head>
        <title>spparser</title>
    </head>
    <body>
        <ul id="container">
            <li class="object-1" tag="1"/>
            <li class="object-2"/>
            <li class="object-3"/>
        </ul>
    </body>
    </html>
    '''
    '''
    read_csv result: data = [{'a': '122github', 'b': '2'}, {'a': '-8spparser999', 'b': '4'}]
    '''
    html_text = Reader.read_anyfile("demo.html",line_by_line=False)
    res = Extractor.xpath("//title/text()",hteml_text)
    print(res)

if __name__ == "__main__":
    main()
```  
异步读取文件

```python
from spparser import Reader,Writer, AsyncReader, AsyncWriter
import asyncio

async def main():
    reader = AsyncReader.async_csv_reader("./src.csv",batch_size=10,each_line_type="dict",max_read_lines=100, debug=True)
    with AsyncWriter.async_csv_writer("./dest.csv") as writer:
        async for items in reader:
            #for item in items:
                # Parser process
            await writer.write(items)

if __name__ == "__main__":
    loop = asyncio.get_event_loop()
    loop.run_until_complete(main())
```
debug设置为True时，输出日志:

```bash
[2020-07-17  14:54:04] AsyncReader.py[line:70] INFO: from source: ./src.csv, this batch get 10 items
[2020-07-17  14:54:04] AsyncWriter.py[line:63] INFO: to destination: ./dest.csv, write 10 items.
[2020-07-17  14:54:04] AsyncReader.py[line:70] INFO: from source: ./src.csv, this batch get 10 items
[2020-07-17  14:54:04] AsyncWriter.py[line:63] INFO: to destination: ./dest.csv, write 10 items.
[2020-07-17  14:54:04] AsyncReader.py[line:70] INFO: from source: ./src.csv, this batch get 10 items
[2020-07-17  14:54:04] AsyncWriter.py[line:63] INFO: to destination: ./dest.csv, write 10 items.
[2020-07-17  14:54:04] AsyncReader.py[line:70] INFO: from source: ./src.csv, this batch get 10 items
[2020-07-17  14:54:04] AsyncWriter.py[line:63] INFO: to destination: ./dest.csv, write 10 items.
...
```
# History
## 0.2.10
- async_anyfile_reader, async_anyfile_writer, async_csv_reader, async_csv_writer support.
- xpath, css, regex selectors in Exractor support.
