# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['onboardme']

package_data = \
{'': ['*'],
 'onboardme': ['config/*',
               'config/firewall/*',
               'config/firewall/ufw/*',
               'scripts/*']}

install_requires = \
['GitPython>=3.1.31,<4.0.0',
 'PyYAML>=6.0,<7.0',
 'click>=8.1.3,<9.0.0',
 'rich>=13.3.1,<14.0.0',
 'wget>=3.2,<4.0',
 'xdg>=5.1.1,<6.0.0']

entry_points = \
{'console_scripts': ['onboardme = onboardme:main']}

setup_kwargs = {
    'name': 'onboardme',
    'version': '0.18.3',
    'description': 'Install dot files and packages, including a base mode with sensible defaults to run on most computers running Debian based distros or macOS.',
    'long_description': '<h2 align="center">\n  <img\n    src="https://raw.githubusercontent.com/catppuccin/catppuccin/main/assets/misc/transparent.png"\n    height="30"\n    width="0px"\n  />\n  💻 onboard<i>me</i>\n  <img\n    src="https://raw.githubusercontent.com/catppuccin/catppuccin/main/assets/misc/transparent.png"\n    height="30"\n    width="0px"\n  />\n</h2>\n<p align="center">\n  <a href="https://github.com/jessebot/onboardme/releases">\n    <img src="https://img.shields.io/github/v/release/jessebot/onboardme?style=plastic&labelColor=484848&color=3CA324&logo=GitHub&logoColor=white">\n  </a>\n</p>\n\nGet\xa0your\xa0daily\xa0driver\xa0just\xa0the\xa0way\xa0you\xa0like\xa0it,\xa0from\xa0dot\xa0files installation,\xa0to\xa0opensource\xa0package\xa0installation, to other little features you didn\'t know you needed,\xa0`onboardme` intends to save you\xa0time\xa0with\xa0initializing\xa0and\xa0upgrading\xa0your\xa0environment.\n\n## Features\n\n#### Dot files\n- Manage your [dot files] using a git repo (or use [our default dot files] 😃)\n\n#### Package management\n- Install and upgrade libraries and apps\n  - use several package managers across Linux and macOS (you can even add your own!)\n  - group together packages for different kinds of setups, e.g. gaming, devops, gui\n\n#### Vim/NeoVim Plugin Management\n- Keep your [vim-plug] or [packer] plugins installed and up to date in both vim and neovim.\n\n#### Easy `yaml` config files\n- [config files](https://github.com/jessebot/onboardme#configuration) in your `$HOME/.config/onboardme/` directory\n  - we also support the [XDG Base Directory Spec] and will use `$XDG_CONFIG_HOME/onboardme/` if you have `XDG_CONFIG_HOME` configured\n\n#### Other useful (but optional) configurations\n- Enable touchID for sudo on macOS\n- Add your user to the docker group\n- Install nerdfonts (defaults to Hack and Mononoki)\n- Set capslock to control\n\n### Screenshots\n\n<details>\n  <summary>Example of <code>onboardme --help</code></summary>\n\n<p align="center" width="100%">\n<a href="https://raw.githubusercontent.com/jessebot/onboardme/main/docs/onboardme/screenshots/help_text.svg">\n<img src="./docs/onboardme/screenshots/help_text.svg" alt=\'screenshot of full output of onboardme --help\'>\n</a>\n</p>\n\n</details>\n\n<details>\n  <summary>Examples of the terminal after <code>onboardme</code> runs</summary>\n\n<p align="center" width="100%">\n\n### vim\n<img width="90%" src=\'https://raw.githubusercontent.com/jessebot/onboardme/main/docs/onboardme/screenshots/vim_example_1.png\' alt=\'screenshot of vim with colors\'>\n\n### Powerline and ls\n<img width="80%" src=\'https://raw.githubusercontent.com/jessebot/onboardme/main/docs/onboardme/screenshots/ls_tree_examples.png\' alt=\'screenshot of powerline and lsd\'>\n\n### Powerline with git\n<img width="90%" src=\'https://raw.githubusercontent.com/jessebot/onboardme/main/docs/onboardme/screenshots/git_powerline_example.png\' alt=\'screenshot of powerline and git colors\'>\n\n### Image and colors\n<img width="90%" src=\'https://raw.githubusercontent.com/jessebot/onboardme/main/docs/onboardme/screenshots/image_in_terminal.png\' alt=\'screenshot of color samples and image of dog using a computer using sixel\'>\n\n### Python virtual env in powerline and cat\n<img width="90%" src=\'https://raw.githubusercontent.com/jessebot/onboardme/main/docs/onboardme/screenshots/python_virtual_env_example.png\' alt=\'screenshot of using bat and python virtual env in powerline\'>\n</p>\n\n</details>\n\n## Quick Start\n\n### Installation\nThe quickest way to get started on a fresh macOS or distrubtion of Debian (including Ubuntu) is:\n\n```bash\n# this will download setup.sh to your current directory and run it\n/bin/bash -c "$(curl -fsSL https://raw.githubusercontent.com/jessebot/onboardme/main/setup.sh)"\n\n# this will display the help text for the onboardme cli\nonboardme --help\n```\n\nIf you\'ve already got brew and Python3.11 on your machine, you can just do `pip` install onboardme.\n\nYou can read more in depth at the [Getting Started Docs] 💙! There\'s also more [docs] on basically every program that onboardme touches.\n\n### Upgrades\nIf you\'re on python 3.11, you should be able to do:\n\n```bash\npip3.11 install --upgrade onboardme\n```\n\n### Configuration\nonboardme has lots of CLI options, but you can also use config files. You have to create these files for the time being.\n\nConfig files are in `~/.config/onboardme/` (will use `$XDG_CONFIG_HOME`, if defined). Examples below:\n\n<details>\n<summary><code>config.yaml</code></summary>\n\n\n```yaml\nlog:\n  # Full path to a file you\'d like to log to. Creates file if it doesn\'t exist\n  file: ""\n  # what level of logs to output (DEBUG, INFO, WARN, ERROR)\n  level: "INFO"\n\n# steps refer to a specific function in the list of functions we run\nsteps:\n  # these are mac specific steps\n  Darwin:\n    - dot_files\n    - packages\n    - font_setup\n    - vim_setup\n    - neovim_setup\n    - sudo_setup\n  # these are linux specific steps\n  Linux:\n    - dot_files\n    - packages\n    - font_setup\n    - vim_setup\n    - neovim_setup\n    - group_setup\n\ndot_files:\n  # personal git repo URL for your dot files, defaults to jessebot/dot_files\n  git_url: "https://github.com/jessebot/dot_files.git"\n  # the branch to use for the git repo above, defaults to main\n  git_branch: "main"\n  # !CAREFUL: runs a `git reset --hard`, which will overwite/delete local files in ~ that\n  # conflict with the above defined git repo url and branch. You should run\n  # `onboardme -s dot_files` to get the files that would be overwritten\n  overwrite: false\n\n# basic package config\npackage:\n  # Remove any of the below pkg managers to only run the remaining pkg managers\n  managers:\n    # these are macOS specific steps\n    Darwin:\n      - brew\n      - pip3.11\n    # these are linux specific steps\n    Linux:\n      - brew\n      - pip3.11\n      - apt\n      - snap\n      - flatpak\n  # list of extra existing packages groups to install\n  groups:\n    - default\n    # uncomment these to add them as default installed package groups\n    # - gui\n    # - gaming\n    # - devops\n```\n\n</details>\n\n## Under the Hood\n\n#### Made for the following OS:\n\n- [![made-for-macOS](https://img.shields.io/badge/mac%20os-000000?style=for-the-badge&logo=apple&logoColor=white)](https://wikiless.org/wiki/MacOS?lang=en) (Tested on Ventura with an M1 and apple silicon)\n- [![made-for-debian](https://img.shields.io/badge/Debian-A81D33?style=for-the-badge&logo=debian&logoColor=white)](https://www.debian.org/) (Tested only on Debian Bookworm)\n- [![made-for-ubuntu](https://img.shields.io/badge/Ubuntu-E95420?style=for-the-badge&logo=ubuntu&logoColor=white)](https://ubuntu.com/)\n\n#### Optimized for:\n\n[![made-with-for-vim](https://img.shields.io/badge/VIM-%2311AB00.svg?&style=for-the-badge&logo=vim&logoColor=white)](https://www.vim.org/)\n[![made-with-python](https://img.shields.io/badge/Python-FFD43B?style=for-the-badge&logo=python&logoColor=blue)](https://www.python.org/)\n[![made-with-bash](https://img.shields.io/badge/GNU%20Bash-4EAA25?style=for-the-badge&logo=GNU%20Bash&logoColor=white)](https://www.gnu.org/software/bash/)\n\n#### Built using these great tools:\n\n[<img src="https://github.com/textualize/rich/raw/master/imgs/logo.svg" alt="rich python library logo with with yellow snake" width="200">](https://github.com/Textualize/rich/tree/master)\n[<img src="https://raw.githubusercontent.com/ryanoasis/nerd-fonts/master/images/nerd-fonts-logo.svg" width="120" alt="nerd-fonts: Iconic font aggregator, collection, and patcher">](https://www.nerdfonts.com/)\n- [powerline](https://powerline.readthedocs.io/en/master/overview.html)\n\n### License\n\nGNU AFFERO GENERAL PUBLIC LICENSE Version 3:\n\nTLDR;\n- You are free to use and distribute the software for free, but you cannot bundle it with software that you are charging money for.\n- You are free to bundle software with other FOSS projects if you just credit us and link back to this project.\n- All derivatives of this software must be licensed as GNU AFFERO GENERAL PUBLIC LICENSE Version 3 and must open source the source code as well as credit this project and the contibutors.\n\n## Status\nStill not production ready, but reasonably stable :)\n\nPlease report 🐛 in the GitHub issues, and we will collect them,\nand release them into the wild, because we are vegan and nice.\n(Kidding, we will help! 😌)\n\nWe love contributors! Feel free to open a pull request, and we will review it asap! :)\n\n:star: If you like this project, please star it to help us keep motivated :3\n\n### Contributors\n\n<!-- readme: contributors -start -->\n<table>\n<tr>\n    <td align="center">\n        <a href="https://github.com/jessebot">\n            <img src="https://avatars.githubusercontent.com/u/2389292?v=4" width="100;" alt="jessebot"/>\n            <br />\n            <sub><b>JesseBot</b></sub>\n        </a>\n    </td>\n    <td align="center">\n        <a href="https://github.com/cloudymax">\n            <img src="https://avatars.githubusercontent.com/u/84841307?v=4" width="100;" alt="cloudymax"/>\n            <br />\n            <sub><b>Max!</b></sub>\n        </a>\n    </td></tr>\n</table>\n<!-- readme: contributors -end -->\n\n## Shameless plugs for other projects\nGet running on a machine using a bootable USB stick with [pxeless](https://github.com/cloudymax/pxeless).\n\nGet started with virtual machines and QEMU with [scrap metal](https://github.com/cloudymax/Scrap-Metal).\n\nGet started with testing kubernetes locally, even on metal with [smol k8s lab](https://github.com/jessebot/smol_k8s_lab).\n\n<!-- link references -->\n[documentation]: https://jessebot.github.io/onboardme/onboardme "onboardme documentation"\n[dot files]: https://en.wikipedia.org/wiki/Hidden_file_and_hidden_directory#Unix_and_Unix-like_environments "wiki entry for dot file explanation"\n[our default dot files]: https://github.com/jessebot/dot_files "default dot files for onboardme"\n[help text]: https://raw.githubusercontent.com/jessebot/onboardme/main/docs/onboardme/screenshots/help_text.svg "an svg of the command: onboardme --help"\n[Getting Started Docs]: https://jessebot.github.io/onboardme/onboardme/getting-started "getting started documentation"\n[XDG Base Directory Spec]: https://specifications.freedesktop.org/basedir-spec/latest/ar01s03.html\n[vim-plug]: https://github.com/junegunn/vim-plug\n[packer]: https://github.com/wbthomason/packer.nvim\n',
    'author': 'Jesse Hitch',
    'author_email': 'jessebot@linux.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'http://github.com/jessebot/onboardme',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.11,<4.0',
}


setup(**setup_kwargs)
