from django.db import migrations


def forwards_func(apps, schema_editor):
    Country = apps.get_model("django_base_shop", "Country")

    db_alias = schema_editor.connection.alias
    Country.objects.using(db_alias).bulk_create(
        [
            Country(name="Afghanistan"),
            Country(name="Albania"),
            Country(name="Algeria"),
            Country(name="Andorra"),
            Country(name="Angola"),
            Country(name="Antigua & Deps"),
            Country(name="Argentina"),
            Country(name="Armenia"),
            Country(name="Australia"),
            Country(name="Austria"),
            Country(name="Azerbaijan"),
            Country(name="Bahamas"),
            Country(name="Bahrain"),
            Country(name="Bangladesh"),
            Country(name="Barbados"),
            Country(name="Belarus"),
            Country(name="Belgium"),
            Country(name="Belize"),
            Country(name="Benin"),
            Country(name="Bhutan"),
            Country(name="Bolivia"),
            Country(name="Bosnia Herzegovina"),
            Country(name="Botswana"),
            Country(name="Brazil"),
            Country(name="Brunei"),
            Country(name="Bulgaria"),
            Country(name="Burkina"),
            Country(name="Burundi"),
            Country(name="Cambodia"),
            Country(name="Cameroon"),
            Country(name="Canada"),
            Country(name="Cape Verde"),
            Country(name="Central African Rep"),
            Country(name="Chad"),
            Country(name="Chile"),
            Country(name="China"),
            Country(name="Colombia"),
            Country(name="Comoros"),
            Country(name="Congo"),
            Country(name="Democratic Republic of Congo"),
            Country(name="Costa Rica"),
            Country(name="Croatia"),
            Country(name="Cuba"),
            Country(name="Cyprus"),
            Country(name="Czech Republic"),
            Country(name="Denmark"),
            Country(name="Djibouti"),
            Country(name="Dominica"),
            Country(name="Dominican Republic"),
            Country(name="East Timor"),
            Country(name="Ecuador"),
            Country(name="Egypt"),
            Country(name="El Salvador"),
            Country(name="Equatorial Guinea"),
            Country(name="Eritrea"),
            Country(name="Estonia"),
            Country(name="Ethiopia"),
            Country(name="Fiji"),
            Country(name="Finland"),
            Country(name="France"),
            Country(name="Gabon"),
            Country(name="Gambia"),
            Country(name="Georgia"),
            Country(name="Germany"),
            Country(name="Ghana"),
            Country(name="Greece"),
            Country(name="Grenada"),
            Country(name="Guatemala"),
            Country(name="Guinea"),
            Country(name="Guinea-Bissau"),
            Country(name="Guyana"),
            Country(name="Haiti"),
            Country(name="Honduras"),
            Country(name="Hungary"),
            Country(name="Iceland"),
            Country(name="India"),
            Country(name="Indonesia"),
            Country(name="Iran"),
            Country(name="Iraq"),
            Country(name="Ireland "),
            Country(name="Israel"),
            Country(name="Italy"),
            Country(name="Ivory Coast"),
            Country(name="Jamaica"),
            Country(name="Japan"),
            Country(name="Jordan"),
            Country(name="Kazakhstan"),
            Country(name="Kenya"),
            Country(name="Kiribati"),
            Country(name="Korea North"),
            Country(name="Korea South"),
            Country(name="Kosovo"),
            Country(name="Kuwait"),
            Country(name="Kyrgyzstan"),
            Country(name="Laos"),
            Country(name="Latvia"),
            Country(name="Lebanon"),
            Country(name="Lesotho"),
            Country(name="Liberia"),
            Country(name="Libya"),
            Country(name="Liechtenstein"),
            Country(name="Lithuania"),
            Country(name="Luxembourg"),
            Country(name="Macedonia"),
            Country(name="Madagascar"),
            Country(name="Malawi"),
            Country(name="Malaysia"),
            Country(name="Maldives"),
            Country(name="Mali"),
            Country(name="Malta"),
            Country(name="Marshall Islands"),
            Country(name="Mauritania"),
            Country(name="Mauritius"),
            Country(name="Mexico"),
            Country(name="Micronesia"),
            Country(name="Moldova"),
            Country(name="Monaco"),
            Country(name="Mongolia"),
            Country(name="Montenegro"),
            Country(name="Morocco"),
            Country(name="Mozambique"),
            Country(name="Myanmar"),
            Country(name="Namibia"),
            Country(name="Nauru"),
            Country(name="Nepal"),
            Country(name="Netherlands"),
            Country(name="New Zealand"),
            Country(name="Nicaragua"),
            Country(name="Niger"),
            Country(name="Nigeria"),
            Country(name="Norway"),
            Country(name="Oman"),
            Country(name="Pakistan"),
            Country(name="Palau"),
            Country(name="Panama"),
            Country(name="Papua New Guinea"),
            Country(name="Paraguay"),
            Country(name="Peru"),
            Country(name="Philippines"),
            Country(name="Poland"),
            Country(name="Portugal"),
            Country(name="Qatar"),
            Country(name="Romania"),
            Country(name="Russian Federation"),
            Country(name="Rwanda"),
            Country(name="St Kitts & Nevis"),
            Country(name="St Lucia"),
            Country(name="Saint Vincent & the Grenadines"),
            Country(name="Samoa"),
            Country(name="San Marino"),
            Country(name="Sao Tome & Principe"),
            Country(name="Saudi Arabia"),
            Country(name="Senegal"),
            Country(name="Serbia"),
            Country(name="Seychelles"),
            Country(name="Sierra Leone"),
            Country(name="Singapore"),
            Country(name="Slovakia"),
            Country(name="Slovenia"),
            Country(name="Solomon Islands"),
            Country(name="Somalia"),
            Country(name="South Africa"),
            Country(name="South Sudan"),
            Country(name="Spain"),
            Country(name="Sri Lanka"),
            Country(name="Sudan"),
            Country(name="Suriname"),
            Country(name="Swaziland"),
            Country(name="Sweden"),
            Country(name="Switzerland"),
            Country(name="Syria"),
            Country(name="Taiwan"),
            Country(name="Tajikistan"),
            Country(name="Tanzania"),
            Country(name="Thailand"),
            Country(name="Togo"),
            Country(name="Tonga"),
            Country(name="Trinidad & Tobago"),
            Country(name="Tunisia"),
            Country(name="Turkey"),
            Country(name="Turkmenistan"),
            Country(name="Tuvalu"),
            Country(name="Uganda"),
            Country(name="Ukraine"),
            Country(name="United Arab Emirates"),
            Country(name="United Kingdom"),
            Country(name="United States"),
            Country(name="Uruguay"),
            Country(name="Uzbekistan"),
            Country(name="Vanuatu"),
            Country(name="Vatican City"),
            Country(name="Venezuela"),
            Country(name="Vietnam"),
            Country(name="Yemen"),
            Country(name="Zambia"),
            Country(name="Zimbabwe"),
        ]
    )


def reverse_func(apps, schema_editor):
    Country = apps.get_model("django_base_shop", "Country")

    db_alias = schema_editor.connection.alias
    Country.objects.all().delete()


class Migration(migrations.Migration):

    dependencies = [
        ("django_base_shop", "0001_initial"),
    ]

    operations = [
        migrations.RunPython(forwards_func, reverse_func),
    ]
