/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.owlxml.parser;

import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.owlxml.parser.AnnEH;
import org.semanticweb.owlapi.owlxml.parser.AnnotationPropEH;
import org.semanticweb.owlapi.owlxml.parser.AnonEH;
import org.semanticweb.owlapi.owlxml.parser.AtomEH;
import org.semanticweb.owlapi.owlxml.parser.AtomListEH;
import org.semanticweb.owlapi.owlxml.parser.AxiomEH;
import org.semanticweb.owlapi.owlxml.parser.ChainEH;
import org.semanticweb.owlapi.owlxml.parser.ClassEH;
import org.semanticweb.owlapi.owlxml.parser.DataPropertyEH;
import org.semanticweb.owlapi.owlxml.parser.DataRangeEH;
import org.semanticweb.owlapi.owlxml.parser.DatatypeFacetEH;
import org.semanticweb.owlapi.owlxml.parser.IRIEH;
import org.semanticweb.owlapi.owlxml.parser.IndividualEH;
import org.semanticweb.owlapi.owlxml.parser.LiteralEH;
import org.semanticweb.owlapi.owlxml.parser.OWLXMLPH;
import org.semanticweb.owlapi.owlxml.parser.OWLXMLParserAttributeNotFoundException;
import org.semanticweb.owlapi.owlxml.parser.OWLXMLParserElementNotFoundException;
import org.semanticweb.owlapi.owlxml.parser.OWLXMLParserException;
import org.semanticweb.owlapi.owlxml.parser.ObjectPropertyEH;
import org.semanticweb.owlapi.owlxml.parser.VariableEH;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWLXMLVocabulary;
import org.semanticweb.owlapitools.builders.BaseBuilder;
import org.semanticweb.owlapitools.builders.Builder;
import org.semanticweb.owlapitools.builders.SettableProperty;

abstract class OWLEH<O, B extends Builder<O>> {
    final StringBuilder sb = new StringBuilder();
    OWLXMLPH handler;
    OWLEH<?, ?> parentHandler;
    String elementName;
    OWLDataFactory df;
    Function<OWLDataFactory, B> provider;
    B builder;
    HandleChild child;

    OWLEH() {
    }

    void setHandler(OWLXMLPH handler) {
        this.handler = handler;
        this.df = handler.getDataFactory();
        if (this.provider != null) {
            this.builder = (Builder)this.provider.apply(this.df);
        }
    }

    public <T> T getOWLObject() {
        return (T)this.builder.buildObject();
    }

    public <T> T getOWLObject(Class<T> witness) {
        return this.getOWLObject();
    }

    IRI getIRIFromAttribute(String localName, String value) {
        if (localName.equals(OWLXMLVocabulary.IRI_ATTRIBUTE.getShortForm())) {
            return this.handler.getIRI(value);
        }
        if (localName.equals(OWLXMLVocabulary.ABBREVIATED_IRI_ATTRIBUTE.getShortForm())) {
            return this.handler.getAbbreviatedIRI(value);
        }
        if ("URI".equals(localName)) {
            return this.handler.getIRI(value);
        }
        this.ensureAttributeNotNull(null, OWLXMLVocabulary.IRI_ATTRIBUTE.getShortForm());
        return IRI.create((String)"");
    }

    IRI getIRIFromElement(String elementLocalName, String textContent) {
        if (elementLocalName.equals(OWLXMLVocabulary.IRI_ELEMENT.getShortForm())) {
            return this.handler.getIRI(textContent.trim());
        }
        if (elementLocalName.equals(OWLXMLVocabulary.ABBREVIATED_IRI_ELEMENT.getShortForm())) {
            return this.handler.getAbbreviatedIRI(textContent.trim());
        }
        throw new OWLXMLParserException(this.handler, elementLocalName + " is not an IRI element");
    }

    OWLEH<?, ?> getParentHandler() {
        return (OWLEH)OWLAPIPreconditions.verifyNotNull(this.parentHandler, (String)"parentHandler cannot be null at this point");
    }

    void setParentHandler(OWLEH<?, ?> handler) {
        this.parentHandler = handler;
    }

    void attribute(String localName, String value) {
    }

    void startElement(String name) {
        this.elementName = name;
    }

    String getElementName() {
        return this.elementName;
    }

    void handleChild(AxiomEH<? extends OWLAxiom, ?> h) {
        OWLAxiom axiom = (OWLAxiom)h.getOWLObject();
        if (!axiom.isAnnotationAxiom() || this.handler.getConfiguration().isLoadAnnotationAxioms()) {
            this.handler.getOWLOntologyManager().applyChange((OWLOntologyChange)new AddAxiom(this.handler.getOntology(), axiom));
        }
    }

    void handleChild(ClassEH<? extends OWLClassExpression, ?> h) {
    }

    void handleChild(DataRangeEH<? extends OWLDataRange, ?> h) {
    }

    void handleChild(ObjectPropertyEH h) {
        if (this.builder instanceof SettableProperty) {
            ((SettableProperty)this.builder).withProperty((OWLObject)h.getOWLObject(OWLObjectPropertyExpression.class));
        }
    }

    void handleChild(DataPropertyEH h) {
        if (this.builder instanceof SettableProperty) {
            ((SettableProperty)this.builder).withProperty((OWLObject)h.getOWLObject(OWLDataPropertyExpression.class));
        }
    }

    void handleChild(IndividualEH h) {
    }

    void handleChild(LiteralEH h) {
    }

    void handleChild(AnnEH h) {
        ((BaseBuilder)this.builder).withAnnotation((OWLAnnotation)h.getOWLObject());
    }

    void handleChild(ChainEH h) {
    }

    void handleChild(DatatypeFacetEH h) {
    }

    void handleChild(AnnotationPropEH h) {
        if (this.builder instanceof SettableProperty) {
            ((SettableProperty)this.builder).withProperty((OWLObject)h.getOWLObject(OWLAnnotationProperty.class));
        }
    }

    void handleChild(AnonEH h) {
    }

    void handleChild(IRIEH h) {
    }

    void handleChild(VariableEH h) {
    }

    void handleChild(AtomEH<?, ?> h) {
    }

    void handleChild(AtomListEH h) {
    }

    void ensureNotNull(@Nullable Object element, String message) {
        if (element == null) {
            throw new OWLXMLParserElementNotFoundException(this.handler, message);
        }
    }

    void ensureAttributeNotNull(@Nullable Object element, String message) {
        if (element == null) {
            throw new OWLXMLParserAttributeNotFoundException(this.handler, message);
        }
    }

    void handleChars(char[] chars, int start, int length) {
        if (this.isTextContentPossible()) {
            this.sb.append(chars, start, length);
        }
    }

    String getText() {
        return this.sb.toString();
    }

    boolean isTextContentPossible() {
        return false;
    }

    void endElement() {
        this.child.run(this.parentHandler, this);
    }

    static enum HandleChild {
        AbstractOWLAxiomEH((parent, _this) -> parent.handleChild((AxiomEH)_this)),
        AbstractClassExpressionEH((parent, _this) -> parent.handleChild((ClassEH)_this)),
        AbstractOWLDataRangeHandler((parent, _this) -> parent.handleChild((DataRangeEH)_this)),
        ObjectPropertyEH((parent, _this) -> parent.handleChild((ObjectPropertyEH)((Object)_this))),
        OWLDataPropertyEH((parent, _this) -> parent.handleChild((DataPropertyEH)_this)),
        OWLIndividualEH((parent, _this) -> parent.handleChild((IndividualEH)_this)),
        OWLLiteralEH((parent, _this) -> parent.handleChild((LiteralEH)_this)),
        OWLAnnotationEH((parent, _this) -> parent.handleChild((AnnEH)_this)),
        OWLSubObjectPropertyChainEH((parent, _this) -> parent.handleChild((ChainEH)_this)),
        OWLDatatypeFacetRestrictionEH((parent, _this) -> parent.handleChild((DatatypeFacetEH)_this)),
        OWLAnnotationPropertyEH((parent, _this) -> parent.handleChild((AnnotationPropEH)_this)),
        OWLAnonymousIndividualEH((parent, _this) -> parent.handleChild((AnonEH)_this)),
        AbstractIRIEH((parent, _this) -> parent.handleChild((IRIEH)_this)),
        SWRLVariableEH((parent, _this) -> parent.handleChild((VariableEH)_this)),
        SWRLAtomEH((parent, _this) -> parent.handleChild((AtomEH)_this)),
        SWRLAtomListEH((parent, _this) -> parent.handleChild((AtomListEH)_this));

        private BiConsumer<OWLEH<?, ?>, OWLEH<?, ?>> consumer;

        private HandleChild(BiConsumer<OWLEH<?, ?>, OWLEH<?, ?>> c) {
            this.consumer = c;
        }

        final void run(OWLEH<?, ?> parent, OWLEH<?, ?> _this) {
            this.consumer.accept(parent, _this);
        }
    }
}

