/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean.concurrent;

import com.opencsv.bean.AbstractCSVToBean;
import com.opencsv.bean.BeanField;
import com.opencsv.bean.CsvToBeanFilter;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.bean.concurrent.OrderedObject;
import com.opencsv.bean.opencsvUtils;
import com.opencsv.exceptions.CsvBadConverterException;
import com.opencsv.exceptions.CsvConstraintViolationException;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.BlockingQueue;

public class ProcessCsvLine<T>
extends AbstractCSVToBean
implements Runnable {
    private final long lineNumber;
    private final MappingStrategy<T> mapper;
    private final CsvToBeanFilter filter;
    private final String[] line;
    private final BlockingQueue<OrderedObject<T>> resultantBeanQueue;
    private final BlockingQueue<OrderedObject<CsvException>> thrownExceptionsQueue;
    private final boolean throwExceptions;
    T bean;

    public ProcessCsvLine(long lineNumber, MappingStrategy<T> mapper, CsvToBeanFilter filter, String[] line, BlockingQueue<OrderedObject<T>> resultantBeanQueue, BlockingQueue<OrderedObject<CsvException>> thrownExceptionsQueue, boolean throwExceptions) {
        this.lineNumber = lineNumber;
        this.mapper = mapper;
        this.filter = filter;
        this.line = line;
        this.resultantBeanQueue = resultantBeanQueue;
        this.thrownExceptionsQueue = thrownExceptionsQueue;
        this.throwExceptions = throwExceptions;
    }

    @Override
    public void run() {
        try {
            if (this.filter == null || this.filter.allowLine(this.line)) {
                T obj = this.processLine();
                opencsvUtils.queueRefuseToAcceptDefeat(this.resultantBeanQueue, new OrderedObject<T>(this.lineNumber, obj));
            }
        }
        catch (CsvException e) {
            CsvException csve = e;
            csve.setLineNumber(this.lineNumber);
            if (this.throwExceptions) {
                throw new RuntimeException(csve);
            }
            opencsvUtils.queueRefuseToAcceptDefeat(this.thrownExceptionsQueue, new OrderedObject<CsvException>(this.lineNumber, csve));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private T processLine() throws IllegalAccessException, InvocationTargetException, InstantiationException, IntrospectionException, CsvBadConverterException, CsvDataTypeMismatchException, CsvRequiredFieldEmptyException, CsvConstraintViolationException {
        this.mapper.verifyLineLength(this.line.length);
        this.bean = this.mapper.createBean();
        for (int col = 0; col < this.line.length; ++col) {
            if (this.mapper.isAnnotationDriven()) {
                this.processField(col);
                continue;
            }
            this.processProperty(col);
        }
        return this.bean;
    }

    private void processField(int col) throws CsvBadConverterException, CsvDataTypeMismatchException, CsvRequiredFieldEmptyException, CsvConstraintViolationException {
        BeanField beanField = this.mapper.findField(col);
        if (beanField != null) {
            String value = this.line[col];
            beanField.setFieldValue(this.bean, value);
        }
    }

    private void processProperty(int col) throws IntrospectionException, InstantiationException, IllegalAccessException, InvocationTargetException, CsvBadConverterException {
        PropertyDescriptor prop = this.mapper.findDescriptor(col);
        if (null != prop) {
            String value = this.checkForTrim(this.line[col], prop);
            Object obj = this.convertValue(value, prop);
            prop.getWriteMethod().invoke(this.bean, obj);
        }
    }

    @Override
    protected PropertyEditor getPropertyEditor(PropertyDescriptor desc) throws InstantiationException, IllegalAccessException {
        Class<?> cls = desc.getPropertyEditorClass();
        if (null != cls) {
            return (PropertyEditor)cls.newInstance();
        }
        return this.getPropertyEditorValue(desc.getPropertyType());
    }
}

