/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.transformation;

import java.io.FileInputStream;
import java.io.InputStream;
import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.IllegalCoordinateException;
import org.cts.cs.OutOfExtentException;
import org.cts.datum.GeodeticDatum;
import org.cts.op.AbstractCoordinateOperation;
import org.cts.op.CoordinateOperation;
import org.cts.op.NonInvertibleOperationException;
import org.cts.op.transformation.GridBasedTransformation;
import org.cts.op.transformation.grids.GeographicGrid;
import org.cts.op.transformation.grids.GridUtils;
import org.cts.op.transformation.grids.IGNVerticalGrid;

public class Altitude2EllipsoidalHeight
extends AbstractCoordinateOperation
implements GridBasedTransformation {
    private GeographicGrid GRID;
    private String gridFileName;
    private GeodeticDatum associatedDatum;
    private static final Identifier opId = new Identifier("EPSG", "9616", "Vertical Offset (by Interpolation of Gridded Data)", "Translation");
    private Altitude2EllipsoidalHeight inverse;

    public Altitude2EllipsoidalHeight(String nameGrid, GeodeticDatum gd) throws Exception {
        super(opId);
        this.associatedDatum = gd;
        this.precision = 0.01;
        this.gridFileName = nameGrid;
        try {
            InputStream is = GridUtils.class.getClassLoader().getResourceAsStream("org/cts/op/transformation/grids/" + nameGrid);
            this.GRID = is != null ? new IGNVerticalGrid(is, false) : new IGNVerticalGrid(new FileInputStream(GridUtils.findGrid(nameGrid)), false);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage() + "\nThis problem occured when loading the " + nameGrid + " grid file.");
        }
    }

    public GeodeticDatum getAssociatedDatum() {
        return this.associatedDatum;
    }

    public String getGridFileName() {
        return this.gridFileName;
    }

    public double[] transform(double[] coord) throws IllegalCoordinateException {
        double th;
        if (coord.length < 3) {
            throw new CoordinateDimensionException(coord, 3);
        }
        double[] coordi = (double[])coord.clone();
        try {
            double[] t = this.GRID.bilinearInterpolation(coordi[0], coordi[1]);
            th = t[0];
        }
        catch (OutOfExtentException e) {
            throw new IllegalCoordinateException(e.getMessage());
        }
        coord[2] = th + coord[2];
        return coord;
    }

    public CoordinateOperation inverse() throws NonInvertibleOperationException {
        if (this.inverse != null) {
            return this.inverse;
        }
        try {
            this.inverse = new Altitude2EllipsoidalHeight(this.getGridFileName(), this.associatedDatum){

                public double[] transform(double[] coord) throws IllegalCoordinateException {
                    double th;
                    double[] coordi = (double[])coord.clone();
                    try {
                        double[] t = Altitude2EllipsoidalHeight.this.GRID.bilinearInterpolation(coordi[0], coordi[1]);
                        th = t[0];
                    }
                    catch (OutOfExtentException e) {
                        throw new IllegalCoordinateException(e.getMessage());
                    }
                    coord[2] = -th + coord[2];
                    return coord;
                }

                public CoordinateOperation inverse() throws NonInvertibleOperationException {
                    return Altitude2EllipsoidalHeight.this;
                }
            };
            return this.inverse;
        }
        catch (Exception e) {
            throw new NonInvertibleOperationException(e.getMessage());
        }
    }
}

