/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.projection;

import java.util.Map;
import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.datum.Ellipsoid;
import org.cts.op.NonInvertibleOperationException;
import org.cts.op.projection.Projection;
import org.cts.units.Measure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquidistantCylindrical
extends Projection {
    public static final Identifier EQC = new Identifier("EPSG", "1028", "Equidistant Cylindrical", "EQC");
    protected final double lat0;
    protected final double lon0 = this.getCentralMeridian();
    protected final double FE;
    protected final double FN;
    protected final double C;

    public EquidistantCylindrical(Ellipsoid ellipsoid, Map<String, Measure> parameters) {
        super(EQC, ellipsoid, parameters);
        this.lat0 = this.getLatitudeOfOrigin();
        this.FE = this.getFalseEasting();
        this.FN = this.getFalseNorthing();
        double lat_ts = this.getLatitudeOfTrueScale();
        double e2 = ellipsoid.getSquareEccentricity();
        double k0 = Math.cos(lat_ts) / Math.sqrt(1.0 - e2 * Math.pow(Math.sin(lat_ts), 2.0));
        this.C = this.getSemiMajorAxis() * k0;
    }

    @Override
    public Projection.Surface getSurface() {
        return Projection.Surface.CYLINDRICAL;
    }

    @Override
    public Projection.Property getProperty() {
        return Projection.Property.APHYLACTIC;
    }

    @Override
    public Projection.Orientation getOrientation() {
        return Projection.Orientation.TANGENT;
    }

    @Override
    public double[] transform(double[] coord) throws CoordinateDimensionException {
        double lon = coord[1];
        double lat = Math.abs(coord[0]) > 1.4835298641951802 ? 1.4835298641951802 : coord[0];
        double E = this.C * (lon - this.lon0);
        double N = this.ellipsoid.arcFromLat(lat);
        coord[0] = this.FE + E;
        coord[1] = this.FN + N;
        return coord;
    }

    @Override
    public Projection inverse() throws NonInvertibleOperationException {
        return new EquidistantCylindrical(this.ellipsoid, this.parameters){

            public double[] transform(double[] coord) throws CoordinateDimensionException {
                double lat = this.ellipsoid.latFromArc(coord[1] - this.FN);
                coord[1] = (coord[0] - this.FE) / this.C + this.lon0;
                coord[0] = lat;
                return coord;
            }

            public Projection inverse() throws NonInvertibleOperationException {
                return EquidistantCylindrical.this;
            }

            public boolean isDirect() {
                return false;
            }

            public String toString() {
                return EquidistantCylindrical.this.toString() + " inverse";
            }
        };
    }
}

