/*
 * Decompiled with CFR 0.152.
 */
package org.cts.datum;

import java.util.HashMap;
import java.util.Map;
import org.cts.IdentifiableComponent;
import org.cts.Identifier;
import org.cts.util.AngleFormat;

public class PrimeMeridian
extends IdentifiableComponent {
    public static final PrimeMeridian GREENWICH = PrimeMeridian.createPrimeMeridianFromDDLongitude(new Identifier("EPSG", "8901", "Greenwich", "Greenwich"), 0.0);
    public static final PrimeMeridian LISBON = PrimeMeridian.createPrimeMeridianFromDDLongitude(new Identifier("EPSG", "8902", "Lisbon", "Lisbon"), AngleFormat.parseAngle("9\u00b0 07' 54.862\" W"));
    public static final PrimeMeridian PARIS = PrimeMeridian.createPrimeMeridianFromDDLongitude(new Identifier("EPSG", "8903", "Paris", "Paris", "Value adopted by IGN (Paris) in 1936. Equivalent to 2\u00b020'14.025\". Preferred by EPSG to earlier value of 2\u00b0 12' 5.022\" used by RGS London", null), AngleFormat.parseAngle("2\u00b020'14.025\""));
    public static final PrimeMeridian BOGOTA = PrimeMeridian.createPrimeMeridianFromDDLongitude(new Identifier("EPSG", "8904", "Bogota", "Bogota"), AngleFormat.parseAngle("74\u00b0 04' 51.3\" W"));
    public static final PrimeMeridian MADRID = PrimeMeridian.createPrimeMeridianFromDDLongitude(new Identifier("EPSG", "8905", "Madrid", "Madrid"), AngleFormat.parseAngle("3\u00b0 41' 16.58\" W"));
    public static final PrimeMeridian ROME = PrimeMeridian.createPrimeMeridianFromDDLongitude(new Identifier("EPSG", "8906", "Rome", "Rome"), AngleFormat.parseAngle("12\u00b0 27' 08.4\" E"));
    public static final PrimeMeridian BERN = PrimeMeridian.createPrimeMeridianFromDDLongitude(new Identifier("EPSG", "8907", "Bern", "Bern", "1895 value. Newer value of 7\u00b026'22.335\" determined in 1938.", null), AngleFormat.parseAngle("7\u00b0 26' 22.5\" E"));
    public static final PrimeMeridian JAKARTA = PrimeMeridian.createPrimeMeridianFromDDLongitude(new Identifier("EPSG", "8908", "Jakarta", "Jakarta"), AngleFormat.parseAngle("106\u00b0 48' 27.79\" E"));
    public static final PrimeMeridian FERRO = PrimeMeridian.createPrimeMeridianFromDDLongitude(new Identifier("EPSG", "8909", "Ferro", "Ferro", "Used in Austria and former Czechoslovakia.", null), AngleFormat.parseAngle("17\u00b0 40' W"));
    public static final PrimeMeridian BRUSSELS = PrimeMeridian.createPrimeMeridianFromDDLongitude(new Identifier("EPSG", "8910", "Brussels", "Brussels"), AngleFormat.parseAngle("4\u00b0 22' 4.71\" E"));
    public static final PrimeMeridian STOCKHOLM = PrimeMeridian.createPrimeMeridianFromDDLongitude(new Identifier("EPSG", "8911", "Stockholm"), AngleFormat.parseAngle("18\u00b0 03' 29.8\" E"));
    public static final PrimeMeridian ATHENS = PrimeMeridian.createPrimeMeridianFromDDLongitude(new Identifier("EPSG", "8912", "Athens", "Athens", "Used in Greece for older mapping based on Hatt projection.", null), AngleFormat.parseAngle("23\u00b0 42' 58.815\" E"));
    public static final PrimeMeridian OSLO = PrimeMeridian.createPrimeMeridianFromDDLongitude(new Identifier("EPSG", "8913", "Oslo", "Oslo", " Formerly known as Kristiania or Christiania.", null), AngleFormat.parseAngle("10\u00b0 43' 22.5\" E"));
    public static final PrimeMeridian PARIS_RGS = PrimeMeridian.createPrimeMeridianFromDDLongitude(new Identifier("EPSG", "8914", "Paris (RGS)", "Paris (RGS)", "Value replaced by IGN (France) in 1936 - see code 8903. Equivalent to 2.596898 grads.", null), AngleFormat.parseAngle("2\u00b0 12' 5.022\" E"));
    private double ddLongitude;
    public static final Map<String, PrimeMeridian> primeMeridianFromName = new HashMap<String, PrimeMeridian>();

    private PrimeMeridian(String name, double ddLongitude) {
        this(new Identifier(PrimeMeridian.class, name), ddLongitude);
    }

    private PrimeMeridian(Identifier identifier, double ddLongitude) {
        super(identifier);
        this.ddLongitude = ddLongitude;
    }

    public double getLongitudeFromGreenwichInDegrees() {
        return this.ddLongitude;
    }

    public double getLongitudeFromGreenwichInRadians() {
        return Math.toRadians(this.ddLongitude);
    }

    public String getLongitudeFromGreenwichInDMS() {
        return AngleFormat.LONGITUDE_FORMATTER.format(this.ddLongitude);
    }

    public static PrimeMeridian createPrimeMeridianFromDDLongitude(Identifier identifier, double ddLongitude) {
        PrimeMeridian pm = new PrimeMeridian(identifier, ddLongitude);
        return pm.checkExistingPrimeMeridian();
    }

    public static PrimeMeridian createPrimeMeridianFromDMSLongitude(Identifier identifier, double dmsLongitude) {
        PrimeMeridian pm = new PrimeMeridian(identifier, AngleFormat.dms2dd(dmsLongitude));
        return pm.checkExistingPrimeMeridian();
    }

    public static PrimeMeridian createPrimeMeridianFromDMSLongitude(Identifier identifier, String dmsLongitude) throws IllegalArgumentException {
        double ddLongitude = AngleFormat.parseAngle(dmsLongitude);
        PrimeMeridian pm = new PrimeMeridian(identifier, ddLongitude);
        return pm.checkExistingPrimeMeridian();
    }

    public static PrimeMeridian createPrimeMeridianFromLongitudeInRadians(Identifier identifier, double longitude) {
        PrimeMeridian pm = new PrimeMeridian(identifier, Math.toDegrees(longitude));
        return pm.checkExistingPrimeMeridian();
    }

    public static PrimeMeridian createPrimeMeridianFromLongitudeInGrades(Identifier identifier, double longitude) {
        PrimeMeridian pm = new PrimeMeridian(identifier, longitude * 180.0 / 200.0);
        return pm.checkExistingPrimeMeridian();
    }

    private PrimeMeridian checkExistingPrimeMeridian() {
        if (this.equals(GREENWICH)) {
            return GREENWICH;
        }
        if (this.equals(ATHENS)) {
            return ATHENS;
        }
        if (this.equals(BERN)) {
            return BERN;
        }
        if (this.equals(BOGOTA)) {
            return BOGOTA;
        }
        if (this.equals(BRUSSELS)) {
            return BRUSSELS;
        }
        if (this.equals(FERRO)) {
            return FERRO;
        }
        if (this.equals(JAKARTA)) {
            return JAKARTA;
        }
        if (this.equals(LISBON)) {
            return LISBON;
        }
        if (this.equals(MADRID)) {
            return MADRID;
        }
        if (this.equals(OSLO)) {
            return OSLO;
        }
        if (this.equals(PARIS)) {
            return PARIS;
        }
        if (this.equals(PARIS_RGS)) {
            return PARIS_RGS;
        }
        if (this.equals(ROME)) {
            return ROME;
        }
        if (this.equals(STOCKHOLM)) {
            return STOCKHOLM;
        }
        return this;
    }

    public String toWKT() {
        StringBuilder w = new StringBuilder();
        w.append("PRIMEM[\"");
        w.append(this.getName());
        w.append("\",");
        w.append(this.getLongitudeFromGreenwichInDegrees());
        if (!this.getAuthorityName().startsWith("LOCAL")) {
            w.append(',');
            w.append(this.getIdentifier().toWKT());
        }
        w.append(']');
        return w.toString();
    }

    public String toString() {
        return "[" + this.getAuthorityName() + ":" + this.getAuthorityKey() + "] " + this.getName() + " (" + this.getLongitudeFromGreenwichInDMS() + ")";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof PrimeMeridian) {
            double l2;
            PrimeMeridian pm = (PrimeMeridian)other;
            if (this.getAuthorityKey().equals(pm.getAuthorityKey()) || this.getName().equalsIgnoreCase(pm.getName())) {
                return true;
            }
            double l1 = this.getLongitudeFromGreenwichInRadians();
            return Math.abs(l1 - (l2 = pm.getLongitudeFromGreenwichInRadians())) < 1.0E-11;
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + (int)(Double.doubleToLongBits(this.ddLongitude) ^ Double.doubleToLongBits(this.ddLongitude) >>> 32);
        return hash;
    }

    static {
        primeMeridianFromName.put("greenwich", GREENWICH);
        primeMeridianFromName.put("paris", PARIS);
        primeMeridianFromName.put("lisbon", LISBON);
        primeMeridianFromName.put("bogota", BOGOTA);
        primeMeridianFromName.put("madrid", MADRID);
        primeMeridianFromName.put("rome", ROME);
        primeMeridianFromName.put("bern", BERN);
        primeMeridianFromName.put("jakarta", JAKARTA);
        primeMeridianFromName.put("ferro", FERRO);
        primeMeridianFromName.put("brussels", BRUSSELS);
        primeMeridianFromName.put("stockholm", STOCKHOLM);
        primeMeridianFromName.put("athens", ATHENS);
        primeMeridianFromName.put("oslo", OSLO);
    }
}

