/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.protocol.transaction;

import info.aduna.xml.SimpleSAXAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.openrdf.http.protocol.transaction.operations.AddStatementOperation;
import org.openrdf.http.protocol.transaction.operations.ClearNamespacesOperation;
import org.openrdf.http.protocol.transaction.operations.ClearOperation;
import org.openrdf.http.protocol.transaction.operations.RemoveNamespaceOperation;
import org.openrdf.http.protocol.transaction.operations.RemoveStatementsOperation;
import org.openrdf.http.protocol.transaction.operations.SPARQLUpdateOperation;
import org.openrdf.http.protocol.transaction.operations.SetNamespaceOperation;
import org.openrdf.http.protocol.transaction.operations.TransactionOperation;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.query.Binding;
import org.openrdf.query.Dataset;
import org.openrdf.query.impl.BindingImpl;
import org.openrdf.query.impl.DatasetImpl;
import org.xml.sax.SAXException;

class TransactionSAXParser
extends SimpleSAXAdapter {
    private ValueFactory valueFactory;
    private List<TransactionOperation> txn;
    private List<Value> parsedValues = new ArrayList<Value>();
    private List<Binding> bindings;
    private SPARQLUpdateOperation currentSPARQLUpdate = null;
    private DatasetImpl currentDataset;

    public TransactionSAXParser() {
        this((ValueFactory)new ValueFactoryImpl());
    }

    public TransactionSAXParser(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    public Collection<TransactionOperation> getTxn() {
        return this.txn;
    }

    public void startDocument() throws SAXException {
        this.txn = new ArrayList<TransactionOperation>();
    }

    public void startTag(String tagName, Map<String, String> atts, String text) throws SAXException {
        if ("uri".equals(tagName)) {
            this.parsedValues.add((Value)this.valueFactory.createURI(text));
        } else if ("bnode".equals(tagName)) {
            this.parsedValues.add((Value)this.valueFactory.createBNode(text));
        } else if ("literal".equals(tagName)) {
            Literal lit;
            String lang = atts.get("xml:lang");
            String datatype = atts.get("datatype");
            String encoding = atts.get("encoding");
            if (encoding != null && "base64".equalsIgnoreCase(encoding)) {
                text = new String(DatatypeConverter.parseBase64Binary((String)text));
            }
            if (lang != null) {
                lit = this.valueFactory.createLiteral(text, lang);
            } else if (datatype != null) {
                URI dtURI = this.valueFactory.createURI(datatype);
                lit = this.valueFactory.createLiteral(text, dtURI);
            } else {
                lit = this.valueFactory.createLiteral(text);
            }
            this.parsedValues.add((Value)lit);
        } else if ("null".equals(tagName)) {
            this.parsedValues.add(null);
        } else if ("setNamespace".equals(tagName)) {
            String prefix = atts.get("prefix");
            String name = atts.get("name");
            this.txn.add(new SetNamespaceOperation(prefix, name));
        } else if ("removeNamespace".equals(tagName)) {
            String prefix = atts.get("prefix");
            this.txn.add(new RemoveNamespaceOperation(prefix));
        } else if ("clearNamespaces".equals(tagName)) {
            this.txn.add(new ClearNamespacesOperation());
        } else if ("sparql".equals(tagName)) {
            if (this.currentSPARQLUpdate != null) {
                throw new SAXException("unexpected start of SPARQL Update operation");
            }
            this.currentSPARQLUpdate = new SPARQLUpdateOperation();
            String baseURI = atts.get("baseURI");
            boolean includeInferred = Boolean.parseBoolean(atts.get("includeInferred"));
            this.currentSPARQLUpdate.setIncludeInferred(includeInferred);
            this.currentSPARQLUpdate.setBaseURI(baseURI);
        } else if ("updateString".equals(tagName)) {
            this.currentSPARQLUpdate.setUpdateString(text);
        } else if ("dataset".equals(tagName)) {
            this.currentDataset = new DatasetImpl();
        } else if ("defaultInsertGraph".equals(tagName)) {
            this.currentDataset.setDefaultInsertGraph(this.valueFactory.createURI(text));
        } else if ("graph".equals(tagName)) {
            this.parsedValues.add((Value)this.valueFactory.createURI(text));
        } else if ("bindings".equals(tagName)) {
            if (this.bindings != null) {
                throw new SAXException("unexpected start of SPARQL Update operation bindings");
            }
            this.bindings = new ArrayList<Binding>();
        } else if ("binding_uri".equals(tagName) || "binding_bnode".equals(tagName) || "binding_literal".equals(tagName)) {
            if (this.bindings == null) {
                throw new SAXException("unexpected start of SPARQL Update operation binding (without <bindings>)");
            }
            String value = text;
            String name = atts.get("name");
            if (name != null && value != null) {
                URI v;
                if ("binding_uri".equals(tagName)) {
                    v = this.valueFactory.createURI(value);
                } else if ("binding_bnode".equals(tagName)) {
                    v = this.valueFactory.createBNode(value);
                } else {
                    String language = atts.get("language");
                    String dataType = atts.get("dataType");
                    v = language != null ? this.valueFactory.createLiteral(value, language) : (dataType != null ? this.valueFactory.createLiteral(value, this.valueFactory.createURI(dataType)) : this.valueFactory.createLiteral(value));
                }
                this.bindings.add((Binding)new BindingImpl(name, (Value)v));
            }
        }
    }

    public void endTag(String tagName) throws SAXException {
        if ("add".equals(tagName)) {
            this.txn.add(this.createAddStatementOperation());
        } else if ("remove".equals(tagName)) {
            this.txn.add(this.createRemoveStatementsOperation());
        } else if ("clear".equals(tagName)) {
            this.txn.add(this.createClearOperation());
        } else if ("sparql".equals(tagName)) {
            this.txn.add(this.currentSPARQLUpdate);
            this.currentSPARQLUpdate = null;
        } else if ("defaultGraphs".equals(tagName)) {
            for (Value parsedValue : this.parsedValues) {
                try {
                    this.currentDataset.addDefaultGraph((URI)parsedValue);
                }
                catch (ClassCastException e) {
                    throw new SAXException("unexpected value in default graph list: " + parsedValue);
                }
            }
            this.parsedValues.clear();
        } else if ("namedGraphs".equals(tagName)) {
            for (Value parsedValue : this.parsedValues) {
                try {
                    this.currentDataset.addNamedGraph((URI)parsedValue);
                }
                catch (ClassCastException e) {
                    throw new SAXException("unexpected value in named graph list: " + parsedValue);
                }
            }
            this.parsedValues.clear();
        } else if ("defaultRemoveGraphs".equals(tagName)) {
            for (Value parsedValue : this.parsedValues) {
                try {
                    this.currentDataset.addDefaultRemoveGraph((URI)parsedValue);
                }
                catch (ClassCastException e) {
                    throw new SAXException("unexpected value in default remove graph list: " + parsedValue);
                }
            }
            this.parsedValues.clear();
        } else if ("dataset".equals(tagName)) {
            this.currentSPARQLUpdate.setDataset((Dataset)this.currentDataset);
            this.currentDataset = null;
        } else if ("bindings".equals(tagName)) {
            Binding[] b = this.bindings.toArray(new Binding[0]);
            this.currentSPARQLUpdate.setBindings(b);
            this.bindings.clear();
            this.bindings = null;
        }
    }

    private TransactionOperation createClearOperation() throws SAXException {
        Resource[] contexts = this.createContexts(0);
        this.parsedValues.clear();
        return new ClearOperation(contexts);
    }

    private TransactionOperation createAddStatementOperation() throws SAXException {
        if (this.parsedValues.size() < 3) {
            throw new SAXException("At least three values required for AddStatementOperation, found: " + this.parsedValues.size());
        }
        try {
            Resource subject = (Resource)this.parsedValues.get(0);
            URI predicate = (URI)this.parsedValues.get(1);
            Value object = this.parsedValues.get(2);
            Resource[] contexts = this.createContexts(3);
            this.parsedValues.clear();
            if (subject == null || predicate == null || object == null) {
                throw new SAXException("Subject, predicate and object cannot be null for an AddStatementOperation");
            }
            return new AddStatementOperation(subject, predicate, object, contexts);
        }
        catch (ClassCastException e) {
            throw new SAXException("Invalid argument(s) for AddStatementOperation", e);
        }
    }

    private TransactionOperation createRemoveStatementsOperation() throws SAXException {
        if (this.parsedValues.size() < 3) {
            throw new SAXException("At least three values required for RemoveStatementsOperation, found: " + this.parsedValues.size());
        }
        try {
            Resource subject = (Resource)this.parsedValues.get(0);
            URI predicate = (URI)this.parsedValues.get(1);
            Value object = this.parsedValues.get(2);
            Resource[] contexts = this.createContexts(3);
            this.parsedValues.clear();
            return new RemoveStatementsOperation(subject, predicate, object, contexts);
        }
        catch (ClassCastException e) {
            throw new SAXException("Invalid argument(s) for RemoveStatementsOperation", e);
        }
    }

    private Resource[] createContexts(int startIdx) throws SAXException {
        ArrayList<Resource> contexts = new ArrayList<Resource>();
        for (int i = startIdx; i < this.parsedValues.size(); ++i) {
            Value contextCandidate = this.parsedValues.get(i);
            if (contextCandidate != null && !(contextCandidate instanceof Resource)) {
                throw new SAXException("Invalid context value: " + contextCandidate.getClass());
            }
            contexts.add((Resource)contextCandidate);
        }
        return contexts.toArray(new Resource[contexts.size()]);
    }
}

